/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaEvaSchemeCollection;
import com.kingdee.eas.fi.fa.basedata.FaEvaSchemeFactory;
import com.kingdee.eas.fi.fa.basedata.FaEvaSchemeInfo;
import com.kingdee.eas.fi.fa.manage.FaEvaValueCollection;
import com.kingdee.eas.fi.fa.manage.FaEvaValueInfo;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillCollection;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillFactory;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.services.FaEvaluateBillService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

@Component(value={"com.kingdee.eas.fi.fa.manage.services.FaEvaluateBillService"})
public class FaEvaluateBillServiceImpl
extends BusinessServices
implements FaEvaluateBillService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.services.impl.FaEvaluateBillServiceImpl");

    public FaEvaluateBillServiceImpl(Context context) {
        super(context);
    }

    public Map getFaEvalValueList(String companyId, String[] billIds) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        List evaItems = this.getEvaItem(companyId);
        if (evaItems.size() > 0) {
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < billIds.length; ++i) {
                idSet.add(billIds[i]);
            }
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("faEvaluateBillEntry.id"));
            selector.add(new SelectorItemInfo("faEvaluateBillEntry.evaValue.id"));
            selector.add(new SelectorItemInfo("faEvaluateBillEntry.evaValue.mainType"));
            selector.add(new SelectorItemInfo("faEvaluateBillEntry.evaValue.subType"));
            selector.add(new SelectorItemInfo("faEvaluateBillEntry.evaValue.evaValue"));
            view.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            FaEvaluateBillCollection faEvalColl = FaEvaluateBillFactory.getLocalInstance((Context)this.getContext()).getFaEvaluateBillCollection(view);
            for (FaEvaluateBillInfo billInfo : faEvalColl) {
                FaEvaluateBillEntryCollection billEntryColl = billInfo.getFaEvaluateBillEntry();
                for (int i = 0; i < billEntryColl.size(); ++i) {
                    FaEvaluateBillEntryInfo billEntryInfo = billEntryColl.get(i);
                    FaEvaValueCollection faEvaValueColl = billEntryInfo.getEvaValue();
                    HashMap<String, BigDecimal> threeLevelMap = new HashMap<String, BigDecimal>();
                    block10: for (int j = 0; j < faEvaValueColl.size(); ++j) {
                        FaEvaValueInfo faEvaValueInfo = faEvaValueColl.get(j);
                        int mainType = faEvaValueInfo.getMainType().getValue();
                        int subType = Integer.parseInt(faEvaValueInfo.getSubType().getValue());
                        switch (mainType * 1000 + subType) {
                            case 1011: {
                                threeLevelMap.put("AssetValue_AssetValue", faEvaValueInfo.getEvaValue());
                                continue block10;
                            }
                            case 1012: {
                                threeLevelMap.put("AssetValue_NeatValue", faEvaValueInfo.getEvaValue());
                                continue block10;
                            }
                            case 1000: {
                                threeLevelMap.put("AssetValue_EvalValue", faEvaValueInfo.getEvaValue());
                                continue block10;
                            }
                            case 2021: {
                                threeLevelMap.put("OddUseLife_LeftYear", faEvaValueInfo.getEvaValue());
                                continue block10;
                            }
                            case 2000: {
                                threeLevelMap.put("OddUseLife_EvalValue", faEvaValueInfo.getEvaValue());
                            }
                        }
                    }
                    result.put(billEntryInfo.getId().toString(), threeLevelMap);
                }
            }
        }
        return result;
    }

    private List getEvaItem(String companyId) throws EASBizException, BOSException {
        FaEvaSchemeCollection schemes;
        ArrayList evaItems = new ArrayList();
        try {
            schemes = FaEvaSchemeFactory.getLocalInstance((Context)this.getContext()).getFaEvaSchemeCollection(new EntityViewInfo("select faEvaItem where isEnabled = 1 and CU.id ='" + companyId + "'"));
        }
        catch (ParserException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        int size = schemes.size();
        for (int i = 0; i < size; ++i) {
            FaEvaSchemeInfo scheme = schemes.get(i);
            List rs = FaManageUtils.getItemInfo((String)scheme.getFaEvaItem());
            int size2 = rs.size();
            for (int j = 0; j < size2; ++j) {
                if (evaItems.contains(rs.get(j))) continue;
                evaItems.add(rs.get(j));
            }
        }
        return evaItems;
    }
}

