/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.fa.manage.services.IFaPlatformService;
import com.kingdee.eas.fi.fa.manage.services.util.FaServerUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.fi.fa.manage.services.IFaPlatformService"})
public class FaPlatformService
implements IFaPlatformService {
    private final Context context;

    public FaPlatformService(Context context) {
        this.context = context;
    }

    @Override
    public CompanyOrgUnitCollection getCompanyByPerm(String userId, boolean isFunPerm, String funPermItemId, String rootId, String acountSchemeId, String periodTypeID, boolean onlyLeaf, boolean queryByAccountScheme) throws BOSException {
        CompanyOrgUnitInfo root = null;
        if (rootId != null && rootId.length() > 0) {
            root = new CompanyOrgUnitInfo();
            root.setId(BOSUuid.read((String)rootId));
        }
        AcountSchemeInfo acountScheme = null;
        if (acountSchemeId != null && acountSchemeId.length() > 0) {
            acountScheme = new AcountSchemeInfo();
            acountScheme.setId(BOSUuid.read((String)acountSchemeId));
        } else {
            acountScheme = new AcountSchemeInfo();
            acountScheme.setIsMaster(true);
        }
        StringBuffer sql = new StringBuffer("select  cp.fid,cp.fname_l1,cp.fname_l2,cp.fname_l3,cp.fnumber,cp.flongnumber");
        sql.append(FaServerUtil.getCompanyFilterSQL(userId, funPermItemId, isFunPerm, root, periodTypeID, onlyLeaf, acountScheme, queryByAccountScheme));
        sql.append(" and cp.fid in ( ").append("select forgid from T_PM_OrgRangeIncludeSubOrg where fuserid = '").append(userId).append("' and ftype = 10 ").append(")");
        sql.append(" order by cp.flongnumber");
        IRowSet rs = DbUtil.executeQuery((Context)this.context, (String)sql.toString());
        CompanyOrgUnitCollection collection = new CompanyOrgUnitCollection();
        try {
            while (rs.next()) {
                CompanyOrgUnitInfo orgUnitInfo = new CompanyOrgUnitInfo();
                orgUnitInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                orgUnitInfo.setName(rs.getString("fname_l1"), LocaleUtils.locale_l1);
                orgUnitInfo.setName(rs.getString("fname_l2"), LocaleUtils.locale_l2);
                orgUnitInfo.setName(rs.getString("fname_l3"), LocaleUtils.locale_l3);
                orgUnitInfo.setNumber(rs.getString("fnumber"));
                orgUnitInfo.setLongNumber(rs.getString("flongnumber"));
                collection.add(orgUnitInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return collection;
    }

    @Override
    public Map<String, Integer> getCardCountByCompanyId(String companyId, String periodId) throws BOSException {
        String TEMPSTORE_SQL = "select count(1) as count from T_FA_FaCurCard  where FEffectedStatus = 1 and FCompanyID = ?  and FPeriodID = ?";
        String UNAPPROVE_SQL = "select count(1) as count from T_FA_FaCurCard  where FCheckedStatus = 1 and FCompanyID = ?  and FPeriodID = ?";
        String UNCHANGE_SQL = "select count(1) as count from T_FA_FaCurCard  where FFiVouchered = 0 and FCompanyID = ?  and FPeriodID = ?";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(companyId);
        paramList.add(periodId);
        int tempStoreCount = 0;
        int unapproveCount = 0;
        int unchargeCount = 0;
        IRowSet tempStoreRowSet = DbUtil.executeQuery((Context)this.context, (String)"select count(1) as count from T_FA_FaCurCard  where FEffectedStatus = 1 and FCompanyID = ?  and FPeriodID = ?", (Object[])paramList.toArray());
        IRowSet unapproveRowSet = DbUtil.executeQuery((Context)this.context, (String)"select count(1) as count from T_FA_FaCurCard  where FCheckedStatus = 1 and FCompanyID = ?  and FPeriodID = ?", (Object[])paramList.toArray());
        IRowSet unchargeRowSet = DbUtil.executeQuery((Context)this.context, (String)"select count(1) as count from T_FA_FaCurCard  where FFiVouchered = 0 and FCompanyID = ?  and FPeriodID = ?", (Object[])paramList.toArray());
        try {
            if (tempStoreRowSet.next()) {
                tempStoreCount = tempStoreRowSet.getInt("count");
            }
            if (unapproveRowSet.next()) {
                unapproveCount = unapproveRowSet.getInt("count");
            }
            if (unchargeRowSet.next()) {
                unchargeCount = unchargeRowSet.getInt("count");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("save", tempStoreCount);
        result.put("unapprove", unapproveCount);
        result.put("uncharge", unchargeCount);
        return result;
    }

    @Override
    public Map<String, Integer> getChangeCountByCompanyId(String companyId, String periodId) throws BOSException {
        String TEMPSTORE_SQL = "select count(1) as count from T_FA_FaChangeBill  where FEffectedStatus = 1 and FCompanyID = ? and FPeriodID = ?";
        String UNAPPROVE_SQL = "select count(1) as count from T_FA_FaChangeBill  where FCheckedStatus = 1 and FCompanyID = ? and FPeriodID = ?";
        String UNCHANGE_SQL = "select count(1) as count from T_FA_FaChangeBill  where FFiVouchered = 0 and FCompanyID = ?  and FPeriodID = ? ";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(companyId);
        paramList.add(periodId);
        int tempStoreCount = 0;
        int unapproveCount = 0;
        int unchargeCount = 0;
        IRowSet tempStoreRowSet = DbUtil.executeQuery((Context)this.context, (String)"select count(1) as count from T_FA_FaChangeBill  where FEffectedStatus = 1 and FCompanyID = ? and FPeriodID = ?", (Object[])paramList.toArray());
        IRowSet unapproveRowSet = DbUtil.executeQuery((Context)this.context, (String)"select count(1) as count from T_FA_FaChangeBill  where FCheckedStatus = 1 and FCompanyID = ? and FPeriodID = ?", (Object[])paramList.toArray());
        IRowSet unchargeRowSet = DbUtil.executeQuery((Context)this.context, (String)"select count(1) as count from T_FA_FaChangeBill  where FFiVouchered = 0 and FCompanyID = ?  and FPeriodID = ? ", (Object[])paramList.toArray());
        try {
            if (tempStoreRowSet.next()) {
                tempStoreCount = tempStoreRowSet.getInt("count");
            }
            if (unapproveRowSet.next()) {
                unapproveCount = unapproveRowSet.getInt("count");
            }
            if (unchargeRowSet.next()) {
                unchargeCount = unchargeRowSet.getInt("count");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("save", tempStoreCount);
        result.put("unapprove", unapproveCount);
        result.put("uncharge", unchargeCount);
        return result;
    }

    @Override
    public Map<String, Integer> getClearCountByCompanyId(String companyId, String periodId) throws BOSException {
        String TEMPSTORE_SQL = "select count(1) as count from T_FA_ClearBill  where FEffectedStatus = 1 and FCompanyID = ? and FPeriodID = ?";
        String UNAPPROVE_SQL = "select count(1) as count from T_FA_ClearBill  where FCheckedStatus = 1 and FCompanyID = ? and FPeriodID = ?";
        String UNCHANGE_SQL = "select count(1) as count from T_FA_ClearBill  where FFiVouchered = 0 and FCompanyID = ?  and FPeriodID = ? ";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(companyId);
        paramList.add(periodId);
        int tempStoreCount = 0;
        int unapproveCount = 0;
        int unchargeCount = 0;
        IRowSet tempStoreRowSet = DbUtil.executeQuery((Context)this.context, (String)"select count(1) as count from T_FA_ClearBill  where FEffectedStatus = 1 and FCompanyID = ? and FPeriodID = ?", (Object[])paramList.toArray());
        IRowSet unapproveRowSet = DbUtil.executeQuery((Context)this.context, (String)"select count(1) as count from T_FA_ClearBill  where FCheckedStatus = 1 and FCompanyID = ? and FPeriodID = ?", (Object[])paramList.toArray());
        IRowSet unchargeRowSet = DbUtil.executeQuery((Context)this.context, (String)"select count(1) as count from T_FA_ClearBill  where FFiVouchered = 0 and FCompanyID = ?  and FPeriodID = ? ", (Object[])paramList.toArray());
        try {
            if (tempStoreRowSet.next()) {
                tempStoreCount = tempStoreRowSet.getInt("count");
            }
            if (unapproveRowSet.next()) {
                unapproveCount = unapproveRowSet.getInt("count");
            }
            if (unchargeRowSet.next()) {
                unchargeCount = unchargeRowSet.getInt("count");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("save", tempStoreCount);
        result.put("unapprove", unapproveCount);
        result.put("uncharge", unchargeCount);
        return result;
    }

    @Override
    public PeriodInfo getCurrentPeriodInfo(String companyId) throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)this.context, (SystemEnum)SystemEnum.FIXEDASSETS, (IObjectPK)new ObjectUuidPK(companyId));
    }

    @Override
    public CompanyOrgUnitInfo getCompanyInfo(String companyId, String selector) throws EASBizException, BOSException {
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        if (selector != null) {
            String[] properties;
            for (String property : properties = selector.split(",")) {
                SelectorItemInfo selectorItemInfo = new SelectorItemInfo(property);
                selectorItemCollection.add(selectorItemInfo);
            }
        }
        return CompanyOrgUnitFactory.getLocalInstance((Context)this.context).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), selectorItemCollection);
    }

    @Override
    public Map<Integer, BigDecimal> getDepAmountByPeriod(String companyId, String startNumer, String currentNumer) throws EASBizException, BOSException {
        String AMOUNT_SQL = "select c.fnumber, sum(b.fdepreciation) as amount from t_fa_fadepreciation a  inner join t_fa_fadepreciationentry b on b.flnkfadepreentry = a.fid  inner join t_bd_period c on a.fperiod = c.fid  where a.fcompanyid  = ?  and c.fnumber >= ? and c.fnumber <= ?  group by c.fnumber";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(companyId);
        paramList.add(startNumer);
        paramList.add(currentNumer);
        HashMap<Integer, BigDecimal> resultMap = new HashMap<Integer, BigDecimal>();
        IRowSet rs = DbUtil.executeQuery((Context)this.context, (String)"select c.fnumber, sum(b.fdepreciation) as amount from t_fa_fadepreciation a  inner join t_fa_fadepreciationentry b on b.flnkfadepreentry = a.fid  inner join t_bd_period c on a.fperiod = c.fid  where a.fcompanyid  = ?  and c.fnumber >= ? and c.fnumber <= ?  group by c.fnumber", (Object[])paramList.toArray());
        try {
            while (rs.next()) {
                resultMap.put(rs.getInt("fnumber"), rs.getBigDecimal("amount"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return resultMap;
    }

    @Override
    public Map<Integer, Integer> getDepQuantityByPeriod(String companyId, String startNumer, String currentNumer) throws EASBizException, BOSException {
        String QUANTITY_SQL = "select c.fnumber, count(1) as count from t_fa_fadepreciation a  inner join t_fa_fadepreciationentry b on b.flnkfadepreentry = a.fid  inner join t_bd_period c on a.fperiod = c.fid  where a.fcompanyid = ?  and c.fnumber >= ? and c.fnumber <= ?  group by c.fnumber ";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(companyId);
        paramList.add(startNumer);
        paramList.add(currentNumer);
        HashMap<Integer, Integer> resultMap = new HashMap<Integer, Integer>();
        IRowSet rs = DbUtil.executeQuery((Context)this.context, (String)"select c.fnumber, count(1) as count from t_fa_fadepreciation a  inner join t_fa_fadepreciationentry b on b.flnkfadepreentry = a.fid  inner join t_bd_period c on a.fperiod = c.fid  where a.fcompanyid = ?  and c.fnumber >= ? and c.fnumber <= ?  group by c.fnumber ", (Object[])paramList.toArray());
        try {
            while (rs.next()) {
                resultMap.put(rs.getInt("fnumber"), rs.getInt("count"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return resultMap;
    }

    @Override
    public String getDepPeriodIdByPeriodNumber(String companyId, int periodNumber) throws EASBizException, BOSException {
        String sql = "select c.fid from t_fa_fadepreciation a  inner join t_bd_period c on a.fperiod = c.fid  where a.fcompanyid = ?  and c.fnumber = ? ";
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(companyId);
        paramList.add(periodNumber);
        IRowSet rs = DbUtil.executeQuery((Context)this.context, (String)sql, (Object[])paramList.toArray());
        String periodId = null;
        try {
            if (rs.next()) {
                periodId = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return periodId;
    }

    @Override
    public List getMyAttention(String companyId, String userId) throws BOSException, EASBizException {
        PeriodInfo period = this.getCurrentPeriodInfo(companyId);
        String periodId = null;
        if (period == null) {
            return null;
        }
        periodId = period.getString("id");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(periodId);
        paramList.add(companyId);
        paramList.add(userId);
        String realSql = "select a.fid, b.fid as acctFid, b.Fnumber, b.FName_L2,  isnull(case when a.FBalanceType = 0 then sum(d.frealbeginbalancefor)  when a.FBalanceType = 1 then sum(d.frealdebitFor) when a.FBalanceType = 2 then sum(d.frealCreditFor) when a.FBalanceType = 3 then sum(d.frealendbalanceFor) end, 0.00) as balance, (case when a.FBalanceType = 0 then '\ufffd\u06b3\ufffd\ufffd\ufffd\ufffd'  when a.FBalanceType = 1 then '\ufffd\ufffd\ufffd\u06bd\u8dfd\ufffd\ufffd\ufffd\ufffd' when a.FBalanceType = 2 then '\ufffd\ufffd\ufffd\u06b4\ufffd\ufffd\ufffd'  when a.FBalanceType = 3 then '\ufffd\ufffd\u0129\ufffd\ufffd\ufffd' end) as balanceType  from T_Fa_FaPlatformAttention a  join T_BD_AccountView b on a.faccoutid = b.fid  left join t_fa_facurcard c on c.FAccountAssetId = b.fid  left join t_fa_faaccountbalance d on d.ffacurcardid = c.fid  and d.fperiodid = ?  where a.fcompanyid = ?  and a.fuserid = ?  group by a.fid, b.fid, b.FName_L2, b.Fnumber, a.FBalanceType";
        String depSql = "select a.fid, b.fid as acctFid,  b.Fnumber, b.FName_L2,  isnull(case when a.FBalanceType = 0 then sum(d.fDepreBeginbalancefor)  when a.FBalanceType = 1 then sum(d.fDepreDebitFor) when a.FBalanceType = 2 then sum(d.fDepreCreditFor) when a.FBalanceType = 3 then sum(d.fDepreEndbalanceFor) end, 0.00) as balance, (case when a.FBalanceType = 0 then '\ufffd\u06b3\ufffd\ufffd\ufffd\ufffd'  when a.FBalanceType = 1 then '\ufffd\ufffd\ufffd\u06bd\u8dfd\ufffd\ufffd\ufffd\ufffd' when a.FBalanceType = 2 then '\ufffd\ufffd\ufffd\u06b4\ufffd\ufffd\ufffd'  when a.FBalanceType = 3 then '\ufffd\ufffd\u0129\ufffd\ufffd\ufffd' end) as balanceType  from T_Fa_FaPlatformAttention a  join T_BD_AccountView b on a.faccoutid = b.fid  left join t_fa_facurcard c on c.FAccountAccuDeprID = b.fid  left join t_fa_faaccountbalance d on d.ffacurcardid = c.fid  and d.fperiodid = ?  where a.fcompanyid = ? and a.fuserid = ?  group by a.fid, b.fid, b.FName_L2, b.Fnumber, a.FBalanceType";
        String decSql = "select a.fid, b.fid as acctFid, b.Fnumber, b.FName_L2,  isnull(case when a.FBalanceType = 0 then sum(d.fDecValueBeginbalancefor)  when a.FBalanceType = 1 then sum(d.fDecValueDebitFor) when a.FBalanceType = 2 then sum(d.fDecValueCreditFor) when a.FBalanceType = 3 then sum(d.fDecValueEndbalanceFor) end, 0.00) as balance, (case when a.FBalanceType = 0 then '\ufffd\u06b3\ufffd\ufffd\ufffd\ufffd'  when a.FBalanceType = 1 then '\ufffd\ufffd\ufffd\u06bd\u8dfd\ufffd\ufffd\ufffd\ufffd' when a.FBalanceType = 2 then '\ufffd\ufffd\ufffd\u06b4\ufffd\ufffd\ufffd'  when a.FBalanceType = 3 then '\ufffd\ufffd\u0129\ufffd\ufffd\ufffd' end) as balanceType  from T_Fa_FaPlatformAttention a  join T_BD_AccountView b on a.faccoutid = b.fid  left join t_fa_facurcard c on c.FAccountDecValueID = b.fid  left join t_fa_faaccountbalance d on d.ffacurcardid = c.fid  and d.fperiodid = ?  where a.fcompanyid = ? and a.fuserid = ?  group by a.fid, b.fid, b.FName_L2, b.Fnumber, a.FBalanceType";
        IRowSet rs = DbUtil.executeQuery((Context)this.context, (String)realSql, (Object[])paramList.toArray());
        ArrayList realList = new ArrayList();
        try {
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", rs.getString("fid"));
                map.put("account", rs.getString("Fnumber") + rs.getString("FName_L2"));
                map.put("balanceType", rs.getString("balanceType"));
                map.put("balance", rs.getBigDecimal("balance"));
                realList.add(map);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        rs = DbUtil.executeQuery((Context)this.context, (String)depSql, (Object[])paramList.toArray());
        ArrayList depList = new ArrayList();
        try {
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", rs.getString("fid"));
                map.put("account", rs.getString("Fnumber") + rs.getString("FName_L2"));
                map.put("balanceType", rs.getString("balanceType"));
                map.put("balance", rs.getBigDecimal("balance"));
                depList.add(map);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        rs = DbUtil.executeQuery((Context)this.context, (String)decSql, (Object[])paramList.toArray());
        ArrayList decList = new ArrayList();
        try {
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", rs.getString("fid"));
                map.put("account", rs.getString("Fnumber") + rs.getString("FName_L2"));
                map.put("balanceType", rs.getString("balanceType"));
                map.put("balance", rs.getBigDecimal("balance"));
                decList.add(map);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        ArrayList<Map> balanceList = new ArrayList<Map>();
        for (Object e : realList) {
            Map realMap = (Map)e;
            BigDecimal sumBalance = new BigDecimal(realMap.get("balance").toString());
            for (Object e2 : depList) {
                Map depMap = (Map)e2;
                if (!depMap.get("id").equals(realMap.get("id"))) continue;
                sumBalance = sumBalance.add(new BigDecimal(depMap.get("balance").toString()));
            }
            for (Object e3 : decList) {
                Map decMap = (Map)e3;
                if (!decMap.get("id").equals(realMap.get("id"))) continue;
                sumBalance = sumBalance.add(new BigDecimal(decMap.get("balance").toString()));
            }
            realMap.put("balance", sumBalance);
            balanceList.add(realMap);
        }
        return balanceList;
    }

    @Override
    public void deleteMyAttention(String myAttentionId) throws BOSException {
        String sql = " delete from  T_Fa_FaPlatformAttention where fid = ?";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(myAttentionId);
        DbUtil.execute((Context)this.context, (String)sql, (Object[])paramList.toArray());
    }
}

