/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.services.impl;

import com.google.gson.internal.LinkedTreeMap;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.DataObject;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseFacade;
import com.kingdee.eas.fi.gl.rpt.GLRptQueryInitData;
import com.kingdee.eas.fi.gl.rpt.GLRptQueryResult;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.GLRptTreeNode;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.fi.gl.services.IGLRptBaseService;
import com.kingdee.eas.fi.gl.services.impl.rpt.GLRptBaseConditionBuilder;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.RptException;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Base64Encoder;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class GLRptBaseServiceImpl
extends GLRptBaseFacade
implements IGLRptBaseService {
    private static Logger logger = Logger.getLogger(GLRptBaseServiceImpl.class);
    protected final Context ctx;

    public GLRptBaseServiceImpl(Context ctx) {
        this.ctx = ctx;
    }

    public GLRptQueryInitData getQueryInitData(boolean isSupportUnion) throws BOSException, EASBizException {
        return this.getBizCtrl().getQueryInitData(isSupportUnion);
    }

    public Map getPeriodRange(Set companyIdSet, String periodTypeId) throws BOSException, EASBizException {
        return this.getBizCtrl().getPeriodRange(companyIdSet, periodTypeId);
    }

    protected abstract IGLRptBaseFacade getBizCtrl() throws BOSException;

    public CompanyOrgUnitInfo getCompanyInfo(String companyID, String selector) throws EASBizException, BOSException {
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        if (selector != null) {
            String[] properties;
            for (String property : properties = selector.split(",")) {
                SelectorItemInfo selectorItemInfo = new SelectorItemInfo(property);
                selectorItemCollection.add(selectorItemInfo);
            }
        }
        return CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), selectorItemCollection);
    }

    public CompanyOrgUnitCollection getCompanys(Set companyIdSet, String selector) throws EASBizException, BOSException {
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        if (selector != null) {
            String[] properties;
            for (String property : properties = selector.split(",")) {
                SelectorItemInfo selectorItemInfo = new SelectorItemInfo(property);
                selectorItemCollection.add(selectorItemInfo);
            }
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)companyIdSet, CompareType.INCLUDE));
        return CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitCollection(EntityViewInfo.getInstance((FilterInfo)filter, (SelectorItemCollection)selectorItemCollection, null));
    }

    public int getAccountMaxLevel(Set companyIdSet, String accountTableId) throws BOSException, EASBizException {
        return this.getBizCtrl().getAccountMaxLevel(companyIdSet, accountTableId);
    }

    public Map saveQuerySolution(String uipk, String filterUIPK, String queryPK, String solutionName, ArrayList customFilter, ArrayList queryFilter, ArrayList queryOrder, boolean isdefault) throws BOSException, EASBizException {
        QuerySolutionInfo solutionInfo = this.getSameNameSolution(solutionName, queryPK, uipk);
        HashMap<String, String> results = new HashMap<String, String>();
        String viewId = "";
        if (solutionInfo != null) {
            viewId = solutionInfo.getId().toString();
            this.editSolution(viewId, solutionName, queryPK, filterUIPK, customFilter, queryFilter, queryOrder, isdefault);
            results.put("oprSta", "update");
        } else {
            viewId = this.addSolution(solutionName, queryPK, filterUIPK, uipk, customFilter, queryFilter, queryOrder, isdefault);
            results.put("oprSta", "addnew");
        }
        results.put("viewId", viewId);
        return results;
    }

    private QuerySolutionInfo getSameNameSolution(String solutionName, String queryPK, String parentPageName) {
        MetaDataPK queryObjectPK = new MetaDataPK(queryPK);
        QueryInfo queryInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getQuery((IMetaDataPK)queryObjectPK);
        String orgID = GLRptBaseServiceImpl.getOrgIDString(this.ctx, queryInfo);
        try {
            IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)this.ctx);
            return iQuerySolution.getOwnerSolutionByName(orgID, queryPK, parentPageName, ShareTypeEnum.USER_LEVEL, solutionName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getOrgIDString(Context ctx, QueryInfo queryInfo) {
        try {
            BOSUuid id = GLRptBaseServiceImpl.getOrgID(ctx, queryInfo);
            if (id != null) {
                return id.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static BOSUuid getOrgID(Context ctx, QueryInfo queryInfo) {
        BOSUuid orgID = null;
        try {
            String orgType = null;
            if (GLRptBaseServiceImpl.getOrgType(queryInfo) != null) {
                orgType = GLRptBaseServiceImpl.getOrgType(queryInfo).getName();
            }
            if (orgType != null) {
                if ("Admin".equalsIgnoreCase(orgType)) {
                    orgID = ContextUtil.getCurrentAdminUnit((Context)ctx).getId();
                } else if ("Company".equalsIgnoreCase(orgType)) {
                    orgID = ContextUtil.getCurrentFIUnit((Context)ctx).getId();
                } else if ("Sale".equalsIgnoreCase(orgType)) {
                    orgID = ContextUtil.getCurrentSaleUnit((Context)ctx).getId();
                } else if ("Purchase".equalsIgnoreCase(orgType)) {
                    orgID = ContextUtil.getCurrentPurchaseUnit((Context)ctx).getId();
                } else if ("Storage".equalsIgnoreCase(orgType)) {
                    orgID = ContextUtil.getCurrentStorageUnit((Context)ctx).getId();
                } else if ("CostCenter".equalsIgnoreCase(orgType)) {
                    orgID = ContextUtil.getCurrentCostUnit((Context)ctx).getId();
                } else if ("ProfitCenter".equalsIgnoreCase(orgType)) {
                    orgID = ContextUtil.getCurrentProfitUnit((Context)ctx).getId();
                } else if ("ControlUnit".equalsIgnoreCase(orgType)) {
                    orgID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId();
                } else if ("HRO".equalsIgnoreCase(orgType)) {
                    orgID = ContextUtil.getCurrentHRUnit((Context)ctx).getId();
                } else if ("NONE".equalsIgnoreCase(orgType)) {
                    orgID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId();
                }
            } else {
                orgID = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            orgID = null;
        }
        return orgID;
    }

    public static OrgType getOrgType(QueryInfo queryInfo) {
        OrgType orgType = null;
        try {
            EntityObjectInfo eo;
            String orgTypeStr;
            SubObjectInfo main = queryInfo.getMainObject();
            if (main instanceof SubQueryInfo) {
                main = ((SubQueryInfo)main).getQueryRef().getMainObject();
            }
            if ((orgTypeStr = (eo = ((SubEntityInfo)main).getEntityRef()).getExtendedProperty("OrgType")) != null) {
                if ("Admin".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.Admin;
                } else if ("Company".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.Company;
                } else if ("Sale".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.Sale;
                } else if ("Purchase".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.Purchase;
                } else if ("Storage".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.Storage;
                } else if ("CostCenter".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.CostCenter;
                } else if ("ProfitCenter".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.ProfitCenter;
                } else if ("ControlUnit".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.ControlUnit;
                } else if ("HRO".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.HRO;
                } else if ("Transport".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.Transport;
                } else if ("NONE".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.NONE;
                }
            } else {
                orgType = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            orgType = null;
        }
        return orgType;
    }

    private boolean editSolution(String solutionID, String solutionName, String queryPK, String filterUIPK, ArrayList customDataList, ArrayList filterDataList, ArrayList orderDataList, boolean isdefault) {
        try {
            IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)this.ctx);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)solutionID));
            QuerySolutionInfo solutionInfo = iSolution.getQuerySolutionInfo((IObjectPK)pk);
            solutionInfo.setEntityViewInfo(this.getEntityViewInfo(queryPK, filterDataList).toString());
            solutionInfo.setShareType(ShareTypeEnum.USER_LEVEL);
            solutionInfo.setIsUserDefaultSolu(isdefault);
            QueryPanelCollection queryPanelCol = new QueryPanelCollection();
            queryPanelCol.add(this.getCustomFilterQueryPanel(filterUIPK, customDataList));
            queryPanelCol.add(this.getFilterQueryPanel(queryPK, filterDataList));
            queryPanelCol.add(this.getOrderQueryPanel(queryPK, orderDataList));
            solutionInfo.getQueryPanelInfo().clear();
            solutionInfo.getQueryPanelInfo().addCollection(queryPanelCol);
            solutionInfo.setRowCount(-1);
            iSolution.update((IObjectPK)pk, (CoreBaseInfo)solutionInfo);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private String addSolution(String solutionName, String queryPK, String filterUIPK, String parentPageName, ArrayList customDataList, ArrayList filterDataList, ArrayList orderDataList, boolean isdefault) {
        MetaDataPK queryObjectPK = new MetaDataPK(queryPK);
        QueryInfo queryInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getQuery((IMetaDataPK)queryObjectPK);
        try {
            QuerySolutionInfo solutionInfo = new QuerySolutionInfo();
            solutionInfo.setName(solutionName);
            solutionInfo.setName(solutionName, new Locale("l1"));
            solutionInfo.setName(solutionName, new Locale("l3"));
            solutionInfo.setOwner(ContextUtil.getCurrentUserInfo((Context)this.ctx).getId());
            solutionInfo.setOrgID(GLRptBaseServiceImpl.getOrgID(this.ctx, queryInfo));
            solutionInfo.setQueryObjectName(queryPK);
            solutionInfo.setEntityViewInfo(this.getEntityViewInfo(queryPK, filterDataList).toString());
            solutionInfo.setShareType(ShareTypeEnum.USER_LEVEL);
            solutionInfo.setSolutionType(SolutionTypeEnum.CUSTOMER_SOLUTION);
            solutionInfo.setParentUIName(parentPageName);
            solutionInfo.setIsUserDefaultSolu(isdefault);
            QueryPanelCollection queryPanelCol = new QueryPanelCollection();
            queryPanelCol.add(this.getCustomFilterQueryPanel(filterUIPK, customDataList));
            queryPanelCol.add(this.getFilterQueryPanel(queryPK, filterDataList));
            queryPanelCol.add(this.getOrderQueryPanel(queryPK, orderDataList));
            solutionInfo.getQueryPanelInfo().addCollection(queryPanelCol);
            solutionInfo.setRowCount(-1);
            IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)this.ctx);
            IObjectPK pk = iSolution.addnew((CoreBaseInfo)solutionInfo);
            solutionInfo.setId(BOSUuid.read((String)pk.toString()));
            return solutionInfo.getId().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private EntityViewInfo getEntityViewInfo(String queryPK, ArrayList filterDataList) {
        EntityViewInfo resultEntityViewInfo = new EntityViewInfo();
        if (resultEntityViewInfo.getFilter() != null) {
            resultEntityViewInfo.getFilter().setMaskString("");
            resultEntityViewInfo.getFilter().getFilterItems().clear();
        }
        resultEntityViewInfo.setFilter(this.getCommFilter(queryPK, filterDataList));
        return resultEntityViewInfo;
    }

    private QueryPanelInfo getCustomFilterQueryPanel(String filterUIPK, ArrayList customfilterDataList) throws Exception {
        QueryPanelInfo queryPanelInfo = new QueryPanelInfo();
        queryPanelInfo.setPanelClassName(filterUIPK);
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        int rowCount = customfilterDataList.size();
        for (int i = 0; i < rowCount; ++i) {
            Object compareValue = null;
            LinkedTreeMap hsFilter = (LinkedTreeMap)customfilterDataList.get(i);
            String filterField = (String)hsFilter.get((Object)"prop_field");
            Object fValue = hsFilter.get((Object)"prop_value");
            filterMap.put(filterField, fValue);
        }
        GLRptBaseCondition condition = this.getConditionBuilder().getCustomCondition(this.ctx, filterMap);
        CustomerParams cp = new CustomerParams();
        if (cp != null) {
            cp.addCustomerParam("RPTPARAMS_KEY_AT_CUSTOMERPARAMS", Base64Encoder.byteArrayToBase64((byte[])GLRptBaseServiceImpl.getBytes(RptFilterUtils.toRptFilterMapFromObject((Object)condition.toMap()))));
        }
        String customerParams = null;
        if (cp != null) {
            Collection keys = cp.getKeys();
            Collection values = cp.getValues();
            if (keys.size() > 0) {
                customerParams = XMLBean.CreateXMLStrRecursion((Collection)keys, (Collection)values);
            }
        }
        queryPanelInfo.setCustomerParams(customerParams);
        queryPanelInfo.setSorterInfo(null);
        queryPanelInfo.setParam(null);
        queryPanelInfo.setPanelName("\u6761\u4ef6");
        queryPanelInfo.setQueryPanelType(QueryPanelTypeEnum.CUSTOMER_PANEL);
        return queryPanelInfo;
    }

    protected abstract GLRptBaseConditionBuilder getConditionBuilder();

    private QueryPanelInfo getFilterQueryPanel(String queryPK, ArrayList filterDataList) throws Exception {
        QueryPanelInfo queryPanelInfo = new QueryPanelInfo();
        queryPanelInfo.setPanelClassName("com.kingdee.eas.base.commonquery.client.CommonFilterPanel");
        FilterInfo filter = this.getCommFilter(queryPK, filterDataList);
        queryPanelInfo.setFilterInfo(filter.toString());
        queryPanelInfo.setSorterInfo(null);
        queryPanelInfo.setParam(null);
        queryPanelInfo.setPanelName("\u81ea\u5b9a\u4e49");
        queryPanelInfo.setQueryPanelType(QueryPanelTypeEnum.FILTER_PANEL);
        return queryPanelInfo;
    }

    private QueryPanelInfo getOrderQueryPanel(String queryPK, ArrayList orderDataList) throws Exception {
        QueryPanelInfo queryPanelInfo = new QueryPanelInfo();
        queryPanelInfo.setPanelName("\u6392\u5e8f");
        queryPanelInfo.setPanelClassName("com.kingdee.eas.base.commonquery.client.CommonSorterPanel");
        String orderString = this.getCommOrder(queryPK, orderDataList);
        queryPanelInfo.setFilterInfo(null);
        queryPanelInfo.setSorterInfo(orderString);
        queryPanelInfo.setParam(null);
        queryPanelInfo.setQueryPanelType(QueryPanelTypeEnum.SORTER_PANEL);
        return queryPanelInfo;
    }

    private FilterInfo getCommFilter(String queryPK, ArrayList filterDataList) {
        MetaDataPK queryObjectPK = new MetaDataPK(queryPK);
        QueryInfo queryInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getQuery((IMetaDataPK)queryObjectPK);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItem = null;
        int rowCount = filterDataList.size();
        for (int i = 0; i < rowCount; ++i) {
            String filterField;
            Object compareValue = null;
            LinkedTreeMap hsFilter = (LinkedTreeMap)filterDataList.get(i);
            String realField = filterField = (String)hsFilter.get((Object)"prop_field");
            if (filterField.indexOf("aqdef.") >= 0) {
                realField = filterField.substring(6);
            }
            String compareOp = (String)hsFilter.get((Object)"prop_op");
            Object fValue = hsFilter.get((Object)"prop_value");
            if (fValue instanceof String) {
                compareValue = this.processDateType(realField, (String)fValue, compareOp, queryInfo);
            }
            if (this.isUsingF7(realField, queryInfo) && fValue instanceof LinkedTreeMap) {
                compareValue = this.processF7Type(realField, (LinkedTreeMap)fValue);
            }
            if (compareValue == null) {
                compareValue = fValue;
            }
            if (compareValue != null && ("like".equals(compareOp) || "not like".equals(compareOp))) {
                String value = compareValue.toString();
                if (value.charAt(0) != '%') {
                    value = "%" + value;
                }
                if (!value.endsWith("%")) {
                    value = value + "%";
                }
                compareValue = value;
            } else if ("is".equals(compareOp) || "is not".equals(compareOp)) {
                compareValue = null;
            } else if (compareOp.startsWith("tod=")) {
                compareValue = "today";
                compareOp = "=";
            } else if (compareOp.startsWith("yes=")) {
                compareValue = "yesterday";
                compareOp = "=";
            } else if (compareOp.startsWith("tom=")) {
                compareValue = "tomorrow";
                compareOp = "=";
            }
            filterItem = new FilterItemInfo(filterField, compareValue, CompareType.getEnum((String)compareOp));
            filterInfo.getFilterItems().add(filterItem);
        }
        return filterInfo;
    }

    private String getCommOrder(String queryPK, ArrayList orderDataList) {
        StringBuffer orderString = new StringBuffer();
        int rowCount = orderDataList.size();
        if (rowCount > 0) {
            orderString.append("ORDER BY");
        }
        for (int i = 0; i < rowCount; ++i) {
            Object compareValue = null;
            LinkedTreeMap hsFilter = (LinkedTreeMap)orderDataList.get(i);
            String filterField = (String)hsFilter.get((Object)"prop_field");
            String compareOp = (String)hsFilter.get((Object)"prop_op");
            orderString.append(" ").append(filterField).append(" ").append(compareOp);
            if (i >= rowCount - 1) continue;
            orderString.append(",");
        }
        return orderString.toString();
    }

    private Object processDateType(String filterField, String filterValue, String compareOp, QueryInfo queryInfo) {
        if (StringUtils.isEmpty((String)filterValue)) {
            return null;
        }
        if (this.isUsingDate(filterField, queryInfo)) {
            if (filterValue.startsWith("d") || filterValue.startsWith("w") || filterValue.startsWith("m")) {
                return null;
            }
            return filterValue;
        }
        return null;
    }

    private boolean isUsingDate(String queryFieldName, QueryInfo queryInfo) {
        String type;
        DataObject dataObject = QueryUtils.getRefMetaData(null, (QueryInfo)queryInfo, (String)queryFieldName);
        return dataObject != null && ((type = dataObject.getName()).equalsIgnoreCase(DataType.DATE.getName()) || type.equalsIgnoreCase(DataType.TIMESTAMP.getName()) || type.equalsIgnoreCase(DataType.TIME.getName()));
    }

    private Object processF7Type(String filterField, LinkedTreeMap filterValue) {
        if (filterValue == null) {
            return null;
        }
        return filterValue.get((Object)"id");
    }

    private boolean isUsingF7(String queryFieldName, QueryInfo queryInfo) {
        String type;
        DataObject dataObject = QueryUtils.getRefMetaData(null, (QueryInfo)queryInfo, (String)queryFieldName);
        return dataObject != null && (type = dataObject.getName()).equalsIgnoreCase("F7");
    }

    public static byte[] getBytes(Object object) {
        byte[] bytes = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            bytes = byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return bytes;
    }

    public static Object getObject(byte[] bytes) {
        Object object = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return object;
    }

    public Map getQuerySolution(String id, String queryPK) throws BOSException, EASBizException {
        QueryInfo queryInfo = null;
        if (!StringUtils.isEmpty((String)queryPK)) {
            MetaDataPK queryObjectPK = new MetaDataPK(queryPK);
            queryInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getQuery((IMetaDataPK)queryObjectPK);
        }
        ArrayList filters = new ArrayList();
        ArrayList orders = new ArrayList();
        Map customCondition = new HashMap();
        QuerySolutionInfo solutionInfo = null;
        try {
            IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)this.ctx);
            solutionInfo = iQuerySolution.getQuerySolutionInfo((IObjectPK)new ObjectUuidPK(id));
            QueryPanelCollection queryPanels = solutionInfo.getQueryPanelInfo();
            for (int i0 = 0; i0 < queryPanels.size(); ++i0) {
                QueryPanelInfo info = queryPanels.get(i0);
                if (!StringUtils.isEmpty((String)queryPK) && QueryPanelTypeEnum.FILTER_PANEL.equals((Object)info.getQueryPanelType())) {
                    FilterInfo filterInfo = new FilterInfo(info.getFilterInfo());
                    if (!FilterUtility.hasFilterItem((FilterInfo)filterInfo)) continue;
                    FilterItemCollection filterItemCol = filterInfo.getFilterItems();
                    for (int i = 0; i < filterItemCol.size(); ++i) {
                        FilterItemInfo filterItemInfo = filterItemCol.get(i);
                        String filterField = filterItemInfo.getPropertyName();
                        String filterValue = null;
                        Object cmpVal = filterItemInfo.getCompareValue();
                        if (cmpVal != null) {
                            filterValue = cmpVal.toString();
                        }
                        String compareOp = filterItemInfo.getCompareType().toString();
                        if ((CompareType.LIKE.toString().equals(compareOp) || CompareType.NOTLIKE.toString().equals(compareOp)) && filterValue != null && filterValue.length() > 2) {
                            if (filterValue.startsWith("%")) {
                                filterValue = filterValue.substring(1);
                            }
                            if (filterValue.endsWith("%")) {
                                filterValue = filterValue.substring(0, filterValue.length() - 1);
                            }
                        }
                        HashMap<String, String> row = new HashMap<String, String>();
                        row.put("prop_field", filterField);
                        row.put("prop_op", compareOp);
                        row.put("prop_value", filterValue);
                        filters.add(row);
                    }
                    continue;
                }
                if (!StringUtils.isEmpty((String)queryPK) && QueryPanelTypeEnum.SORTER_PANEL.equals((Object)info.getQueryPanelType()) && !StringUtils.isEmpty((String)info.getSorterInfo())) {
                    String orderString = info.getSorterInfo();
                    SorterItemCollection sortColl = new SorterItemCollection(orderString);
                    for (int i = 0; i < sortColl.size(); ++i) {
                        SorterItemInfo sorterItemInfo = sortColl.get(i);
                        HashMap<String, String> row = new HashMap<String, String>();
                        row.put("prop_field", sorterItemInfo.getPropertyName());
                        row.put("prop_op", sorterItemInfo.getSortType().getName());
                        orders.add(row);
                    }
                    continue;
                }
                if (!QueryPanelTypeEnum.CUSTOMER_PANEL.equals((Object)info.getQueryPanelType()) || StringUtils.isEmpty((String)info.getCustomerParams())) continue;
                String customerParams = info.getCustomerParams();
                CustomerParams cp = XMLBean.transStrToCommonCustParams((String)customerParams);
                Object param = this.getFromCustomerParams(cp, "RPTPARAMS_KEY_AT_CUSTOMERPARAMS");
                if (param instanceof RptFilterInfo || param instanceof RptFilterCollection || param instanceof RptFilterInfo[] || param instanceof RptFilterCollection[]) {
                    param = RptFilterUtils.toObjectFromRptFilterMap((Object)param);
                }
                if (param instanceof RptParams) {
                    param = ((RptParams)param).toMap();
                }
                GLRptBaseCondition condition = this.createReportCondition((Map)param);
                customCondition = this.getConditionBuilder().setCustomCondition(this.ctx, condition);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("searchFilter", filters);
        data.put("searchOrder", orders);
        data.put("customCondition", customCondition);
        data.put("defaultView", solutionInfo.isIsUserDefaultSolu());
        return data;
    }

    protected abstract GLRptBaseCondition createReportCondition(Map var1) throws CloneNotSupportedException;

    private Object getFromCustomerParams(CustomerParams cp, String key) throws EASBizException {
        if (cp != null) {
            String s = cp.getCustomerParam(key);
            if (s != null) {
                byte[] bytes = Base64Encoder.base64ToByteArray((String)s);
                Object object = null;
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
                    ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    object = objectInputStream.readObject();
                    return object;
                }
                catch (Exception e) {
                    throw new RptException(RptException.IOSERIALIZABLE_ERROR);
                }
            }
            throw new RptException(RptException.IOSERIALIZABLE_ERROR);
        }
        return null;
    }

    private IObjectValue getF7ValueInfo(String id) {
        ObjectUuidPK objpk = new ObjectUuidPK(id);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        try {
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)this.ctx);
            IObjectValue billInfo = iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk, sic);
            return billInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getResourceName() {
        return "com.kingdee.eas.fi.gl.GLXResource";
    }

    public Map query(Map condition) throws BOSException, EASBizException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        EntityViewInfo view = this.buildQueryCondition(condition);
        GLRptQueryResult queryResult = this.getBizCtrl().query(view);
        int size = queryResult.getTableHeadInfo().getColumnSize();
        ArrayList<GLRptTableHeadInfo.GLRptTableColumnInfo> columns = new ArrayList<GLRptTableHeadInfo.GLRptTableColumnInfo>(size);
        GLRptTableHeadInfo.GLRptTableColumnInfo idColumn = new GLRptTableHeadInfo.GLRptTableColumnInfo(new GLRptTableHeadInfo());
        idColumn.setColName("id");
        columns.add(idColumn);
        for (int i = 0; i < size; ++i) {
            GLRptTableHeadInfo.GLRptTableColumnInfo col = queryResult.getTableHeadInfo().getTableColumnInfo(i);
            columns.add(col);
            if (!col.isNumeral()) continue;
            col.setAlign(3);
        }
        String[][] hNamess = queryResult.getTableHeadInfo().getHeadTitle();
        ArrayList headNamess = new ArrayList(hNamess.length);
        ArrayList headTitless = new ArrayList(hNamess.length);
        for (int i = 0; i < hNamess.length; ++i) {
            ArrayList<String> headNames = new ArrayList<String>(hNamess[i].length + 1);
            ArrayList<String> headTitles = new ArrayList<String>(hNamess[i].length + 1);
            headNames.add("id");
            headTitles.add("ID");
            for (int j = 0; j < hNamess[i].length; ++j) {
                headNames.add(hNamess[i][j]);
                String headTitle = "";
                if (hNamess[i][j] == null) {
                    headTitles.add(headTitle);
                    continue;
                }
                headTitle = ResourceBase.getString((String)this.getResourceName(), (String)hNamess[i][j], (Locale)this.ctx.getLocale()).equals("Missing Resource") ? hNamess[i][j] : ResourceBase.getString((String)this.getResourceName(), (String)hNamess[i][j], (Locale)this.ctx.getLocale());
                headTitles.add(headTitle);
            }
            headNamess.add(headNames);
            headTitless.add(headTitles);
        }
        data.put("queryId", queryResult.getQueryId());
        data.put("records", queryResult.getViewRowCount());
        data.put("columns", columns);
        data.put("headNamess", headNamess);
        data.put("headTitless", headTitless);
        data.put("sumRow", queryResult.getSumRow());
        return data;
    }

    protected EntityViewInfo buildQueryCondition(Map condition) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        Map obj = (Map)condition.get("rptFilter");
        if (obj == null || !(obj instanceof Map)) {
            return null;
        }
        Map rptFilter = obj;
        GLRptBaseCondition glRptBaseCondition = this.getConditionBuilder().getCustomCondition(this.ctx, rptFilter);
        view.put("GLFixCondition", (Object)glRptBaseCondition);
        view.put("PAGE_ROW_COUNT", (Object)0);
        return view;
    }

    public Map getData(Map condition) throws BOSException, EASBizException {
        int from;
        String queryId = (String)condition.get("queryId");
        String strPage = (String)condition.get("page");
        String strRecords = (String)condition.get("records");
        String strRows = (String)condition.get("rows");
        String strCurrentIndex = (String)condition.get("currentIndex");
        int currentIndex = -1;
        if (strCurrentIndex != null && strCurrentIndex.trim().length() > 0) {
            currentIndex = Integer.parseInt(strCurrentIndex.trim());
        }
        int page = Integer.parseInt(strPage);
        int rows = Integer.parseInt(strRows);
        int records = Integer.parseInt(strRecords);
        int total = records / rows;
        if (total * rows < records) {
            ++total;
        }
        if ((from = (page - 1) * rows) >= records) {
            page = 1;
            from = 0;
        }
        GLRptRowSet rowSet = this.getBizCtrl().getData(queryId, from, rows);
        String[] keys = rowSet.getColumKeys();
        ArrayList datas = new ArrayList(rowSet.size());
        rowSet.beforeFirst();
        while (rowSet.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            int rowIndex = rowSet.getRowIndex();
            if (rowIndex < currentIndex) continue;
            row.put("id", rowIndex);
            for (String key : keys) {
                Object value = rowSet.getObject(key);
                if (value instanceof GLRptTreeNode) {
                    GLRptTreeNode treeNode = (GLRptTreeNode)value;
                    row.put("level", treeNode.getLevel());
                    row.put("parent", "todo");
                    row.put("expanded", treeNode.isExpend());
                    row.put("isLeaf", treeNode.isLeaf());
                    if (!treeNode.isLeaf() && StringUtils.isEmpty((String)treeNode.toString())) {
                        row.put(key, "\u5408\u8ba1");
                        continue;
                    }
                    if (StringUtils.isEmpty((String)treeNode.toString())) {
                        row.put(key, "");
                        row.put("level", treeNode.getLevel() + 1);
                        continue;
                    }
                    row.put(key, treeNode.toString());
                    continue;
                }
                row.put(key, value);
            }
            datas.add(row);
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("page", Integer.valueOf(page));
        map.put("total", Integer.valueOf(total));
        map.put("records", Integer.valueOf(records));
        map.put("rows", datas);
        return map;
    }

    public Map queryPrint(Map condition) throws BOSException, EASBizException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        EntityViewInfo view = this.buildQueryCondition(condition);
        GLRptBaseCondition cond = (GLRptBaseCondition)view.get("GLFixCondition");
        GLRptQueryResult queryResult = this.getBizCtrl().query(view);
        String queryId = queryResult.getQueryId();
        int count = 0;
        GLRptRowSet rs = null;
        while (true) {
            GLRptRowSet rowSet = this.getBizCtrl().getData(queryId, count, 100);
            if (rs == null) {
                rs = rowSet;
            } else {
                rs.addRowSets(rowSet);
            }
            if (rowSet.size() < 100) break;
            count += 100;
        }
        GLRptRowSet sumRow = this.getBizCtrl().getSumData(queryId);
        if (sumRow != null) {
            while (sumRow.next()) {
                int rowIndex = sumRow.getRowIndex();
                String[] colKey = sumRow.getColumKeys();
                for (int i = 0; i < colKey.length; ++i) {
                    rs.updateObject(rowIndex, colKey[i], sumRow.getObject(colKey[i]));
                }
            }
        }
        this.releaseDataSource(queryId);
        data.put("cond", cond);
        data.put("rowSet", rs);
        data.put("head", queryResult.getTableHeadInfo());
        return data;
    }

    public void releaseDataSource(String queryId) throws BOSException {
        this.getBizCtrl().releaseDataSource(queryId);
    }

    public int expandRow(String queryId, int rowIndex) throws BOSException, EASBizException {
        return this.getBizCtrl().expandRow(queryId, rowIndex);
    }

    public int expandAllRow(String queryId, int rowIndex) throws BOSException, EASBizException {
        return this.getBizCtrl().expandAllRow(queryId, rowIndex);
    }

    public int shrinkRow(String queryId, int rowIndex) throws BOSException, EASBizException {
        return this.getBizCtrl().shrinkRow(queryId, rowIndex);
    }

    public CompanyOrgUnitInfo[] getValidCompanys(Set companyIDs, String accountTableId, String periodTypeId, String periodNumber) throws BOSException, EASBizException {
        if (companyIDs == null || companyIDs.size() == 0) {
            return null;
        }
        StringBuffer filterSql = new StringBuffer();
        filterSql.append(" select com.fid from t_org_company com ");
        filterSql.append(" inner join t_bd_acct_contorl ac on ac.fdestcompanyid = com.fid ");
        filterSql.append(" inner join t_bd_accounttable ab on ab.fid = ac.faccounttableid ");
        filterSql.append(" inner join t_bd_systemstatusctrol ssc on ssc.fcompanyid = com.fid");
        filterSql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = ").append(6);
        filterSql.append(" inner join t_bd_period pe on pe.fid = ssc.fstartperiodid ");
        filterSql.append(" where ac.FIsDefaultForRefer = 0 ");
        if (accountTableId != null) {
            filterSql.append(" and ab.fid = '").append(accountTableId).append("'");
        }
        filterSql.append(" and com.fid in ").append(GLRptBaseServiceImpl.getIdStr(companyIDs));
        filterSql.append(" and pe.fnumber <= ").append(periodNumber);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        if (periodTypeId != null) {
            fic.add(new FilterItemInfo("accountPeriodType.id", (Object)periodTypeId));
        }
        fic.add(new FilterItemInfo("id", (Object)filterSql.toString(), CompareType.INNER));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("longnumber"));
        view.setFilter(filter);
        view.setSelector(GlUtils.getCompanySic());
        view.setSorter(sorter);
        CompanyOrgUnitCollection companyCollection = null;
        try {
            companyCollection = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (companyCollection == null) {
            return null;
        }
        CompanyOrgUnitInfo[] checkedCompanys = new CompanyOrgUnitInfo[companyCollection.size()];
        for (int i = 0; i < companyCollection.size(); ++i) {
            checkedCompanys[i] = companyCollection.get(i);
        }
        return checkedCompanys;
    }

    public static String getIdStr(Set idSet) {
        if (idSet == null || idSet.size() == 0) {
            return null;
        }
        StringBuffer ids = new StringBuffer();
        Iterator it = idSet.iterator();
        ids.append("('").append(it.next()).append("'");
        while (it.hasNext()) {
            ids.append(",'").append(it.next()).append("'");
        }
        ids.append(")");
        return ids.toString();
    }

    public String getAllParentCompanyID(Set companyIdSet) throws BOSException {
        StringBuffer parents = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append("select pcp.fid from t_org_company pcp inner join t_org_company cp on (charindex(pcp.flongnumber||'!', cp.flongnumber) = 1 or pcp.fid = cp.fid) where cp.fid in(");
        Iterator it = companyIdSet.iterator();
        sql.append("'").append(it.next()).append("'");
        while (it.hasNext()) {
            sql.append(",'").append(it.next()).append("'");
        }
        sql.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                parents.append("'").append(rs.getString("fid")).append("'");
            }
            while (rs.next()) {
                parents.append(",'").append(rs.getString("fid")).append("'");
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql error!", (Throwable)e);
        }
        return parents.toString();
    }
}

