/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.Domain;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.IVoucherType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ReportCurrencyConvertMode;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyCollection;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyInfo;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.UserSettingFactory;
import com.kingdee.eas.fi.gl.UserSettingObject;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherCrossDuoCurrency;
import com.kingdee.eas.fi.gl.VoucherCrossProvider;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherPrintSettingInfo;
import com.kingdee.eas.fi.gl.VoucherRowSetProvider;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.services.VoucherService;
import com.kingdee.eas.fi.gl.services.impl.ServiceWebUtils;
import com.kingdee.eas.framework.AbstractCoreBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

@Component(value={"com.kingdee.eas.fi.gl.services.VoucherService"})
@Description(value="\u51ed\u8bc1\u670d\u52a1")
public class VoucherServiceImpl
implements VoucherService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.services.VoucherServiceImpl");
    public static final String PERMISSONID_VOUCHER_ADD = "6f20ed45-00fd-1000-e000-0001c0a81279PERMITEM";
    private final Context ctx;

    public VoucherServiceImpl(Context ctx) {
        this.ctx = ctx;
    }

    public VoucherInfo getVoucherInfo(String id, String selector) throws BOSException, EASBizException {
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        if (selector != null) {
            String[] properties;
            for (String property : properties = selector.split(",")) {
                if ("".equals(property) || "entries.localdebitamount".equals(property) || "entries.localcreditamount".equals(property) || "entries.rptdebitamount".equals(property) || "entries.rptcreditamount".equals(property) || "entries.assistrecordid".equals(property) || "entries.entryid".equals(property) || "entry_assistrecord_id".equals(property)) continue;
                SelectorItemInfo selectorItemInfo = new SelectorItemInfo(property);
                selectorItemCollection.add(selectorItemInfo);
            }
        }
        selectorItemCollection = this.fullSelector(selectorItemCollection);
        VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)this.ctx).getValue((IObjectPK)new ObjectUuidPK(id), selectorItemCollection);
        return this.toWebVoucherInfo(voucherInfo);
    }

    public VoucherCollection getVoucherCollection(String selector, String filteritem, String sorteritem) throws BOSException, EASBizException {
        return VoucherFactory.getLocalInstance((Context)this.ctx).getVoucherCollection("select " + selector + " where " + filteritem + (sorteritem != null && sorteritem.trim().length() > 0 ? " order by " + sorteritem : ""));
    }

    public void batchSubmitVoucher(String[] ids) throws EASBizException, BOSException {
        if (ids == null || ids.length == 0) {
            return;
        }
        if (ids.length == 1) {
            VoucherFactory.getLocalInstance((Context)this.ctx).submitVoucher((IObjectPK)new ObjectUuidPK(ids[0]));
        } else {
            VoucherFactory.getLocalInstance((Context)this.ctx).submitVoucherCollection(Arrays.asList(ids));
        }
    }

    public void deleteVoucher(String[] ids) throws EASBizException, BOSException {
        if (ids == null || ids.length == 0) {
            return;
        }
        if (ids.length == 1) {
            VoucherFactory.getLocalInstance((Context)this.ctx).delete((IObjectPK)new ObjectUuidPK(ids[0]), SystemEnum.GENERALLEDGER);
        } else {
            VoucherFactory.getLocalInstance((Context)this.ctx).deleteVoucherCollection(Arrays.asList(ids), SystemEnum.GENERALLEDGER);
        }
    }

    public void auditVoucher(String[] ids) throws EASBizException, BOSException {
        if (ids == null || ids.length == 0) {
            return;
        }
        if (ids.length == 1) {
            VoucherFactory.getLocalInstance((Context)this.ctx).auditVoucher((IObjectPK)new ObjectUuidPK(ids[0]), null);
        } else {
            VoucherFactory.getLocalInstance((Context)this.ctx).auditVoucherCollection(Arrays.asList(ids));
        }
    }

    public void antiAuditVoucher(String[] ids) throws EASBizException, BOSException {
        if (ids == null || ids.length == 0) {
            return;
        }
        if (ids.length == 1) {
            VoucherFactory.getLocalInstance((Context)this.ctx).antiAuditVoucher((IObjectPK)new ObjectUuidPK(ids[0]), null);
        } else {
            StringBuffer msg = new StringBuffer();
            for (int i = 0; i < ids.length; ++i) {
                try {
                    VoucherFactory.getLocalInstance((Context)this.ctx).antiAuditVoucher((IObjectPK)new ObjectUuidPK(ids[i]), null);
                    continue;
                }
                catch (Exception ex) {
                    VoucherInfo voucherInfo = this.getSimpleVoucherInfo(ids[i]);
                    msg.append("\r\n").append(voucherInfo.getCompany().getName()).append(" ");
                    msg.append(voucherInfo.getVoucherType().getName() + voucherInfo.getNumber() + " " + ex.getMessage());
                }
            }
            if (msg.length() > 0) {
                throw new VoucherException(VoucherException.ANTIAUDIT_FAILED, new Object[]{msg.toString()});
            }
        }
    }

    public void postVoucher(String[] ids) throws EASBizException, BOSException {
        if (ids == null || ids.length == 0) {
            return;
        }
        if (ids.length == 1) {
            VoucherFactory.getLocalInstance((Context)this.ctx).post((IObjectPK)new ObjectUuidPK(ids[0]), null);
        } else {
            VoucherFactory.getLocalInstance((Context)this.ctx).postVoucherCollection(Arrays.asList(ids), null);
        }
    }

    public void antiPostVoucher(String[] ids) throws EASBizException, BOSException {
        if (ids == null || ids.length == 0) {
            return;
        }
        if (ids.length == 1) {
            VoucherFactory.getLocalInstance((Context)this.ctx).antiPostVoucher((IObjectPK)new ObjectUuidPK(ids[0]), null);
        } else {
            StringBuffer msg = new StringBuffer();
            for (int i = 0; i < ids.length; ++i) {
                try {
                    VoucherFactory.getLocalInstance((Context)this.ctx).antiPostVoucher((IObjectPK)new ObjectUuidPK(ids[i]), null);
                    continue;
                }
                catch (Exception ex) {
                    VoucherInfo voucherInfo = this.getSimpleVoucherInfo(ids[i]);
                    msg.append("\r\n").append(voucherInfo.getCompany().getName()).append(" ");
                    msg.append(voucherInfo.getVoucherType().getName() + voucherInfo.getNumber() + " " + ex.getMessage());
                }
            }
            if (msg.length() > 0) {
                throw new VoucherException(VoucherException.UNPOST_FAIL, new Object[]{msg.toString()});
            }
        }
    }

    public void cancelVoucher(String[] ids) throws BOSException, EASBizException {
        if (ids == null || ids.length == 0) {
            return;
        }
        if (ids.length == 1) {
            VoucherFactory.getLocalInstance((Context)this.ctx).cancelVoucher((IObjectPK)new ObjectUuidPK(ids[0]));
        } else {
            StringBuffer msg = new StringBuffer();
            for (int i = 0; i < ids.length; ++i) {
                try {
                    VoucherFactory.getLocalInstance((Context)this.ctx).cancelVoucher((IObjectPK)new ObjectUuidPK(ids[i]));
                    continue;
                }
                catch (Exception ex) {
                    VoucherInfo voucherInfo = this.getSimpleVoucherInfo(ids[i]);
                    msg.append("\r\n").append(voucherInfo.getCompany().getName()).append(" ");
                    msg.append(voucherInfo.getVoucherType().getName() + voucherInfo.getNumber() + " " + ex.getMessage());
                }
            }
            if (msg.length() > 0) {
                throw new VoucherException(VoucherException.CANCEL_FAIL, new Object[]{msg.toString()});
            }
        }
    }

    public void antiCancelVoucher(String[] ids) throws BOSException, EASBizException {
        if (ids == null || ids.length == 0) {
            return;
        }
        if (ids.length == 1) {
            VoucherFactory.getLocalInstance((Context)this.ctx).antiCancelVoucher((IObjectPK)new ObjectUuidPK(ids[0]), null);
        } else {
            VoucherFactory.getLocalInstance((Context)this.ctx).antiCancelVoucherCollection(Arrays.asList(ids), null);
        }
    }

    public void checkVoucher(String[] ids) throws BOSException, EASBizException {
        if (ids == null || ids.length == 0) {
            return;
        }
        VoucherFactory.getLocalInstance((Context)this.ctx).checkVoucherCollection(Arrays.asList(ids));
    }

    public void antiCheckVoucher(String[] ids) throws BOSException, EASBizException {
        if (ids == null || ids.length == 0) {
            return;
        }
        if (ids.length == 1) {
            VoucherFactory.getLocalInstance((Context)this.ctx).antiCheckVoucher((IObjectPK)new ObjectUuidPK(ids[0]));
        } else {
            StringBuffer msg = new StringBuffer();
            for (int i = 0; i < ids.length; ++i) {
                try {
                    VoucherFactory.getLocalInstance((Context)this.ctx).antiCheckVoucher((IObjectPK)new ObjectUuidPK(ids[i]));
                    continue;
                }
                catch (Exception ex) {
                    VoucherInfo voucherInfo = this.getSimpleVoucherInfo(ids[i]);
                    msg.append("\r\n").append(voucherInfo.getCompany().getName()).append(" ");
                    msg.append(voucherInfo.getVoucherType().getName() + voucherInfo.getNumber() + " " + ex.getMessage());
                }
            }
            if (msg.length() > 0) {
                throw new VoucherException(VoucherException.ANTICHECK_FAIL, new Object[]{msg.toString()});
            }
        }
    }

    public String saveVoucher(VoucherInfo voucherInfo) throws BOSException, EASBizException {
        VoucherInfo newVoucherInfo = this.toVoucherInfo(voucherInfo);
        if (voucherInfo.getId() != null && (SourceType.NONE == voucherInfo.getSourceType() || voucherInfo.getSourceBillId() != null)) {
            IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)this.ctx);
            BOTRelationCollection relations = iBTPManager.getRelationCollection(voucherInfo.getId().toString());
            return iBTPManager.saveRelations((CoreBillBaseInfo)voucherInfo, relations).toString();
        }
        return VoucherFactory.getLocalInstance((Context)this.ctx).save((CoreBaseInfo)newVoucherInfo).toString();
    }

    public String submitVoucher(VoucherInfo voucherInfo) throws BOSException, EASBizException {
        VoucherInfo newVoucherInfo = this.toVoucherInfo(voucherInfo);
        if (voucherInfo.getId() != null && (SourceType.NONE == voucherInfo.getSourceType() || voucherInfo.getSourceBillId() != null)) {
            IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)this.ctx);
            BOTRelationCollection relations = iBTPManager.getRelationCollection(voucherInfo.getId().toString());
            return iBTPManager.submitRelations((CoreBillBaseInfo)voucherInfo, relations).toString();
        }
        return VoucherFactory.getLocalInstance((Context)this.ctx).submit((CoreBaseInfo)newVoucherInfo).toString();
    }

    public VoucherInfo createNewVoucherInfo(String companyId) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = new VoucherInfo();
        voucherInfo.setPostedByUI(true);
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)this.ctx);
        company = companyId == null ? GLGeneralFacadeFactory.getLocalInstance((Context)this.ctx).getFirstCompany(PERMISSONID_VOUCHER_ADD) : GlUtils.getCompanyById((Context)this.ctx, (String)companyId);
        if (company == null) {
            throw new BOSException("\u4f60\u6ca1\u6709\u51ed\u8bc1\u65b0\u589e\u7684\u6743\u9650\uff01");
        }
        voucherInfo.setCompany(company);
        PeriodInfo period = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx).getCacheCurrentPeriod(6, company.getId().toString());
        UserSettingObject settingObj = UserSettingFactory.getLocalInstance((Context)this.ctx).getValue(companyId, "fi.gl.voucher.editSetting");
        Date date = DateTimeUtils.truncateDate((Date)new Date());
        if (settingObj != null && settingObj.getBoolean("sysData") && (period == null || date.after(period.getEndDate()))) {
            PeriodCollection periodColl = PeriodUtils.getPeriodCollection((Context)this.ctx, (Date)date, (Date)date, (CompanyOrgUnitInfo)company);
            if (!periodColl.isEmpty()) {
                period = periodColl.get(0);
            }
        } else {
            if (period != null) {
                if (date.before(period.getBeginDate())) {
                    date = period.getBeginDate();
                } else if (date.after(period.getEndDate())) {
                    date = period.getEndDate();
                }
            }
            date = DateTimeUtils.truncateDate((Date)date);
        }
        voucherInfo.setBizDate(date);
        voucherInfo.setBookedDate(date);
        voucherInfo.setPeriod(period);
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)this.ctx);
        voucherInfo.setCreator(curUser);
        voucherInfo.setHandler(curUser);
        voucherInfo.setAttachments(0);
        voucherInfo.setSourceSys(SystemEnum.GENERALLEDGER);
        voucherInfo.setSourceType(SourceType.HANDCRAFT);
        VoucherTypeInfo vouherType = this.getDefaultVoucherTypeInfo(company.getCU().getId().toString());
        voucherInfo.setVoucherType(vouherType);
        voucherInfo.setCashflowFetched(true);
        voucherInfo.setCashflowFlag(CashflowFlag.NONE);
        if (this.getBudgetSubstractCtrl(company.getId().toString()) == 0) {
            voucherInfo.setIsMgCtrl(true);
        }
        this.setNumberAddNew(voucherInfo);
        voucherInfo = this.toWebVoucherInfo(voucherInfo);
        return voucherInfo;
    }

    private int getBudgetSubstractCtrl(String companyId) {
        HashMap<String, ObjectUuidPK> param = new HashMap<String, ObjectUuidPK>();
        param.put("GL_075", new ObjectUuidPK(companyId));
        try {
            HashMap outParam = ParamControlFactory.getLocalInstance((Context)this.ctx).getParamHashMap(param);
            if (outParam.get("GL_075") != null) {
                return Integer.valueOf(outParam.get("GL_075").toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Get system param error!", (Throwable)e);
        }
        return 0;
    }

    private void setNumberAddNew(VoucherInfo voucherInfo) throws EASBizException, BOSException {
        voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)this.ctx);
        boolean isNumberAddNew = iCodingRuleManager.isAddView((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "bizStatus");
        if (isNumberAddNew) {
            String number = iCodingRuleManager.readNumber((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "bizStatus", "");
            voucherInfo.setNumber(number);
        }
        voucherInfo.setBizStatus(VoucherStatusEnum.TEMP);
    }

    private VoucherTypeInfo getDefaultVoucherTypeInfo(String cuId) throws BOSException, EASBizException {
        IVoucherType iVoucherType = VoucherTypeFactory.getLocalInstance((Context)this.ctx);
        FilterInfo filter = iVoucherType.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuId), "id", "adminCU");
        SelectorItemCollection sic = new SelectorItemCollection();
        EntityViewInfo view = new EntityViewInfo();
        sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("pretermit"));
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("number"));
        view.setFilter(filter);
        VoucherTypeCollection voucherTypeColl = iVoucherType.getVoucherTypeCollection(view);
        Iterator it = voucherTypeColl.iterator();
        VoucherTypeInfo defaultVoucherTypeInfo = null;
        while (it.hasNext()) {
            VoucherTypeInfo voucherTypeInfo = (VoucherTypeInfo)it.next();
            if (!voucherTypeInfo.isPretermit()) continue;
            defaultVoucherTypeInfo = voucherTypeInfo;
            break;
        }
        if (defaultVoucherTypeInfo != null) {
            return defaultVoucherTypeInfo;
        }
        if (!voucherTypeColl.isEmpty()) {
            return voucherTypeColl.get(0);
        }
        return null;
    }

    private VoucherInfo toVoucherInfo(VoucherInfo webVoucherInfo) throws BOSException, EASBizException {
        this.removeNull((CoreBaseInfo)webVoucherInfo);
        String periodStr = (String)webVoucherInfo.get("periodstr");
        webVoucherInfo.setPeriod(ServiceWebUtils.toPeriodInfo(periodStr));
        webVoucherInfo.setBizStatus(webVoucherInfo.getBizStatus());
        VoucherEntryCollection entryColl = new VoucherEntryCollection();
        for (int i = 0; i < webVoucherInfo.getEntries().size(); ++i) {
            VoucherEntryInfo entryInfo = webVoucherInfo.getEntries().get(i);
            this.removeNull((CoreBaseInfo)entryInfo);
            if (entryInfo.getDescription() == null && entryInfo.getAccount() == null && entryInfo.getOriginalAmount() == null && entryInfo.get("localdebitamount") == null && entryInfo.get("localcreditamount") == null && entryInfo.get("rptdebitamount") == null && entryInfo.get("rptcreditamount") == null) continue;
            VoucherEntryInfo newEntryInfo = this.getVoucherEntryInfo(entryInfo, entryColl);
            newEntryInfo.setBill(webVoucherInfo);
            entryColl.add(newEntryInfo);
        }
        this.generateDeleteEntryIds(webVoucherInfo);
        webVoucherInfo.setEntries(entryColl);
        this.calVoucherAmount(webVoucherInfo);
        return webVoucherInfo;
    }

    private void calVoucherAmount(VoucherInfo voucherInfo) {
        for (int i = 0; i < voucherInfo.getEntries().size(); ++i) {
            VoucherEntryInfo entryInfo = voucherInfo.getEntries().get(i);
            BigDecimal rptAmount = entryInfo.getReportingAmount();
            if (entryInfo.getEntryDC() == EntryDC.CREDIT) {
                BigDecimal credtLocal = voucherInfo.getLocalCreditAmount();
                voucherInfo.setLocalCreditAmount(credtLocal == null ? entryInfo.getLocalAmount() : credtLocal.add(entryInfo.getLocalAmount()));
                BigDecimal credtRpt = voucherInfo.getReportingCreditAmount();
                if (rptAmount == null) continue;
                voucherInfo.setReportingCreditAmount(credtRpt == null ? rptAmount : credtRpt.add(rptAmount));
                continue;
            }
            BigDecimal debitLocal = voucherInfo.getLocalDebitAmount();
            voucherInfo.setLocalDebitAmount(debitLocal == null ? entryInfo.getLocalAmount() : debitLocal.add(entryInfo.getLocalAmount()));
            BigDecimal debitRpt = voucherInfo.getReportingDebitAmount();
            if (rptAmount == null) continue;
            voucherInfo.setReportingDebitAmount(debitRpt == null ? rptAmount : debitRpt.add(rptAmount));
        }
    }

    private VoucherEntryInfo getVoucherEntryInfo(VoucherEntryInfo entryInfo, VoucherEntryCollection entryColl) throws BOSException {
        String entryId = entryInfo.getString("entryid");
        if (StringUtils.isEmpty((String)entryId)) {
            entryInfo.setOprStatus(1);
        } else {
            BOSUuid entryKey = BOSUuid.read((String)entryId);
            if (entryColl.contains((Object)entryKey)) {
                entryInfo.setId(null);
                entryInfo.setOprStatus(1);
            } else {
                entryInfo.setId(entryKey);
                entryInfo.setOprStatus(2);
            }
        }
        entryInfo.setEntryDC(this.getEntryDC(entryInfo));
        this.setCurrencyOrigAmountQty(entryInfo);
        AccountViewInfo account = entryInfo.getAccount();
        if (account != null && (account.getCAA() != null || account.isHasUserProperty())) {
            this.toVoucherAssistRecordInfo(entryInfo);
        }
        return entryInfo;
    }

    private void removeNull(CoreBaseInfo info) {
        Enumeration e = info.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object value = info.get(key);
            if (!"null".equals(value) && !"".equals(value)) continue;
            info.put(key, null);
        }
    }

    private void toVoucherAssistRecordInfo(VoucherEntryInfo entryInfo) throws BOSException {
        AccountViewInfo account = entryInfo.getAccount();
        AsstAccountInfo asstAccountInfo = account.getCAA();
        VoucherAssistRecordInfo recordInfo = new VoucherAssistRecordInfo();
        recordInfo.setEntry(entryInfo);
        recordInfo.setDescription(entryInfo.getDescription());
        recordInfo.setOriginalAmount(entryInfo.getOriginalAmount());
        recordInfo.setLocalAmount(entryInfo.getLocalAmount());
        recordInfo.setReportingAmount(entryInfo.getReportingAmount());
        recordInfo.setQuantity(entryInfo.getQuantity());
        recordInfo.setStandardQuantity(entryInfo.getStandardQuantity());
        recordInfo.setPrice(entryInfo.getPrice());
        String assistrecordId = entryInfo.getString("assistrecordid");
        if (entryInfo.getId() != null && assistrecordId != null) {
            recordInfo.setId(BOSUuid.read((String)assistrecordId));
            recordInfo.setOprStatus(2);
        } else {
            recordInfo.setId(null);
            recordInfo.setOprStatus(1);
        }
        if (asstAccountInfo != null && account.getCAA().isIsQty() && this.isAsstQty()) {
            recordInfo.setMeasureUnit(entryInfo.getMeasureUnit());
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Object endDate;
            Object bizDate = account.get("asstbizdate");
            if (bizDate != null && bizDate.toString().trim().length() > 0) {
                recordInfo.setBizDate(dateFormat.parse(bizDate.toString()));
            }
            if (account.isAC() && (endDate = account.get("asstenddate")) != null && endDate.toString().trim().length() > 0) {
                recordInfo.setEndDate(dateFormat.parse(endDate.toString()));
            }
        }
        catch (ParseException e) {
            throw new BOSException("parse date error!", (Throwable)e);
        }
        this.toAssGrpInfo((Map)account.get("assgrp"), asstAccountInfo, recordInfo);
        this.toAccountCustProp(account, recordInfo);
        entryInfo.getAssistRecords().add(recordInfo);
        account.remove("assgrp");
    }

    private void toAccountCustProp(AccountViewInfo account, VoucherAssistRecordInfo recordInfo) throws BOSException {
        if (!account.isHasUserProperty()) {
            return;
        }
        String accountcustpropJson = (String)account.get("accountcustprop");
        List custProps = (List)JSONUtils.convertJsonToObject((Context)this.ctx, (String)accountcustpropJson, List.class);
        for (int n = 0; n < custProps.size(); ++n) {
            Map prop = (Map)custProps.get(n);
            Map type = (Map)prop.get("customizedType");
            String mappingPropName = (String)type.get("mappingPropName");
            if (((Double)((Map)type.get("dataType")).get("value")).intValue() == 0) {
                if (prop.get("value") == null) continue;
                String id = (String)((Map)prop.get("value")).get("id");
                BOSUuid uuid = BOSUuid.read((String)id);
                BOSObjectType bosType = uuid.getType();
                EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)this.ctx).getEntity(bosType);
                try {
                    AbstractCoreBaseInfo value = (AbstractCoreBaseInfo)Class.forName(entityObjectInfo.getObjectValueClass()).newInstance();
                    value.setId(uuid);
                    recordInfo.put(mappingPropName, (Object)value);
                    continue;
                }
                catch (Exception e) {
                    throw new BOSException("newInstance error!", (Throwable)e);
                }
            }
            recordInfo.put(mappingPropName, prop.get("value"));
        }
    }

    private void toAssGrpInfo(Map assGrp, AsstAccountInfo asstAccountInfo, VoucherAssistRecordInfo recordInfo) throws BOSException {
        if (assGrp == null || asstAccountInfo == null) {
            return;
        }
        String hgId = (String)assGrp.get("id");
        if (StringUtils.isEmpty((String)hgId)) {
            List asstItemList = (List)assGrp.get("detail");
            HashMap dbMap = new HashMap();
            if (asstItemList != null && !asstItemList.isEmpty()) {
                for (Map actType : asstItemList) {
                    Object value = actType.get("value");
                    if (value == null || !(value instanceof Map)) continue;
                    Object dbId = ((Map)value).get("id");
                    dbMap.put(actType.get("asstHGAttribute"), dbId);
                }
            }
            if (dbMap.isEmpty()) {
                return;
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("asstAccountId", asstAccountInfo.getId().toString());
            paramMap.put("asstDataBaseIdMap", dbMap);
            hgId = Domain.getInstance((String)"eas-fi-gl", null).invokeService(this.ctx, "GLBaseService", "getAssistantHG", JSONUtils.convertObjectToJson((Context)this.ctx, paramMap));
        }
        if (!StringUtils.isEmpty((String)hgId)) {
            AssistantHGInfo hg = new AssistantHGInfo();
            hg.setId(BOSUuid.read((String)hgId));
            recordInfo.setAssGrp(hg);
        }
    }

    private void setCurrencyOrigAmountQty(VoucherEntryInfo entryInfo) {
        Map original = (Map)entryInfo.get("original");
        String currencyId = (String)original.get("currencyid");
        if (currencyId != null && currencyId.trim().length() > 0) {
            CurrencyInfo currency = new CurrencyInfo();
            currency.setId(BOSUuid.read((String)currencyId));
            entryInfo.setCurrency(currency);
        }
        Object originalamountObj = original.get("originalamount");
        BigDecimal originalAmount = new BigDecimal(originalamountObj.toString());
        entryInfo.setOriginalAmount(originalAmount);
        AccountViewInfo account = entryInfo.getAccount();
        BigDecimal quantity = GlUtils.zero;
        BigDecimal standardQuantity = GlUtils.zero;
        BigDecimal price = GlUtils.zero;
        if (account != null && account.isIsQty()) {
            Object priceObj;
            Object quantityObj;
            Object measureunitObj = original.get("measureunit");
            BigDecimal coefficent = null;
            if (measureunitObj != null && measureunitObj instanceof Map) {
                Object coefficentObj;
                Object measureUnitId = ((Map)measureunitObj).get("id");
                if (measureUnitId != null) {
                    MeasureUnitInfo measureunit = new MeasureUnitInfo();
                    measureunit.setId(BOSUuid.read((String)measureUnitId.toString()));
                    entryInfo.setMeasureUnit(measureunit);
                }
                if ((coefficentObj = ((Map)measureunitObj).get("coefficent")) != null) {
                    coefficent = new BigDecimal(coefficentObj.toString());
                }
            }
            if ((quantityObj = original.get("quantity")) != null) {
                quantity = new BigDecimal(quantityObj.toString());
            }
            if (coefficent != null) {
                standardQuantity = quantity.multiply(coefficent);
            }
            if ((priceObj = original.get("price")) != null) {
                price = new BigDecimal(priceObj.toString());
            }
        }
        entryInfo.setQuantity(quantity);
        entryInfo.setStandardQuantity(standardQuantity);
        entryInfo.setPrice(price);
    }

    private void generateDeleteEntryIds(VoucherInfo webVoucherInfo) throws BOSException {
        String deleteentrysJson = (String)webVoucherInfo.get("deleteentrys");
        if (deleteentrysJson != null) {
            List deletedEntrys = (List)JSONUtils.convertJsonToObject((Context)this.ctx, (String)deleteentrysJson, ArrayList.class);
            Vector<BOSUuid> deleteRecordIds = new Vector<BOSUuid>();
            Vector<BOSUuid> deleteEntryIds = new Vector<BOSUuid>();
            HashSet deleteRecordEntryIds = new HashSet();
            for (int i = 0; i < deletedEntrys.size(); ++i) {
                String entryId = (String)((Map)deletedEntrys.get(i)).get("entryid");
                String recordId = (String)((Map)deletedEntrys.get(i)).get("recordid");
                if (recordId != null && !recordId.equals("")) {
                    BOSUuid entryKey = BOSUuid.read((String)entryId);
                    deleteRecordIds.add(BOSUuid.read((String)recordId));
                    if (webVoucherInfo.getEntries().contains((Object)entryKey) || deleteEntryIds.contains(entryKey)) continue;
                    deleteEntryIds.add(entryKey);
                    continue;
                }
                if (entryId == null || entryId.equals("")) continue;
                deleteEntryIds.add(BOSUuid.read((String)entryId));
            }
            if (!deleteRecordIds.isEmpty()) {
                webVoucherInfo.setRemovedRecords(deleteRecordIds);
            }
            if (!deletedEntrys.isEmpty()) {
                webVoucherInfo.setRemovedEntries(deleteEntryIds);
            }
        }
    }

    private EntryDC getEntryDC(VoucherEntryInfo entryInfo) {
        EntryDC entryDC = EntryDC.DEBIT;
        if (this.isCredit(entryInfo)) {
            entryDC = EntryDC.CREDIT;
            entryInfo.put("localAmount", entryInfo.get("localcreditamount"));
            entryInfo.put("reportingAmount", entryInfo.get("rptcreditamount"));
        } else {
            entryInfo.put("localAmount", entryInfo.get("localdebitamount"));
            entryInfo.put("reportingAmount", entryInfo.get("rptdebitamount"));
        }
        entryInfo.remove("localdebitamount");
        entryInfo.remove("rptdebitamount");
        entryInfo.remove("localcreditamount");
        entryInfo.remove("rptcreditamount");
        return entryDC;
    }

    private boolean isCredit(VoucherEntryInfo entryInfo) {
        Object localCreditAmount = entryInfo.get("localcreditamount");
        Object rptCreditAmount = entryInfo.get("rptcreditamount");
        return localCreditAmount != null && Double.parseDouble(localCreditAmount.toString()) != 0.0 || rptCreditAmount != null && Double.parseDouble(rptCreditAmount.toString()) != 0.0;
    }

    private VoucherInfo toWebVoucherInfo(VoucherInfo voucherInfo) throws EASBizException, BOSException {
        this.setCompanySysParam(voucherInfo);
        this.setPeriodEnum(voucherInfo);
        VoucherEntryCollection entryColl = voucherInfo.getEntries();
        VoucherEntryCollection newEntryColl = new VoucherEntryCollection();
        boolean isAsstQty = this.isAsstQty();
        HashMap exchangeRateCache = new HashMap();
        for (int i = 0; i < entryColl.size(); ++i) {
            VoucherEntryInfo entryInfo = entryColl.get(i);
            this.setExchangeRate(voucherInfo, entryInfo, exchangeRateCache);
            String entryId = entryInfo.getId().toString();
            entryInfo.setId(null);
            entryInfo.put("entryid", (Object)entryId);
            VoucherAssistRecordCollection assistRecords = entryInfo.getAssistRecords();
            if (assistRecords != null && !assistRecords.isEmpty()) {
                for (int j = 0; j < assistRecords.size(); ++j) {
                    VoucherAssistRecordInfo record = assistRecords.get(j);
                    VoucherEntryInfo entry = (VoucherEntryInfo)entryInfo.clone();
                    String voucherassistrecordId = record.getId().toString();
                    entry.put("entry_assistrecord_id", (Object)(entryId + voucherassistrecordId));
                    entry.put("assistrecordid", (Object)voucherassistrecordId);
                    AccountViewInfo account = entry.getAccount();
                    AssistantHGInfo hgInfo = record.getAssGrp();
                    if (hgInfo != null) {
                        String displayNameGroup = hgInfo.getDisplayNameGroup();
                        String[] displayNames = displayNameGroup.split(";");
                        StringBuffer displayName = new StringBuffer();
                        for (int n = 0; n < displayNames.length; ++n) {
                            String[] name = displayNames[n].split("_!", 2);
                            if ("".equals(name[1])) continue;
                            if (displayName.length() > 0) {
                                displayName.append("|");
                            }
                            displayName.append(name[1]);
                        }
                        hgInfo.put("displayname", (Object)displayName.toString());
                        account.put("assgrp", (Object)hgInfo);
                    }
                    if (account.isHasUserProperty()) {
                        AssistCustomizedPropertyCollection props = ServiceWebUtils.getAccountCustProp(this.ctx, account.getId().toString());
                        ArrayList<AssistCustomizedPropertyInfo> propList = new ArrayList<AssistCustomizedPropertyInfo>();
                        for (int k = 0; k < props.size(); ++k) {
                            AssistCustomizedPropertyInfo propInfo = props.get(k);
                            String propName = propInfo.getCustomizedType().getMappingPropName();
                            propInfo.put("value", record.get(propName));
                            propList.add(propInfo);
                        }
                        account.put("accountcustprop", propList);
                    }
                    if (record.getBizDate() != null) {
                        account.put("asstbizdate", (Object)record.getBizDate());
                    }
                    if (account.isAC() && record.getEndDate() != null) {
                        account.put("asstenddate", (Object)record.getEndDate());
                    }
                    entry.setDescription(record.getDescription());
                    entry.setOriginalAmount(record.getOriginalAmount());
                    entry.setLocalAmount(record.getLocalAmount());
                    entry.setReportingAmount(record.getReportingAmount());
                    entry.setQuantity(record.getQuantity());
                    entry.setPrice(record.getPrice());
                    if (isAsstQty) {
                        entry.setMeasureUnit(record.getMeasureUnit());
                    }
                    this.setOrginal(entry);
                    entry.getAssistRecords().clear();
                    this.separateDebitCredit(entry);
                    newEntryColl.add(entry);
                }
                continue;
            }
            entryInfo.put("entry_assistrecord_id", (Object)entryId);
            this.setOrginal(entryInfo);
            this.separateDebitCredit(entryInfo);
            newEntryColl.add(entryInfo);
        }
        voucherInfo.put("exchangerate", exchangeRateCache);
        voucherInfo.getEntries().clear();
        voucherInfo.getEntries().addCollection(newEntryColl);
        return voucherInfo;
    }

    private void setOrginal(VoucherEntryInfo entryInfo) {
        HashMap<String, Object> original = new HashMap<String, Object>();
        original.put("currencyid", entryInfo.getCurrency().getId().toString());
        original.put("originalamount", entryInfo.getOriginalAmount());
        original.put("quantity", entryInfo.getQuantity());
        original.put("measureunit", entryInfo.getMeasureUnit());
        original.put("price", entryInfo.getPrice());
        entryInfo.put("original", original);
    }

    private void setCompanySysParam(VoucherInfo voucherInfo) throws GLException, EASBizException, BOSException {
        String[] paramNumbers = new String[]{"GL_002", "GL_003", "GL_047", "GL_0151", "GL_069", "GL_043", "GL_0155"};
        Map params = GlParam.getGlParams((Context)this.ctx, (String[])paramNumbers, (String)voucherInfo.getCompany().getId().toString()).getParamMap();
        voucherInfo.getCompany().put("sysparam", (Object)params);
    }

    private void setPeriodEnum(VoucherInfo voucherInfo) {
        voucherInfo.put("periodstr", (Object)ServiceWebUtils.toPeriodString(voucherInfo.getPeriod()));
    }

    private void setExchangeRate(VoucherInfo voucherInfo, VoucherEntryInfo entryInfo, Map exchangeRateCache) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = voucherInfo.getCompany();
        boolean isAdjustment = voucherInfo.getSourceType() == SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT;
        ObjectUuidPK baseExchangeTableId = new ObjectUuidPK(isAdjustment && company.getAdjustExchangeTable() != null ? company.getAdjustExchangeTable().getId() : company.getBaseExchangeTable().getId());
        ObjectUuidPK currencyId = new ObjectUuidPK(entryInfo.getCurrency().getId());
        ObjectUuidPK baseCurrencyId = new ObjectUuidPK(company.getBaseCurrency().getId());
        this.cacheExchangeRate(baseExchangeTableId, currencyId, baseCurrencyId, voucherInfo.getBookedDate(), exchangeRateCache);
        if (company.getReportExchangeTable() != null && company.getReportCurrency() != null) {
            ObjectUuidPK rptExchangeTableId = new ObjectUuidPK(company.getReportExchangeTable().getId());
            ObjectUuidPK rptCurrencyId = new ObjectUuidPK(company.getReportCurrency().getId());
            ObjectUuidPK srcCurrencyId = company.getReportConvertMode() == ReportCurrencyConvertMode.Base ? baseCurrencyId : currencyId;
            this.cacheExchangeRate(rptExchangeTableId, srcCurrencyId, rptCurrencyId, voucherInfo.getBookedDate(), exchangeRateCache);
        }
    }

    private void cacheExchangeRate(ObjectUuidPK exchangeTableId, ObjectUuidPK srcCurrencyId, ObjectUuidPK targetCurrencyId, Date date, Map exchangeRateCache) throws EASBizException, BOSException {
        String key = exchangeTableId + "_" + srcCurrencyId + "_" + targetCurrencyId;
        if (exchangeRateCache.get(key) == null) {
            exchangeRateCache.put(key, ExchangeRateFactory.getLocalInstance((Context)this.ctx).getExchangeRateConvertInfo((IObjectPK)exchangeTableId, (IObjectPK)srcCurrencyId, (IObjectPK)targetCurrencyId, date));
        }
    }

    private void separateDebitCredit(VoucherEntryInfo entryInfo) {
        if (entryInfo.getEntryDC() == EntryDC.CREDIT) {
            entryInfo.put("localDebitAmount", null);
            entryInfo.put("rptDebitAmount", null);
            entryInfo.put("localCreditAmount", (Object)entryInfo.getLocalAmount());
            entryInfo.put("rptCreditAmount", (Object)entryInfo.getReportingAmount());
        } else {
            entryInfo.put("localDebitAmount", (Object)entryInfo.getLocalAmount());
            entryInfo.put("rptDebitAmount", (Object)entryInfo.getReportingAmount());
            entryInfo.remove("localCreditAmount");
            entryInfo.remove("rptCreditAmount");
        }
        entryInfo.remove("entryDC");
        entryInfo.remove("localAmount");
        entryInfo.remove("reportingAmount");
    }

    private boolean isAsstQty() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("G010", null);
        try {
            HashMap outParam = ParamControlFactory.getLocalInstance((Context)this.ctx).getParamHashMap(param);
            if (outParam.get("G010") != null) {
                return Boolean.valueOf(outParam.get("G010").toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Get system param error!", (Throwable)e);
        }
        return false;
    }

    public VoucherInfo getSimpleVoucherInfo(String voucherId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("voucherType.name"));
        return (VoucherInfo)VoucherFactory.getLocalInstance((Context)this.ctx).getValue((IObjectPK)new ObjectUuidPK(voucherId), sic);
    }

    private SelectorItemCollection fullSelector(SelectorItemCollection sic) {
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("bizStatus"));
        sic.add(new SelectorItemInfo("isCheck"));
        sic.add(new SelectorItemInfo("isReverseVoucher"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("company.CU.id"));
        sic.add(new SelectorItemInfo("company.accountPeriodType.id"));
        sic.add(new SelectorItemInfo("company.baseCurrency.id"));
        sic.add(new SelectorItemInfo("company.baseCurrency.number"));
        sic.add(new SelectorItemInfo("company.baseCurrency.name"));
        sic.add(new SelectorItemInfo("company.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("company.reportCurrency.id"));
        sic.add(new SelectorItemInfo("company.reportCurrency.number"));
        sic.add(new SelectorItemInfo("company.reportCurrency.name"));
        sic.add(new SelectorItemInfo("company.reportCurrency.precision"));
        sic.add(new SelectorItemInfo("company.baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("company.reportExchangeTable.id"));
        sic.add(new SelectorItemInfo("company.reportConvertMode"));
        sic.add(new SelectorItemInfo("company.accountTable.id"));
        sic.add(new SelectorItemInfo("company.adjustExchangeTable.id"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("period.id"));
        sic.add(new SelectorItemInfo("period.number"));
        sic.add(new SelectorItemInfo("period.periodYear"));
        sic.add(new SelectorItemInfo("period.periodNumber"));
        sic.add(new SelectorItemInfo("period.beginDate"));
        sic.add(new SelectorItemInfo("period.endDate"));
        sic.add(new SelectorItemInfo("period.isAdjustPeriod"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.account.id"));
        sic.add(new SelectorItemInfo("entries.account.longNumber"));
        sic.add(new SelectorItemInfo("entries.account.longName"));
        sic.add(new SelectorItemInfo("entries.account.level"));
        sic.add(new SelectorItemInfo("entries.account.DC"));
        sic.add(new SelectorItemInfo("entries.account.AC"));
        sic.add(new SelectorItemInfo("entries.account.bw"));
        sic.add(new SelectorItemInfo("entries.account.ACNotice"));
        sic.add(new SelectorItemInfo("entries.account.isQty"));
        sic.add(new SelectorItemInfo("entries.account.control"));
        sic.add(new SelectorItemInfo("entries.account.isCash"));
        sic.add(new SelectorItemInfo("entries.account.isBank"));
        sic.add(new SelectorItemInfo("entries.account.isCashEquivalent"));
        sic.add(new SelectorItemInfo("entries.account.hasUserProperty"));
        sic.add(new SelectorItemInfo("entries.account.isGFreeze"));
        sic.add(new SelectorItemInfo("entries.account.isCFreeze"));
        sic.add(new SelectorItemInfo("entries.account.isSelfFreeze"));
        sic.add(new SelectorItemInfo("entries.account.isLeaf"));
        sic.add(new SelectorItemInfo("entries.account.PLType"));
        sic.add(new SelectorItemInfo("entries.account.accountingcurrency"));
        sic.add(new SelectorItemInfo("entries.account.accountCurrency.currency.id"));
        sic.add(new SelectorItemInfo("entries.account.isChangeCurrency"));
        sic.add(new SelectorItemInfo("entries.account.companyID.id"));
        sic.add(new SelectorItemInfo("entries.account.currencyID.id"));
        sic.add(new SelectorItemInfo("entries.account.measureUnitGroupID.id"));
        sic.add(new SelectorItemInfo("entries.account.accountTableID.id"));
        sic.add(new SelectorItemInfo("entries.account.accountTypeID.id"));
        sic.add(new SelectorItemInfo("entries.account.accountTypeID.property"));
        sic.add(new SelectorItemInfo("entries.account.CAA.id"));
        sic.add(new SelectorItemInfo("entries.account.CAA.measureUnit.id"));
        sic.add(new SelectorItemInfo("entries.account.CAA.measureUnit.name"));
        sic.add(new SelectorItemInfo("entries.account.CAA.measureUnit.coefficient"));
        sic.add(new SelectorItemInfo("entries.account.CAA.measureUnitGroup.id"));
        sic.add(new SelectorItemInfo("entries.account.CAA.isQty"));
        sic.add(new SelectorItemInfo("entries.account.CAA.name"));
        sic.add(new SelectorItemInfo("entries.account.CAA.number"));
        sic.add(new SelectorItemInfo("entries.currency.id"));
        sic.add(new SelectorItemInfo("entries.currency.precision"));
        sic.add(new SelectorItemInfo("entries.currency.isoCode"));
        sic.add(new SelectorItemInfo("entries.currency.deletedStatus"));
        sic.add(new SelectorItemInfo("entries.originalAmount"));
        sic.add(new SelectorItemInfo("entries.localAmount"));
        sic.add(new SelectorItemInfo("entries.reportingAmount"));
        sic.add(new SelectorItemInfo("entries.quantity"));
        sic.add(new SelectorItemInfo("entries.standardQuantity"));
        sic.add(new SelectorItemInfo("entries.price"));
        sic.add(new SelectorItemInfo("entries.measureUnit.id"));
        sic.add(new SelectorItemInfo("entries.measureUnit.name"));
        sic.add(new SelectorItemInfo("entries.measureUnit.coefficient"));
        sic.add(new SelectorItemInfo("entries.measureUnit.isDisabled"));
        sic.add(new SelectorItemInfo("entries.measureUnit.measureUnitGroup.id"));
        sic.add(new SelectorItemInfo("entries.maCtrlAmount"));
        sic.add(new SelectorItemInfo("entries.maHoldAmount"));
        sic.add(new SelectorItemInfo("entries.entryDC"));
        sic.add(new SelectorItemInfo("entries.isVerify"));
        sic.add(new SelectorItemInfo("entries.assistRecords.id"));
        sic.add(new SelectorItemInfo("entries.assistRecords.seq"));
        sic.add(new SelectorItemInfo("entries.assistRecords.bizDate"));
        sic.add(new SelectorItemInfo("entries.assistRecords.description"));
        sic.add(new SelectorItemInfo("entries.assistRecords.endDate"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.id"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.longNameGroup"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.displaynameGroup"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.numberGroup"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.asstAccount.isQty"));
        sic.add(new SelectorItemInfo("entries.assistRecords.price"));
        sic.add(new SelectorItemInfo("entries.assistRecords.quantity"));
        sic.add(new SelectorItemInfo("entries.assistRecords.standardQuantity"));
        sic.add(new SelectorItemInfo("entries.assistRecords.originalAmount"));
        sic.add(new SelectorItemInfo("entries.assistRecords.maCtrlAmount"));
        sic.add(new SelectorItemInfo("entries.assistRecords.maHoldAmount"));
        sic.add(new SelectorItemInfo("entries.assistRecords.localAmount"));
        sic.add(new SelectorItemInfo("entries.assistRecords.reportingAmount"));
        sic.add(new SelectorItemInfo("entries.assistRecords.ticketNumber"));
        sic.add(new SelectorItemInfo("entries.assistRecords.invoiceNumber"));
        sic.add(new SelectorItemInfo("entries.assistRecords.isFullProp"));
        sic.add(new SelectorItemInfo("entries.assistRecords.measureUnit.id"));
        sic.add(new SelectorItemInfo("entries.assistRecords.measureUnit.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.measureUnit.coefficient"));
        sic.add(new SelectorItemInfo("entries.assistRecords.measureUnit.isDisabled"));
        sic.add(new SelectorItemInfo("entries.assistRecords.measureUnit.measureUnitGroup.id"));
        sic.add(new SelectorItemInfo("entries.assistRecords.settlementType.id"));
        sic.add(new SelectorItemInfo("entries.assistRecords.settlementType.number"));
        sic.add(new SelectorItemInfo("entries.assistRecords.settlementType.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.settlementCode"));
        sic.add(new SelectorItemInfo("entries.assistRecords.bizNumber"));
        sic.add(new SelectorItemInfo("entries.assistRecords.feeType"));
        sic.add(new SelectorItemInfo("entries.assistRecords.handler.id"));
        sic.add(new SelectorItemInfo("entries.assistRecords.handler.number"));
        sic.add(new SelectorItemInfo("entries.assistRecords.handler.name"));
        return sic;
    }

    public IRowSet getVoucherCrossPrintRowSet(String voucherId, int rowCount, int type, Map printSetting) throws BOSException, EASBizException {
        VoucherCollection vc = this.getPrintVoucherCollection(new String[]{voucherId}, printSetting);
        VoucherCrossProvider provider = new VoucherCrossProvider(this.ctx.getLocale(), this.toVoucherPrintSettingInfo(printSetting));
        return provider.getRowSet(vc.get(0), rowCount, type);
    }

    public IRowSet getVoucherMulCurrencyCrossPrintRowSet(String voucherId, int rowCount, int type, Map printSetting) throws BOSException, EASBizException {
        VoucherCollection vc = this.getPrintVoucherCollection(new String[]{voucherId}, printSetting);
        VoucherCrossDuoCurrency provider = new VoucherCrossDuoCurrency(this.ctx.getLocale(), this.toVoucherPrintSettingInfo(printSetting));
        return provider.getRowSet(vc.get(0), rowCount, type);
    }

    public IRowSet getVoucherPrintRowSet(String[] voucherIds, String dataSourceId, Map printSetting) throws BOSException, EASBizException {
        VoucherCollection vc = this.getPrintVoucherCollection(voucherIds, printSetting);
        VoucherRowSetProvider provider = new VoucherRowSetProvider(this.ctx.getLocale(), vc, this.toVoucherPrintSettingInfo(printSetting));
        return provider.getRowSet(dataSourceId);
    }

    private VoucherPrintSettingInfo toVoucherPrintSettingInfo(Map userSetting) {
        VoucherPrintSettingInfo setting = new VoucherPrintSettingInfo();
        setting.setPrintCashFlow("true".equals(userSetting.get("rdobPrintCashflow") == null ? "false" : userSetting.get("rdobPrintCashflow").toString()));
        setting.setPrintCashflowMeOrOther("true".equals(userSetting.get("cashPrintAtAccount") == null ? "false" : userSetting.get("cashPrintAtAccount").toString()));
        setting.setPrintAssistant("true".equals(userSetting.get("printAsst") == null ? "false" : userSetting.get("printAsst").toString()));
        setting.setShowAsstFullName("true".equals(userSetting.get("showFullAsstName") == null ? "false" : userSetting.get("showFullAsstName").toString()));
        setting.setShowAsstNumber("true".equals(userSetting.get("showAsstNumber") == null ? "false" : userSetting.get("showAsstNumber").toString()));
        setting.setAutoMachAsstTemplate("true".equals(userSetting.get("asstAutoTemplate") == null ? "false" : userSetting.get("asstAutoTemplate").toString()));
        setting.setAutoMachMulCurrencyTemplate("true".equals(userSetting.get("currencyAutoTemplate") == null ? "false" : userSetting.get("currencyAutoTemplate").toString()));
        setting.setPrintCashflowMeOrOther("true".equals(setting.isPrintCashFlow()) && !"true".equals(userSetting.get("rdobPrintCashflowOther") == null ? "false" : userSetting.get("rdobPrintCashflowOther").toString()));
        setting.setShowAccountNumber("true".equals(userSetting.get("showAccountNumber") == null ? "false" : userSetting.get("showAccountNumber").toString()));
        setting.setShowAccountFullName("true".equals(userSetting.get("showFullAccountName") == null ? "false" : userSetting.get("showFullAccountName").toString()));
        return setting;
    }

    protected VoucherCollection getPrintVoucherCollection(String[] ids, Map printSetting) throws BOSException, EASBizException {
        EntityViewInfo v = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        v.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            idSet.add(ids[i]);
        }
        fic.add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        boolean isChkAssistant = "true".equals(printSetting.get("printAsst") == null ? "false" : printSetting.get("printAsst").toString());
        boolean isChkPrintCashFlow = "true".equals(printSetting.get("printCashflow") == null ? "false" : printSetting.get("printCashflow").toString());
        boolean isDebitBeforeCredit = "true".equals(printSetting.get("debitCredit") == null ? "false" : printSetting.get("debitCredit").toString());
        boolean isRdobPrintCashflow = "true".equals(printSetting.get("rdobPrintCashflow") == null ? "false" : printSetting.get("rdobPrintCashflow").toString());
        boolean isRdobPrintCashflowOther = "true".equals(printSetting.get("rdobPrintCashflowOther") == null ? "false" : printSetting.get("rdobPrintCashflowOther").toString());
        boolean isPrintCashflowMeOrOther = isRdobPrintCashflow && !isRdobPrintCashflowOther;
        SorterItemCollection sorters = v.getSorter();
        sorters.add(new SorterItemInfo("company.number"));
        sorters.add(new SorterItemInfo("voucherType.number"));
        sorters.add(new SorterItemInfo("number"));
        if (isDebitBeforeCredit) {
            sorters.add(new SorterItemInfo("entries.entryDC"));
        }
        sorters.add(new SorterItemInfo("entries.seq"));
        if (isChkAssistant) {
            sorters.add(new SorterItemInfo("entries.assistRecords.seq"));
        }
        SelectorItemCollection sic = VoucherInfo.getPrintSelector((boolean)isChkAssistant, (boolean)isChkPrintCashFlow, (boolean)isPrintCashflowMeOrOther);
        v.getSelector().addObjectCollection((IObjectCollection)sic);
        return VoucherFactory.getLocalInstance((Context)this.ctx).getVoucherCollection(v);
    }

    public CashflowRecordCollection getCashflowRecordCollection(String voucherId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("voucher.id"));
        view.getSelector().add(new SelectorItemInfo("entry.id"));
        view.getSelector().add(new SelectorItemInfo("opposingAccountEntry.id"));
        view.getSelector().add(new SelectorItemInfo("oppVoucherAssistRecord.id"));
        view.getSelector().add(new SelectorItemInfo("primaryItem.id"));
        view.getSelector().add(new SelectorItemInfo("primaryItem.direction"));
        view.getSelector().add(new SelectorItemInfo("primaryItem.name"));
        view.getSelector().add(new SelectorItemInfo("supplementaryItem.id"));
        view.getSelector().add(new SelectorItemInfo("supplementaryItem.name"));
        view.getSelector().add(new SelectorItemInfo("fullInfoItem.id"));
        view.getSelector().add(new SelectorItemInfo("fullInfoItem.name"));
        view.getSelector().add(new SelectorItemInfo("originalAmount"));
        view.getSelector().add(new SelectorItemInfo("localAmount"));
        view.getSelector().add(new SelectorItemInfo("reportingAmount"));
        view.getSelector().add(new SelectorItemInfo("itemFlag"));
        view.getSelector().add(new SelectorItemInfo("isSupItem"));
        view.getSelector().add(new SelectorItemInfo("type"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("voucher.id", (Object)voucherId));
        view.setFilter(filter);
        return CashflowRecordFactory.getLocalInstance((Context)this.ctx).getCashflowRecordCollection(view);
    }
}

