/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.services.impl.base;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.services.base.GLPlatfromService;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Component(value={"com.kingdee.eas.fi.gl.services.base.GLPlatfromService"})
@Description(value="\u603b\u8d26\u5de5\u4f5c\u53f0")
public class GLPlatfromServiceImpl
implements GLPlatfromService {
    private final Context ctx;

    public GLPlatfromServiceImpl(Context ctx) {
        this.ctx = ctx;
    }

    public int getVoucherCountByCompanyId(String companyId, String periodId, int voucherstatus, String creatorid) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer("select count(1) count from t_gl_voucher ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (companyId != null && !"".equals(companyId)) {
            sql.append(" where fcompanyid = ?");
            paramList.add(companyId);
        }
        if (VoucherStatusEnum.getEnum((int)voucherstatus) != null) {
            if (paramList.size() > 0) {
                sql.append(" and ");
            } else {
                sql.append(" where ");
            }
            sql.append("  FBIZSTATUS = ?");
            paramList.add(voucherstatus);
        }
        if (periodId != null && !"".equals(periodId)) {
            if (paramList.size() > 0) {
                sql.append(" and ");
            } else {
                sql.append(" where ");
            }
            sql.append(" FPeriodID = ?");
            paramList.add(periodId);
        }
        if (creatorid != null && !"".equals(creatorid)) {
            if (paramList.size() > 0) {
                sql.append(" and ");
            } else {
                sql.append(" where ");
            }
            sql.append(" FCREATORID = ?");
            paramList.add(creatorid);
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])paramList.toArray());
        try {
            if (rs.next()) {
                return rs.getInt("count");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return 0;
    }

    public int getVoucherEntryCountByCompanyId(String companyId, String periodId, String creatorid) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer("select count(1) count ");
        StringBuffer where = new StringBuffer();
        StringBuffer from = new StringBuffer(" from t_gl_voucherentry ve ");
        ArrayList<String> paramList = new ArrayList<String>();
        if (companyId != null && !"".equals(companyId)) {
            where.append(" where v.fcompanyid = ?");
            paramList.add(companyId);
        }
        if (creatorid != null && !"".equals(creatorid)) {
            if (paramList.size() > 0) {
                where.append(" and v.FCREATORID = ?");
            } else {
                where.append(" where v.FCREATORID = ?");
            }
            paramList.add(creatorid);
        }
        if (periodId != null && !"".equals(periodId)) {
            if (paramList.size() > 0) {
                where.append(" and ");
            } else {
                where.append(" where ");
            }
            where.append(" v.FPeriodID = ?");
            paramList.add(periodId);
        }
        from.append(" inner join t_gl_voucher v on ve.fbillid = v.fid ");
        sql = sql.append(from).append(where);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])paramList.toArray());
        try {
            if (rs.next()) {
                return rs.getInt("count");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return 0;
    }

    public Map getVoucherCountByPeriod(String companyId, int startPeriodNum, int endPeriodNum, int voucherstatus, String creatorid) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer("select count(1) count,p.fnumber periodnumber ");
        StringBuffer where = new StringBuffer();
        StringBuffer from = new StringBuffer(" from t_gl_voucher v ");
        from.append(" inner join t_bd_period p on v.fperiodid = p.fid ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (companyId != null && !"".equals(companyId)) {
            where.append(" where v.fcompanyid = ?");
            paramList.add(companyId);
        }
        if (VoucherStatusEnum.getEnum((int)voucherstatus) != null) {
            if (paramList.size() > 0) {
                where.append(" and ");
            } else {
                where.append(" where ");
            }
            where.append("  FBIZSTATUS = ?");
            paramList.add(voucherstatus);
        }
        if (creatorid != null && !"".equals(creatorid)) {
            if (paramList.size() > 0) {
                where.append(" and v.FCREATORID = ?");
            } else {
                where.append(" where v.FCREATORID = ?");
            }
            paramList.add(creatorid);
        }
        if (paramList.size() > 0) {
            where.append(" and ");
        } else {
            where.append(" where ");
        }
        where.append(" p.FNumber >= ?");
        paramList.add(startPeriodNum);
        if (paramList.size() > 0) {
            where.append(" and ");
        } else {
            where.append(" where ");
        }
        where.append(" p.FNumber <= ?");
        paramList.add(endPeriodNum);
        StringBuffer groupBy = new StringBuffer();
        groupBy.append(" group by p.fid,p.fnumber");
        sql = sql.append(from).append(where).append(groupBy);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])paramList.toArray());
        HashMap<Integer, Integer> resultMap = new HashMap<Integer, Integer>();
        try {
            while (rs.next()) {
                resultMap.put(rs.getInt("periodnumber"), rs.getInt("count"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return resultMap;
    }

    public Map getVoucherEntryCountByPeriod(String companyId, int startPeriodNum, int endPeriodNum, String creatorid) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer("select count(1) count ,p.fperiodnumber periodnumber ");
        StringBuffer where = new StringBuffer();
        StringBuffer from = new StringBuffer(" from t_gl_voucherentry ve ");
        from.append(" inner join t_gl_voucher v on ve.fbillid = v.fid ");
        from.append(" inner join t_bd_period p on v.fperiodid = p.fid ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (companyId != null && !"".equals(companyId)) {
            where.append(" where v.fcompanyid = ?");
            paramList.add(companyId);
        }
        if (creatorid != null && !"".equals(creatorid)) {
            if (paramList.size() > 0) {
                where.append(" and v.FCREATORID = ?");
            } else {
                where.append(" where v.FCREATORID = ?");
            }
            paramList.add(creatorid);
        }
        if (paramList.size() > 0) {
            where.append(" and ");
        } else {
            where.append(" where ");
        }
        where.append(" p.FNumber >= ?");
        paramList.add(startPeriodNum);
        if (paramList.size() > 0) {
            where.append(" and ");
        } else {
            where.append(" where ");
        }
        where.append(" p.FNumber <= ?");
        paramList.add(endPeriodNum);
        StringBuffer groupBy = new StringBuffer();
        groupBy.append(" group by p.fid,p.fperiodnumber");
        sql = sql.append(from).append(where).append(groupBy);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])paramList.toArray());
        HashMap<Integer, Integer> resultMap = new HashMap<Integer, Integer>();
        try {
            while (rs.next()) {
                resultMap.put(rs.getInt("periodnumber"), rs.getInt("count"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return resultMap;
    }

    public CompanyOrgUnitCollection getCompanyByPerm(String userId, boolean isFunPerm, String funPermItemId, String rootId, String acountSchemeId, String periodTypeID, boolean onlyLeaf, boolean queryByAccountScheme) throws BOSException {
        CompanyOrgUnitInfo root = null;
        if (rootId != null && rootId.length() > 0) {
            root = new CompanyOrgUnitInfo();
            root.setId(BOSUuid.read((String)rootId));
        }
        AcountSchemeInfo acountScheme = null;
        if (acountSchemeId != null && acountSchemeId.length() > 0) {
            acountScheme = new AcountSchemeInfo();
            acountScheme.setId(BOSUuid.read((String)acountSchemeId));
        } else {
            acountScheme = new AcountSchemeInfo();
            acountScheme.setIsMaster(true);
        }
        StringBuffer sql = new StringBuffer("select  cp.fid,cp.fname_l1,cp.fname_l2,cp.fname_l3,cp.fnumber,cp.flongnumber");
        sql.append(GlUtils.getCompanyFilterSQL((String)userId, (String)funPermItemId, (boolean)isFunPerm, (CompanyOrgUnitInfo)root, (String)periodTypeID, (boolean)onlyLeaf, (AcountSchemeInfo)acountScheme, (boolean)queryByAccountScheme));
        sql.append(" and cp.fid in ( ").append("select forgid from T_PM_OrgRangeIncludeSubOrg where fuserid = '").append(userId).append("' and ftype = 10 ").append(")");
        sql.append(" order by cp.flongnumber");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        CompanyOrgUnitCollection collection = new CompanyOrgUnitCollection();
        try {
            while (rs.next()) {
                CompanyOrgUnitInfo orgUnitInfo = new CompanyOrgUnitInfo();
                orgUnitInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                orgUnitInfo.setName(rs.getString("fname_l1"), LocaleUtils.locale_l1);
                orgUnitInfo.setName(rs.getString("fname_l2"), LocaleUtils.locale_l2);
                orgUnitInfo.setName(rs.getString("fname_l3"), LocaleUtils.locale_l3);
                orgUnitInfo.setNumber(rs.getString("fnumber"));
                orgUnitInfo.setLongNumber(rs.getString("flongnumber"));
                collection.add(orgUnitInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return collection;
    }

    public CompanyOrgUnitCollection getCompanyByUserId(String userId) throws BOSException, EASBizException {
        Set orgIds = OrgRangeIncludeSubOrgFactory.getLocalInstance((Context)this.ctx).getOrgIdsByUserAndType((IObjectPK)new ObjectUuidPK(userId), OrgRangeType.BIZ_ORG_TYPE);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longnumber"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)orgIds, CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("longnumber"));
        view.setSorter(sort);
        CompanyOrgUnitCollection collection = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitCollection(view);
        return collection;
    }
}

