/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.privacy.encrypt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.privacy.PrivacyData;
import com.kingdee.bos.privacy.encrypt.ComposeEncryptor;
import com.kingdee.bos.privacy.encrypt.EncryptorType;
import com.kingdee.bos.privacy.encrypt.IEncryptor;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import org.apache.commons.codec.binary.Base64;

public class EncryptUtils {
    private static final int p = 16777619;
    private static final int ihash = -2128831035;

    public static ComposeEncryptor getEncryptor(Context ctx, String solutionId) throws BOSException {
        return ComposeEncryptor.getInstance(ctx, solutionId);
    }

    public static String generateKey(Context ctx, EncryptorType encryptType) throws BOSException {
        return ComposeEncryptor.generateKey(ctx, encryptType);
    }

    public static void resetEncryptor(String ais, String[] solutionIds) throws BOSException {
        ComposeEncryptor.reset(ais, solutionIds);
    }

    public static EncryptorType getRecentEncryptorType(Context ctx) throws BOSException {
        String sql = "select top 1 FType from T_Privacy_Encryptor order by FCreateTime desc ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        int type = -1;
        try {
            if (rs.next()) {
                type = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return EncryptorType.getEncryptorType(type);
    }

    public static Object decrypt(Context ctx, String ciphertext, PrivacyData privacyData) throws BOSException {
        DataType dataType;
        IEncryptor encryptor = privacyData.getEncryptor(ctx);
        OwnPropertyInfo fld = privacyData.getOwnPropertyInfo();
        byte[] bytes = Base64.decodeBase64((String)ciphertext);
        bytes = encryptor.decrypt(bytes);
        String clearText = null;
        try {
            clearText = new String(bytes, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (fld == null) {
            dataType = DataType.getEnum((String)privacyData.getPrivacyProp().getDataType());
            fld = new OwnPropertyInfo();
            fld.put("configured", (Object)false);
        } else {
            dataType = fld.getDataType();
        }
        if (dataType == DataType.BYTEARRAY) {
            return bytes;
        }
        return ImplUtils.ConvertSQLTypeData2Java((DataType)dataType, (Object)clearText, (OwnPropertyInfo)fld);
    }

    public static String encrypt(Object obj, IEncryptor encryptor) throws BOSException {
        if (obj instanceof String) {
            if (StringUtils.isEmpty((String)((String)obj))) {
                return null;
            }
            return encryptor.encryptStr((String)obj);
        }
        if (obj instanceof byte[]) {
            byte[] bytes = encryptor.encrypt((byte[])obj);
            return Base64.encodeBase64String((byte[])bytes);
        }
        throw new BOSException("unbelievable");
    }

    public static String hashCode(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        int hash = -2128831035;
        for (int i = 0; i < str.length(); ++i) {
            hash = (hash ^ str.charAt(i)) * 16777619;
            hash += hash << 13;
            hash ^= hash >> 7;
            hash += hash << 3;
            hash ^= hash >> 17;
            hash += hash << 5;
        }
        return String.valueOf(hash);
    }
}

