/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.shell.trace;

import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.sql.shell.trace.ConnectionLogger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class LogFileReader {
    private BufferedReader reader;

    public LogFileReader(String logFile) throws IOException {
        FileReader fileReader = new FileReader(logFile);
        this.reader = new BufferedReader(fileReader);
    }

    public LogItem readItem() throws IOException {
        String temp;
        String temp2;
        String method;
        LogItem rtnVal = new LogItem();
        while ((method = this.readLine()) != null && method.length() == 0) {
        }
        if (method == null) {
            return null;
        }
        String executeTimeLine = this.readLine();
        String dbTypeLine = this.readLine();
        String skipLine1 = this.readLine();
        if (!"K-SQL : ".equals(skipLine1)) {
            throw new IOException("Fatal Error. Invalid format.");
        }
        StringBuffer buff = new StringBuffer();
        while (!"$--------------------------------------------------------------".equals(temp2 = this.readLine())) {
            buff.append(temp2);
        }
        String ksql = buff.toString();
        String skipLine2 = this.readLine();
        if (!"Dialect-SQL : ".equals(skipLine2)) {
            throw new IOException("Fatal Error. Invalid format.");
        }
        StringBuffer buff2 = new StringBuffer();
        while (!"$--------------------------------------------------------------".equals(temp = this.readLine())) {
            buff2.append(temp);
        }
        String dialect_sql = buff2.toString();
        String timeSpanLine = this.readLine();
        temp = this.readLine();
        if (temp.startsWith("updateCount : ")) {
            rtnVal.updateCount = Integer.parseInt(temp.substring("updateCount : ".length()));
            temp = this.readLine();
        }
        if ("Parameters : ".equals(temp)) {
            while ((temp = this.readLine()).length() != 0) {
                int index = temp.indexOf(58);
                String pramText = temp.substring(index + 2);
                rtnVal.parameters.add(pramText);
            }
        }
        rtnVal.method = method;
        rtnVal.executeTime = Timestamp.valueOf(executeTimeLine.substring("execute time : ".length()));
        rtnVal.dbType = DbType.getValue(dbTypeLine.substring("dbType : ".length()));
        rtnVal.ksql = ksql;
        rtnVal.dialect_sql = dialect_sql;
        rtnVal.timespan = Integer.parseInt(timeSpanLine.substring("timespan : ".length()));
        return rtnVal;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public String readLine() throws IOException {
        return this.reader.readLine();
    }

    public static class LogItem {
        public String method;
        public Timestamp executeTime;
        public int dbType;
        public String ksql;
        public String dialect_sql;
        public int timespan;
        public int updateCount = -1;
        public List parameters = new ArrayList();

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append(this.method);
            buff.append(ConnectionLogger.LINE_SEPARATOR);
            buff.append("execute time : ");
            buff.append(this.executeTime.toString());
            buff.append(ConnectionLogger.LINE_SEPARATOR);
            buff.append("dbType : ");
            buff.append(DbType.getName(this.dbType));
            buff.append(ConnectionLogger.LINE_SEPARATOR);
            buff.append("K-SQL : ");
            buff.append(ConnectionLogger.LINE_SEPARATOR);
            buff.append(this.ksql);
            buff.append(ConnectionLogger.LINE_SEPARATOR);
            buff.append("$--------------------------------------------------------------");
            buff.append(ConnectionLogger.LINE_SEPARATOR);
            buff.append("Dialect-SQL : ");
            buff.append(ConnectionLogger.LINE_SEPARATOR);
            buff.append(this.dialect_sql);
            buff.append(ConnectionLogger.LINE_SEPARATOR);
            buff.append("$--------------------------------------------------------------");
            buff.append(ConnectionLogger.LINE_SEPARATOR);
            buff.append("timespan : ");
            buff.append(this.timespan);
            buff.append(ConnectionLogger.LINE_SEPARATOR);
            if (this.updateCount != -1) {
                buff.append("updateCount : ");
                buff.append(this.updateCount);
                buff.append(ConnectionLogger.LINE_SEPARATOR);
            }
            if (this.parameters.size() > 0) {
                buff.append("Parameters : ");
                buff.append(ConnectionLogger.LINE_SEPARATOR);
                int size = this.parameters.size();
                for (int i = 0; i < size; ++i) {
                    Object pram = this.parameters.get(i);
                    buff.append(i + 1);
                    buff.append(" : ");
                    buff.append(pram);
                    buff.append(ConnectionLogger.LINE_SEPARATOR);
                }
            }
            buff.append(ConnectionLogger.LINE_SEPARATOR);
            return buff.toString();
        }
    }
}

