/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.util;

import com.kingdee.bos.sql.dom.expr.JavaObjectValueExpr;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlDateTimeExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlIntExpr;
import com.kingdee.bos.sql.dom.expr.SqlNCharExpr;
import java.text.DateFormat;
import java.text.ParseException;

public class SqlExprUtil {
    public static SqlExpr buildPropExpr(String owner, String prop) {
        if (owner == null) {
            return new SqlIdentifierExpr(prop);
        }
        SqlIdentifierExpr ownerExpr = new SqlIdentifierExpr(owner);
        SqlIdentifierExpr propExpr = new SqlIdentifierExpr(prop);
        return new SqlBinaryOpExpr(ownerExpr, 20, propExpr);
    }

    public static Object getValue(SqlExpr expr) {
        switch (expr.type) {
            case 5: {
                return ((SqlCharExpr)expr).getJavaString();
            }
            case 6: {
                return ((SqlNCharExpr)expr).getJavaString();
            }
            case 1: {
                String str = ((SqlIntExpr)expr).text;
                return Integer.parseInt(str);
            }
            case 21: {
                SqlDateTimeExpr datetimeExpr = (SqlDateTimeExpr)expr;
                StringBuffer buff = new StringBuffer();
                buff.append(datetimeExpr.getYear());
                buff.append("-");
                buff.append(datetimeExpr.getMonth());
                buff.append("-");
                buff.append(datetimeExpr.getDate());
                buff.append(" ");
                buff.append(datetimeExpr.getHour());
                buff.append(":");
                buff.append(datetimeExpr.getMinute());
                buff.append(":");
                buff.append(datetimeExpr.getSecond());
                DateFormat formatter = DateFormat.getDateTimeInstance();
                try {
                    return formatter.parse(buff.toString());
                }
                catch (ParseException e) {
                    throw new RuntimeException("TODO");
                }
            }
            case 26: {
                return ((JavaObjectValueExpr)expr).value;
            }
        }
        throw new IllegalStateException("Fatal Error." + expr.toString());
    }

    public static boolean isValueExpr(SqlExpr expr) {
        if (expr.type == 5 || expr.type == 21 || expr.type == 2 || expr.type == 1 || expr.type == 6 || expr.type == 20 || expr.type == 3 || expr.type == 26) {
            return true;
        }
        if (expr instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr binaryOpExpr = (SqlBinaryOpExpr)expr;
            if (SqlExprUtil.isValueExpr(binaryOpExpr.left) && SqlExprUtil.isValueExpr(binaryOpExpr.right)) {
                return true;
            }
        }
        return false;
    }
}

