/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.dom;

import com.kingdee.bos.sql.dom.SqlObject;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.stmt.SqlInsertStmt;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SqlInsert
extends SqlObject
implements Serializable {
    public String tableName;
    public List columnList;
    public List valueList;
    private volatile List hints;
    public SqlSelectBase subQuery;
    private String insertWord;
    private String intoWord;
    private String valuesWord;

    public SqlInsert(String tableName) {
        this.valueList = new ArrayList();
        this.columnList = new ArrayList();
        this.tableName = tableName;
    }

    public SqlInsert(String tableName, List columnList, List valueList) {
        this.tableName = tableName;
        this.columnList = columnList;
        this.valueList = valueList;
    }

    public SqlInsert(String tableName, int columnListSize, int valueListSize) {
        this.tableName = tableName;
        this.columnList = new ArrayList(columnListSize);
        this.valueList = new ArrayList(valueListSize);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        this.output(buff);
        return buff.toString();
    }

    public void output(StringBuffer buff) {
        try {
            new DrSQLFormater(buff).formatInsertStmt(new SqlInsertStmt(this));
        }
        catch (FormaterException formaterException) {
            // empty catch block
        }
    }

    @Override
    public Object clone() {
        int i;
        int columnListSize = this.columnList.size();
        int valueListSize = this.valueList.size();
        SqlInsert new_obj = new SqlInsert(this.tableName, columnListSize, valueListSize);
        for (i = 0; i < columnListSize; ++i) {
            Object colItem = this.columnList.get(i);
            if (colItem instanceof SqlIdentifierExpr) {
                SqlIdentifierExpr identExpr = (SqlIdentifierExpr)colItem;
                new_obj.columnList.add(identExpr.clone());
                continue;
            }
            if (colItem instanceof String) {
                new_obj.columnList.add(colItem);
                continue;
            }
            throw new IllegalStateException("unexpect expression: '" + colItem + "'");
        }
        for (i = 0; i < valueListSize; ++i) {
            SqlExpr item = (SqlExpr)((SqlExpr)this.valueList.get(i)).clone();
            new_obj.valueList.add(item);
        }
        new_obj.setInsertWord(this.getInsertWord());
        new_obj.setIntoWord(this.getIntoWord());
        new_obj.setValuesWord(this.getValuesWord());
        return new_obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getHints() {
        if (this.hints == null) {
            SqlInsert sqlInsert = this;
            synchronized (sqlInsert) {
                if (this.hints == null) {
                    this.hints = new ArrayList();
                }
            }
        }
        return this.hints;
    }

    public String getInsertWord() {
        if (this.insertWord == null || this.insertWord.length() == 0) {
            return "INSERT";
        }
        return this.insertWord;
    }

    public void setInsertWord(String insertWord) {
        this.insertWord = insertWord;
    }

    public String getValuesWord() {
        if (this.valuesWord == null || this.valuesWord.length() == 0) {
            return "VALUES";
        }
        return this.valuesWord;
    }

    public void setValuesWord(String valuesWord) {
        this.valuesWord = valuesWord;
    }

    public String getIntoWord() {
        if (this.intoWord == null) {
            return "INTO";
        }
        return this.intoWord;
    }

    public void setIntoWord(String intoWord) {
        this.intoWord = intoWord;
    }
}

