/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.privacy.encrypt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.privacy.encrypt.EncryptorType;
import com.kingdee.bos.privacy.encrypt.IEncryptor;
import com.kingdee.util.StringUtils;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.codec.binary.Base64;

abstract class AbstractEncryptor
implements IEncryptor {
    private static final IvParameterSpec IV = new IvParameterSpec(new byte[16]);
    protected SecretKey secretKey;
    protected Cipher cipher;

    AbstractEncryptor() {
    }

    protected AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return IV;
    }

    @Override
    public synchronized byte[] decrypt(byte[] src) throws BOSException {
        try {
            if (src == null) {
                return src;
            }
            this.cipher.init(2, (Key)this.secretKey, this.getAlgorithmParameterSpec());
            return this.cipher.doFinal(src);
        }
        catch (Exception e) {
            throw new BOSException((Object)((Object)this.getType()) + " decrypt error", (Throwable)e);
        }
    }

    @Override
    public synchronized byte[] encrypt(byte[] src) throws BOSException {
        try {
            if (src == null) {
                return src;
            }
            this.cipher.init(1, (Key)this.secretKey, this.getAlgorithmParameterSpec());
            return this.cipher.doFinal(src);
        }
        catch (Exception e) {
            throw new BOSException((Object)((Object)this.getType()) + " encrypt error", (Throwable)e);
        }
    }

    @Override
    public String decryptStr(String src) throws BOSException {
        if (StringUtils.isEmpty((String)src)) {
            return src;
        }
        byte[] data = Base64.decodeBase64((String)src);
        data = this.decrypt(data);
        return new String(data, StandardCharsets.UTF_8);
    }

    @Override
    public String encryptStr(String src) throws BOSException {
        if (StringUtils.isEmpty((String)src)) {
            return src;
        }
        byte[] data = src.getBytes(StandardCharsets.UTF_8);
        data = this.encrypt(data);
        return Base64.encodeBase64String((byte[])data);
    }

    @Override
    public EncryptorType getType() {
        return EncryptorType.CUSTOM;
    }
}

