/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.cache;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.risk.cache.RiskCacheManager;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RiskModelCache {
    private static Logger logger = Logger.getLogger(RiskModelCache.class);

    static boolean existUipkAction(Context ctx, String uipk, String action) {
        if (ctx == null) {
            throw new IllegalArgumentException("existUipkAction ctx is null");
        }
        Map cfgMap = null;
        Set uipk_action_set = null;
        Object cacheObj = RiskCacheManager.getValue("risk_uipk_action_cache");
        if (cacheObj != null) {
            cfgMap = (Map)cacheObj;
        } else {
            logger.error((Object)"[risk_uipk_action_cache]");
            RiskModelCache.initUipkActionCache(ctx);
            cacheObj = RiskCacheManager.getValue("risk_uipk_action_cache");
            cfgMap = (Map)cacheObj;
        }
        String dbId = ctx.getAIS();
        if (StringUtils.isEmpty((CharSequence)dbId)) {
            throw new IllegalArgumentException("ctx[" + ctx + "]ctx getAIS isEmpty");
        }
        if (cfgMap == null) {
            return false;
        }
        uipk_action_set = (Set)cfgMap.get(dbId);
        return uipk_action_set.contains(uipk.trim() + action.trim());
    }

    static boolean existUipk(Context ctx, String uipk) {
        if (ctx == null) {
            throw new IllegalArgumentException("existUipk ctx is null");
        }
        Map cfgMap = null;
        Set uipk_action_set = null;
        Object cacheObj = RiskCacheManager.getValue("risk_uipk_cache");
        if (cacheObj != null) {
            cfgMap = (Map)cacheObj;
        } else {
            logger.error((Object)"[risk_uipk_cache]");
            RiskModelCache.initUipkCache(ctx);
            cacheObj = RiskCacheManager.getValue("risk_uipk_cache");
            cfgMap = (Map)cacheObj;
        }
        String dbId = ctx.getAIS();
        if (StringUtils.isEmpty((CharSequence)dbId)) {
            throw new IllegalArgumentException("ctx[" + ctx + "]ctx getAIS isEmpty");
        }
        if (cfgMap == null) {
            return false;
        }
        uipk_action_set = (Set)cfgMap.get(dbId);
        return uipk_action_set.contains(uipk.trim());
    }

    static boolean existFunction(Context ctx, BOSObjectType bosType, IMetaDataPK metaDataPK) {
        if (ctx == null) {
            throw new IllegalArgumentException("existFunction ctx is null");
        }
        Map cfgMap = null;
        Set uipk_action_set = null;
        Object cacheObj = RiskCacheManager.getValue("risk_function_cache");
        if (cacheObj != null) {
            cfgMap = (Map)cacheObj;
        } else {
            logger.error((Object)"[risk_function_cache]");
            RiskModelCache.initFunctionCache(ctx);
            cacheObj = RiskCacheManager.getValue("risk_function_cache");
            cfgMap = (Map)cacheObj;
        }
        String dbId = ctx.getAIS();
        if (StringUtils.isEmpty((CharSequence)dbId)) {
            throw new IllegalArgumentException("ctx[" + ctx + "]ctx getAIS isEmpty");
        }
        if (cfgMap == null) {
            return false;
        }
        uipk_action_set = (Set)cfgMap.get(dbId);
        return uipk_action_set.contains(bosType.toString() + metaDataPK.toString());
    }

    static boolean existROBOT(Context ctx, BOSObjectType metaBosType, String method) {
        if (ctx == null) {
            throw new IllegalArgumentException("existROBOT ctx is null");
        }
        Map cfgMap = null;
        Set uipk_action_set = null;
        Object cacheObj = RiskCacheManager.getValue("risk_robot_cache");
        if (cacheObj != null) {
            cfgMap = (Map)cacheObj;
        } else {
            logger.error((Object)"[risk_robot_cache]");
            RiskModelCache.initRobotCache(ctx);
            cacheObj = RiskCacheManager.getValue("risk_robot_cache");
            cfgMap = (Map)cacheObj;
        }
        String dbId = ctx.getAIS();
        if (StringUtils.isEmpty((CharSequence)dbId)) {
            throw new IllegalArgumentException("ctx[" + ctx + "]ctx getAIS isEmpty");
        }
        if (cfgMap == null) {
            return false;
        }
        uipk_action_set = (Set)cfgMap.get(dbId);
        return uipk_action_set.contains(metaBosType.toString() + method);
    }

    private static synchronized void initUipkActionCache(Context ctx) {
        HashSet<String> uipk_action_set;
        HashMap aisCacheMap = null;
        Object value = RiskCacheManager.getValue("risk_uipk_action_cache");
        if (value != null) {
            return;
        }
        aisCacheMap = (HashMap)value;
        if (aisCacheMap == null) {
            aisCacheMap = new HashMap();
        }
        if ((uipk_action_set = (HashSet<String>)aisCacheMap.get(ctx.getAIS())) != null) {
            return;
        }
        uipk_action_set = new HashSet<String>();
        try {
            StringBuilder builder = new StringBuilder(300);
            builder.append(" select distinct pe.FPageUIPK,ae.FactionNumber from t_Ris_RiskDesigner rd ");
            builder.append(" inner join t_ris_pageEntry pe on rd.fid = pe.fparentId ");
            builder.append(" inner join T_RIS_ActionEntry ae on rd.fid = ae.FDesignerId and pe.fid = ae.FPageEntryId ");
            builder.append(" inner join T_RIS_DesignerEntry de on de.FDesignerid = rd.fid ");
            builder.append(" inner join T_RIS_RiskModel rm on rm.fid = de.fparentid ");
            builder.append(" inner join T_RIS_ModelSHOW ms on rm.fid = ms.FRiskModelid ");
            builder.append(" where rd.fcontrolModel = 'BILLOPER' AND ms.FStatus = 'enable' ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)builder.toString());
            while (rowSet.next()) {
                uipk_action_set.add(rowSet.getString(1).trim() + rowSet.getString(2).trim());
            }
            aisCacheMap.put(ctx.getAIS(), uipk_action_set);
            RiskCacheManager.put("risk_uipk_action_cache", aisCacheMap);
        }
        catch (Exception e) {
            logger.error((Object)("RiskModelCache--initUipkActionCache--error--" + e));
        }
    }

    private static synchronized void initPageActionCache(Context ctx) {
        HashMap<String, ArrayList<String>> page_action_map;
        HashMap aisCacheMap = null;
        Object value = RiskCacheManager.getValue("risk_page_action_cache");
        if (value != null) {
            return;
        }
        aisCacheMap = (HashMap)value;
        if (aisCacheMap == null) {
            aisCacheMap = new HashMap();
        }
        if ((page_action_map = (HashMap<String, ArrayList<String>>)aisCacheMap.get(ctx.getAIS())) != null) {
            return;
        }
        page_action_map = new HashMap<String, ArrayList<String>>();
        try {
            StringBuilder builder = new StringBuilder(300);
            builder.append(" select distinct pe.FPageUIPK,ae.FactionNumber from t_Ris_RiskDesigner rd ");
            builder.append(" inner join t_ris_pageEntry pe on rd.fid = pe.fparentId ");
            builder.append(" inner join T_RIS_ActionEntry ae on rd.fid = ae.FDesignerId and pe.fid = ae.FPageEntryId ");
            builder.append(" inner join T_RIS_DesignerEntry de on de.FDesignerid = rd.fid ");
            builder.append(" inner join T_RIS_RiskModel rm on rm.fid = de.fparentid ");
            builder.append(" inner join T_RIS_ModelSHOW ms on rm.fid = ms.FRiskModelid ");
            builder.append(" where rd.fcontrolModel = 'BILLOPER' AND ms.FStatus = 'enable' ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)builder.toString());
            while (rowSet.next()) {
                String page = rowSet.getString(1).trim();
                ArrayList<String> actionList = (ArrayList<String>)page_action_map.get(page);
                String action = rowSet.getString(2).trim();
                if (actionList == null) {
                    actionList = new ArrayList<String>();
                    page_action_map.put(page, actionList);
                }
                actionList.add(action);
            }
            aisCacheMap.put(ctx.getAIS(), page_action_map);
            RiskCacheManager.put("risk_page_action_cache", aisCacheMap);
        }
        catch (Exception e) {
            logger.error((Object)("RiskModelCache--initpageActionCache--error--" + e));
        }
    }

    public static synchronized void initUipkCache(Context ctx) {
        HashSet<String> uipk_set;
        HashMap aisCacheMap = null;
        Object value = RiskCacheManager.getValue("risk_uipk_cache");
        if (value != null) {
            return;
        }
        aisCacheMap = (HashMap)value;
        if (aisCacheMap == null) {
            aisCacheMap = new HashMap();
        }
        if ((uipk_set = (HashSet<String>)aisCacheMap.get(ctx.getAIS())) != null) {
            return;
        }
        uipk_set = new HashSet<String>();
        try {
            StringBuilder builder = new StringBuilder(300);
            builder.append(" select pe.FPageUIPK from t_Ris_RiskDesigner rd ");
            builder.append(" inner join t_ris_pageEntry pe on rd.fid = pe.fparentId ");
            builder.append(" inner join T_RIS_DesignerEntry de on de.FDesignerid = rd.fid ");
            builder.append(" inner join T_RIS_RiskModel rm on rm.fid = de.fparentid ");
            builder.append(" inner join T_RIS_ModelSHOW ms on rm.fid = ms.FRiskModelid ");
            builder.append(" where rd.fcontrolModel = 'POTIPS' AND ms.FStatus = 'enable'  ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)builder.toString());
            while (rowSet.next()) {
                uipk_set.add(rowSet.getString(1).trim());
            }
            aisCacheMap.put(ctx.getAIS(), uipk_set);
            RiskCacheManager.put("risk_uipk_cache", aisCacheMap);
        }
        catch (Exception e) {
            logger.error((Object)("RiskModelCache--initUipkCache--error--" + e));
        }
    }

    public static synchronized void initFunctionCache(Context ctx) {
        HashSet<String> function_set;
        HashMap aisCacheMap = null;
        Object value = RiskCacheManager.getValue("risk_function_cache");
        if (value != null) {
            return;
        }
        aisCacheMap = (HashMap)value;
        if (aisCacheMap == null) {
            aisCacheMap = new HashMap();
        }
        if ((function_set = (HashSet<String>)aisCacheMap.get(ctx.getAIS())) != null) {
            return;
        }
        function_set = new HashSet<String>();
        try {
            StringBuilder builder = new StringBuilder(300);
            builder.append(" select rd.fmetaBostype,rd.FMethodPK from t_Ris_RiskDesigner rd ");
            builder.append(" inner join T_RIS_DesignerEntry de on de.FDesignerid = rd.fid ");
            builder.append(" inner join T_RIS_RiskModel rm on rm.fid = de.fparentid ");
            builder.append(" inner join T_RIS_ModelSHOW ms on rm.fid = ms.FRiskModelid ");
            builder.append(" where rd.fcontrolModel = 'FUNCONTROL'  AND ms.FStatus = 'enable' ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)builder.toString());
            while (rowSet.next()) {
                function_set.add(rowSet.getString(1).trim() + rowSet.getString(2).trim());
            }
            aisCacheMap.put(ctx.getAIS(), function_set);
            RiskCacheManager.put("risk_function_cache", aisCacheMap);
        }
        catch (Exception e) {
            logger.error((Object)("RiskModelCache--initFunctionCache--error--" + e));
        }
    }

    public static synchronized void initRobotCache(Context ctx) {
        HashSet<String> function_set;
        HashMap aisCacheMap = null;
        Object value = RiskCacheManager.getValue("risk_robot_cache");
        if (value != null) {
            return;
        }
        aisCacheMap = (HashMap)value;
        if (aisCacheMap == null) {
            aisCacheMap = new HashMap();
        }
        if ((function_set = (HashSet<String>)aisCacheMap.get(ctx.getAIS())) != null) {
            return;
        }
        function_set = new HashSet<String>();
        try {
            StringBuilder builder = new StringBuilder(300);
            builder.append(" select rd.fmetaBostype,rd.fmethodName from t_Ris_RiskDesigner rd ");
            builder.append(" inner join T_RIS_DesignerEntry de on de.FDesignerid = rd.fid ");
            builder.append(" inner join T_RIS_RiskModel rm on rm.fid = de.fparentid ");
            builder.append(" inner join T_RIS_ModelSHOW ms on rm.fid = ms.FRiskModelid ");
            builder.append(" where rd.fcontrolModel = 'ROBOT' AND ms.FStatus = 'enable' ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)builder.toString());
            while (rowSet.next()) {
                function_set.add(rowSet.getString(1).trim() + rowSet.getString(2).trim());
            }
            aisCacheMap.put(ctx.getAIS(), function_set);
            RiskCacheManager.put("risk_robot_cache", aisCacheMap);
        }
        catch (Exception e) {
            logger.error((Object)("RiskModelCache--initRobotCache--error--" + e));
        }
    }

    public static void clearRiskModelCache(Context ctx) {
        RiskCacheManager.clearCache("risk_page_action_cache");
        RiskCacheManager.clearCache("risk_function_cache");
        RiskCacheManager.clearCache("risk_robot_cache");
        RiskCacheManager.clearCache("risk_uipk_action_cache");
        RiskCacheManager.clearCache("risk_uipk_cache");
        RiskModelCache.initRobotCache(ctx);
        RiskModelCache.initFunctionCache(ctx);
        RiskModelCache.initUipkCache(ctx);
        RiskModelCache.initUipkActionCache(ctx);
        RiskModelCache.initPageActionCache(ctx);
    }

    public static List<String> getUipkAction(Context ctx, String uipk) {
        if (ctx == null) {
            throw new IllegalArgumentException("existPagekAction ctx is null");
        }
        Map cfgMap = null;
        Map uipk_action_map = null;
        Object cacheObj = RiskCacheManager.getValue("risk_page_action_cache");
        if (cacheObj != null) {
            cfgMap = (Map)cacheObj;
        } else {
            logger.error((Object)"[risk_page_action_cache]");
            RiskModelCache.initPageActionCache(ctx);
            cacheObj = RiskCacheManager.getValue("risk_page_action_cache");
            cfgMap = (Map)cacheObj;
        }
        String dbId = ctx.getAIS();
        if (StringUtils.isEmpty((CharSequence)dbId)) {
            throw new IllegalArgumentException("ctx[" + ctx + "]ctx getAIS isEmpty");
        }
        if (cfgMap != null && (uipk_action_map = (Map)cfgMap.get(dbId)) != null) {
            return (List)uipk_action_map.get(uipk);
        }
        return new ArrayList<String>();
    }
}

