/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.export;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.risk.BillTypeInfo;
import com.kingdee.eas.base.risk.CheckGroupInfo;
import com.kingdee.eas.base.risk.DesignerEntryCollection;
import com.kingdee.eas.base.risk.DesignerEntryInfo;
import com.kingdee.eas.base.risk.ModelConditEntryInfo;
import com.kingdee.eas.base.risk.ModelShowCollection;
import com.kingdee.eas.base.risk.ModelShowFactory;
import com.kingdee.eas.base.risk.PageEntryCollection;
import com.kingdee.eas.base.risk.PageEntryInfo;
import com.kingdee.eas.base.risk.RiskDesignerInfo;
import com.kingdee.eas.base.risk.RiskFactorsInfo;
import com.kingdee.eas.base.risk.RiskLevelInfo;
import com.kingdee.eas.base.risk.RiskModelCollection;
import com.kingdee.eas.base.risk.RiskModelFactory;
import com.kingdee.eas.base.risk.RiskModelInfo;
import com.kingdee.eas.base.ssccommon.utils.sqlutils.GenertSQLUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class RiskDataExportUtils {
    private static Logger logger = Logger.getLogger(RiskDataExportUtils.class);
    private static Set<String> idSet = new HashSet<String>();

    public static String runScript(Context ctx, String sql) throws EASBizException {
        return GenertSQLUtils.runScript((Context)ctx, (String)sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String test_EAS_V_90(Context ctx) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("('suspiciousTrade-000001',");
            builder.append("'suspiciousTrade-000002',");
            builder.append("'suspiciousTrade-000003',");
            builder.append("'suspiciousTrade-000004',");
            builder.append("'suspiciousTrade-000005',");
            builder.append("'suspiciousTrade-000006',");
            builder.append("'suspiciousTrade-000007',");
            builder.append("'suspiciousTrade-000008',");
            builder.append("'suspiciousTrade-000009',");
            builder.append("'suspiciousTrade-000010',");
            builder.append("'suspiciousTrade-000011',");
            builder.append("'suspiciousTrade-000012',");
            builder.append("'suspiciousTrade-000013',");
            builder.append("'suspiciousTrade-000014',");
            builder.append("'suspiciousTrade-000015',");
            builder.append("'suspiciousTrade-000016',");
            builder.append("'suspiciousTrade-000017',");
            builder.append("'suspiciousTrade-000018',");
            builder.append("'suspiciousTrade-000019',");
            builder.append("'suspiciousTrade-000020',");
            builder.append("'suspiciousTrade-000021',");
            builder.append("'suspiciousTrade-000022',");
            builder.append("'suspiciousTrade-000023',");
            builder.append("'suspiciousTrade-000024',");
            builder.append("'suspiciousTrade-000025',");
            builder.append("'suspiciousTrade-000026',");
            builder.append("'suspiciousTrade-000027',");
            builder.append("'suspiciousTrade-000028',");
            builder.append("'suspiciousTrade-000029',");
            builder.append("'suspiciousTrade-000030',");
            builder.append("'suspiciousTrade-000031',");
            builder.append("'suspiciousTrade-000032',");
            builder.append("'suspiciousTrade-000033',");
            builder.append("'suspiciousTrade-000034',");
            builder.append("'suspiciousTrade-000035',");
            builder.append("'suspiciousTrade-000036')");
            ArrayList<String> list = new ArrayList<String>();
            String sql = "select fid from t_ris_riskmodel where fnumber in " + builder.toString();
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                list.add(rowSet.getString("fid"));
            }
            StringBuilder genSql = new StringBuilder(10000);
            for (String riskModelId : list) {
                genSql.append(RiskDataExportUtils.genSQL(ctx, riskModelId));
            }
            String string = genSql.toString();
            return string;
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            String string = "\u540e\u53f0\u5bfc\u51fa\u5f02\u5e38:" + e.getMessage();
            return string;
        }
        finally {
            idSet.clear();
        }
    }

    public static String genSQL_Common(Context ctx, List<String> risks) {
        try {
            StringBuilder genSql = new StringBuilder(10000);
            for (String riskModelId : risks) {
                genSql.append(RiskDataExportUtils.genSQL(ctx, riskModelId));
            }
            return genSql.toString();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return "\u540e\u53f0\u5bfc\u51fa\u5f02\u5e38:" + e.getMessage();
        }
    }

    public static String genSQL(Context ctx, String riskModelId) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)riskModelId, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection selector = RiskDataExportUtils.getRiskItemSelectors();
        viewInfo.setSelector(selector);
        RiskModelCollection modelCollection = RiskModelFactory.getLocalInstance(ctx).getRiskModelCollection(viewInfo);
        if (modelCollection != null && modelCollection.size() > 0) {
            return RiskDataExportUtils.genInsertSQL(ctx, modelCollection.get(0));
        }
        return "";
    }

    private static String genInsertSQL(Context ctx, RiskModelInfo riskModelInfo) throws EASBizException, BOSException {
        StringBuilder builder = new StringBuilder();
        builder.append("--").append(riskModelInfo.getNumber()).append(":").append(riskModelInfo.getName()).append(";").append("begin").append("\n");
        String riskModelSQL = RiskDataExportUtils.genRiskModelSQL(ctx, riskModelInfo);
        builder.append(riskModelSQL);
        String riskModelTargetSQL = RiskDataExportUtils.genRiskModelTargetBillTypeSQL(ctx, riskModelInfo);
        builder.append(riskModelTargetSQL);
        if (riskModelInfo.getRiskFactors() != null) {
            String riskModelFactorsSQL = RiskDataExportUtils.genRiskModelFactorsSQL(ctx, riskModelInfo.getRiskFactors());
            builder.append(riskModelFactorsSQL);
        }
        String riskModelDesignerSQL = RiskDataExportUtils.genRiskModelDesignerSQL(ctx, riskModelInfo);
        builder.append(riskModelDesignerSQL);
        if (riskModelInfo.getCheckGroup() != null) {
            String riskModelCheckGroupSQL = RiskDataExportUtils.genRiskModelCheckGroup(ctx, riskModelInfo.getCheckGroup());
            builder.append(riskModelCheckGroupSQL);
        }
        if (riskModelInfo.getRiskLevel() != null) {
            String riskModelRiskLevelSQL = RiskDataExportUtils.genRiskModelRiskLevel(ctx, riskModelInfo.getRiskLevel());
            builder.append(riskModelRiskLevelSQL);
        }
        builder.append("--").append(riskModelInfo.getNumber()).append(":").append(riskModelInfo.getName()).append(";").append("end").append("\n");
        return builder.toString();
    }

    private static String genRiskModelRiskLevel(Context ctx, RiskLevelInfo riskLevel) throws BOSException, EASBizException {
        if (idSet.contains(riskLevel.getId().toString())) {
            return "";
        }
        String script = null;
        String table = "";
        StringBuilder builder = new StringBuilder();
        table = "T_RIS_RiskLevel";
        builder.append("--\u98ce\u9669\u7b49\u7ea7--T_RIS_RiskLevel").append("\n");
        builder.append("if not exists (select 1 from " + table + " where FId='" + riskLevel.getId().toString() + "')");
        script = RiskDataExportUtils.runScript(ctx, "geninsert select * from " + table + " where fid = '" + riskLevel.getId().toString() + "'");
        builder.append(script.toString()).append("\n");
        idSet.add(riskLevel.getId().toString());
        script = null;
        table = null;
        return builder.toString();
    }

    private static String genRiskModelCheckGroup(Context ctx, CheckGroupInfo checkGroup) throws BOSException, EASBizException {
        if (idSet.contains(checkGroup.getId().toString())) {
            return "";
        }
        String script = null;
        String table = "";
        StringBuilder builder = new StringBuilder();
        table = "T_RIS_CheckGroup";
        builder.append("--\u98ce\u9669\u70b9\u5206\u7ec4--T_RIS_CheckGroup").append("\n");
        builder.append("if not exists (select 1 from " + table + " where FId='" + checkGroup.getId().toString() + "')");
        script = RiskDataExportUtils.runScript(ctx, "geninsert select * from " + table + " where fid = '" + checkGroup.getId().toString() + "'");
        builder.append(script.toString()).append("\n");
        idSet.add(checkGroup.getId().toString());
        script = null;
        table = null;
        return builder.toString();
    }

    private static String genRiskModelDesignerSQL(Context ctx, RiskModelInfo riskModelInfo) throws BOSException, EASBizException {
        String script = null;
        String table = "";
        StringBuilder builder = new StringBuilder();
        if (riskModelInfo.getDesignerEntry() != null && riskModelInfo.getDesignerEntry().size() > 0) {
            CoreBillEntryBaseInfo paramEntryInfo;
            AbstractObjectCollection paramEntry;
            int j;
            RiskDesignerInfo designer;
            DesignerEntryInfo info;
            int i;
            table = "T_RIS_DesignerEntry";
            builder.append("--T_RIS_DesignerEntry \u98ce\u63a7\u6a21\u578b\u8bbe\u8ba1\u5668\u5206\u5f55").append("\n");
            DesignerEntryCollection entry = riskModelInfo.getDesignerEntry();
            for (i = 0; i < entry.size(); ++i) {
                info = entry.get(i);
                builder.append("if not exists (select 1 from " + table + " where FId='" + info.getId().toString() + "')");
                script = RiskDataExportUtils.runScript(ctx, "geninsert select * from " + table + " where fid = '" + info.getId().toString() + "'");
                builder.append(script.toString()).append("\n");
                script = null;
            }
            table = null;
            table = "T_RIS_RiskDesigner";
            for (i = 0; i < entry.size(); ++i) {
                info = entry.get(i);
                designer = info.getDesigner();
                if (idSet.contains(designer.getId().toString())) continue;
                builder.append("if not exists (select 1 from " + table + " where FId='" + designer.getId().toString() + "')");
                script = RiskDataExportUtils.runScript(ctx, "geninsert select * from " + table + " where fid = '" + designer.getId().toString() + "'");
                builder.append(script.toString()).append("\n");
                idSet.add(designer.getId().toString());
                script = null;
            }
            table = "";
            table = "T_RIS_PageEntry";
            for (i = 0; i < entry.size(); ++i) {
                info = entry.get(i);
                designer = info.getDesigner();
                PageEntryCollection pageEntry = designer.getPageEntry();
                if (pageEntry == null || pageEntry.size() <= 0) continue;
                for (j = 0; j < pageEntry.size(); ++j) {
                    PageEntryInfo pageEntryInfo = pageEntry.get(j);
                    if (idSet.contains(pageEntryInfo.getId().toString())) continue;
                    builder.append("if not exists (select 1 from " + table + " where FId='" + pageEntryInfo.getId().toString() + "')");
                    script = RiskDataExportUtils.runScript(ctx, "geninsert select * from " + table + " where fid = '" + pageEntryInfo.getId().toString() + "'");
                    builder.append(script.toString()).append("\n");
                    idSet.add(pageEntryInfo.getId().toString());
                    script = null;
                }
            }
            table = "";
            table = "T_RIS_ParamEntry";
            for (i = 0; i < entry.size(); ++i) {
                info = entry.get(i);
                designer = info.getDesigner();
                paramEntry = designer.getParamEntry();
                if (paramEntry == null || paramEntry.size() <= 0) continue;
                for (j = 0; j < paramEntry.size(); ++j) {
                    paramEntryInfo = paramEntry.get(j);
                    if (idSet.contains(paramEntryInfo.getId().toString())) continue;
                    builder.append("if not exists (select 1 from " + table + " where FId='" + paramEntryInfo.getId().toString() + "')");
                    script = RiskDataExportUtils.runScript(ctx, "geninsert select * from " + table + " where fid = '" + paramEntryInfo.getId().toString() + "'");
                    builder.append(script.toString()).append("\n");
                    idSet.add(paramEntryInfo.getId().toString());
                    script = null;
                }
            }
            table = "";
            table = "T_RIS_ActionEntry";
            for (i = 0; i < entry.size(); ++i) {
                info = entry.get(i);
                designer = info.getDesigner();
                paramEntry = designer.getActionEntry();
                if (paramEntry == null || paramEntry.size() <= 0) continue;
                for (j = 0; j < paramEntry.size(); ++j) {
                    paramEntryInfo = paramEntry.get(j);
                    if (idSet.contains(paramEntryInfo.getId().toString())) continue;
                    builder.append("if not exists (select 1 from " + table + " where FId='" + paramEntryInfo.getId().toString() + "')");
                    script = RiskDataExportUtils.runScript(ctx, "geninsert select * from " + table + " where fid = '" + paramEntryInfo.getId().toString() + "'");
                    builder.append(script.toString()).append("\n");
                    idSet.add(paramEntryInfo.getId().toString());
                    script = null;
                }
            }
            table = "";
        }
        return builder.toString();
    }

    private static String genRiskModelFactorsSQL(Context ctx, RiskFactorsInfo riskFactors) throws BOSException, EASBizException {
        CoreBillEntryBaseInfo info;
        int i;
        AbstractObjectCollection entry;
        if (idSet.contains(riskFactors.getId().toString())) {
            return "";
        }
        String script = null;
        String table = "";
        StringBuilder builder = new StringBuilder();
        table = "T_RIS_RiskFactors";
        builder.append("--\u5355\u636e\u7c7b\u578b--\u98ce\u9669\u56e0\u5b50").append("\n");
        builder.append("if not exists (select 1 from " + table + " where FId='" + riskFactors.getId().toString() + "')");
        script = RiskDataExportUtils.runScript(ctx, "geninsert select * from " + table + " where fid = '" + riskFactors.getId().toString() + "'");
        builder.append(script.toString()).append("\n");
        idSet.add(riskFactors.getId().toString());
        script = null;
        table = null;
        if (!idSet.contains(riskFactors.getBillType().getId().toString())) {
            table = "T_RIS_BillType";
            builder.append("--\u5355\u636e\u7c7b\u578b--T_RIS_BillType").append("\n");
            builder.append("if not exists (select 1 from " + table + " where FId='" + riskFactors.getBillType().getId().toString() + "')");
            script = RiskDataExportUtils.runScript(ctx, "geninsert select * from " + table + " where fid = '" + riskFactors.getBillType().getId().toString() + "'");
            builder.append(script.toString()).append("\n");
            idSet.add(riskFactors.getBillType().getId().toString());
            script = null;
            table = null;
        }
        if (riskFactors.getFactorsFieldEntry() != null && riskFactors.getFactorsFieldEntry().size() > 0) {
            table = "T_RIS_FactorsFieldEntry";
            builder.append("--T_RIS_FactorsFieldEntry-- \u98ce\u9669\u56e0\u5b50\u91c7\u96c6\u5b57\u6bb5\u5206\u5f55").append("\n");
            entry = riskFactors.getFactorsFieldEntry();
            for (i = 0; i < entry.size(); ++i) {
                info = entry.get(i);
                builder.append("if not exists (select 1 from " + table + " where FId='" + info.getId().toString() + "')");
                script = RiskDataExportUtils.runScript(ctx, "geninsert select * from " + table + " where fid = '" + info.getId().toString() + "'");
                builder.append(script.toString()).append("\n");
                script = null;
            }
            table = null;
        }
        if (riskFactors.getFactorsRuleEntry() != null && riskFactors.getFactorsRuleEntry().size() > 0) {
            table = "T_RIS_FactorsRuleEntry";
            builder.append("--T_RIS_FactorsRuleEntry-- \u98ce\u9669\u56e0\u5b50\u91c7\u96c6\u89c4\u5219\u5206\u5f55").append("\n");
            entry = riskFactors.getFactorsRuleEntry();
            for (i = 0; i < entry.size(); ++i) {
                info = entry.get(i);
                builder.append("if not exists (select 1 from " + table + " where FId='" + info.getId().toString() + "')");
                script = RiskDataExportUtils.runScript(ctx, "geninsert select * from " + table + " where fid = '" + info.getId().toString() + "'");
                builder.append(script.toString()).append("\n");
                script = null;
            }
            table = null;
        }
        return builder.toString();
    }

    private static String genRiskModelTargetBillTypeSQL(Context ctx, RiskModelInfo riskModelInfo) throws EASBizException, BOSException {
        BillTypeInfo targetBillType = riskModelInfo.getTargetBillType();
        if (idSet.contains(targetBillType.getId().toString())) {
            return "";
        }
        String script = null;
        String table = "";
        StringBuilder builder = new StringBuilder();
        table = "T_RIS_BillType";
        builder.append("--\u5355\u636e\u7c7b\u578b--T_RIS_BillType").append("\n");
        builder.append("if not exists (select 1 from " + table + " where FId='" + targetBillType.getId().toString() + "')");
        script = RiskDataExportUtils.runScript(ctx, "geninsert select * from " + table + " where fid = '" + targetBillType.getId().toString() + "'");
        builder.append(script.toString()).append("\n");
        idSet.add(targetBillType.getId().toString());
        script = null;
        if (targetBillType.getParent() != null) {
            if (idSet.contains(targetBillType.getParent().getId().toString())) {
                return builder.toString();
            }
            builder.append("if not exists (select 1 from " + table + " where FId='" + targetBillType.getParent().getId().toString() + "')");
            script = RiskDataExportUtils.runScript(ctx, "geninsert select * from " + table + " where fid = '" + targetBillType.getParent().getId().toString() + "'");
            builder.append(script.toString()).append("\n");
            idSet.add(targetBillType.getParent().getId().toString());
            script = null;
        }
        table = null;
        return builder.toString();
    }

    private static String genRiskModelSQL(Context ctx, RiskModelInfo riskModelInfo) throws BOSException, EASBizException {
        ModelShowCollection modelShowCollection;
        Serializable info;
        int i;
        AbstractObjectCollection entry;
        String script = null;
        String table = "";
        StringBuilder builder = new StringBuilder();
        table = "t_ris_riskModel";
        builder.append("--\u98ce\u63a7\u6a21\u578b--t_ris_riskModel").append("\n");
        builder.append("if not exists (select 1 from " + table + " where FId='" + riskModelInfo.getId().toString() + "')");
        script = RiskDataExportUtils.runScript(ctx, "geninsert select * from " + table + " where fid = '" + riskModelInfo.getId().toString() + "'");
        builder.append(script.toString()).append("\n");
        script = null;
        table = null;
        if (riskModelInfo.getModelConditEntry() != null && riskModelInfo.getModelConditEntry().size() > 0) {
            table = "T_RIS_ModelConditEntry";
            entry = riskModelInfo.getModelConditEntry();
            builder.append("--modelConditEntry--T_RIS_ModelConditEntry \u9002\u7528\u6761\u4ef6\u5206\u5f55").append("\n");
            for (i = 0; i < entry.size(); ++i) {
                ModelConditEntryInfo entryInfo = entry.get(i);
                builder.append("if not exists (select 1 from " + table + " where FId='" + entryInfo.getId().toString() + "')");
                script = RiskDataExportUtils.runScript(ctx, "geninsert select * from " + table + " where fid = '" + entryInfo.getId().toString() + "'");
                builder.append(script.toString()).append("\n");
                script = null;
            }
            table = null;
        }
        if (riskModelInfo.getModelApiParamEntry() != null && riskModelInfo.getModelApiParamEntry().size() > 0) {
            table = "T_RIS_ModelApiParamEntry";
            builder.append("--ModelApiParamEntry--T_RIS_ModelApiParamEntry \u98ce\u63a7\u6a21\u578bAPI\u53c2\u6570\u5206\u5f55").append("\n");
            entry = riskModelInfo.getModelApiParamEntry();
            for (i = 0; i < entry.size(); ++i) {
                info = entry.get(i);
                builder.append("if not exists (select 1 from " + table + " where FId='" + info.getId().toString() + "')");
                script = RiskDataExportUtils.runScript(ctx, "geninsert select * from " + table + " where fid = '" + info.getId().toString() + "'");
                builder.append(script.toString()).append("\n");
                script = null;
            }
            table = null;
        }
        if (riskModelInfo.getModelRuleEntry() != null && riskModelInfo.getModelRuleEntry().size() > 0) {
            table = "T_RIS_ModelRuleEntry";
            builder.append("--T_RIS_ModelRuleEntry \u98ce\u63a7\u6a21\u578b\u6267\u884c\u89c4\u5219\u5206\u5f55").append("\n");
            entry = riskModelInfo.getModelRuleEntry();
            for (i = 0; i < entry.size(); ++i) {
                info = entry.get(i);
                builder.append("if not exists (select 1 from " + table + " where FId='" + info.getId().toString() + "')");
                script = RiskDataExportUtils.runScript(ctx, "geninsert select * from " + table + " where fid = '" + info.getId().toString() + "'");
                builder.append(script.toString()).append("\n");
                script = null;
            }
            table = null;
        }
        if (riskModelInfo.getFilterEntry() != null && riskModelInfo.getFilterEntry().size() > 0) {
            table = "T_RIS_FactorsFilterEntry";
            builder.append("--T_RIS_FactorsFilterEntry \u98ce\u63a7\u6a21\u578b\u98ce\u9669\u56e0\u5b50\u8fc7\u6ee4\u6761\u4ef6\u8bbe\u7f6e").append("\n");
            entry = riskModelInfo.getFilterEntry();
            for (i = 0; i < entry.size(); ++i) {
                info = entry.get(i);
                builder.append("if not exists (select 1 from " + table + " where FId='" + info.getId().toString() + "')");
                script = RiskDataExportUtils.runScript(ctx, "geninsert select * from " + table + " where fid = '" + info.getId().toString() + "'");
                builder.append(script.toString()).append("\n");
                script = null;
            }
            table = null;
        }
        if (riskModelInfo.getModelFieldEntry() != null && riskModelInfo.getModelFieldEntry().size() > 0) {
            table = "T_RIS_ModelFieldEntry";
            builder.append("--T_RIS_ModelFieldEntry \u98ce\u63a7\u6a21\u578b\u5c55\u793a\u5b57\u6bb5").append("\n");
            entry = riskModelInfo.getModelFieldEntry();
            for (i = 0; i < entry.size(); ++i) {
                info = entry.get(i);
                builder.append("if not exists (select 1 from " + table + " where FId='" + info.getId().toString() + "')");
                script = RiskDataExportUtils.runScript(ctx, "geninsert select * from " + table + " where fid = '" + info.getId().toString() + "'");
                builder.append(script.toString()).append("\n");
                script = null;
            }
            table = null;
        }
        if (riskModelInfo.getModelOtherEntry() != null && riskModelInfo.getModelOtherEntry().size() > 0) {
            table = "T_RIS_ModelOtherEntry";
            builder.append("--T_RIS_ModelOtherEntry \u98ce\u63a7\u6a21\u578b\u5176\u4ed6\u5c55\u793a\u5b57\u6bb5").append("\n");
            entry = riskModelInfo.getModelOtherEntry();
            for (i = 0; i < entry.size(); ++i) {
                info = entry.get(i);
                builder.append("if not exists (select 1 from " + table + " where FId='" + info.getId().toString() + "')");
                script = RiskDataExportUtils.runScript(ctx, "geninsert select * from " + table + " where fid = '" + info.getId().toString() + "'");
                builder.append(script.toString()).append("\n");
                script = null;
            }
            table = null;
        }
        if (riskModelInfo.getOrgEntry() != null && riskModelInfo.getOrgEntry().size() > 0) {
            table = "T_RIS_ModelOrg";
            builder.append("--T_RIS_ModelOrg \u98ce\u63a7\u6a21\u578b\u7ec4\u7ec7\u5206\u5f55").append("\n");
            entry = riskModelInfo.getOrgEntry();
            for (i = 0; i < entry.size(); ++i) {
                info = entry.get(i);
                builder.append("if not exists (select 1 from " + table + " where FId='" + info.getId().toString() + "')");
                script = RiskDataExportUtils.runScript(ctx, "geninsert select * from " + table + " where fid = '" + info.getId().toString() + "'");
                builder.append(script.toString()).append("\n");
                script = null;
            }
            table = null;
        }
        if ((modelShowCollection = ModelShowFactory.getLocalInstance(ctx).getModelShowCollection("select * where riskModel='" + riskModelInfo.getId().toString() + "'")) != null && modelShowCollection.size() > 0) {
            table = "T_RIS_ModelShow";
            builder.append("--T_RIS_ModelShow \u98ce\u63a7\u6a21\u578b\u5c55\u73b0\u987a\u5e8f").append("\n");
            for (i = 0; i < modelShowCollection.size(); ++i) {
                info = modelShowCollection.get(i);
                builder.append("if not exists (select 1 from " + table + " where FId='" + info.getId().toString() + "')");
                script = RiskDataExportUtils.runScript(ctx, "geninsert select * from " + table + " where fid = '" + info.getId().toString() + "'");
                builder.append(script.toString()).append("\n");
                script = null;
            }
            table = null;
        }
        return builder.toString();
    }

    public static SelectorItemCollection getRiskItemSelectors() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("checkGroup.*");
        selector.add("riskLevel.*");
        selector.add("targetBillType.*");
        selector.add("riskFactors.*");
        selector.add("riskFactors.billType.*");
        selector.add("riskFactors.factorsRuleEntry.*");
        selector.add("riskFactors.factorsFieldEntry.*");
        selector.add("riskFactors.factorsFieldEntry.fixedValue.*");
        selector.add("modelConditEntry.*");
        selector.add("filterEntry.*");
        selector.add("modelFieldEntry.*");
        selector.add("modelRuleEntry.*");
        selector.add("modelRuleEntry.filterEntry.*");
        selector.add("apiConfig.*");
        selector.add("apiConfig.apiParam.*");
        selector.add("modelApiParamEntry.*");
        selector.add("modelApiParamEntry.apiParam.*");
        selector.add("designerEntry.*");
        selector.add("modelOtherEntry.*");
        selector.add("overAmount.*");
        selector.add("overAmount.srcBill.*");
        selector.add("overAmount.srcFilter.*");
        selector.add("overAmount.targetFilter.*");
        selector.add("repeatBill.*");
        selector.add("repeatBill.srcBill.*");
        selector.add("repeatBill.entry.*");
        selector.add("repeatBill.targetFilter.*");
        selector.add("repeatBill.showFiledEntry.*");
        return selector;
    }
}

