/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.service.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.risk.OperateMark;
import com.kingdee.eas.base.risk.OperateMarkFacadeFactory;
import com.kingdee.eas.base.risk.RiskApiFacadeFactory;
import com.kingdee.eas.base.risk.service.operateMark.OperateMarkUtils;
import com.kingdee.eas.common.EASBizException;
import java.util.List;
import org.apache.log4j.Logger;

public class RiskClientUtil {
    private static Logger logger = Logger.getLogger(RiskClientUtil.class);

    public static List<String> getActions(String uipk) {
        try {
            return RiskApiFacadeFactory.getRemoteInstance().getActions(uipk);
        }
        catch (BOSException e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public static String getWeakRiskForModel(IObjectValue modelValue, String uipk) {
        try {
            return RiskApiFacadeFactory.getRemoteInstance().getWeakRiskForModel(modelValue, uipk);
        }
        catch (BOSException e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public static String getActionRiskForModel(IObjectValue modelValue, String uipk, String action) {
        try {
            return RiskApiFacadeFactory.getRemoteInstance().getActionRiskForModel(modelValue, uipk, action);
        }
        catch (BOSException e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public static String getWeakRiskForModel(IObjectValue modelValue, String uipk, IObjectCollection botRelColl) {
        try {
            if (botRelColl == null || botRelColl.size() == 0) {
                return RiskApiFacadeFactory.getRemoteInstance().getWeakRiskForModel(modelValue, uipk);
            }
            return RiskApiFacadeFactory.getRemoteInstance().getWeakRiskForModel(modelValue, uipk, botRelColl);
        }
        catch (BOSException e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public static String getActionRiskForModel(IObjectValue modelValue, String uipk, String action, IObjectCollection botRelColl) {
        try {
            if (botRelColl == null || botRelColl.size() == 0) {
                return RiskApiFacadeFactory.getRemoteInstance().getActionRiskForModel(modelValue, uipk, action);
            }
            return RiskApiFacadeFactory.getRemoteInstance().getActionRiskForModel(modelValue, uipk, action, botRelColl);
        }
        catch (BOSException e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public static String getWeakRisk(String billId, String uipk) {
        try {
            return RiskApiFacadeFactory.getRemoteInstance().getWeakRisk(billId, uipk);
        }
        catch (BOSException e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public static String getWeakRiskBatch(List<String> billIds, String uipk) {
        try {
            return RiskApiFacadeFactory.getRemoteInstance().getWeakRiskBatch(billIds, uipk);
        }
        catch (BOSException e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public static String getActionRiskBatch(List<String> billIds, String uipk, String action) {
        try {
            return RiskApiFacadeFactory.getRemoteInstance().getActionRiskBatch(billIds, uipk, action);
        }
        catch (BOSException e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public static String getActionRisk(String billId, String uipk, String action) {
        try {
            return RiskApiFacadeFactory.getRemoteInstance().getActionRisk(billId, uipk, action);
        }
        catch (BOSException e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public static void actionRiskMark(String batchNumber, String operateMark) throws BOSException, EASBizException {
        OperateMark mark = OperateMarkUtils.convert2enum(operateMark);
        OperateMarkFacadeFactory.getRemoteInstance().writeMark(batchNumber, mark);
    }
}

