/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.service.common;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.util.enums.Enum;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BillAttrUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.risk.service.common.BillAttrUtils");

    public static Map<String, String> getBillAttribute(Context ctx, List<String> keyList, IObjectValue dataObj) {
        HashMap<String, String> fromSC = new HashMap<String, String>();
        for (int i = 0; i < keyList.size(); ++i) {
            String dyKey = keyList.get(i);
            Object dyValue = null;
            if (dataObj instanceof IObjectValue) {
                try {
                    dyValue = dataObj;
                    String[] keys = dyKey.split("\\.");
                    dyValue = BillAttrUtils.getDyValue(ctx, dyValue, keys);
                    if (dyValue instanceof Map) {
                        Map dyValueMap = (Map)dyValue;
                        String retuString = "";
                        retuString = JSONObject.toJSONString((Object)dyValueMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
                        dyValue = retuString;
                    }
                }
                catch (Exception e) {
                    dyValue = null;
                    logger.error((Object)("get params error from bill,dyKey:" + dyKey), (Throwable)e);
                }
            }
            String value = null;
            if (dyValue != null && !dyValue.toString().equals("null")) {
                value = String.valueOf(dyValue);
            }
            logger.info((Object)("dykey is..." + dyKey));
            logger.info((Object)("value is..." + value));
            fromSC.put(dyKey, value);
        }
        return fromSC;
    }

    private static String toUpperCaseFirst(String name) {
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        return name;
    }

    private static Object getDyValue(Context ctx, Object dyValue, String[] keys) {
        String key = keys[0];
        try {
            Object spobj;
            if (dyValue instanceof IObjectValue && (spobj = ((IObjectValue)dyValue).get(key)) == null) {
                return "";
            }
        }
        catch (Exception spobj) {
            // empty catch block
        }
        try {
            Method method2;
            Class<?> cls = dyValue.getClass();
            String fieldKey = BillAttrUtils.toUpperCaseFirst(key);
            try {
                method2 = cls.getMethod("get" + fieldKey, new Class[0]);
                Object enumDyValue = method2.invoke(dyValue, new Object[0]);
                if (enumDyValue instanceof Enum) {
                    cls = enumDyValue.getClass();
                    method2 = cls.getMethod("getAlias", new Class[0]);
                    dyValue = method2.invoke(enumDyValue, new Object[0]);
                    return dyValue;
                }
            }
            catch (Exception method2) {
                // empty catch block
            }
            try {
                method2 = cls.getMethod("is" + fieldKey, new Class[0]);
                Object booleanDyValue = method2.invoke(dyValue, new Object[0]);
                if (booleanDyValue instanceof Boolean) {
                    return (Boolean)booleanDyValue;
                }
            }
            catch (Exception method3) {
                // empty catch block
            }
            method2 = cls.getMethod("get", String.class);
            dyValue = method2.invoke(dyValue, key);
            if (dyValue instanceof Enum) {
                cls = dyValue.getClass();
                method2 = cls.getMethod("getAlias", new Class[0]);
                dyValue = method2.invoke(dyValue, new Object[0]);
                return dyValue;
            }
            if (dyValue instanceof Timestamp) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return format.format(dyValue);
            }
            if (dyValue instanceof IObjectCollection) {
                IObjectCollection coll = (IObjectCollection)dyValue;
                String[] strArr = BillAttrUtils.removeStringArrFrist(keys);
                ArrayList<Object> list = new ArrayList<Object>();
                for (int j = 0; j < coll.size(); ++j) {
                    IObjectValue objValue = coll.getObject(j);
                    dyValue = BillAttrUtils.getDyValue(ctx, objValue, strArr);
                    list.add(dyValue);
                }
                return list;
            }
            if (dyValue instanceof IObjectValue) {
                String[] strArr = BillAttrUtils.removeStringArrFrist(keys);
                dyValue = BillAttrUtils.getDyValue(ctx, dyValue, strArr);
                return dyValue;
            }
            if (dyValue instanceof String) {
                dyValue = dyValue != null ? ((String)dyValue).trim() : dyValue;
            }
            return dyValue;
        }
        catch (Exception e) {
            dyValue = null;
            logger.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private static String[] removeStringArrFrist(String[] keys) {
        String[] arrNew = new String[keys.length - 1];
        for (int i = 1; i < keys.length; ++i) {
            arrNew[i - 1] = keys[i];
        }
        return arrNew;
    }
}

