/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.service.exprEngine;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.risk.MetaDataType;
import com.kingdee.eas.base.risk.RiskException;
import com.kingdee.eas.base.risk.service.common.AviatorUtils;
import com.kingdee.eas.base.risk.service.common.BillModelUitls;
import com.kingdee.eas.base.risk.service.common.ExprConvertUtil;
import com.kingdee.eas.base.risk.service.engine.IEngine;
import com.kingdee.eas.base.risk.service.engine.exprEngin.ProcessingPropListEngine;
import com.kingdee.eas.base.risk.service.pojo.RiskParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public abstract class ProcessingExprEngine
extends ProcessingPropListEngine
implements IEngine {
    private static Logger logger = Logger.getLogger(ProcessingExprEngine.class);
    public static String[] AggregateFunctions = new String[]{"SUM", "AVG", "COUNT", "MAX", "MIN"};

    @Override
    public Object getRealValue(Context ctx, RiskParam param, IObjectValue objectValue, CoreBaseInfo coreBaseInfo, MetaDataType metaDataType, String compareField, Map map) throws RiskException {
        List propMapArr = (List)map.get("propMapArr");
        String expression = map.get("showExpress").toString();
        expression = this.convertPression(expression);
        expression = this.replaceAllFixed(expression);
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("__$$dataList", coreBaseInfo.get("__$$dataList"));
        expression = this.replaceAllField(ctx, expression, propMapArr, param, objectValue, coreBaseInfo, env);
        String finalExpr = expression = this.processFunExpr(ctx, expression);
        Object returnObj = this.getExprValue(ctx, finalExpr, env);
        return returnObj;
    }

    private String processFunExpr(Context ctx, String expression) {
        expression = this.processAggregateFun(ctx, expression);
        return expression;
    }

    private String processAggregateFun(Context ctx, String expression) {
        String patternStr = "\\((.*?)\\)";
        for (String fun : AggregateFunctions) {
            String fixedPattern = fun + patternStr;
            Matcher matcher = Pattern.compile(fixedPattern).matcher(expression);
            while (matcher.find()) {
                String group = matcher.group();
                String[] split = group.split(fun + "(");
                StringBuffer buffers = new StringBuffer();
                buffers.append(split[0]).append("__$$dataList").append(",").append(split[1]);
                expression = expression.replace(group, buffers);
            }
        }
        return expression;
    }

    protected Object getExprValue(Context ctx, String finalExpr, Map<String, Object> env) {
        Object execute = AviatorUtils.execute(ctx, finalExpr, env);
        return execute;
    }

    protected String replaceAllField(Context ctx, String expression, List<Map> propMapArr, RiskParam param, IObjectValue objectValue, CoreBaseInfo coreBaseInfo, Map<String, Object> env) throws RiskException {
        for (int i = 0; i < propMapArr.size(); ++i) {
            Map propMap = propMapArr.get(i);
            String number = (String)propMap.get("number");
            String name = (String)propMap.get("name");
            StringBuffer bf = new StringBuffer();
            bf.append("[").append(number).append("|").append(name).append("]");
            Object realValue = this.getPropValue(param, number);
            env.put(number, realValue);
            expression = expression.replace(bf.toString(), number);
        }
        return expression;
    }

    private Object getPropValue(RiskParam param, String number) throws RiskException {
        IObjectValue model = param.getModel();
        Object o = BillModelUitls.modelGetVal(model, number);
        return o;
    }

    protected String convertPression(String expression) {
        return ExprConvertUtil.convertPression(expression);
    }

    protected String replaceAllFixed(String expression) {
        String fixedPattern = "\\[\"(.*?)\"]";
        Matcher matcher = Pattern.compile(fixedPattern).matcher(expression);
        while (matcher.find()) {
            String group = matcher.group();
            expression = expression.replace(group, "'" + group.substring(2, group.length() - 2) + "'");
        }
        return expression;
    }
}

