/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.service.paySafe;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.risk.RiskException;
import com.kingdee.eas.base.risk.RiskModelInfo;
import com.kingdee.eas.base.risk.app.paySafe.OASrcBillFilterCollection;
import com.kingdee.eas.base.risk.app.paySafe.OATargetBillFilterCollection;
import com.kingdee.eas.base.risk.app.paySafe.OverAmountCollection;
import com.kingdee.eas.base.risk.app.paySafe.OverAmountFactory;
import com.kingdee.eas.base.risk.app.paySafe.OverAmountInfo;
import com.kingdee.eas.base.risk.service.business.IModelService;
import com.kingdee.eas.base.risk.service.business.ResultMsg;
import com.kingdee.eas.base.risk.service.common.EngineUtils;
import com.kingdee.eas.base.risk.service.common.RealValUtils;
import com.kingdee.eas.base.risk.service.condit.PaySafeFilerRule;
import com.kingdee.eas.base.risk.service.pojo.RiskParam;
import com.kingdee.eas.base.risk.service.showdata.OnlyTextInfo;
import com.kingdee.eas.base.risk.service.showdata.ShowDataInfo;
import com.kingdee.eas.base.risk.tools.sqlTools.SqlFormatUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AvoidExcess
implements IModelService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.risk.service.paySafe.AvoidExcess");

    @Override
    public ResultMsg check(Context ctx, RiskModelInfo modelInfo, IObjectValue billModelInfo, Object ... args) {
        String bosType = billModelInfo.getBOSType().toString();
        String mess = "";
        ArrayList<ShowDataInfo> showDataList = new ArrayList<ShowDataInfo>();
        try {
            PaySafeFilerRule paySafeFilerRule;
            int i;
            Map<String, Set<String>> bostypeToBillIds = this.getBosTypeToBillIds(ctx, billModelInfo);
            if (bostypeToBillIds.isEmpty()) {
                return this.concretResult("\u975ebotp\u751f\u6210\u5355\u636e", false, showDataList);
            }
            OverAmountInfo overAmountInfo = modelInfo.getOverAmount();
            if (overAmountInfo == null) {
                Object[] bosTypes = bostypeToBillIds.keySet().toArray();
                String srcBostype = bosType.equalsIgnoreCase((String)bosTypes[0]) ? (String)bosTypes[1] : (String)bosTypes[0];
                OverAmountCollection overAmountCollection = OverAmountFactory.getLocalInstance((Context)ctx).getOverAmountCollection("select *,srcBill.*,targetBill.*,srcFilter.*,targetFilter.* where targetBill.billBosType = '" + bosType + "' and srcBill.billBosType = '" + srcBostype + "'");
                if (overAmountCollection.isEmpty()) {
                    return this.concretResult("\u672a\u914d\u7f6e\u8d85\u989d\u4fe1\u606f", false, showDataList);
                }
                overAmountInfo = overAmountCollection.get(0);
            }
            Map<String, IObjectCollection> billsValue = this.getBillsValue(ctx, overAmountInfo, billModelInfo, bostypeToBillIds);
            IObjectCollection srcCollection = billsValue.get(overAmountInfo.getSrcBill().getBillBosType());
            IObjectCollection targetCollection = billsValue.get(overAmountInfo.getTargetBill().getBillBosType());
            RiskParam riskParam = new RiskParam();
            RiskModelInfo riskModelInfo = new RiskModelInfo();
            if (overAmountInfo.getSrcFilter().size() != 0) {
                riskModelInfo.put("modelRuleEntry", overAmountInfo.getSrcFilter());
                for (i = srcCollection.size() - 1; i >= 0; --i) {
                    riskParam.setModel(srcCollection.getObject(i));
                    paySafeFilerRule = new PaySafeFilerRule(ctx, riskParam, riskModelInfo);
                    if (!((Boolean)paySafeFilerRule.match()).booleanValue()) continue;
                    srcCollection.removeObject(i);
                }
            }
            if (overAmountInfo.getTargetFilter().size() != 0) {
                riskModelInfo.put("modelRuleEntry", overAmountInfo.getTargetFilter());
                for (i = targetCollection.size() - 1; i >= 0; --i) {
                    if (billModelInfo.get("id").equals(targetCollection.getObject(i).get("id"))) continue;
                    riskParam.setModel(targetCollection.getObject(i));
                    paySafeFilerRule = new PaySafeFilerRule(ctx, riskParam, riskModelInfo);
                    if (!((Boolean)paySafeFilerRule.match()).booleanValue()) continue;
                    targetCollection.removeObject(i);
                }
            }
            if (srcCollection.isEmpty() || targetCollection.isEmpty()) {
                return this.concretResult("\u5355\u636e\u5df2\u8fc7\u6ee4\uff0c\u65e0\u9002\u914d\u8d85\u989d\u5355\u636e", false, showDataList);
            }
            BigDecimal srcValue = this.caculateAmount(ctx, srcCollection, overAmountInfo.getSrcAF());
            mess = mess + " srcValue=" + srcValue.toString();
            BigDecimal targetValue = this.caculateAmount(ctx, targetCollection, overAmountInfo.getTargetAF());
            mess = mess + " ;targetValue=" + targetValue.toString();
            if (targetValue.compareTo(srcValue) == 1) {
                this.putDataToShowList(showDataList, srcValue, targetValue);
                return this.concretResult("\u8d85\u989d" + mess, true, showDataList);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u8d85\u989d\u6821\u9a8c:" + e.getMessage()), (Throwable)e);
            StringBuilder tag = new StringBuilder();
            try {
                for (StackTraceElement log : e.getStackTrace()) {
                    tag.append(log.getClassName() + "." + log.getMethodName() + "_____\u884c\u6570" + log.getLineNumber() + ";\n");
                }
                if (tag.length() >= 3000) {
                    tag.setLength(3000);
                }
                DbUtil.execute((Context)ctx, (String)"INSERT INTO T_RIS_RiskErrLog(ferrstack,fbillid,fid) VALUES (?,?,newbosid('C76F6002'))", (Object[])new Object[]{tag.toString(), billModelInfo.get("id").toString()});
            }
            catch (Exception e1) {
                logger.error((Object)("\u83b7\u53d6\u5806\u6808\u4fe1\u606f\u9519\u8bef\uff1a" + e));
            }
            return this.concretResult("\u4ee3\u7801\u6267\u884c\u5f02\u5e38" + mess, false, showDataList);
        }
        return this.concretResult("\u6b63\u5e38" + mess, false, showDataList);
    }

    private void putDataToShowList(List<ShowDataInfo> showDataList, Object srcValue, Object targetValue) {
        ArrayList<Object> srcShowValues = new ArrayList<Object>();
        srcShowValues.add(srcValue);
        OnlyTextInfo onlyTextInfo = new OnlyTextInfo();
        onlyTextInfo.setShowName("\u4e0a\u6e38\u5355\u636e\u5408\u8ba1\u91d1\u989d");
        onlyTextInfo.setShowNumber("\u4e0a\u6e38\u5355\u636e\u5408\u8ba1\u91d1\u989d");
        onlyTextInfo.setShowValue(srcShowValues);
        showDataList.add(onlyTextInfo);
        ArrayList<Object> tarShowValues = new ArrayList<Object>();
        tarShowValues.add(targetValue);
        OnlyTextInfo onlyTextInfo1 = new OnlyTextInfo();
        onlyTextInfo1.setShowName("\u4e0b\u6e38\u5355\u636e\u5408\u8ba1\u91d1\u989d");
        onlyTextInfo1.setShowNumber("\u4e0b\u6e38\u5355\u636e\u5408\u8ba1\u91d1\u989d");
        onlyTextInfo1.setShowValue(tarShowValues);
        showDataList.add(onlyTextInfo1);
    }

    private ResultMsg concretResult(String msg, boolean result, List<ShowDataInfo> showDataList) {
        ResultMsg builder = ResultMsg.builder();
        Map<String, String> dataMap = builder.getDataMap();
        dataMap.put(ResultMsg.DEFKEY[0], msg);
        dataMap.put(ResultMsg.DEFKEY[1], this.getClass().getName());
        builder.setResult(result).setDataMap(dataMap);
        builder.setShowDataList(showDataList);
        return builder;
    }

    private BigDecimal caculateAmount(Context ctx, IObjectCollection conllection, String formula) throws RiskException, BOSException {
        BigDecimal value = new BigDecimal(0);
        RiskParam riskParam = new RiskParam();
        for (int i = 0; i < conllection.size(); ++i) {
            riskParam.setModel(conllection.getObject(i));
            Object realValue = RealValUtils.getRealValue(ctx, riskParam, null, null, null, formula);
            try {
                if (realValue instanceof BigDecimal) {
                    value = value.add((BigDecimal)realValue);
                    continue;
                }
                if (realValue == null) {
                    logger.error((Object)"realValue = null");
                    continue;
                }
                value = value.add(new BigDecimal(String.valueOf(realValue)));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("realValue =" + (realValue == null ? "null" : realValue.toString())));
                throw new BOSException((Throwable)e);
            }
        }
        return value;
    }

    private Map<String, IObjectCollection> getBillsValue(Context ctx, OverAmountInfo overAmountInfo, IObjectValue billModelInfo, Map<String, Set<String>> bostypeToBillIds) throws BOSException {
        OASrcBillFilterCollection srcFilter = overAmountInfo.getSrcFilter();
        SelectorItemCollection sicSrc = new SelectorItemCollection();
        for (int i = 0; i < srcFilter.size(); ++i) {
            this.putSelectorToSIC(srcFilter.get(i).getCompareField(), sicSrc);
            this.putSelectorToSIC(srcFilter.get(i).getCompareValue(), sicSrc);
        }
        this.putSelectorToSIC(overAmountInfo.getSrcAF(), sicSrc);
        String srcBostype = overAmountInfo.getSrcBill().getBillBosType();
        Set<String> srcBillids = bostypeToBillIds.get(srcBostype);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", srcBillids, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(sicSrc);
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        IObjectCollection srcCollection = iDynamicObject.getCollection(new BOSObjectType(srcBostype), view);
        OATargetBillFilterCollection targetFilter = overAmountInfo.getTargetFilter();
        SelectorItemCollection sicDest = new SelectorItemCollection();
        for (int i = 0; i < targetFilter.size(); ++i) {
            this.putSelectorToSIC(targetFilter.get(i).getCompareField(), sicDest);
            this.putSelectorToSIC(targetFilter.get(i).getCompareValue(), sicDest);
        }
        this.putSelectorToSIC(overAmountInfo.getTargetAF(), sicDest);
        String destBostype = overAmountInfo.getTargetBill().getBillBosType();
        Set<String> destBillids = bostypeToBillIds.get(destBostype);
        destBillids.remove(billModelInfo.get("id").toString());
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", destBillids, CompareType.INCLUDE));
        view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(sicDest);
        IObjectCollection destCollection = iDynamicObject.getCollection(new BOSObjectType(destBostype), view);
        destCollection.addObject(billModelInfo);
        HashMap<String, IObjectCollection> result = new HashMap<String, IObjectCollection>();
        result.put(srcBostype, srcCollection);
        result.put(destBostype, destCollection);
        return result;
    }

    private void putSelectorToSIC(String Field2, SelectorItemCollection sic) {
        if (Field2 != null && (Field2.indexOf("propMapArr") != -1 || Field2.indexOf("propMap") != -1)) {
            Map map = EngineUtils.jsonTOMap(Field2);
            if (map.get("propMapArr") != null) {
                List propMapArr = (List)map.get("propMapArr");
                for (int j = 0; j < propMapArr.size(); ++j) {
                    sic.add(new SelectorItemInfo((String)((Map)propMapArr.get(j)).get("number")));
                }
            } else if (map.get("propMap") != null) {
                Map propMap = (Map)map.get("propMap");
                sic.add(new SelectorItemInfo((String)propMap.get("number")));
            }
        }
    }

    private Map<String, Set<String>> getBosTypeToBillIds(Context ctx, IObjectValue billModelInfo) throws BOSException, SQLException {
        Set riskSrcBillIds = billModelInfo.get("riskSrcBillIds") == null ? null : (Set)billModelInfo.get("riskSrcBillIds");
        String billid = billModelInfo.get("id").toString();
        String botpSql = "";
        botpSql = riskSrcBillIds != null && !riskSrcBillIds.isEmpty() ? "SELECT FSRCOBJECTID,FSRCENTITYID  ,FDESTOBJECTID,FDESTENTITYID  FROM T_BOT_RELATION where  FSRCOBJECTID in" + SqlFormatUtils.set2Sql(riskSrcBillIds) : "SELECT FSRCOBJECTID,FSRCENTITYID  ,FDESTOBJECTID,FDESTENTITYID  FROM T_BOT_RELATION where  FSRCOBJECTID in (SELECT FSRCOBJECTID FROM T_BOT_RELATION where FDESTOBJECTID = '" + billid + "')";
        IRowSet rowSets = DbUtil.executeQuery((Context)ctx, (String)botpSql);
        HashMap<String, Set<String>> bostypeToBillIds = new HashMap<String, Set<String>>();
        while (rowSets.next()) {
            String srcBostype = rowSets.getString("FSRCENTITYID");
            String destBostype = rowSets.getString("FDESTENTITYID");
            Set<String> srcBillIds = bostypeToBillIds.get(srcBostype);
            if (srcBillIds == null) {
                srcBillIds = new HashSet<String>();
                bostypeToBillIds.put(srcBostype, srcBillIds);
            }
            srcBillIds.add(rowSets.getString("FSRCOBJECTID"));
            Set<String> destBillIds = bostypeToBillIds.get(destBostype);
            if (destBillIds == null) {
                destBillIds = new HashSet<String>();
                bostypeToBillIds.put(destBostype, destBillIds);
            }
            destBillIds.add(rowSets.getString("FDESTOBJECTID"));
        }
        if (bostypeToBillIds.isEmpty() && riskSrcBillIds != null && !riskSrcBillIds.isEmpty()) {
            String srcBillId = (String)riskSrcBillIds.iterator().next();
            ObjectUuidPK srctype = new ObjectUuidPK(srcBillId);
            bostypeToBillIds.put(srctype.getObjectType().toString(), riskSrcBillIds);
            HashSet<String> destBillIds = new HashSet<String>();
            destBillIds.add(billid);
            ObjectUuidPK tartype = new ObjectUuidPK(billid);
            bostypeToBillIds.put(tartype.getObjectType().toString(), destBillIds);
        }
        return bostypeToBillIds;
    }
}

