/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.service.wfEngine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.event.util.DBUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.service.AbstractServiceAdapter;
import com.kingdee.bos.service.IServiceAdapter;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.risk.RiskBizException;
import com.kingdee.eas.base.risk.cache.RiskCacheManager;
import com.kingdee.eas.base.risk.cache.RiskSysParam;
import com.kingdee.eas.base.risk.service.riskManage.RiskForceManager;
import com.kingdee.eas.base.risk.service.wfEngine.CtxSign;
import com.kingdee.eas.base.risk.service.wfEngine.SpecialCheckFactory;
import com.kingdee.eas.common.EASBizException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RiskServiceAdapter
extends AbstractServiceAdapter
implements IServiceAdapter {
    private static Logger logger = Logger.getLogger(RiskServiceAdapter.class);
    public static final String[] RISK_CACHE_KEY = new String[]{"metaCache", "methodCache", "init_cache"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initCacheSet(Context ctx) {
        Boolean has_init_cache;
        HashMap cacheMap = null;
        Object value = RiskCacheManager.getValue("risk_service_adapter_cache");
        if (value != null) {
            return;
        }
        cacheMap = new HashMap();
        HashMap<String, Serializable> aisCacheMap = (HashMap<String, Serializable>)cacheMap.get(ctx.getAIS());
        if (aisCacheMap == null) {
            aisCacheMap = new HashMap<String, Serializable>();
        }
        if ((has_init_cache = (Boolean)aisCacheMap.get(RISK_CACHE_KEY[2])) != null && has_init_cache.booleanValue()) {
            return;
        }
        HashSet<String> metaCache = new HashSet<String>();
        HashSet<String> methodCache = new HashSet<String>();
        Statement pps = null;
        Connection connection = null;
        ResultSet rs = null;
        try {
            StringBuilder builder = new StringBuilder(200);
            builder.append(" SELECT FMetaBostype,FMethodPK FROM T_RIS_RiskDesigner ").append(" WHERE fControlModel != 'POTIPS'");
            connection = DBUtils.getConnection((Context)ctx);
            pps = connection.prepareStatement(builder.toString());
            rs = pps.executeQuery();
            while (rs.next()) {
                String FMetaBostype = rs.getString("FMetaBostype");
                String FMethodPK = rs.getString("FMethodPK");
                if (StringUtils.isNotEmpty((CharSequence)FMetaBostype)) {
                    metaCache.add(FMetaBostype);
                }
                if (!StringUtils.isNotEmpty((CharSequence)FMethodPK)) continue;
                methodCache.add(FMethodPK + FMetaBostype);
            }
            has_init_cache = true;
            aisCacheMap.put(RISK_CACHE_KEY[0], metaCache);
            aisCacheMap.put(RISK_CACHE_KEY[1], methodCache);
            aisCacheMap.put(RISK_CACHE_KEY[2], has_init_cache);
            cacheMap.put(ctx.getAIS(), aisCacheMap);
        }
        catch (SQLException e) {
            logger.error((Object)("RiskServiceAdapter--initCacheSet--error--" + e));
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("RiskServiceAdapter--initCacheSet--closeDB--error--rs" + e));
                }
            }
            if (pps != null) {
                try {
                    pps.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("RiskServiceAdapter--initCacheSet--closeDB--error--pps" + e));
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("RiskServiceAdapter--initCacheSet--closeDB--error--connection" + e));
                }
            }
        }
        RiskCacheManager.put("risk_service_adapter_cache", cacheMap);
    }

    public int getPriority() {
        return 500;
    }

    public String getName() {
        return "BASE_RISK_SERVICE";
    }

    public void execute(IServiceContext svcCtx) throws BOSException {
        try {
            Context ctx = svcCtx.getContext();
            if (svcCtx.getExecutionMode() == 1) {
                return;
            }
            BOSObjectType bosType = svcCtx.getBoType();
            if (bosType == null) {
                return;
            }
            IMetaDataPK metaDataPK = svcCtx.getOperationPK();
            if (metaDataPK == null) {
                return;
            }
            if (this.specialCheck(svcCtx, ctx, bosType, metaDataPK)) {
                if (RiskSysParam.risk_enable(ctx)) {
                    this.doRiskCheck(svcCtx, ctx, bosType, metaDataPK);
                }
            } else {
                Object value = RiskCacheManager.getValue("risk_service_adapter_cache");
                Map objectMap = null;
                if (value != null) {
                    objectMap = (Map)value;
                } else {
                    RiskServiceAdapter.initCacheSet(ctx);
                    value = RiskCacheManager.getValue("risk_service_adapter_cache");
                    objectMap = (Map)value;
                }
                if (objectMap == null) {
                    return;
                }
                Object cacheObj = objectMap.get(ctx.getAIS());
                Map cacheMap = null;
                if (cacheObj != null) {
                    cacheMap = (Map)cacheObj;
                }
                if (cacheMap == null) {
                    return;
                }
                Set metaCache = (Set)cacheMap.get(RISK_CACHE_KEY[0]);
                if (bosType == null || !metaCache.contains(bosType.toString())) {
                    return;
                }
                Set methodCache = (Set)cacheMap.get(RISK_CACHE_KEY[1]);
                if (metaDataPK == null || !methodCache.contains(metaDataPK.toString() + bosType.toString())) {
                    return;
                }
                if (svcCtx.getContext().get((Object)"$$EAS_RISK_SAVE$$") != null && CtxSign.Value.TRUE.equals(svcCtx.getContext().get((Object)"$$EAS_RISK_SAVE$$"))) {
                    return;
                }
                if (!RiskSysParam.risk_enable(ctx)) {
                    return;
                }
                this.doRiskEvent(svcCtx, bosType, metaDataPK);
            }
        }
        catch (Throwable e) {
            if (e instanceof RiskBizException || e instanceof BOSException || e instanceof EASBizException) {
                throw new BOSException(e);
            }
            logger.error((Object)e, e);
        }
    }

    private void doRiskCheck(IServiceContext svcCtx, Context ctx, BOSObjectType bosType, IMetaDataPK metaDataPK) throws EASBizException, BOSException {
        SpecialCheckFactory.doRiskCheck(svcCtx, ctx, bosType, metaDataPK);
    }

    private boolean specialCheck(IServiceContext svcCtx, Context ctx, BOSObjectType bosType, IMetaDataPK metaDataPK) {
        return SpecialCheckFactory.specialCheck(svcCtx, ctx, bosType, metaDataPK);
    }

    private void doRiskEvent(IServiceContext svcCtx, BOSObjectType bosType, IMetaDataPK metaDataPK) throws EASBizException, BOSException {
        RiskForceManager.getService(svcCtx.getContext()).forcedRisk(svcCtx.getContext(), bosType, metaDataPK, svcCtx.getOperationParameters());
    }
}

