/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.tools.smecloud.apigw.http;

import com.kingdee.eas.base.risk.tools.smecloud.apigw.exception.ApiException;
import com.kingdee.eas.base.risk.tools.smecloud.apigw.model.ApiCallBack;
import com.kingdee.eas.base.risk.tools.smecloud.apigw.model.ApiRequest;
import com.kingdee.eas.base.risk.tools.smecloud.apigw.model.ApiResult;
import com.kingdee.eas.base.risk.tools.smecloud.apigw.model.ApigwConfig;
import com.kingdee.eas.base.risk.tools.smecloud.apigw.model.FileStream;
import com.kingdee.eas.base.risk.tools.smecloud.apigw.util.CommontUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class HttpClient {
    private ExecutorService executorService = null;
    private static final int DEFAULT_THREAD_KEEP_ALIVE_TIME = 60;
    private static CloseableHttpClient httpClient;
    private static PoolingHttpClientConnectionManager connManager;

    public void init(ApigwConfig config) {
        try {
            SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).setSoKeepAlive(true).setSoReuseAddress(true).setSoTimeout(config.getResponseTimeout()).build();
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build());
            RegistryBuilder registryBuilder = RegistryBuilder.create();
            Registry socketFactoryRegistry = registryBuilder.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslsf).build();
            connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            connManager.setMaxTotal(config.getDispatchMaxRequests());
            connManager.setDefaultMaxPerRoute(config.getDispatchMaxRequestsPerHost());
            connManager.setDefaultSocketConfig(socketConfig);
            connManager.setDefaultConnectionConfig(ConnectionConfig.custom().build());
            httpClient = HttpClient.getHttpClient(config.getRequestTimeout(), config.getConnectTimeout(), config.getResponseTimeout());
            this.executorService = new ThreadPoolExecutor(config.getDispatchCoreThreads(), config.getDispatchMaxThreads(), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DeafultAsyncThreadFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static CloseableHttpClient getHttpClient(int reqeustTimeout, int connectTimeout, int responseTimeout) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(reqeustTimeout).setConnectTimeout(connectTimeout).setSocketTimeout(responseTimeout).build();
        HttpRequestRetryHandler retry = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (executionCount >= 3) {
                    return false;
                }
                if (exception instanceof NoHttpResponseException) {
                    return true;
                }
                if (exception instanceof SSLHandshakeException) {
                    return false;
                }
                if (exception instanceof InterruptedIOException) {
                    return true;
                }
                if (exception instanceof UnknownHostException) {
                    return false;
                }
                if (exception instanceof SSLException) {
                    return false;
                }
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                HttpRequest request = clientContext.getRequest();
                return !(request instanceof HttpEntityEnclosingRequest);
            }
        };
        return HttpClients.custom().setDefaultRequestConfig(requestConfig).setRetryHandler(retry).setConnectionManager((HttpClientConnectionManager)connManager).build();
    }

    private HttpUriRequest buildRequest(ApiRequest apiRequest) {
        RequestBuilder builder = RequestBuilder.create((String)apiRequest.getMethod().getValue());
        try {
            URIBuilder uriBuilder = new URIBuilder();
            uriBuilder.setScheme(apiRequest.getScheme());
            uriBuilder.setHost(apiRequest.getHost());
            uriBuilder.setPath(apiRequest.getPath());
            if (!CommontUtil.isEmpty(apiRequest.getQuerys())) {
                for (Map.Entry entry : apiRequest.getQuerys().entrySet()) {
                    uriBuilder.addParameter((String)entry.getKey(), (String)entry.getValue());
                }
            }
            builder.setUri(uriBuilder.build());
        }
        catch (URISyntaxException e) {
            throw new ApiException(e);
        }
        switch (apiRequest.getMethod()) {
            case POST_FORM_DATA: 
            case PUT_FORM_DATA: 
            case PATCH_FORM_DATA: 
            case OPTIONS_FORM_DATA: {
                MultipartEntityBuilder multiBuilder = MultipartEntityBuilder.create();
                if (!CommontUtil.isEmpty(apiRequest.getFormData())) {
                    ContentType contentType = ContentType.create((String)"text/plain", (Charset)StandardCharsets.UTF_8);
                    for (Map.Entry entry : apiRequest.getFormData().entrySet()) {
                        multiBuilder.addPart((String)entry.getKey(), (ContentBody)new StringBody((String)entry.getValue(), contentType));
                    }
                }
                if (!CommontUtil.isEmpty(apiRequest.getFormFile())) {
                    for (Map.Entry entry : apiRequest.getFormFile().entrySet()) {
                        multiBuilder.addPart((String)entry.getKey(), (ContentBody)new FileBody((File)entry.getValue()));
                    }
                }
                if (!CommontUtil.isEmpty(apiRequest.getFormFileStream())) {
                    for (Map.Entry entry : apiRequest.getFormFileStream().entrySet()) {
                        multiBuilder.addBinaryBody((String)entry.getKey(), (InputStream)entry.getValue(), ContentType.DEFAULT_BINARY, "uploadfile.tmp");
                    }
                }
                if (!CommontUtil.isEmpty(apiRequest.getFileStreams())) {
                    for (Map.Entry entry : apiRequest.getFileStreams().entrySet()) {
                        multiBuilder.addBinaryBody((String)entry.getKey(), ((FileStream)entry.getValue()).getStream(), ContentType.DEFAULT_BINARY, ((FileStream)entry.getValue()).getFileName());
                    }
                }
                builder.setEntity(multiBuilder.build());
                break;
            }
            case POST_FORM: 
            case PUT_FORM: 
            case PATCH_FORM: 
            case OPTIONS_FORM: {
                if (CommontUtil.isEmpty(apiRequest.getFormParam())) break;
                ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
                for (Map.Entry entry : apiRequest.getFormParam().entrySet()) {
                    nameValuePairs.add(new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue()));
                }
                builder.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, StandardCharsets.UTF_8));
                break;
            }
            case POST_BODY: 
            case PUT_BODY: 
            case PATCH_BODY: 
            case OPTIONS_BODY: {
                EntityBuilder bodyBuilder = EntityBuilder.create();
                bodyBuilder.setContentType(ContentType.parse((String)apiRequest.getRequestContentType()));
                bodyBuilder.setBinary(apiRequest.getBody());
                builder.setEntity(bodyBuilder.build());
                break;
            }
            case POST_FILE: 
            case PUT_FILE: 
            case PATCH_FILE: 
            case OPTIONS_FILE: {
                EntityBuilder fileBuilder = EntityBuilder.create();
                if (!CommontUtil.isEmpty(apiRequest.getFile())) {
                    fileBuilder.setContentType(ContentType.parse((String)apiRequest.getRequestContentType()));
                    fileBuilder.setFile(apiRequest.getFile());
                    builder.setEntity(fileBuilder.build());
                    break;
                }
                if (CommontUtil.isEmpty(apiRequest.getBinaryStream())) break;
                fileBuilder.setContentType(ContentType.parse((String)apiRequest.getRequestContentType()));
                fileBuilder.setStream(apiRequest.getBinaryStream());
                builder.setEntity(fileBuilder.build());
            }
        }
        if (!CommontUtil.isEmpty(apiRequest.getHeaders())) {
            for (Map.Entry entry : apiRequest.getHeaders().entrySet()) {
                builder.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return builder.build();
    }

    protected ApiResult syncRequest(ApiRequest apiRequest) {
        HttpUriRequest httpRequest = this.buildRequest(apiRequest);
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = httpClient.execute(httpRequest);
            String body = httpResponse.getEntity() != null ? EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8) : null;
            ApiResult apiResult = new ApiResult(httpResponse.getStatusLine().getStatusCode(), body, httpRequest.getAllHeaders());
            return apiResult;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        finally {
            CommontUtil.closeQuietly((Closeable)httpResponse);
        }
    }

    protected void downloadFile(ApiRequest apiRequest, String filepath) {
        HttpUriRequest httpRequest = this.buildRequest(apiRequest);
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = httpClient.execute(httpRequest);
            InputStream in = httpResponse.getEntity().getContent();
            FileOutputStream out = new FileOutputStream(filepath);
            byte[] b = new byte[1024];
            int ch = 0;
            while ((ch = in.read(b)) != -1) {
                out.write(b, 0, ch);
            }
            in.close();
            out.flush();
            out.close();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        finally {
            CommontUtil.closeQuietly((Closeable)httpResponse);
        }
    }

    protected final void asyncRequest(final ApiRequest apiRequest, final ApiCallBack apiCallback) {
        this.executorService.submit(new Callable<ApiResult>(){

            @Override
            public ApiResult call() throws Exception {
                ApiResult apiResponse;
                try {
                    apiResponse = HttpClient.this.syncRequest(apiRequest);
                }
                catch (Exception e) {
                    if (apiCallback != null) {
                        apiCallback.onFailure(apiRequest, e);
                    }
                    throw e;
                }
                if (apiCallback != null) {
                    apiCallback.onResponse(apiRequest, apiResponse);
                }
                return apiResponse;
            }
        });
    }

    static {
        connManager = null;
    }

    private class DeafultAsyncThreadFactory
    implements ThreadFactory {
        private AtomicInteger counter = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "Aliyun_SDK_Async_ThreadPool_" + this.counter.incrementAndGet());
        }

        private DeafultAsyncThreadFactory() {
        }
    }
}

