/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.common.json.org;

import com.kingdee.eas.cp.common.json.org.JSONObject;
import com.kingdee.eas.cp.common.json.org.JSONTokener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;

public class JSONArray {
    private ArrayList myArrayList;

    public JSONArray() {
        this.myArrayList = new ArrayList();
    }

    public JSONArray(JSONTokener x) throws ParseException {
        this();
        if (x.nextClean() != '[') {
            throw x.syntaxError("A JSONArray must start with '['");
        }
        if (x.nextClean() == ']') {
            return;
        }
        x.back();
        block4: while (true) {
            this.myArrayList.add(x.nextValue());
            switch (x.nextClean()) {
                case ',': {
                    if (x.nextClean() == ']') {
                        return;
                    }
                    x.back();
                    continue block4;
                }
                case ']': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or ']'");
    }

    public JSONArray(String string) throws ParseException {
        this(new JSONTokener(string));
    }

    public JSONArray(Collection collection) {
        this.myArrayList = new ArrayList(collection);
    }

    public Object get(int index) throws NoSuchElementException {
        Object o = this.opt(index);
        if (o == null) {
            throw new NoSuchElementException("JSONArray[" + index + "] not found.");
        }
        return o;
    }

    ArrayList getArrayList() {
        return this.myArrayList;
    }

    public boolean getBoolean(int index) throws ClassCastException, NoSuchElementException {
        Object o = this.get(index);
        if (o == Boolean.FALSE || o.equals("false")) {
            return false;
        }
        if (o == Boolean.TRUE || o.equals("true")) {
            return true;
        }
        throw new ClassCastException("JSONArray[" + index + "] not a Boolean.");
    }

    public double getDouble(int index) throws NoSuchElementException, NumberFormatException {
        Object o = this.get(index);
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String) {
            return new Double((String)o);
        }
        throw new NumberFormatException("JSONObject[" + index + "] is not a number.");
    }

    public int getInt(int index) throws NoSuchElementException, NumberFormatException {
        Object o = this.get(index);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return (int)this.getDouble(index);
    }

    public JSONArray getJSONArray(int index) throws NoSuchElementException {
        Object o = this.get(index);
        if (o instanceof JSONArray) {
            return (JSONArray)o;
        }
        throw new NoSuchElementException("JSONArray[" + index + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(int index) throws NoSuchElementException {
        Object o = this.get(index);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new NoSuchElementException("JSONArray[" + index + "] is not a JSONObject.");
    }

    public String getString(int index) throws NoSuchElementException {
        return this.get(index).toString();
    }

    public boolean isNull(int index) {
        Object o = this.opt(index);
        return o == null || o.equals(null);
    }

    public String join(String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.myArrayList.size(); ++i) {
            Object o;
            if (i > 0) {
                sb.append(separator);
            }
            if ((o = this.myArrayList.get(i)) == null) {
                sb.append("null");
                continue;
            }
            if (o instanceof String) {
                sb.append(JSONObject.quote((String)o));
                continue;
            }
            if (o instanceof Number) {
                sb.append(JSONObject.numberToString((Number)o));
                continue;
            }
            sb.append(o.toString());
        }
        return sb.toString();
    }

    public int length() {
        return this.myArrayList.size();
    }

    public Object opt(int index) {
        if (index < 0 || index >= this.length()) {
            return null;
        }
        return this.myArrayList.get(index);
    }

    public boolean optBoolean(int index) {
        return this.optBoolean(index, false);
    }

    public boolean optBoolean(int index, boolean defaultValue) {
        Object o = this.opt(index);
        if (o != null) {
            if (o == Boolean.FALSE || o.equals("false")) {
                return false;
            }
            if (o == Boolean.TRUE || o.equals("true")) {
                return true;
            }
        }
        return defaultValue;
    }

    public double optDouble(int index) {
        return this.optDouble(index, Double.NaN);
    }

    public double optDouble(int index, double defaultValue) {
        Object o = this.opt(index);
        if (o != null) {
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
            try {
                return new Double((String)o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public int optInt(int index) {
        return this.optInt(index, 0);
    }

    public int optInt(int index, int defaultValue) {
        Object o = this.opt(index);
        if (o != null) {
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
            try {
                return Integer.parseInt((String)o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public JSONArray optJSONArray(int index) {
        Object o = this.opt(index);
        if (o instanceof JSONArray) {
            return (JSONArray)o;
        }
        return null;
    }

    public JSONObject optJSONObject(int index) {
        Object o = this.opt(index);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        return null;
    }

    public String optString(int index) {
        return this.optString(index, "");
    }

    public String optString(int index, String defaultValue) {
        Object o = this.opt(index);
        if (o != null) {
            return o.toString();
        }
        return defaultValue;
    }

    public JSONArray put(boolean value) {
        this.put(new Boolean(value));
        return this;
    }

    public JSONArray put(double value) {
        this.put(new Double(value));
        return this;
    }

    public JSONArray put(int value) {
        this.put(new Integer(value));
        return this;
    }

    public JSONArray put(Object value) {
        this.myArrayList.add(value);
        return this;
    }

    public JSONArray put(int index, boolean value) {
        this.put(index, new Boolean(value));
        return this;
    }

    public JSONArray put(int index, double value) {
        this.put(index, new Double(value));
        return this;
    }

    public JSONArray put(int index, int value) {
        this.put(index, new Integer(value));
        return this;
    }

    public JSONArray put(int index, Object value) throws NoSuchElementException, NullPointerException {
        if (index < 0) {
            throw new NoSuchElementException("JSONArray[" + index + "] not found.");
        }
        if (value == null) {
            throw new NullPointerException();
        }
        if (index < this.length()) {
            this.myArrayList.set(index, value);
        } else {
            while (index != this.length()) {
                this.put(null);
            }
            this.put(value);
        }
        return this;
    }

    public JSONObject toJSONObject(JSONArray names) {
        if (names == null || names.length() == 0 || this.length() == 0) {
            return null;
        }
        JSONObject jo = new JSONObject();
        for (int i = 0; i < names.length(); ++i) {
            jo.put(names.getString(i), this.opt(i));
        }
        return jo;
    }

    public String toString() {
        return '[' + this.join(",") + ']';
    }

    public String toString(int indentFactor) {
        return this.toString(indentFactor, 0);
    }

    String toString(int indentFactor, int indent) {
        int i;
        String pad = "";
        StringBuffer sb = new StringBuffer();
        indent += indentFactor;
        for (i = 0; i < indent; ++i) {
            pad = pad + ' ';
        }
        sb.append("[\n");
        for (i = 0; i < this.myArrayList.size(); ++i) {
            if (i > 0) {
                sb.append(",\n");
            }
            sb.append(pad);
            Object o = this.myArrayList.get(i);
            if (o == null) {
                sb.append("null");
                continue;
            }
            if (o instanceof String) {
                sb.append(JSONObject.quote((String)o));
                continue;
            }
            if (o instanceof Number) {
                sb.append(JSONObject.numberToString((Number)o));
                continue;
            }
            if (o instanceof JSONObject) {
                sb.append(((JSONObject)o).toString(indentFactor, indent));
                continue;
            }
            if (o instanceof JSONArray) {
                sb.append(((JSONArray)o).toString(indentFactor, indent));
                continue;
            }
            sb.append(o.toString());
        }
        sb.append(']');
        return sb.toString();
    }
}

