/*
 * Decompiled with CFR 0.152.
 */
package net.buffalo.service.spring;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import net.buffalo.service.BuffaloServiceConfigurer;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringUtil {
    public static Map getConfigedBeanNames(ServletContext context) {
        HashMap<String, String> services = new HashMap<String, String>();
        if (context == null) {
            return null;
        }
        WebApplicationContext appCtx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
        if (appCtx == null) {
            return services;
        }
        String[] buffaloConfigBeanNames = appCtx.getBeanNamesForType(BuffaloServiceConfigurer.class);
        for (int i = 0; i < buffaloConfigBeanNames.length; ++i) {
            String beanName = buffaloConfigBeanNames[i];
            BuffaloServiceConfigurer configBean = (BuffaloServiceConfigurer)appCtx.getBean(beanName);
            Map singleServices = configBean.getServices();
            for (String serviceName : singleServices.keySet()) {
                services.put(serviceName, beanName);
            }
        }
        return services;
    }
}

