/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.editor;

import com.kingdee.bos.ctrl.common.editor.AbstractCellEditor;
import com.kingdee.bos.ctrl.common.editor.TableCheckBoxIcon;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.BasicNumberTextField;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDBusiCurrencyField;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.plaf.KingdeePromptBoxUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.text.AttributedCharacterIterator;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DefaultCellEditor
extends AbstractCellEditor {
    protected JComponent comp;
    protected EditorDelegate delegate;
    protected int clickCountToStart = 2;

    public DefaultCellEditor() {
    }

    public DefaultCellEditor(final JTextField textField) {
        if (textField instanceof KDTextField) {
            ((KDTextField)textField).setEnabledPopup(false);
            ((KDTextField)textField).setSelectAllOnFocus(false);
        }
        this.comp = textField;
        if (JFormattedTextField.class.isAssignableFrom(textField.getClass())) {
            this.handleEsc(textField);
        } else {
            textField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    DefaultCellEditor.this.fireEditingChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    DefaultCellEditor.this.fireEditingChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    DefaultCellEditor.this.fireEditingChanged();
                }
            });
        }
        this.delegate = new EditorDelegate(){

            @Override
            public String getText() {
                String text = null;
                if (textField instanceof KDBusiCurrencyField) {
                    KDBusiCurrencyField btextField = (KDBusiCurrencyField)textField;
                    text = btextField.getText();
                } else {
                    text = textField.getText();
                }
                return text;
            }

            @Override
            public void setValue(Object value) {
                if (JFormattedTextField.class.isAssignableFrom(textField.getClass())) {
                    if (textField instanceof BasicNumberTextField && value != null) {
                        BasicNumberTextField b = (BasicNumberTextField)textField;
                        BigDecimal n = null;
                        String s = value.toString();
                        if ("".equals(s)) {
                            return;
                        }
                        n = new BigDecimal(s);
                        b.setNumberValue((Number)n);
                    } else if (textField instanceof KDFormattedTextField) {
                        BigDecimal n = null;
                        if (value != null && !"".equals(value.toString())) {
                            String s = value.toString();
                            try {
                                n = new BigDecimal(s);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ((KDFormattedTextField)textField).setNumberValue(n);
                    } else {
                        ((JFormattedTextField)textField).setValue(value);
                    }
                } else {
                    textField.setText(value != null ? value.toString() : "");
                }
            }

            @Override
            public Object getValue() {
                String str;
                Object value = null;
                value = JFormattedTextField.class.isAssignableFrom(textField.getClass()) ? (textField instanceof KDFormattedTextField ? ((KDFormattedTextField)textField).getNumberValue() : (textField instanceof BasicNumberTextField ? this.getText() : ((JFormattedTextField)textField).getValue())) : ((str = textField.getText()) == null || str.equals("") ? null : str);
                return value;
            }

            @Override
            public void initComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
                if (anEvent instanceof KeyEvent) {
                    super.initComponent(null, expandValue, style, anEvent);
                    String str = String.valueOf(((KeyEvent)anEvent).getKeyChar());
                    this.initComponent(str);
                } else if (anEvent instanceof InputMethodEvent) {
                    super.initComponent(null, expandValue, style, anEvent);
                    String str = DefaultCellEditor.getInputMethodEventText((InputMethodEvent)anEvent);
                    this.initComponent(str);
                } else if (anEvent instanceof ActionEvent) {
                    super.initComponent(null, expandValue, style, anEvent);
                    String str = DefaultCellEditor.getActionEventText((ActionEvent)anEvent);
                    this.initComponent(str);
                } else {
                    super.initComponent(value, expandValue, style, anEvent);
                    if (textField instanceof KDFormattedTextField) {
                        ((KDFormattedTextField)textField).setSelectAllOnFocus(true);
                    } else {
                        textField.selectAll();
                    }
                }
            }

            void initComponent(String str) {
                if (textField instanceof KDFormattedTextField) {
                    ((KDFormattedTextField)textField).setSelectAllOnFocus(false);
                    if (!StringUtil.isEmptyString((String)str)) {
                        if (!"-".equals(str)) {
                            try {
                                new BigDecimal(str);
                            }
                            catch (Exception e) {
                                str = null;
                            }
                        }
                        ((KDFormattedTextField)textField).setEditingText(str);
                    }
                } else if (textField instanceof BasicNumberTextField) {
                    ((BasicNumberTextField)textField).setSelectAllOnFocus(false);
                    if (!StringUtil.isEmptyString((String)str)) {
                        int length = str.length();
                        try {
                            new Double(str);
                        }
                        catch (Exception e) {
                            str = null;
                            length = 0;
                        }
                        ((BasicNumberTextField)textField).setText(str);
                        textField.setCaretPosition(length);
                    }
                } else {
                    textField.setText(str);
                    if (!StringUtil.isEmptyString((String)str)) {
                        textField.setCaretPosition(str.length());
                    }
                }
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                if (super.isCellEditable(anEvent)) {
                    return true;
                }
                return anEvent instanceof KeyEvent ? DefaultCellEditor.isVisibleChar((KeyEvent)anEvent) : anEvent instanceof InputMethodEvent || anEvent instanceof ActionEvent;
            }
        };
        textField.addActionListener(this.delegate);
    }

    public DefaultCellEditor(final JTextArea textArea) {
        this.comp = textArea;
        if (textArea instanceof KDTextArea) {
            ((KDTextArea)textArea).setSelectAllOnFocus(false);
        }
        InputMap inputMap = this.comp.getInputMap(0);
        KeyStroke ks = KeyStroke.getKeyStroke(10, 0);
        Object actionName = inputMap.get(ks);
        inputMap.put(ks, "no-action");
        ks = KeyStroke.getKeyStroke(10, 512);
        inputMap.put(ks, actionName);
        this.delegate = new EditorDelegate(){

            @Override
            public void setValue(Object value) {
                textArea.setText(value != null ? value.toString() : "");
            }

            @Override
            public Object getValue() {
                String str = textArea.getText();
                if (str == null || str.equals("")) {
                    str = null;
                }
                return str;
            }

            @Override
            public void initComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
                if (anEvent instanceof KeyEvent) {
                    super.initComponent(null, expandValue, style, anEvent);
                    char keyChar = ((KeyEvent)anEvent).getKeyChar();
                    if (keyChar >= ' ' && keyChar <= '~') {
                        textArea.setText(String.valueOf(keyChar));
                    }
                } else if (anEvent instanceof InputMethodEvent) {
                    super.initComponent(null, expandValue, style, anEvent);
                    textArea.setText(DefaultCellEditor.getInputMethodEventText((InputMethodEvent)anEvent));
                } else if (anEvent instanceof ActionEvent) {
                    super.initComponent(null, expandValue, style, anEvent);
                    textArea.setText(DefaultCellEditor.getActionEventText((ActionEvent)anEvent));
                } else {
                    super.initComponent(value, expandValue, style, anEvent);
                }
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                if (super.isCellEditable(anEvent)) {
                    return true;
                }
                return anEvent instanceof KeyEvent ? DefaultCellEditor.isVisibleChar((KeyEvent)anEvent) : anEvent instanceof InputMethodEvent || anEvent instanceof ActionEvent;
            }
        };
    }

    public DefaultCellEditor(final JCheckBox checkBox) {
        checkBox.setIcon(new TableCheckBoxIcon());
        checkBox.setHorizontalAlignment(0);
        this.comp = checkBox;
        this.clickCountToStart = 1;
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultCellEditor.this.fireEditingChanged();
            }
        });
        this.delegate = new EditorDelegate(){

            @Override
            public void setValue(Object value) {
                boolean selected = false;
                if (value instanceof Boolean) {
                    selected = (Boolean)value;
                } else if (value instanceof String) {
                    selected = value.equals("true");
                }
                checkBox.setSelected(selected);
            }

            @Override
            public Object getValue() {
                return checkBox.isSelected();
            }

            @Override
            public void initComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
                super.initComponent(value, expandValue, style, anEvent);
                if (anEvent != null) {
                    if (anEvent instanceof KeyEvent || anEvent instanceof ActionEvent) {
                        ((JCheckBox)DefaultCellEditor.this.comp).doClick();
                    } else if (anEvent instanceof MouseEvent) {
                        ((JCheckBox)DefaultCellEditor.this.comp).doClick();
                    }
                }
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                String text;
                char keyChar;
                if (super.isCellEditable(anEvent)) {
                    return true;
                }
                return anEvent instanceof KeyEvent ? (keyChar = ((KeyEvent)anEvent).getKeyChar()) == ' ' : anEvent instanceof ActionEvent && !StringUtil.isEmptyString((String)(text = DefaultCellEditor.getActionEventText((ActionEvent)anEvent))) && text.charAt(0) == ' ';
            }
        };
    }

    public DefaultCellEditor(final JComboBox comboBox) {
        this.comp = comboBox;
        this.clickCountToStart = 1;
        comboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.delegate = new EditorDelegate(){

            @Override
            public void setValue(Object value) {
                comboBox.removeActionListener(DefaultCellEditor.this.delegate);
                comboBox.setSelectedItem(value);
                comboBox.addActionListener(DefaultCellEditor.this.delegate);
            }

            @Override
            public Object getValue() {
                return comboBox.getSelectedItem();
            }

            @Override
            public void initComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
                super.initComponent(value, expandValue, style, anEvent);
            }

            @Override
            public void releaseComponent() {
            }
        };
        comboBox.addActionListener(this.delegate);
    }

    public DefaultCellEditor(final IKDEditor editor) {
        JComponent tempC;
        this.clickCountToStart = 1;
        this.comp = (JComponent)editor;
        this.delegate = new EditorDelegate(){

            @Override
            public Object getValue() {
                if (editor instanceof KDPromptBox) {
                    KDPromptBox f7 = (KDPromptBox)editor;
                    if (f7.isEditable()) {
                        try {
                            f7.commitEdit();
                        }
                        catch (ParseException parseException) {}
                    }
                } else if (editor instanceof KDDatePicker) {
                    try {
                        ((KDDatePicker)editor).commitEdit();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                return editor.getValue();
            }

            @Override
            public void setValue(Object value) {
                editor.setValue(value);
            }

            @Override
            public Component getFocusComponent() {
                if (KDPromptBox.class.isAssignableFrom(editor.getClass())) {
                    KDPromptBox f7 = (KDPromptBox)editor;
                    return f7.getEditor();
                }
                if (KDDatePicker.class.isAssignableFrom(editor.getClass())) {
                    KDDatePicker dp = (KDDatePicker)editor;
                    if (dp.isEditable()) {
                        return dp.getEditor().getEditorComponent();
                    }
                    return dp;
                }
                return super.getFocusComponent();
            }

            @Override
            public void initComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
                KDDatePicker dp;
                JComponent tempC;
                super.initComponent(value, expandValue, style, anEvent);
                if (KDPromptBox.class.isAssignableFrom(editor.getClass())) {
                    KDPromptBox f7 = (KDPromptBox)editor;
                    JComponent f7Editor = f7.getEditor();
                    f7Editor.setBorder(null);
                    f7Editor.setBackground(DefaultCellEditor.this.getBackgroundColor(style.getBackground()));
                    f7.setAlignment(1);
                    f7.setOpaque(true);
                    f7.setToolTipText(null);
                    f7.setButtonTooltipsText(null);
                    f7.setAutoFocusNextComponent(false);
                    if (anEvent instanceof KeyEvent) {
                        int keyCode;
                        if (f7.isEditable() && (keyCode = ((KeyEvent)anEvent).getKeyCode()) != 118 && DefaultCellEditor.isVisibleChar((KeyEvent)anEvent)) {
                            char keyChar = ((KeyEvent)anEvent).getKeyChar();
                            if (f7Editor instanceof JTextField) {
                                f7.setEditingText(String.valueOf(keyChar));
                            }
                        }
                    } else if (anEvent instanceof InputMethodEvent) {
                        if (f7.isEditable()) {
                            String text = DefaultCellEditor.getInputMethodEventText((InputMethodEvent)anEvent);
                            if (f7Editor instanceof JTextField) {
                                f7.setEditingText(text);
                            }
                        }
                    } else if (anEvent instanceof ActionEvent) {
                        if (f7.isEditable()) {
                            String text = DefaultCellEditor.getActionEventText((ActionEvent)anEvent);
                            if (f7Editor instanceof JTextField) {
                                f7.setEditingText(text);
                            }
                        }
                    } else if (f7Editor instanceof JTextField) {
                        f7.updateData();
                        ((JTextField)f7Editor).selectAll();
                    }
                } else if (KDDatePicker.class.isAssignableFrom(editor.getClass()) && (tempC = (dp = (KDDatePicker)editor).getEditor().getEditorComponent()) != null) {
                    tempC.setBorder(null);
                }
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                if (super.isCellEditable(anEvent)) {
                    return true;
                }
                if (anEvent instanceof KeyEvent) {
                    if (KDPromptBox.class.isAssignableFrom(editor.getClass())) {
                        int keyCode = ((KeyEvent)anEvent).getKeyCode();
                        if (DefaultCellEditor.isVisibleChar((KeyEvent)anEvent) || keyCode == 118) {
                            return true;
                        }
                    }
                } else if ((anEvent instanceof InputMethodEvent || anEvent instanceof ActionEvent) && KDPromptBox.class.isAssignableFrom(editor.getClass())) {
                    return true;
                }
                return false;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof KDPromptBox) {
                    Object obj = ((KDPromptBox)e.getSource()).getClientProperty((Object)"dirty");
                    if (obj instanceof Boolean && obj.equals(Boolean.FALSE)) {
                        DefaultCellEditor.this.stopCellEditing();
                    }
                } else {
                    DefaultCellEditor.this.stopCellEditing();
                }
            }
        };
        if (KDPromptBox.class.isAssignableFrom(editor.getClass())) {
            KDPromptBox e = (KDPromptBox)editor;
            FocusListener[] fls = e.getEditor().getFocusListeners();
            for (int i = fls.length - 1; i >= 0; --i) {
                FocusListener fl = fls[i];
                if (!(fl instanceof KingdeePromptBoxUI.PromptBoxListener)) continue;
                e.getEditor().removeFocusListener(fl);
                break;
            }
            e.addActionListener((ActionListener)this.delegate);
            e.putClientProperty((Object)"EditorForKDTable", (Object)Boolean.TRUE);
        } else if (KDDatePicker.class.isAssignableFrom(editor.getClass()) && (tempC = ((KDDatePicker)editor).getEditor().getEditorComponent()) != null && tempC instanceof JFormattedTextField) {
            ((JFormattedTextField)tempC).addActionListener(this.delegate);
            this.handleEsc(tempC);
        }
    }

    public DefaultCellEditor(JPanel editor) {
        this.comp = editor;
        this.delegate = new EditorDelegate(){

            @Override
            public Object getValue() {
                return "editor.getValue()";
            }
        };
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public void setClickCountToStart(int count) {
        this.clickCountToStart = count;
    }

    private void handleEsc(JComponent comp) {
        comp.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "esc2");
        comp.getActionMap().put("esc2", new AbstractAction(){
            private static final long serialVersionUID = -1948897795240252276L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultCellEditor.this.fireEditingCanceled();
            }
        });
    }

    Color getBackgroundColor(Color color) {
        if (color.getAlpha() == 0) {
            return Color.WHITE;
        }
        return color;
    }

    @Override
    public String getText() {
        return this.delegate.getText();
    }

    @Override
    public void setText(String text) {
        this.delegate.setText(text);
    }

    @Override
    public Object getValue() {
        return this.delegate.getValue();
    }

    @Override
    public void setValue(Object value) {
        this.delegate.setValue(value);
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return this.delegate.isCellEditable(anEvent);
    }

    @Override
    public boolean isDisplayable() {
        return this.delegate.isDisplayable();
    }

    @Override
    public Component prepareComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
        if (this.isDisplayable()) {
            this.delegate.initComponent(value, expandValue, style, anEvent);
            return this.comp;
        }
        this.delegate.actionPerformed(value, anEvent);
        return null;
    }

    @Override
    public void releaseComponent() {
        this.delegate.releaseComponent();
    }

    @Override
    public Component getFocusComponent() {
        return this.delegate.getFocusComponent();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.delegate.setBounds(x, y, width, height);
    }

    @Override
    public Component getComponent() {
        return this.comp;
    }

    public static String getInputMethodEventText(InputMethodEvent event) {
        AttributedCharacterIterator text = event.getText();
        StringBuffer strBuf = new StringBuffer();
        text.first();
        char c = text.current();
        for (int commitCount = event.getCommittedCharacterCount(); commitCount > 0; --commitCount) {
            strBuf.append(c);
            c = text.next();
        }
        return strBuf.toString();
    }

    public static String getActionEventText(ActionEvent event) {
        return event.getActionCommand();
    }

    public static boolean isVisibleChar(KeyEvent anEvent) {
        if (anEvent == null || anEvent.isAltDown() || anEvent.isControlDown()) {
            return false;
        }
        char keyChar = anEvent.getKeyChar();
        return keyChar >= ' ' && keyChar <= '~';
    }

    protected class EditorDelegate
    implements ActionListener,
    ItemListener {
        protected EditorDelegate() {
        }

        public String getText() {
            return null;
        }

        public void setText(String text) {
        }

        public Object getValue() {
            return null;
        }

        public void setValue(Object value) {
        }

        public void setExpandValue(Object value) {
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent == null) {
                return true;
            }
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= DefaultCellEditor.this.clickCountToStart;
            }
            return false;
        }

        public boolean isDisplayable() {
            return true;
        }

        public Component getFocusComponent() {
            return DefaultCellEditor.this.comp;
        }

        public void setBounds(int x, int y, int width, int height) {
            DefaultCellEditor.this.comp.setBounds(x, y, width, height);
        }

        public void initComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
            DefaultCellEditor.this.comp.setOpaque(true);
            DefaultCellEditor.this.comp.setBorder(null);
            DefaultCellEditor.this.comp.setBackground(DefaultCellEditor.this.getBackgroundColor(style.getBackground()));
            DefaultCellEditor.this.comp.setForeground(style.getFontColor());
            DefaultCellEditor.this.comp.setFont((Font)style.getKDFont());
            this.setValue(value);
        }

        public void releaseComponent() {
        }

        public void actionPerformed(Object value, EventObject anEvent) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultCellEditor.this.stopCellEditing();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            DefaultCellEditor.this.stopCellEditing();
        }
    }
}

