/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui.editor.styled;

import com.kingdee.bos.ctrl.common.ui.editor.DefaultEditorStyleModel;
import com.kingdee.bos.ctrl.common.ui.editor.Lexer;
import com.kingdee.bos.ctrl.common.ui.editor.MatchedToken;
import java.awt.Color;

class CSScriptStyleModel
extends DefaultEditorStyleModel {
    public CSScriptStyleModel() {
        this.initStyle();
    }

    @Override
    public void beforeRun(Lexer lex) {
        lex.delSpecialChar("[]._");
    }

    private void initStyle() {
        this.addStyle(new MatchedToken(){

            @Override
            public boolean match(String token) {
                return token.matches("'.*'") || token.matches("\".*\"");
            }
        }, this.createSimpleAttributeSet(Color.RED));
        this.addStyle(new MatchedToken(){

            @Override
            public boolean match(String token) {
                return token.matches("\\[.*\\]");
            }
        }, this.createSimpleAttributeSet(Color.GREEN.darker()));
        this.addStyle(new MatchedToken(){

            @Override
            public boolean match(String token) {
                return token.matches("[\\d]+(([Ll])|(\\.[\\d]+([DdFf])?))?");
            }
        }, this.createSimpleAttributeSet(Color.RED));
        String keys = "name,caption,properties,parent,currentmember,value";
        this.addStyle(keys.split(","), this.createSimpleAttributeSet(new Color(0xFF00FF)));
        keys = "ForeColor,FontSize,Bold,Italic,UnderLine,ThroughLine,Rotation,FontName,BackGround";
        this.addStyle(keys.split(","), this.createSimpleAttributeSet(new Color(0x3366FF)));
        keys = "TRUE,FALSE,RGB,RED,WHITE,BLACK,BLUE,GREEN,LIGHT_GRAY,GRAY,DARK_GRAY,PINK,ORANGE,YELLOW,MAGENTA,CYAN";
        this.addStyle(keys.split(","), this.createSimpleAttributeSet(Color.RED));
        keys = "Measures,If,and,or";
        this.addStyle(keys.split(","), this.createSimpleAttributeSet(Color.RED.darker()));
        keys = "~`!@#$%^&*()-=_+[]{};':\",./<>?\\|";
        this.addStyle(keys.split(""), this.createSimpleAttributeSet(Color.GRAY));
    }
}

