/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui.restree;

import com.kingdee.bos.ctrl.common.ResourceManager;
import com.kingdee.bos.ctrl.common.restype.def.ActionDef;
import com.kingdee.bos.ctrl.common.restype.def.ResTypeDef;
import com.kingdee.bos.ctrl.common.restype.def.ResTypeDefs;
import com.kingdee.bos.ctrl.common.restype.def.ResTypeTree;
import com.kingdee.bos.ctrl.common.ui.restree.ResNodeAction;
import com.kingdee.bos.ctrl.common.ui.restree.ResNodesAction;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;

public class ItemsHelper {
    public static final Logger log = LogUtil.getPackageLogger(ItemsHelper.class);

    public static ArrayList trimMenuItems(String menuItems, ResTypeTree typeTree) {
        ResTypeDefs defs = typeTree.getRuntimeResTypes();
        if (menuItems == null) {
            Iterator i = defs.iterator();
            while (i.hasNext()) {
                menuItems = menuItems + "{" + ((ResTypeDef)i.next()).getName() + "}|";
            }
        } else {
            menuItems = menuItems + ",";
        }
        Stack stack = new Stack();
        stack.push(new ArrayList());
        int lastIndex_type = -1;
        int lastIndex = -1;
        HashSet set = new HashSet();
        int len = menuItems.length();
        block7: for (int i = 0; i < len; ++i) {
            char ch = menuItems.charAt(i);
            switch (ch) {
                case '{': {
                    lastIndex_type = i;
                    continue block7;
                }
                case '}': {
                    String id = menuItems.substring(lastIndex_type + 1, i);
                    ResTypeDef type = defs.find(id);
                    ResTypeDef.ActionDefs actionDefs = type.getActionDefs();
                    if (actionDefs != null) {
                        ArrayList list = (ArrayList)stack.peek();
                        for (Object obj : actionDefs) {
                            if (set.contains(obj)) continue;
                            list.add(obj);
                            set.add(obj);
                        }
                    }
                    lastIndex_type = -1;
                    lastIndex = i;
                    continue block7;
                }
                case ')': 
                case ',': 
                case '|': {
                    String id = menuItems.substring(lastIndex + 1, i);
                    if (id.length() != 0) {
                        ActionDef actionDef = typeTree.findAction(id.trim());
                        if (actionDef == null) {
                            log.warn((Object)("Not found action:" + id));
                        } else if (!set.contains(actionDef)) {
                            ((ArrayList)stack.peek()).add(actionDef);
                            set.add(actionDef);
                        }
                    }
                    if (ch == '|') {
                        ((ArrayList)stack.peek()).add(new JSeparator());
                    } else if (ch == ')') {
                        stack.pop();
                    }
                    lastIndex = i;
                    continue block7;
                }
                case '(': {
                    String id = menuItems.substring(lastIndex + 1, i);
                    ArrayList<String> newGroup = new ArrayList<String>();
                    newGroup.add(id);
                    ((ArrayList)stack.peek()).add(newGroup);
                    stack.push(newGroup);
                    lastIndex = i;
                }
            }
        }
        return (ArrayList)stack.get(0);
    }

    public static Icon loadIcon(String displayIcon, ResTypeDef runtimeTypeDef) {
        if (displayIcon == null) {
            return null;
        }
        String[] ss = displayIcon.split(":");
        if (ss.length == 2) {
            String iconBase = (String)runtimeTypeDef.getProperty(ss[0]);
            if (iconBase == null) {
                iconBase = ss[0];
            }
            return ResourceManager.getIcon(iconBase, ss[1]);
        }
        return null;
    }

    public static void addAction(KDToolBar toolbar, Object action) {
        if (action instanceof KDMenu) {
            KDMenu kdMenu = (KDMenu)action;
            KDWorkButton menuBt = new KDWorkButton();
            while (kdMenu.getItemCount() > 0) {
                menuBt.addAssistMenuItem(kdMenu.getItem(0));
            }
            menuBt.setText(kdMenu.getText());
            toolbar.addWorkButton(menuBt);
        } else if (action instanceof ResNodesAction) {
            ResNodesAction resAction = (ResNodesAction)action;
            if (!resAction.isVisible(null)) {
                return;
            }
            KDWorkButton btn = new KDWorkButton();
            btn.setAction((Action)action);
            btn.setTextIconDisStyle((short)2);
            String toolTip = (String)resAction.getValue("ShortDescription");
            if (toolTip != null) {
                btn.setToolTipText(toolTip);
            }
            toolbar.addWorkButton(btn);
        } else if (action instanceof ResNodeAction) {
            ResNodeAction resAction = (ResNodeAction)action;
            if (!resAction.isVisible(null)) {
                return;
            }
            KDWorkButton btn = new KDWorkButton();
            btn.setAction((Action)action);
            btn.setTextIconDisStyle((short)2);
            String toolTip = (String)resAction.getValue("ShortDescription");
            if (toolTip != null) {
                btn.setToolTipText(toolTip);
            }
            toolbar.addWorkButton(btn);
        } else if (action instanceof JSeparator) {
            toolbar.add((Component)((JSeparator)action));
        }
    }
}

