/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui.tree;

import com.kingdee.bos.ctrl.common.ui.tree.INodeFilter;
import com.kingdee.bos.ctrl.common.ui.tree.ITreeAction;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUI;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;

public abstract class ATreeController {
    private TreeUI treeUI;
    private TreeUINode topNode;
    private ArrayList popMenuActions;
    private ATreeController next;
    private String _relaRoot = "/";
    private INodeFilter nodeFitler;

    public void setRelativeRoot(String relaRoot) {
        this._relaRoot = relaRoot;
    }

    public String getRelativeRoot() {
        return this._relaRoot;
    }

    public String getRelativePathText(String absolutePathText) {
        String relativePathText = !StringUtil.equals((String)this._relaRoot, (String)"/") ? absolutePathText.substring(this._relaRoot.length()) : absolutePathText;
        return relativePathText;
    }

    public String makePathText(TreePath tp) {
        return PathUtil.makeChildPath((String)this._relaRoot, (String)TreeUtil.makePathText(tp));
    }

    public TreePath makeTreePath(TreeUINode tnParent, String pathText) {
        return TreeUtil.makeTreePath(tnParent, this.getRelativePathText(pathText));
    }

    public void initTreeUI(TreeUI treeUI) {
        TreeUINode topNode = new TreeUINode("/");
        treeUI.setRootNode(topNode);
        this.bindTreeUI(treeUI, topNode);
    }

    public void bindTreeUI(TreeUI treeUI, TreeUINode topNode) {
        this.treeUI = treeUI;
        this.topNode = topNode;
        this.topNode.setHook(this);
    }

    public ATreeController getNext() {
        return this.next;
    }

    public void setNext(ATreeController next) {
        this.next = next;
    }

    public TreeUI getTreeUI() {
        return this.treeUI;
    }

    public TreeUINode getTopNode() {
        return this.topNode;
    }

    public ArrayList getPopMenuActions() {
        if (this.popMenuActions == null) {
            this.popMenuActions = new ArrayList();
        }
        return this.popMenuActions;
    }

    public void setPopMenuActions(ArrayList list) {
        this.popMenuActions = list;
    }

    protected abstract boolean initNode(TreePath var1) throws Exception;

    protected boolean onSelectNode(TreePath selectPath, TreePath deselectPath) {
        return true;
    }

    protected boolean onPopMenu(TreePath[] treePaths, JPopupMenu popupMenu) {
        int nums;
        for (Object item : this.getPopMenuActions()) {
            if (item instanceof ITreeAction && item instanceof Action) {
                if (!((ITreeAction)item).isVisible(treePaths)) continue;
                popupMenu.add((JMenuItem)new KDMenuItem((Action)item));
                continue;
            }
            if (item instanceof JSeparator) {
                nums = popupMenu.getComponentCount();
                if (nums <= 0 || popupMenu.getComponent(nums - 1) instanceof JSeparator) continue;
                popupMenu.add((JSeparator)item);
                continue;
            }
            if (!(item instanceof KDMenu)) continue;
            popupMenu.add((JMenuItem)((KDMenu)item));
        }
        nums = popupMenu.getComponentCount();
        if (nums > 0 && popupMenu.getComponent(nums - 1) instanceof JSeparator) {
            popupMenu.remove(--nums);
        }
        return nums > 0;
    }

    protected void onDoubleClick(MouseEvent evt, TreePath path) {
    }

    protected void addAcceleratorKey(Action action) {
        Object objKs = action.getValue("AcceleratorKey");
        if (objKs instanceof KeyStroke) {
            KeyStroke ks = (KeyStroke)objKs;
            InputMap inputMap = this.getTreeUI().getInputMap(1);
            ActionMap actionMap = this.getTreeUI().getActionMap();
            inputMap.put(ks, action.getValue("Name"));
            actionMap.put(action.getValue("Name"), action);
        }
    }

    protected void validatePopupMenuActionAcceleratorKey() {
        for (Object item : this.getPopMenuActions()) {
            if (!(item instanceof Action)) continue;
            this.addAcceleratorKey((Action)item);
        }
    }

    public TreeUINode newTreeNode(Object category, String name, String alias, boolean allowsChildren) {
        TreeUINode tn = new TreeUINode(name);
        tn.setAlias(alias);
        tn.setCategory(category);
        tn.setAllowsChildren(allowsChildren);
        return tn;
    }

    public final INodeFilter getNodeFitler() {
        return this.nodeFitler;
    }

    public final void setNodeFitler(INodeFilter categoryFitler) {
        this.nodeFitler = categoryFitler;
    }

    protected boolean isVisible(Object category, String text) {
        if (this.nodeFitler == null) {
            return true;
        }
        return this.nodeFitler.isVisibleCategory(category) && this.nodeFitler.isVisibleText(text);
    }

    protected boolean handleException(Exception ex) {
        return false;
    }
}

