/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.res.tool.java.stat;

import com.kingdee.bos.ctrl.res.tool.java.stat.IStatListener;
import com.kingdee.bos.ctrl.res.tool.java.stat.JavaFileBean;
import com.kingdee.bos.ctrl.res.tool.java.stat.JavaFileStatInfo;
import com.kingdee.bos.ctrl.res.tool.java.stat.JavaFileStatInfoSummary;
import com.kingdee.bos.ctrl.res.tool.java.stat.visitor.CNCodeVisitor;
import com.kingdee.bos.ctrl.res.tool.java.stat.visitor.LineLengthVisitor;
import com.kingdee.bos.ctrl.res.tool.java.stat.visitor.MethodVisitor;
import com.kingdee.bos.ctrl.res.tool.java.stat.visitor.PKClassVisitor;
import com.kingdee.bos.ctrl.res.tool.java.stat.visitor.VarVisitor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class StatFile {
    private static List excludePatternList = null;

    public static void setExcludePattern(String pattern) {
        excludePatternList = null;
        if (pattern != null) {
            String[] ps = pattern.split(",");
            excludePatternList = new ArrayList();
            for (int i = 0; i < ps.length; ++i) {
                String p = ps[i].trim();
                if (p.length() <= 0) continue;
                excludePatternList.add(p);
            }
        }
    }

    public static JavaFileStatInfo scan(String fileName) throws Exception {
        System.out.println("Scan... " + fileName);
        JavaFileBean jfb = new JavaFileBean(fileName);
        if (!jfb.withError()) {
            jfb.accept(new CNCodeVisitor());
            jfb.accept(new VarVisitor());
            jfb.accept(new MethodVisitor());
            jfb.accept(new PKClassVisitor());
            jfb.accept(new LineLengthVisitor());
        }
        jfb.finishAccept();
        return jfb.getJavaFileStatInfo();
    }

    public static int scanPath(String path, IStatListener sl) throws Exception {
        List list = StatFile.getJavaFileNameList(path);
        if (sl != null) {
            sl.scanFileCount(list.size());
        }
        JavaFileStatInfoSummary summary = new JavaFileStatInfoSummary();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            System.out.print(i + 1 + ") ");
            if (sl != null) {
                sl.scanFileIndex(i);
            }
            JavaFileStatInfo info = StatFile.scan((String)list.get(i));
            summary.stat(info);
            sl.scanFileStep(info, i);
        }
        sl.scanFinished(summary);
        return n;
    }

    private static List getJavaFileNameList(String path) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        File f = new File(FilenameUtils.normalize((String)path));
        if (f.isDirectory()) {
            File[] fs = f.listFiles();
            Arrays.sort(fs, new Comparator(){

                public int compare(Object o1, Object o2) {
                    File f1 = (File)o1;
                    File f2 = (File)o2;
                    if (f1.isFile()) {
                        if (f2.isDirectory()) {
                            return -1;
                        }
                        return f1.getName().compareTo(f2.getName());
                    }
                    if (f2.isFile()) {
                        return 1;
                    }
                    return f1.getName().compareTo(f2.getName());
                }
            });
            for (int i = 0; i < fs.length; ++i) {
                list.addAll(StatFile.getJavaFileNameList(fs[i].getAbsolutePath()));
            }
        } else if (path.endsWith(".java")) {
            boolean matched = true;
            if (excludePatternList != null) {
                int n = excludePatternList.size();
                for (int i = 0; i < n; ++i) {
                    String p = (String)excludePatternList.get(i);
                    if (!StatFile.getFileName(path).matches(p)) continue;
                    matched = false;
                    break;
                }
            }
            if (matched) {
                list.add(path);
            }
        }
        return list;
    }

    private static String getFileName(String path) {
        int i = (path = path.replace('\\', '/')).lastIndexOf(47);
        if (i >= 0) {
            return path.substring(i + 1);
        }
        return path;
    }
}

