/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.framework.connection.ui;

import com.kingdee.bos.ctrl.bizshare.ConnectException;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.data.framework.connection.DBConnection;
import com.kingdee.bos.ctrl.data.framework.connection.ui.UiResource;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPasswordField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class DBConnPanel
extends JPanel
implements ActionListener {
    private static final String[] DB_TYPES = new String[]{"sqlserver", "oracle", "db2"};
    private KDComboBox cbxServerType;
    private KDTextField txtServiceUrl = new KDTextField("192.168.19.240:1433");
    private KDTextField txtDatabase;
    private KDTextField txtUser;
    private KDPasswordField psw;
    private KDButton btnTestConn;

    public DBConnPanel() {
        this.cbxServerType = new KDComboBox();
        for (int i = 0; i < DB_TYPES.length; ++i) {
            this.cbxServerType.insertItemAt((Object)DB_TYPES[i], i);
        }
        this.cbxServerType.setSelectedItem(this.cbxServerType.getItemAt(0));
        this.txtDatabase = new KDTextField("kdrsdb");
        this.txtUser = new KDTextField("sa");
        this.psw = new KDPasswordField("");
        this.btnTestConn = new KDButton(UiResource.getString("res_2"));
        TableLayout layout = TableLayout.splitRow((int)7);
        this.setLayout((LayoutManager)layout);
        layout.defaultStyle().setMarginBottom(3);
        layout.rowStyle(6).setPriY(1);
        layout.cell(5).style().setAlignmentX((short)2);
        this.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.txtServiceUrl, (String)UiResource.getString("res_3"), (int)80), layout.cell(0));
        this.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.cbxServerType, (String)UiResource.getString("res_14"), (int)80), layout.cell(1));
        this.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.txtDatabase, (String)UiResource.getString("res_15"), (int)80), layout.cell(2));
        this.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.txtUser, (String)UiResource.getString("res_6"), (int)80), layout.cell(3));
        this.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.psw, (String)UiResource.getString("res_7"), (int)80), layout.cell(4));
        this.add((Component)this.btnTestConn, layout.cell(5));
        this.btnTestConn.addActionListener((ActionListener)this);
    }

    public void setDBConnection(DBConnection conn) {
        this.setServerType(conn.getDBType());
        this.setServiceUrl(conn.getServiceUrl());
        this.setDatabase(conn.getDBName());
        this.setUser(conn.getUser());
        this.setPassword(conn.getPassword());
    }

    public DBConnection makeDBConnection() {
        return new DBConnection(this.getServerType(), this.getServiceUrl(), this.getDatabase(), this.getUser(), this.getPassword());
    }

    public String getServerType() {
        return (String)this.cbxServerType.getSelectedItem();
    }

    public void setServerType(String serverType) {
        this.cbxServerType.setSelectedItem((Object)serverType);
    }

    public String getDatabase() {
        return this.txtDatabase.getText();
    }

    public void setDatabase(String dbName) {
        this.txtDatabase.setText(dbName);
    }

    public String getServiceUrl() {
        return this.txtServiceUrl.getText();
    }

    public void setServiceUrl(String serviceUrl) {
        this.txtServiceUrl.setText(serviceUrl);
    }

    public String getUser() {
        return this.txtUser.getText();
    }

    public void setUser(String user) {
        this.txtUser.setText(user);
    }

    public String getPassword() {
        return String.valueOf(this.psw.getPassword());
    }

    public void setPassword(String pswText) {
        this.psw.setText(pswText);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnTestConn) {
            try {
                this.testDBConn();
                WindowUtil.msgboxInfo((Object)UiResource.getString("res_9"), (String)UiResource.getString("res_10"), (Component)this);
            }
            catch (ConnectException ex) {
                WindowUtil.showException((String)UiResource.getString("res_11"), (Throwable)ex, (String)UiResource.getString("res_10"), (Component)this);
            }
        }
    }

    public void testDBConn() throws ConnectException {
        DBConnection conn = this.makeDBConnection();
        conn.open();
        conn.close();
    }
}

