/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.framework.datasource.ui;

import com.kingdee.bos.ctrl.common.ui.select.AObjectSelector;
import com.kingdee.bos.ctrl.data.framework.datasource.IDataSource;
import com.kingdee.bos.ctrl.data.framework.datasource.IDataSourceFactory;
import com.kingdee.bos.ctrl.swing.KDList;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DataSourceSelectList
extends AObjectSelector {
    private IDataSourceFactory dsFactory;
    private KDList listView;

    public DataSourceSelectList(IDataSourceFactory dsFactory) {
        this.dsFactory = dsFactory;
        this.listView = new KDList();
        IDataSource[] dss = this.dsFactory.getDataSources();
        for (int i = 0; i < dss.length; ++i) {
            this.listView.addElement((Object)dss[i]);
            this.listView.setSelectedIndex(0);
        }
        ListEventHandler leh = new ListEventHandler();
        this.listView.addMouseListener((MouseListener)leh);
        this.listView.addListSelectionListener((ListSelectionListener)leh);
    }

    public JComponent getUI() {
        return this.listView;
    }

    public String getSelectedInfo() {
        return ((IDataSource)this.listView.getSelectedValue()).getName();
    }

    public void setSelectedInfo(String infoText) {
        if (infoText == null) {
            return;
        }
        IDataSource ds = this.dsFactory.getDataSource(infoText);
        if (this.listView != null) {
            if (ds != null) {
                this.listView.setSelectedValue((Object)ds, true);
            } else {
                this.listView.setSelectedIndex(-1);
            }
        }
    }

    public Object getObject(String infoText) {
        if (infoText == null) {
            return null;
        }
        return this.dsFactory.getDataSource(infoText);
    }

    private class ListEventHandler
    extends MouseAdapter
    implements ListSelectionListener {
        private ListEventHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2) {
                DataSourceSelectList.this.fireSelectConfirm();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            DataSourceSelectList.this.fireSelectChanged();
        }
    }
}

