/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.wizard.process.crosstab;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.ListView;
import com.kingdee.bos.ctrl.data.modal.types.TypesUtil;
import com.kingdee.bos.ctrl.data.modal.types.crosstab.AxisDef;
import com.kingdee.bos.ctrl.data.modal.types.grouping.Total;
import com.kingdee.bos.ctrl.data.modal.types.rows.OutputColumn;
import com.kingdee.bos.ctrl.data.modal.types.rows.OutputColumns;
import com.kingdee.bos.ctrl.data.process.dataset.group.aggregate.Aggregates;
import com.kingdee.bos.ctrl.data.wizard.process.Process2Resource;
import com.kingdee.bos.ctrl.data.wizard.process.WizardHelper;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CrosstabColumnsPanel
extends KDPanel {
    private ListView lvCols;
    private KDComboBox cbFields;
    private KDList list;
    private ArrayList values;
    private boolean axisMode;
    private KDCheckBox cbPutCrossFieldToX;

    public CrosstabColumnsPanel(boolean axisMode) {
        this.axisMode = axisMode;
        this.values = new ArrayList();
        this.initComponents();
        this.initActionListeners();
    }

    public void setCrossColumns(List crossCols, OutputColumns supplyOCs) {
        for (int i = 0; i < crossCols.size(); ++i) {
            Total cc = (Total)crossCols.get(i);
            OutputColumn oc = supplyOCs.findColumn(cc.getColumn());
            this.getList().addElement((Object)oc);
            this.values.add(cc.getFunction());
        }
        if (crossCols != null && crossCols.size() > 0) {
            this.getList().setSelectedIndex(0);
        }
    }

    public void setAxisDef(AxisDef axisDef) {
        OutputColumns groupCols = axisDef.getGroupCols();
        for (int i = 0; i < groupCols.size(); ++i) {
            OutputColumn oc = (OutputColumn)groupCols.get(i);
            this.getList().addElement((Object)oc);
            this.values.add(TypesUtil.orderAscToString((int)oc.getOrderAsc()));
        }
        if (groupCols != null && groupCols.size() > 0) {
            this.getList().setSelectedIndex(0);
        }
    }

    public void setTitle(String title) {
        this.lvCols.setTitle(title);
    }

    private void initComponents() {
        this.lvCols = new ListView();
        this.list = this.lvCols.getList();
        this.cbFields = new KDComboBox();
        this.initFields();
        this.cbFields.setSelectedIndex(-1);
        this.cbFields.setEnabled(false);
        if (!this.axisMode) {
            this.cbPutCrossFieldToX = new KDCheckBox();
            this.cbPutCrossFieldToX.setText("\u5c06\u4ea4\u53c9\u5b57\u6bb5\u653e\u5728X\u8f74\u4e0a");
            this.cbPutCrossFieldToX.setSelected(true);
        }
        TableLayout layout = TableLayout.split((int)(this.axisMode ? 3 : 4), (int)1);
        this.setLayout((LayoutManager)layout);
        this.add((Component)this.lvCols, layout.cell(0, 0));
        this.add((Component)new KDLabel(this.axisMode ? Process2Resource.getString("res_17") : Process2Resource.getString("res_18")), layout.cell(1, 0));
        this.add((Component)this.cbFields, layout.cell(2, 0));
        if (!this.axisMode) {
            this.add((Component)this.cbPutCrossFieldToX, layout.cell(3, 0));
            layout.rowStyle(3).setMarginLeft(-4);
        }
        layout.rowStyle(0).setPriY(1);
        layout.rowStyle(1).setHeight(20);
        layout.rowStyle(2).setHeight(20);
    }

    public boolean isPutCrossFieldToX() {
        return this.cbPutCrossFieldToX.isSelected();
    }

    public void setPutCrossFieldX(boolean toX) {
        this.cbPutCrossFieldToX.setSelected(toX);
    }

    private void initActionListeners() {
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int sel = CrosstabColumnsPanel.this.list.getSelectedIndex();
                CrosstabColumnsPanel.this.cbFields.setEnabled(sel >= 0);
                if (sel >= 0) {
                    CrosstabColumnsPanel.this.cbFields.setSelectedItem(CrosstabColumnsPanel.this.values.get(sel));
                } else {
                    CrosstabColumnsPanel.this.cbFields.setSelectedIndex(-1);
                }
            }
        });
        this.cbFields.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getID() == 701 && e.getStateChange() == 1) {
                    CrosstabColumnsPanel.this.values.set(CrosstabColumnsPanel.this.list.getSelectedIndex(), CrosstabColumnsPanel.this.cbFields.getSelectedItem());
                }
            }
        });
    }

    private void initFields() {
        if (this.axisMode) {
            this.cbFields.addItem((Object)TypesUtil.orderAscToString((int)0));
            this.cbFields.addItem((Object)TypesUtil.orderAscToString((int)1));
        } else {
            this.cbFields.addItems((Object[])Aggregates.aggregates());
        }
    }

    private String getDefaultValue(OutputColumn c) {
        if (this.axisMode) {
            return TypesUtil.orderAscToString((int)0);
        }
        return Aggregates.getDefaultTotalMethod((DataType)c.getDataType());
    }

    public void addColumn(OutputColumn column) {
        if (WizardHelper.findObject(this.list, column) != -1) {
            return;
        }
        this.values.add(this.getDefaultValue(column));
        this.list.addElement((Object)column);
        this.list.setSelectedIndex(this.list.getElementCount() - 1);
        this.cbFields.setEnabled(true);
    }

    public void removeCurrentColumn() {
        int sel = this.list.getSelectedIndex();
        this.values.remove(sel);
        this.list.removeElementAt(sel);
        this.list.setSelectedIndex(sel == (this.list.getElementCount() == 0 ? -1 : 0) ? 0 : sel - 1);
        this.cbFields.setEnabled(this.list.getElementCount() > 0);
    }

    public void removeAllColumns() {
        this.list.removeAllElements();
        this.cbFields.setSelectedIndex(-1);
        this.values.clear();
        this.cbFields.setEnabled(this.list.getElementCount() > 0);
    }

    public List getSelectedAsCrossCols() {
        List columns = this.getSelectedAsCols();
        ArrayList<Total> crossCols = new ArrayList<Total>();
        for (int i = 0; i < columns.size(); ++i) {
            OutputColumn oc = (OutputColumn)columns.get(i);
            Total total = new Total();
            total.setColumn(oc.getName());
            total.setColumnType(oc.getDataType());
            total.setFunction(String.valueOf(this.values.get(i)));
            crossCols.add(total);
        }
        return crossCols;
    }

    public List getSelectedAsCols() {
        ArrayList<OutputColumn> al = new ArrayList<OutputColumn>();
        int size = this.list.getElementCount();
        for (int i = 0; i < size; ++i) {
            OutputColumn oc = (OutputColumn)this.list.getElement(i);
            if (this.axisMode) {
                oc.setOrderPri(i);
                oc.setOrderAsc(TypesUtil.parseOrderAscString((String)((String)this.values.get(i))));
            }
            al.add(oc);
        }
        return al;
    }

    public List getValues() {
        return this.values;
    }

    public final KDList getList() {
        return this.list;
    }
}

