/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.DERGeneralizedTime;
import com.kingdee.bos.ctrl.cipher.asn1.DERObject;
import com.kingdee.bos.ctrl.cipher.asn1.DEROctetString;
import com.kingdee.bos.ctrl.cipher.asn1.cms.RecipientKeyIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.smime.SMIMECapabilitiesAttribute;
import com.kingdee.bos.ctrl.cipher.asn1.smime.SMIMECapability;
import com.kingdee.bos.ctrl.cipher.asn1.smime.SMIMECapabilityVector;
import com.kingdee.bos.ctrl.cipher.asn1.smime.SMIMEEncryptionKeyPreferenceAttribute;
import com.kingdee.bos.ctrl.cipher.util.encoders.Base64;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTestResult;
import com.kingdee.bos.ctrl.cipher.util.test.Test;
import com.kingdee.bos.ctrl.cipher.util.test.TestResult;
import java.io.ByteArrayInputStream;

public class SMIMETest
implements Test {
    byte[] attrBytes = Base64.decode("MDQGCSqGSIb3DQEJDzEnMCUwCgYIKoZIhvcNAwcwDgYIKoZIhvcNAwICAgCAMAcGBSsOAwIH");
    byte[] prefBytes = Base64.decode("MCwGCyqGSIb3DQEJEAILMR2hGwQIAAAAAAAAAAAYDzIwMDcwMzE1MTczNzI5Wg==");

    private boolean isSameAs(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i != a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public TestResult perform() {
        SMIMECapabilityVector caps = new SMIMECapabilityVector();
        caps.addCapability(SMIMECapability.dES_EDE3_CBC);
        caps.addCapability(SMIMECapability.rC2_CBC, 128);
        caps.addCapability(SMIMECapability.dES_CBC);
        SMIMECapabilitiesAttribute attr = new SMIMECapabilitiesAttribute(caps);
        SMIMEEncryptionKeyPreferenceAttribute pref = new SMIMEEncryptionKeyPreferenceAttribute(new RecipientKeyIdentifier(new DEROctetString(new byte[8]), new DERGeneralizedTime("20070315173729Z"), null));
        try {
            if (!this.isSameAs(attr.getEncoded(), this.attrBytes)) {
                return new SimpleTestResult(false, this.getName() + ": Failed attr data check");
            }
            ByteArrayInputStream bIn = new ByteArrayInputStream(this.attrBytes);
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            DERObject o = aIn.readObject();
            if (!attr.equals(o)) {
                return new SimpleTestResult(false, this.getName() + ": Failed equality test for attr");
            }
            if (!this.isSameAs(pref.getEncoded(), this.prefBytes)) {
                return new SimpleTestResult(false, this.getName() + ": Failed attr data check");
            }
            bIn = new ByteArrayInputStream(this.prefBytes);
            aIn = new ASN1InputStream(bIn);
            o = aIn.readObject();
            if (!pref.equals(o)) {
                return new SimpleTestResult(false, this.getName() + ": Failed equality test for pref");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": Failed - exception " + e.toString(), e);
        }
    }

    @Override
    public String getName() {
        return "SMIME";
    }

    public static void main(String[] args) {
        SMIMETest test = new SMIMETest();
        TestResult result = test.perform();
        System.out.println(result);
    }
}

