/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1Object;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1TaggedObject;
import com.kingdee.bos.ctrl.cipher.asn1.DERApplicationSpecific;
import com.kingdee.bos.ctrl.cipher.util.encoders.Base64;
import com.kingdee.bos.ctrl.cipher.util.encoders.Hex;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;
import java.io.IOException;
import java.security.SecureRandom;

public class TagTest
extends SimpleTest {
    byte[] longTagged = Base64.decode("ZSRzIp8gEEZFRENCQTk4NzY1NDMyMTCfIQwyMDA2MDQwMTEyMzSUCCAFERVzA4kCAHEXGBkalAggBRcYGRqUCCAFZS6QAkRFkQlURUNITklLRVKSBQECAwQFkxAREhMUFRYXGBkalAggBREVcwOJAgBxFxgZGpQIIAUXGBkalAggBWUukAJERZEJVEVDSE5JS0VSkgUBAgMEBZMQERITFBUWFxgZGpQIIAURFXMDiQIAcRcYGRqUCCAFFxgZGpQIIAVlLpACREWRCVRFQ0hOSUtFUpIFAQIDBAWTEBESExQVFhcYGRqUCCAFERVzA4kCAHEXGBkalAggBRcYGRqUCCAFFxgZGpQIIAUXGBkalAg=");
    byte[] longAppSpecificTag = Hex.decode("5F610101");

    @Override
    public String getName() {
        return "Tag";
    }

    @Override
    public void performTest() throws IOException {
        ASN1InputStream aIn = new ASN1InputStream(this.longTagged);
        DERApplicationSpecific app = (DERApplicationSpecific)aIn.readObject();
        aIn = new ASN1InputStream(app.getContents());
        app = (DERApplicationSpecific)aIn.readObject();
        ASN1TaggedObject tagged = (ASN1TaggedObject)(aIn = new ASN1InputStream(app.getContents())).readObject();
        if (tagged.getTagNo() != 32) {
            this.fail("unexpected tag value found - not 32");
        }
        if ((tagged = (ASN1TaggedObject)ASN1Object.fromByteArray(tagged.getEncoded())).getTagNo() != 32) {
            this.fail("unexpected tag value found on recode - not 32");
        }
        if ((tagged = (ASN1TaggedObject)aIn.readObject()).getTagNo() != 33) {
            this.fail("unexpected tag value found - not 33");
        }
        if ((tagged = (ASN1TaggedObject)ASN1Object.fromByteArray(tagged.getEncoded())).getTagNo() != 33) {
            this.fail("unexpected tag value found on recode - not 33");
        }
        if ((app = (DERApplicationSpecific)(aIn = new ASN1InputStream(this.longAppSpecificTag)).readObject()).getApplicationTag() != 97) {
            this.fail("incorrect tag number read");
        }
        if ((app = (DERApplicationSpecific)ASN1Object.fromByteArray(app.getEncoded())).getApplicationTag() != 97) {
            this.fail("incorrect tag number read on recode");
        }
        SecureRandom sr = new SecureRandom();
        for (int i = 0; i < 100; ++i) {
            int testTag = sr.nextInt() >>> 1 + (sr.nextInt() >>> 1) % 26;
            app = new DERApplicationSpecific(testTag, new byte[]{1});
            if ((app = (DERApplicationSpecific)ASN1Object.fromByteArray(app.getEncoded())).getApplicationTag() == testTag) continue;
            this.fail("incorrect tag number read on recode (random test value: " + testTag + ")");
        }
    }

    public static void main(String[] args) {
        TagTest.runTest(new TagTest());
    }
}

