/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.generators;

import com.kingdee.bos.ctrl.cipher.crypto.AsymmetricCipherKeyPair;
import com.kingdee.bos.ctrl.cipher.crypto.AsymmetricCipherKeyPairGenerator;
import com.kingdee.bos.ctrl.cipher.crypto.KeyGenerationParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.DSAKeyGenerationParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.DSAParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.DSAPrivateKeyParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.DSAPublicKeyParameters;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private DSAKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (DSAKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger x;
        DSAParameters dsaParams = this.param.getParameters();
        SecureRandom random = this.param.getRandom();
        BigInteger q = dsaParams.getQ();
        BigInteger p = dsaParams.getP();
        BigInteger g = dsaParams.getG();
        while ((x = new BigInteger(160, random)).equals(ZERO) || x.compareTo(q) >= 0) {
        }
        BigInteger y = g.modPow(x, p);
        return new AsymmetricCipherKeyPair(new DSAPublicKeyParameters(y, dsaParams), new DSAPrivateKeyParameters(x, dsaParams));
    }
}

