/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.test;

import com.kingdee.bos.ctrl.cipher.crypto.CipherParameters;
import com.kingdee.bos.ctrl.cipher.crypto.engines.Salsa20Engine;
import com.kingdee.bos.ctrl.cipher.crypto.params.KeyParameter;
import com.kingdee.bos.ctrl.cipher.crypto.params.ParametersWithIV;
import com.kingdee.bos.ctrl.cipher.util.encoders.Hex;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;

public class Salsa20Test
extends SimpleTest {
    byte[] zeroes = Hex.decode("00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000");
    String set1v0_0 = "4DFA5E481DA23EA09A31022050859936DA52FCEE218005164F267CB65F5CFD7F2B4F97E0FF16924A52DF269515110A07F9E460BC65EF95DA58F740B7D1DBB0AA";
    String set1v0_192 = "DA9C1581F429E0A00F7D67E23B730676783B262E8EB43A25F55FB90B3E753AEF8C6713EC66C51881111593CCB3E8CB8F8DE124080501EEEB389C4BCB6977CF95";
    String set1v0_256 = "7D5789631EB4554400E1E025935DFA7B3E9039D61BDC58A8697D36815BF1985CEFDF7AE112E5BB81E37ECF0616CE7147FC08A93A367E08631F23C03B00A8DA2F";
    String set1v0_448 = "B375703739DACED4DD4059FD71C3C47FC2F9939670FAD4A46066ADCC6A5645783308B90FFB72BE04A6B147CBE38CC0C3B9267C296A92A7C69873F9F263BE9703";
    String set1v9_0 = "0471076057830FB99202291177FBFE5D38C888944DF8917CAB82788B91B53D1CFB06D07A304B18BB763F888A61BB6B755CD58BEC9C4CFB7569CB91862E79C459";
    String set1v9_192 = "D1D7E97556426E6CFC21312AE38114259E5A6FB10DACBD88E4354B04725569352B6DA5ACAFACD5E266F9575C2ED8E6F2EFE4B4D36114C3A623DD49F4794F865B";
    String set1v9_256 = "AF06FAA82C73291231E1BD916A773DE152FD2126C40A10C3A6EB40F22834B8CC68BD5C6DBD7FC1EC8F34165C517C0B639DB0C60506D3606906B8463AA0D0EC2F";
    String set1v9_448 = "AB3216F1216379EFD5EC589510B8FD35014D0AA0B613040BAE63ECAB90A9AF79661F8DA2F853A5204B0F8E72E9D9EB4DBA5A4690E73A4D25F61EE7295215140C";
    String set6v0_0 = "F5FAD53F79F9DF58C4AEA0D0ED9A9601F278112CA7180D565B420A48019670EAF24CE493A86263F677B46ACE1924773D2BB25571E1AA8593758FC382B1280B71";
    String set6v0_65472 = "B70C50139C63332EF6E77AC54338A4079B82BEC9F9A403DFEA821B83F7860791650EF1B2489D0590B1DE772EEDA4E3BCD60FA7CE9CD623D9D2FD5758B8653E70";
    String set6v0_65536 = "81582C65D7562B80AEC2F1A673A9D01C9F892A23D4919F6AB47B9154E08E699B4117D7C666477B60F8391481682F5D95D96623DBC489D88DAA6956B9F0646B6E";
    String set6v1_0 = "3944F6DC9F85B128083879FDF190F7DEE4053A07BC09896D51D0690BD4DA4AC1062F1E47D3D0716F80A9B4D85E6D6085EE06947601C85F1A27A2F76E45A6AA87";
    String set6v1_65472 = "36E03B4B54B0B2E04D069E690082C8C592DF56E633F5D8C7682A02A65ECD13718CA4352AACCB0DA20ED6BBBA62E177F210E3560E63BB822C4158CAA806A88C82";
    String set6v1_65536 = "1B779E7A917C8C26039FFB23CF0EF8E08A1A13B43ACDD9402CF5DF38501098DFC945A6CC69A6A17367BC03431A86B3ED04B0245B56379BF997E25800AD837D7D";

    @Override
    public String getName() {
        return "Salsa20";
    }

    @Override
    public void performTest() {
        this.salsa20Test1(new ParametersWithIV(new KeyParameter(Hex.decode("80000000000000000000000000000000")), Hex.decode("0000000000000000")), this.set1v0_0, this.set1v0_192, this.set1v0_256, this.set1v0_448);
        this.salsa20Test1(new ParametersWithIV(new KeyParameter(Hex.decode("00400000000000000000000000000000")), Hex.decode("0000000000000000")), this.set1v9_0, this.set1v9_192, this.set1v9_256, this.set1v9_448);
        this.salsa20Test2(new ParametersWithIV(new KeyParameter(Hex.decode("0053A6F94C9FF24598EB3E91E4378ADD3083D6297CCF2275C81B6EC11467BA0D")), Hex.decode("0D74DB42A91077DE")), this.set6v0_0, this.set6v0_65472, this.set6v0_65536);
        this.salsa20Test2(new ParametersWithIV(new KeyParameter(Hex.decode("0558ABFE51A4F74A9DF04396E93C8FE23588DB2E81D4277ACD2073C6196CBF12")), Hex.decode("167DE44BB21980E7")), this.set6v1_0, this.set6v1_65472, this.set6v1_65536);
        this.reinitBug();
    }

    private void salsa20Test1(CipherParameters params, String v0, String v192, String v256, String v448) {
        int i;
        Salsa20Engine salsa = new Salsa20Engine();
        byte[] buf = new byte[64];
        salsa.init(true, params);
        block5: for (i = 0; i != 7; ++i) {
            salsa.processBytes(this.zeroes, 0, 64, buf, 0);
            switch (i) {
                case 0: {
                    if (this.areEqual(buf, Hex.decode(v0))) continue block5;
                    this.mismatch("v0", v0, buf);
                    continue block5;
                }
                case 3: {
                    if (this.areEqual(buf, Hex.decode(v192))) continue block5;
                    this.mismatch("v192", v192, buf);
                    continue block5;
                }
                case 4: {
                    if (this.areEqual(buf, Hex.decode(v256))) continue block5;
                    this.mismatch("v256", v256, buf);
                    continue block5;
                }
            }
        }
        for (i = 0; i != 64; ++i) {
            buf[i] = salsa.returnByte(this.zeroes[i]);
        }
        if (!this.areEqual(buf, Hex.decode(v448))) {
            this.mismatch("v448", v448, buf);
        }
    }

    private void salsa20Test2(CipherParameters params, String v0, String v65472, String v65536) {
        Salsa20Engine salsa = new Salsa20Engine();
        byte[] buf = new byte[64];
        salsa.init(true, params);
        block5: for (int i = 0; i != 1025; ++i) {
            salsa.processBytes(this.zeroes, 0, 64, buf, 0);
            switch (i) {
                case 0: {
                    if (this.areEqual(buf, Hex.decode(v0))) continue block5;
                    this.mismatch("v0", v0, buf);
                    continue block5;
                }
                case 1023: {
                    if (this.areEqual(buf, Hex.decode(v65472))) continue block5;
                    this.mismatch("v65472", v65472, buf);
                    continue block5;
                }
                case 1024: {
                    if (this.areEqual(buf, Hex.decode(v65536))) continue block5;
                    this.mismatch("v65536", v65536, buf);
                    continue block5;
                }
            }
        }
    }

    private void mismatch(String name, String expected, byte[] found) {
        this.fail("mismatch on " + name, expected, new String(Hex.encode(found)));
    }

    private void reinitBug() {
        KeyParameter key = new KeyParameter(Hex.decode("80000000000000000000000000000000"));
        ParametersWithIV parameters = new ParametersWithIV(key, Hex.decode("0000000000000000"));
        Salsa20Engine salsa = new Salsa20Engine();
        salsa.init(true, parameters);
        try {
            salsa.init(true, key);
            this.fail("Salsa20 should throw exception if no IV in Init");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        Salsa20Test.runTest(new Salsa20Test());
    }
}

