/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.tls.test;

import com.kingdee.bos.ctrl.cipher.crypto.tls.test.KeyStores;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;

public class HTTPSServerThread
extends Thread {
    private static final int PORT_NO = 8003;
    private static final char[] SERVER_PASSWORD = "serverPassword".toCharArray();
    private static final char[] TRUST_STORE_PASSWORD = "trustPassword".toCharArray();

    private void readRequest(InputStream in) throws IOException {
        int ch = 0;
        int lastCh = 0;
        while ((ch = in.read()) >= 0 && ch != 10 && lastCh != 10) {
            if (ch == 13) continue;
            lastCh = ch;
        }
    }

    private void sendResponse(OutputStream out) {
        PrintWriter pWrt = new PrintWriter(new OutputStreamWriter(out));
        pWrt.print("HTTP/1.1 200 OK\r\n");
        pWrt.print("Content-Type: text/html\r\n");
        pWrt.print("\r\n");
        pWrt.print("<html>\r\n");
        pWrt.print("<body>\r\n");
        pWrt.print("Hello World!\r\n");
        pWrt.print("</body>\r\n");
        pWrt.print("</html>\r\n");
        pWrt.flush();
    }

    SSLContext createSSLContext() throws Exception {
        KeyManagerFactory mgrFact = KeyManagerFactory.getInstance("SunX509");
        KeyStore serverStore = KeyStore.getInstance("JKS");
        serverStore.load(new ByteArrayInputStream(KeyStores.server), SERVER_PASSWORD);
        mgrFact.init(serverStore, SERVER_PASSWORD);
        TrustManagerFactory trustFact = TrustManagerFactory.getInstance("SunX509");
        KeyStore trustStore = KeyStore.getInstance("JKS");
        trustStore.load(new ByteArrayInputStream(KeyStores.trustStore), TRUST_STORE_PASSWORD);
        trustFact.init(trustStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(mgrFact.getKeyManagers(), trustFact.getTrustManagers(), null);
        return sslContext;
    }

    @Override
    public void run() {
        Socket sslSock = null;
        SSLServerSocket sSock = null;
        try {
            SSLContext sslContext = this.createSSLContext();
            SSLServerSocketFactory fact = sslContext.getServerSocketFactory();
            sSock = (SSLServerSocket)fact.createServerSocket(8003);
            sslSock = (SSLSocket)sSock.accept();
            ((SSLSocket)sslSock).startHandshake();
            this.readRequest(sslSock.getInputStream());
            this.sendResponse(sslSock.getOutputStream());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (null != sslSock && !sslSock.isClosed()) {
                    sslSock.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (null != sSock && !sSock.isClosed()) {
                    sSock.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

