/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.fulfil.mobile.card;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.BasicExtCallback;
import com.kingdee.bos.ctrl.ext.ExtActionManager;
import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.fulfil.mobile.CustomContext;
import com.kingdee.bos.ctrl.ext.fulfil.mobile.ExtMobileExecutor;
import com.kingdee.bos.ctrl.ext.fulfil.mobile.card.CardPreviewItemAction;
import com.kingdee.bos.ctrl.ext.fulfil.mobile.device.AbstractDevice;
import com.kingdee.bos.ctrl.ext.fulfil.mobile.device.DeviceFactory;
import com.kingdee.bos.ctrl.ext.fulfil.mobile.jetty.JettyServer;
import com.kingdee.bos.ctrl.ext.fulfil.mobile.jetty.event.JettyServerStateChangedEvent;
import com.kingdee.bos.ctrl.ext.fulfil.mobile.jetty.event.JettyServerStateChangedListener;
import com.kingdee.bos.ctrl.ext.fulfil.mobile.simui.Simulator;
import com.kingdee.bos.ctrl.ext.immit.IExtCallback;
import com.kingdee.bos.ctrl.ext.rd.RptPerspective;
import com.kingdee.bos.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.io.BookIOUtil;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.embed.browser.jfx.KDWebViewPanel;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.workbench.ui.Perspective;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CardPreviewAction
extends AbstractAction {
    private static Logger logger = CommonLogger.getLogger(CardPreviewAction.class);
    public static final String CUSTOM_CONTEXT = "CustomContext";
    private Component simOwner;
    private KDExt _ext;
    private JettyServer jtServer;
    private static ServerStateChangedListener serverStateChangedListener;
    private long startTime;
    private boolean firstStart = true;
    private static AbstractDevice lastDevice;
    protected AbstractDevice device;
    private KDWorkButton preivewBtn;
    protected byte[] bookData;
    protected IExtCallback callback;
    protected boolean isLimit = false;
    private String reportId;
    private String reportName;
    private KDPanel loadPanel;
    private KDDialog dlg;
    private Simulator sim;

    public CardPreviewAction(Component simOwner, AbstractDevice device, KDWorkButton preivewBtn) {
        this.simOwner = simOwner;
        if (simOwner instanceof KDExt) {
            this._ext = (KDExt)((Object)simOwner);
        }
        this.device = device;
        this.preivewBtn = preivewBtn;
        this.putValue("Name", ExtActionManager.getLocalText("cardPreview", "\u9884\u89c8"));
        this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_preview2.gif"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.callback != null && !this.callback.checkCloudRptEnable()) {
            return;
        }
        this.jtServer = JettyServer.getInstance();
        if (serverStateChangedListener == null) {
            this.jtServer.addStateChangedListener(this.getListnenr());
        }
        this.firstStart = true;
        CardPreviewAction cardPreviewAction = this;
        if (!cardPreviewAction.jtServer.isStarted() && !this.jtServer.isStarting()) {
            this.preivewBtn.setEnabled(false);
            this.startTime = System.currentTimeMillis();
            CardPreviewAction.clearWebkitCache();
            this.showSimulator(null);
            this.jtServer.start();
        } else {
            this.popUpPreviewer();
        }
    }

    public static void clearWebkitCache() {
        boolean delResult;
        String tempPath = System.getProperty("java.io.tmpdir");
        File tempDir = new File(tempPath);
        String webkitCachePath = tempDir.getParent() + File.separator + "Apple Computer" + File.separator + "Cache.db";
        File webkitCacheFile = new File(webkitCachePath);
        if (webkitCacheFile.exists() && !(delResult = webkitCacheFile.delete())) {
            logger.info((Object)("clear Cache.db failed! cache file : " + webkitCacheFile), null);
        }
    }

    private void popUpPreviewer() {
        this.preivewBtn.setEnabled(true);
        Book book = null;
        if (this._ext != null) {
            SpreadContext context = MiscUtil.getActiveSpreadContext(this._ext);
            context.getStateManager().stopEditing();
            Perspective perspective = this._ext.getPerspective("Report Designer", false);
            if (perspective != null) {
                ((RptPerspective)perspective).getBeanBindManager().commitPropertySheetPanels();
            }
            book = context.getBook();
            Object obj = this._ext.getExtCallback().clone();
            this.callback = obj instanceof BasicExtCallback ? (BasicExtCallback)obj : this._ext.getExtCallback();
            try {
                this.bookData = BookIOUtil.pack(book);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        ExtMobileExecutor executor = new ExtMobileExecutor(this.bookData, this.callback, this.isLimit);
        if (this instanceof CardPreviewItemAction) {
            lastDevice = this.device;
        } else if (lastDevice != null) {
            this.device = lastDevice;
        }
        this.setReportName(this.reportName);
        String cacheId = StringUtil.isEmptyString((String)this.reportId) ? UUID.randomUUID().toString() : this.reportId;
        StringBuffer url = new StringBuffer();
        url.append("http://").append("127.0.0.1").append(":").append(this.jtServer.getServerPort()).append("/extweb/ext30/mobile/cardPreview.html?").append("reportId").append("=").append(cacheId).append("&reportName=").append(this.reportName).append("&cardWidth=").append(this.device.getSimScreenWidth()).append("&cardHeight=").append(this.device.getSimScreenHeight()).append("&limited=").append(this.isLimit).append("&t=").append(System.currentTimeMillis());
        book = executor.getBook();
        CustomContext cusCtx = new CustomContext();
        cusCtx.setExecutor(executor);
        book.setUserObject(CUSTOM_CONTEXT, cusCtx);
        this.jtServer.putClientCache(cacheId, book);
        this.showSimulator(url.toString());
    }

    private void showSimulator(String url) {
        if (this.firstStart) {
            this.showFrame();
        }
        if (!StringUtil.isEmptyString((String)url)) {
            KDWebViewPanel browser = new KDWebViewPanel(url);
            this.sim.setWebview(browser.getMainComponent(), this.reportName);
            browser.reload();
            this.dlg.setUserObject((Object)browser);
            browser.execute("var alert1 = window.alert;window.alert=function(obj){window.isAlertShowing = true;alert1(obj);window.isAlertShowing = false;}");
            logger.info((Object)("simulator request url:" + url));
        }
    }

    private void showFrame() {
        if (this.device == null) {
            this.device = DeviceFactory.createAll()[0];
        }
        KDLabel labelText = new KDLabel("\u6b63\u5728\u542f\u52a8\u670d\u52a1...");
        ImageIcon icon = ResourceManager.getImageIcon("loader.gif");
        KDLabel labelImage = new KDLabel();
        labelImage.setIcon((Icon)icon);
        this.loadPanel = new KDPanel();
        this.loadPanel.setLayout(null);
        int labelImageX = (this.device.getSimScreenWidth() - icon.getIconWidth()) / 2;
        int labelImageY = (this.device.getSimScreenHeight() - icon.getIconHeight()) / 2 - 40;
        labelImage.setBounds(labelImageX, labelImageY, icon.getIconWidth(), icon.getIconHeight());
        labelText.setBounds(labelImageX - 15, labelImageY + icon.getIconHeight(), 128, 20);
        this.loadPanel.add((Component)labelImage);
        this.loadPanel.add((Component)labelText);
        this.loadPanel.setBackground(Color.WHITE);
        this.sim = new Simulator();
        this.sim.setDevice(this.device);
        this.sim.setWebview((JComponent)this.loadPanel, this.reportName);
        this.dlg = (KDDialog)this.sim.createDialog(this.simOwner);
        this.dlg.setVisible(true);
        this.dlg.getContentPane().requestFocusInWindow();
    }

    public void setCallback(IExtCallback callback) {
        this.callback = callback;
    }

    public void setBookData(byte[] bookData) {
        this.bookData = bookData;
    }

    public void setLimit(boolean isLimit) {
        this.isLimit = isLimit;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public void setReportName(String reportName) {
        this.reportName = StringUtil.isEmptyString((String)reportName) ? "\u9884\u89c8" : reportName;
    }

    public void setPropertites(byte[] bookData, IExtCallback callbackImpl, boolean isLimitRecord, String reportId, String reportName) {
        this.setBookData(bookData);
        this.setCallback(callbackImpl);
        this.setLimit(isLimitRecord);
        this.setReportId(reportId);
        this.setReportName(reportName);
    }

    private ServerStateChangedListener getListnenr() {
        if (serverStateChangedListener == null) {
            serverStateChangedListener = new ServerStateChangedListener();
        }
        return serverStateChangedListener;
    }

    class ServerStateChangedListener
    implements JettyServerStateChangedListener {
        ServerStateChangedListener() {
        }

        @Override
        public void stateChange(final JettyServerStateChangedEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    switch (e.getStateType()) {
                        case 2: {
                            logger.info((Object)("start jetty cost time\uff1a" + (System.currentTimeMillis() - CardPreviewAction.this.startTime)));
                            CardPreviewAction.this.firstStart = false;
                            CardPreviewAction.this.popUpPreviewer();
                            break;
                        }
                        case -1: {
                            logger.info((Object)"jetty server is failed!!!!!!");
                            CardPreviewAction.this.preivewBtn.setEnabled(true);
                            break;
                        }
                        case 0: {
                            logger.info((Object)"jetty server is stopped!!!!!!");
                            CardPreviewAction.this.preivewBtn.setEnabled(true);
                            serverStateChangedListener = null;
                            CardPreviewAction.this.jtServer.removeAllListener();
                            break;
                        }
                        case 1: {
                            logger.info((Object)"jetty server is starting!!!!!!");
                            break;
                        }
                        case 3: {
                            logger.info((Object)"jetty server is stopping!!!!!!");
                        }
                    }
                }
            });
        }
    }
}

