/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.rd.celltree;

import com.kingdee.bos.ctrl.ext.rd.celltree.CellTreeNode;
import com.kingdee.bos.ctrl.ext.rd.celltree.TreeCellUtil;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;

public class TreeCellRowRender
implements IBasicRender {
    public static final int CellWidth = 14;
    private Color baseColor = new Color(61, 78, 124);

    public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
        Rectangle r = (Rectangle)clip;
        r = new Rectangle(r.x, r.y - 1, r.width, r.height + 1);
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setColor(this.baseColor);
        Shape oldClip = g2d.getClip();
        if (object instanceof Cell) {
            Rectangle cellRectWidthGridLine;
            Cell cell = (Cell)object;
            if (!TreeCellUtil.isColumnCellTreeDisplay(cell)) {
                return;
            }
            if (TreeCellUtil.isCellRowAndColumenTreeDisplay(cell)) {
                return;
            }
            Rectangle cw = cellRectWidthGridLine = SheetBaseMath.getCellRect(cell.getSheet(), cell.getRow(), cell.getCol(), true);
            CellTreeNode node = TreeCellUtil.queryCellInfo(cell, "CellLevelAndType");
            if (node == null) {
                return;
            }
            g2d.setClip(r);
            if (node != null) {
                if (cell.getSheet().isAboveOfOutlineGroup()) {
                    this.drawAbove(g2d, cell, r);
                } else {
                    this.drawBelow(g2d, node, r, cw, cell);
                }
            }
        }
        g2d.setClip(oldClip);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void drawBelow(Graphics2D g2d, CellTreeNode node, Rectangle r, Rectangle cw, Cell cell) {
        int nextRowHeight = -1;
        nextRowHeight = SheetBaseMath.getRowHeight(cell.getSheet(), cell.getRow() - 1);
        BasicStroke stroke = new BasicStroke(1.0f);
        BasicStroke dashStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f}, 0.0f);
        g2d.setStroke(stroke);
        int basePos = r.x + 11 * node.getLevel();
        int prevRowLevel = 0;
        int rowId = cell.getRow();
        SortedAttributeSpanArray sasa = cell.getSheet().getRowSpans();
        int spanPos = sasa.searchSpan(rowId);
        int level = -1;
        if (spanPos < 0) {
            spanPos = sasa.searchSpan(rowId - 1);
            if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) return;
            level = 0;
        } else {
            level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
        }
        int prevSpanPos = sasa.searchSpan(rowId - 1);
        if (prevSpanPos >= 0) {
            prevRowLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(prevSpanPos)).getOutlineGroupLevel();
        }
        if (level == 0 && prevRowLevel == 0) {
            return;
        }
        if (!node.getType().equals("Leaf")) {
            TreeCellUtil.drawRectangle(g2d, basePos + 2, r.y + (r.height - 14) / 2 + 2, 11, 11);
            boolean isCollapse = false;
            boolean bl = isCollapse = nextRowHeight == 0;
            if (isCollapse) {
                basePos = r.x + 11 * level;
                TreeCellUtil.drawRectangle(g2d, basePos + 2, r.y + (r.height - 14) / 2 + 2, 11, 11);
                g2d.drawLine(basePos + 4, r.y + (r.height - 14) / 2 + 2 + 5, basePos + 14 - 4, r.y + (r.height - 14) / 2 + 5 + 2);
                g2d.drawLine(basePos + 2 + 5, r.y + (r.height - 14) / 2 + 4, basePos + 2 + 5, r.y + (r.height - 14) / 2 + 14 - 4);
            } else {
                TreeCellUtil.drawRectangle(g2d, basePos + 2, r.y + (r.height - 14) / 2 + 2, 11, 11);
                g2d.drawLine(basePos + 4, r.y + (r.height - 14) / 2 + 2 + 5, basePos + 14 - 4, r.y + (r.height - 14) / 2 + 5 + 2);
                g2d.setStroke(dashStroke);
                g2d.drawLine(basePos + 2 + 5, r.y, basePos + 2 + 5, r.y + (r.height - 14) / 2 + 2);
                g2d.setStroke(stroke);
            }
        }
        for (int j = level - 1; j >= 0; --j) {
            int m;
            boolean conjunctive = false;
            int m2 = rowId + 1;
            while (true) {
                int iteratedLevel;
                int iteratedSpanPos = sasa.searchSpan(m2);
                SortedAttributeSpanArray.AttributeSpan span = null;
                if (iteratedSpanPos < 0) {
                    iteratedLevel = 0;
                } else {
                    span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                    iteratedLevel = span.getOutlineGroupLevel();
                }
                if (iteratedLevel == j) {
                    conjunctive = true;
                    break;
                }
                if (iteratedLevel < j) break;
                if (span != null) {
                    m2 = span.getEnd();
                }
                ++m2;
            }
            if (!conjunctive) continue;
            boolean existPossibleHandler = false;
            SortedAttributeSpanArray.AttributeSpan currentSpan = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos);
            for (m = rowId - 1; m >= currentSpan.getStart(); --m) {
                if (SheetBaseMath.getRowHeight(cell.getSheet(), m) <= 0) continue;
                existPossibleHandler = true;
                break;
            }
            if (!existPossibleHandler) {
                int pos;
                m = currentSpan.getStart() - 1;
                block3: while ((pos = sasa.searchSpan(m)) >= 0) {
                    SortedAttributeSpanArray.AttributeSpan lookupAs = sasa.getAttributeSpan(pos);
                    if (lookupAs != currentSpan && lookupAs.getEnd() <= rowId) {
                        if (lookupAs.getOutlineGroupLevel() <= j) break;
                        for (int n = lookupAs.getEnd(); n >= lookupAs.getStart(); --n) {
                            if (SheetBaseMath.getRowHeight(cell.getSheet(), n) <= 0) continue;
                            boolean sTry = false;
                            int x = n + 1;
                            while (true) {
                                int iteratedLevel;
                                int iteratedSpanPos = sasa.searchSpan(x);
                                SortedAttributeSpanArray.AttributeSpan span = null;
                                if (iteratedSpanPos < 0) {
                                    iteratedLevel = 0;
                                } else {
                                    span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                                    iteratedLevel = span.getOutlineGroupLevel();
                                }
                                if (iteratedLevel == j) {
                                    sTry = true;
                                    break;
                                }
                                if (iteratedLevel < j) break;
                                if (span != null) {
                                    x = span.getEnd();
                                }
                                ++x;
                            }
                            if (!sTry) continue;
                            existPossibleHandler = true;
                            break block3;
                        }
                    }
                    --m;
                }
            }
            if (!existPossibleHandler || j >= prevRowLevel) {
                basePos = r.x + j * 11 + 7;
                g2d.drawLine(basePos, r.y + r.height / 2, basePos + 3, r.y + r.height / 2);
                g2d.setStroke(dashStroke);
                g2d.drawLine(basePos, r.y + r.height / 2, basePos, r.y + r.height);
                g2d.setStroke(stroke);
                continue;
            }
            g2d.setStroke(dashStroke);
            basePos = r.x + j * 11 + 7;
            g2d.drawLine(basePos, r.y - 2, basePos, r.y + r.height + 2);
            g2d.setStroke(stroke);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void drawAbove(Graphics2D g2d, Cell cell, Rectangle r) {
        int rowId = cell.getRow();
        SortedAttributeSpanArray sasa = cell.getSheet().getRowSpans();
        int spanPos = sasa.searchSpan(rowId);
        int level = -1;
        if (spanPos < 0) {
            spanPos = sasa.searchSpan(rowId + 1);
            if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) return;
            level = 0;
        } else {
            level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
        }
        int rowY = r.y;
        int rowHeight = r.height;
        int nextRowLevel = 0;
        int nextSpanPos = sasa.searchSpan(rowId + 1);
        if (nextSpanPos >= 0) {
            nextRowLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(nextSpanPos)).getOutlineGroupLevel();
        }
        if (level == 0 && nextRowLevel == 0) {
            return;
        }
        int nextRowHeight = SheetBaseMath.getRowHeight(cell.getSheet(), rowId + 1);
        BasicStroke stroke = new BasicStroke(1.0f);
        BasicStroke dashStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f}, 0.0f);
        g2d.setStroke(stroke);
        if (level < nextRowLevel) {
            int basePos;
            boolean isCollapse;
            boolean bl = isCollapse = nextRowHeight == 0;
            if (nextRowHeight == 0) {
                basePos = r.x + 11 * level;
                TreeCellUtil.drawRectangle(g2d, basePos + 2, rowY + (rowHeight - 14) / 2 + 2, 11, 11);
                g2d.drawLine(basePos + 4, r.y + (r.height - 14) / 2 + 2 + 5, basePos + 14 - 4, r.y + (r.height - 14) / 2 + 5 + 2);
                g2d.drawLine(basePos + 2 + 5, rowY + (rowHeight - 14) / 2 + 4, basePos + 2 + 5, r.y + (r.height - 14) / 2 + 14 - 4);
            } else {
                basePos = r.x + 11 * level;
                TreeCellUtil.drawRectangle(g2d, basePos + 2, rowY + (rowHeight - 14) / 2 + 2, 11, 11);
                g2d.drawLine(basePos + 4, r.y + (r.height - 14) / 2 + 2 + 5, basePos + 14 - 4, r.y + (r.height - 14) / 2 + 5 + 2);
                g2d.setStroke(dashStroke);
                g2d.drawLine(basePos + 2 + 5, r.y + (r.height - 14) / 2 + 14 - 2, basePos + 2 + 5, r.y + r.height);
                g2d.setStroke(stroke);
            }
        }
        for (int j = level - 1; j >= 0; --j) {
            int basePos;
            int m;
            boolean conjunctive = false;
            int m2 = rowId - 1;
            while (true) {
                int iteratedLevel;
                int iteratedSpanPos = sasa.searchSpan(m2);
                SortedAttributeSpanArray.AttributeSpan span = null;
                if (iteratedSpanPos < 0) {
                    iteratedLevel = 0;
                } else {
                    span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                    iteratedLevel = span.getOutlineGroupLevel();
                }
                if (iteratedLevel == j) {
                    conjunctive = true;
                    break;
                }
                if (iteratedLevel < j) break;
                if (span != null) {
                    m2 = span.getStart();
                }
                --m2;
            }
            if (!conjunctive) continue;
            boolean existPossibleHandler = false;
            SortedAttributeSpanArray.AttributeSpan currentSpan = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos);
            for (m = rowId + 1; m <= currentSpan.getEnd(); ++m) {
                if (SheetBaseMath.getRowHeight(cell.getSheet(), m) <= 0) continue;
                existPossibleHandler = true;
                break;
            }
            if (!existPossibleHandler) {
                int pos;
                m = currentSpan.getEnd() + 1;
                block3: while ((pos = sasa.searchSpan(m)) >= 0) {
                    SortedAttributeSpanArray.AttributeSpan lookupAs = sasa.getAttributeSpan(pos);
                    if (lookupAs != currentSpan && lookupAs.getStart() >= rowId) {
                        if (lookupAs.getOutlineGroupLevel() <= j) break;
                        for (int n = lookupAs.getStart(); n <= lookupAs.getEnd(); ++n) {
                            if (SheetBaseMath.getRowHeight(cell.getSheet(), n) <= 0) continue;
                            boolean sTry = false;
                            int x = n - 1;
                            while (true) {
                                int iteratedLevel;
                                int iteratedSpanPos = sasa.searchSpan(x);
                                SortedAttributeSpanArray.AttributeSpan span = null;
                                if (iteratedSpanPos < 0) {
                                    iteratedLevel = 0;
                                } else {
                                    span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                                    iteratedLevel = span.getOutlineGroupLevel();
                                }
                                if (iteratedLevel == j) {
                                    sTry = true;
                                    break;
                                }
                                if (iteratedLevel < j) break;
                                if (span != null) {
                                    x = span.getStart();
                                }
                                --x;
                            }
                            if (!sTry) continue;
                            existPossibleHandler = true;
                            break block3;
                        }
                    }
                    ++m;
                }
            }
            if (!existPossibleHandler || j >= nextRowLevel) {
                basePos = r.x + j * 11 + 7;
                g2d.drawLine(basePos, rowY + rowHeight / 2, basePos + 3, rowY + rowHeight / 2);
                g2d.setStroke(dashStroke);
                g2d.drawLine(basePos, rowY, basePos, rowY + rowHeight / 2);
                g2d.setStroke(stroke);
                continue;
            }
            g2d.setStroke(dashStroke);
            basePos = r.x + j * 11 + 7;
            g2d.drawLine(basePos, rowY, basePos, rowY + rowHeight);
            g2d.setStroke(stroke);
        }
    }
}

