/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.rd.ui.views.peview.style;

import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.rd.model.style.AbstractStyle;
import com.kingdee.bos.ctrl.ext.rd.model.style.StyleScheme;
import com.kingdee.bos.ctrl.ext.rd.ui.views.peview.style.StyleAreaManager;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.expans.model.ExtProps;
import com.kingdee.bos.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.impl.action.SpreadAction;
import com.kingdee.bos.ctrl.kds.impl.icons.ResourceManager;
import com.kingdee.bos.ctrl.kds.impl.state.SpreadStateManager;
import com.kingdee.bos.ctrl.kds.impl.state.StyleBrushState;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDToggleButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public abstract class AbstractStyleArea {
    public static final String STYLE_AREA = "StyleArea";
    protected KDPanel panelArea;
    protected StyleAreaManager areaManager;
    protected StyleScheme styleScheme;
    protected String bgFormula;
    private static final int BORDER_WIDTH = 2;
    private static final Font FONT_TEXT = new Font("Dialog", 2, 14);
    private static Color colorRaised = Color.WHITE;
    private static Color colorLowered = new Color(100, 100, 100);
    private static Border selectedBorder = new BevelBorder(0, colorRaised, colorLowered);
    private static Border pressedBorder = new BevelBorder(1, colorRaised, colorLowered);
    private Color colorText = Color.LIGHT_GRAY;
    private KDExt kdExt;
    private SpreadContext spreadContext;
    private KDToggleButton btnStyleBrush;

    public AbstractStyleArea(StyleAreaManager areaManager) {
        this.areaManager = areaManager;
        this.setStyleScheme(areaManager.getStyleScheme());
    }

    public AbstractStyleArea(StyleScheme styleScheme) {
        this.setStyleScheme(styleScheme);
    }

    public void setStyleScheme(StyleScheme styleScheme) {
        this.styleScheme = styleScheme;
    }

    public KDPanel getAreaPanel() {
        if (this.panelArea == null) {
            this.panelArea = new AreaPanel(this);
        }
        return this.panelArea;
    }

    protected abstract String getAreaText();

    protected abstract Rectangle getAreaBounds();

    protected abstract Image getAreaImage();

    protected abstract AbstractStyle getStyle();

    public void setBackgroundFormula(Sheet sheet) {
        String formula = this.getBackgroundFormula();
        Range range = sheet.getSelectionRange();
        for (int i = 0; i < range.size(); ++i) {
            CellBlock block = range.getBlock(0);
            for (int r = block.getRow(); r <= block.getRow2(); ++r) {
                for (int c = block.getCol(); c <= block.getCol2(); ++c) {
                    SortedExtPropFormulasArray formulasArray = sheet.getCell(r, c, true).getExtProps(true).getFormulas(true);
                    if (this.getStyle().isInterlaced()) {
                        formulasArray.insert(ExtProps.FORMULA_BACKGROUND, formula);
                        continue;
                    }
                    formulasArray.remove(ExtProps.FORMULA_BACKGROUND);
                }
            }
        }
    }

    private String createInterlacedFormula(Color colorFirst, Color colorSecond) {
        return new StringBuffer("IF(MOD(ROW(), 2) = 1, RGB(").append(colorFirst.getRed()).append(",").append(colorFirst.getGreen()).append(",").append(colorFirst.getBlue()).append("), RGB(").append(colorSecond.getRed()).append(",").append(colorSecond.getGreen()).append(",").append(colorSecond.getBlue()).append("))").toString();
    }

    public String getBackgroundFormula() {
        this.bgFormula = !this.getStyle().isInterlaced() ? null : this.createInterlacedFormula(this.getStyle().getColorFirst(), this.getStyle().getColorSenond());
        return this.bgFormula;
    }

    public void setExt(KDExt ext) {
        this.kdExt = ext;
    }

    SpreadContext getSpreadContext() {
        if (this.spreadContext == null) {
            this.spreadContext = MiscUtil.getActiveSpreadContext(this.kdExt);
        }
        return this.spreadContext;
    }

    final void stopStyleBrushState() {
        this.areaManager.setStyleBrushButtonSelected(null);
        SpreadContext spreadContext = this.getSpreadContext();
        if (spreadContext.getStateManager().isState(SpreadStateManager.Key_Style_Brush)) {
            spreadContext.getSpread().getActiveView().setCursor(Cursor.getDefaultCursor());
            SpreadAction actionStyleBrush = spreadContext.getActionManager().getAction("inner_StyleBrush");
            actionStyleBrush.putValue("continious", Boolean.FALSE);
            spreadContext.getStateManager().stop();
        }
    }

    boolean isButtonSelected() {
        return this.btnStyleBrush.isSelected();
    }

    void setStyleBrushButtonSelected(boolean isSelected) {
        this.btnStyleBrush.setSelected(isSelected);
    }

    public void setSelectedRangeStyle() {
        Sheet sheet = this.getSpreadContext().getBook().getActiveSheet();
        Range range = sheet.getSelectionRange();
        ShareStyleAttributes ssa = this.getStyle().getSSA();
        this.setBackgroundFormula(sheet);
        StyleAttributes saInnerBorder = Styles.getEmptySA();
        if (!range.isSingleCell()) {
            saInnerBorder = this.createInnerBorder(ssa);
        }
        range.setStyle(Styles.getSA((ShareStyleAttributes)ssa), saInnerBorder);
    }

    private StyleAttributes createInnerBorder(ShareStyleAttributes ssa) {
        StyleAttributes saInnerBorder = Styles.getEmptySA();
        this.createInnerBorder(ssa, saInnerBorder, Styles.Position.INNER_H);
        this.createInnerBorder(ssa, saInnerBorder, Styles.Position.INNER_V);
        return saInnerBorder;
    }

    private void createInnerBorder(ShareStyleAttributes ssa, StyleAttributes saInnerBorder, Styles.Position posInner) {
        Styles.Position position = null;
        if (posInner == Styles.Position.INNER_H) {
            if (ssa.hasBorder(Styles.Position.TOP)) {
                position = Styles.Position.TOP;
            } else if (ssa.hasBorder(Styles.Position.BOTTOM)) {
                position = Styles.Position.BOTTOM;
            }
        }
        if (posInner == Styles.Position.INNER_V) {
            if (ssa.hasBorder(Styles.Position.LEFT)) {
                position = Styles.Position.LEFT;
            } else if (ssa.hasBorder(Styles.Position.RIGHT)) {
                position = Styles.Position.RIGHT;
            }
        }
        if (position == null) {
            saInnerBorder.setBorderLineStyle(posInner, LineStyle.NULL_LINE);
        } else {
            saInnerBorder.setBorderColor(posInner, ssa.getBorderColor(position));
            saInnerBorder.setBorderPenStyle(posInner, ssa.getBorderPenStyle(position));
            saInnerBorder.setBorderLineStyle(posInner, ssa.getBorderLineStyle(position));
        }
    }

    private class AreaLabelMouseAdapter
    extends MouseAdapter {
        private AreaLabelMouseAdapter() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            AbstractStyleArea.this.panelArea.setBorder(selectedBorder);
            AbstractStyleArea.this.colorText = Color.LIGHT_GRAY;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            AbstractStyleArea.this.panelArea.setBorder(pressedBorder);
            AbstractStyleArea.this.colorText = Color.RED;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            AbstractStyleArea.this.setSelectedRangeStyle();
        }
    }

    private class AreaLabel
    extends KDLabel {
        private AbstractStyleArea styleArea;

        public AreaLabel(AbstractStyleArea styleArea) {
            this.styleArea = styleArea;
            this.setLayout(null);
            this.setToolTipText(null);
            this.setBounds(AbstractStyleArea.this.getAreaBounds());
            this.setHorizontalAlignment(0);
            this.addMouseListener(new AreaLabelMouseAdapter());
            AbstractStyleArea.this.btnStyleBrush = this.createStyleBrushButton(this.getWidth(), 0);
            this.add((Component)AbstractStyleArea.this.btnStyleBrush);
        }

        private KDToggleButton createStyleBrushButton(int parentWidth, int marginTopRight) {
            ImageIcon iconFormat = ResourceManager.getImageIcon("tbtn_formatpainter.gif");
            KDToggleButton btnStyleBrush = new KDToggleButton();
            btnStyleBrush.setFactType(0);
            btnStyleBrush.setIcon((Icon)iconFormat);
            btnStyleBrush.setOpaque(false);
            int iconWidth = iconFormat.getIconWidth();
            int x = parentWidth - iconWidth - marginTopRight;
            int y = marginTopRight;
            int w = iconWidth;
            int h = iconFormat.getIconHeight();
            btnStyleBrush.setBounds(x, y, w, h);
            btnStyleBrush.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    AbstractStyleArea.this.getSpreadContext().getSpread().requestFocusInWindow();
                    StyleBrushState state = (StyleBrushState)AbstractStyleArea.this.getSpreadContext().getStateManager().createStyleBrushState(null);
                    state.addStateChangeListener(AbstractStyleArea.this.areaManager);
                    AreaLabel.this.doStyleBrushAction(e.getClickCount() == 2);
                }
            });
            return btnStyleBrush;
        }

        private void doStyleBrushAction(boolean isContinue) {
            Cell cell;
            SpreadContext spreadContext = AbstractStyleArea.this.getSpreadContext();
            SpreadAction actionStyleBrush = spreadContext.getActionManager().getAction("inner_StyleBrush");
            actionStyleBrush.putValue(AbstractStyleArea.STYLE_AREA, AbstractStyleArea.this);
            if (Boolean.TRUE.equals(actionStyleBrush.getValue("continious")) && spreadContext.getStateManager().isState(SpreadStateManager.Key_Style_Brush)) {
                AbstractStyleArea.this.stopStyleBrushState();
                return;
            }
            Sheet sheet = Book.Manager.getNewBook().getActiveSheet();
            Range r = sheet.getRange(cell = sheet.getCell(0, 0, true));
            if (r.copy()) {
                spreadContext.getStateManager().addState(spreadContext.getStateManager().createStyleBrushState(r));
            }
            actionStyleBrush.putValue("continious", isContinue);
            AbstractStyleArea.this.areaManager.setStyleBrushButtonSelected(AbstractStyleArea.this);
        }

        public void paint(Graphics g) {
            Image img = this.styleArea.getAreaImage();
            g.drawImage(img, 0, 0, img.getWidth((ImageObserver)((Object)this)), img.getHeight((ImageObserver)((Object)this)), 1, 1, img.getWidth((ImageObserver)((Object)this)) - 1, img.getHeight((ImageObserver)((Object)this)) - 1, (ImageObserver)((Object)this));
            g.setFont(FONT_TEXT);
            g.setColor(AbstractStyleArea.this.colorText);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D rc = fm.getStringBounds(this.styleArea.getAreaText(), g);
            int x = (int)(((double)this.getWidth() - rc.getWidth()) / 2.0);
            int y = (int)(((double)this.getHeight() - rc.getHeight()) / 2.0);
            g.drawString(this.styleArea.getAreaText(), x, y + 15);
            super.paint(g);
        }
    }

    private class AreaPanel
    extends KDPanel {
        public AreaPanel(AbstractStyleArea styleArea) {
            int insert = 4;
            this.setCustomInsets(new Insets(insert, insert, insert, insert));
            Rectangle rect = AbstractStyleArea.this.getAreaBounds();
            rect.x -= 2;
            rect.y -= 2;
            rect.width += 4 + insert;
            rect.height += 4 + insert;
            this.setBounds(rect);
            this.setBorder(selectedBorder);
            this.setLayout(new BorderLayout());
            this.add((Component)((Object)new AreaLabel(styleArea)));
        }
    }
}

