/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.chart;

import com.kingdee.bos.ctrl.ext.ui.wizards.chart.AbstractChartPanel;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.chartpanelImpl.ChartFrameworkTypeChooserPanel;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.chartpanelImpl.FusionChartTypeChooserPanel;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.chartpanelImpl.typechooser.ChartTypeButton;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.layout.ControlPaneLayout;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.FusionGraphicsModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.bos.ctrl.ext.ui.wizards.report.IWizardStep;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.core.SpreadView;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.ChartFrameWorkType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.EChart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class FusionChartWizzard
extends KDDialog
implements ISpreadWizzard,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    public static final String WIZZARD_STATE_NORMAL = "NORMAL";
    public static final String WIZZARD_STATE_TAB = "TAB";
    private KDButton next = new KDButton("\u4e0b\u4e00\u6b65");
    private KDButton last = new KDButton("\u4e0a\u4e00\u6b65");
    private KDButton cancle = new KDButton("\u53d6\u6d88");
    private KDButton finish = new KDButton("\u5b8c\u6210");
    private KDPanel controlPanel;
    private AbstractChartPanel currentStep;
    private AbstractChartPanel tabCurrentStep;
    public static FusionGraphicsModel model;
    private AbstractFusionBean bean;
    private SpreadContext context;
    private Component parent;
    private KDPanel centerPanel = new KDPanel();
    private String _wizzardState = "NORMAL";
    private KDTabbedPane _tab;
    public static boolean SHOWCHARTTYPE;
    private EmbedObject cache;

    public FusionChartWizzard(Frame frame, SpreadContext context) {
        super(frame);
        this.parent = frame;
        this.init(context);
    }

    public FusionChartWizzard(Dialog dialog, SpreadContext context) {
        super(dialog);
        this.parent = dialog;
        this.init(context);
    }

    private void init(SpreadContext context) {
        this.context = context;
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.installComponents();
        this.installListeners();
        this.initControlPanel();
        this.prepare();
    }

    private void initControlPanel() {
        this.controlPanel = new KDPanel();
        this.controlPanel.setLayout((LayoutManager)new ControlPaneLayout());
        this.controlPanel.add((Component)this.last);
        this.controlPanel.add((Component)this.next);
        this.controlPanel.add((Component)this.finish);
        this.controlPanel.add((Component)this.cancle);
        this.getContentPane().add((Component)this.controlPanel, "South");
    }

    private void installComponents() {
        this.setSize(720, 550);
        this.currentStep = SHOWCHARTTYPE ? new ChartFrameworkTypeChooserPanel(null, this.context, (Container)((Object)this), model) : new FusionChartTypeChooserPanel(null, this.context, (Container)((Object)this), model);
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.centerPanel.setLayout((LayoutManager)new BorderLayout());
        this.getContentPane().add((Component)this.centerPanel);
        this.reLayoutPanel(this.currentStep);
    }

    private void reLayoutPanel(KDPanel panel) {
        this.centerPanel.removeAll();
        this.centerPanel.add((Component)panel);
        this.centerPanel.revalidate();
        this.centerPanel.repaint();
    }

    public void dispose() {
        this._wizzardState = WIZZARD_STATE_NORMAL;
        super.setVisible(false);
        this.currentStep.dispose();
        IWizardStep temp = this.currentStep.getPrevStep();
        while (temp != null) {
            IWizardStep temp1 = temp.getPrevStep();
            if (temp1 == null) {
                this.currentStep = (AbstractChartPanel)temp;
                break;
            }
            temp = temp1;
        }
    }

    private void installListeners() {
        this.cancle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FusionChartWizzard.this.dispose();
                FusionChartWizzard.this._wizzardState = FusionChartWizzard.WIZZARD_STATE_NORMAL;
                FusionChartWizzard.this.cache = null;
            }
        });
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FusionChartWizzard.this.currentStep.syncGraphics2Model(-1);
                FusionChartWizzard.this.currentStep = (AbstractChartPanel)FusionChartWizzard.this.currentStep.getNextStep();
                FusionChartWizzard.this.currentStep.prepare();
                FusionChartWizzard.this.currentStep.syncModel2Graphics(-1);
                FusionChartWizzard.this.reLayoutPanel(FusionChartWizzard.this.currentStep);
                FusionChartWizzard.this.configControlPanel();
            }
        });
        this.last.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FusionChartWizzard.this.currentStep.syncGraphics2Model(-1);
                FusionChartWizzard.this.currentStep = (AbstractChartPanel)FusionChartWizzard.this.currentStep.getPrevStep();
                FusionChartWizzard.this.currentStep.prepare();
                FusionChartWizzard.this.currentStep.syncModel2Graphics(-1);
                FusionChartWizzard.this.reLayoutPanel(FusionChartWizzard.this.currentStep);
                FusionChartWizzard.this.configControlPanel();
            }
        });
        this.finish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FusionChartWizzard.this.commit(true)) {
                    FusionChartWizzard.this.dispose();
                    FusionChartWizzard.this._wizzardState = FusionChartWizzard.WIZZARD_STATE_NORMAL;
                }
            }
        });
    }

    private void configControlPanel() {
        this.last.setEnabled(false);
        this.next.setEnabled(false);
        this.finish.setEnabled(model.getChartType() != null && this.currentStep.getPrevStep() != null);
        if (this.currentStep.getNextStep() != null) {
            this.next.setEnabled(true);
        }
        if (this.currentStep.getPrevStep() != null) {
            this.last.setEnabled(true);
        }
    }

    @Override
    public void commit() {
    }

    boolean commit(boolean flag) {
        if (this.cache instanceof FlashChart || this.cache instanceof EChart) {
            Sheet sheet = this.context.getBook().getActiveSheet();
            sheet.getEmbedments(true).selectEmbed(this.cache, 2);
            this.cache = null;
        }
        if (this._wizzardState == WIZZARD_STATE_NORMAL) {
            if (model.getChartType() == null) {
                return false;
            }
            if (!this.currentStep.syncGraphics2Model(-1)) {
                return false;
            }
            this.currentStep.compose();
        } else if (this._wizzardState == WIZZARD_STATE_TAB) {
            AbstractChartPanel selectedStep;
            model.getBean().setLastSelectedIndex(this._tab.getSelectedIndex());
            KDPanel panel = (KDPanel)this._tab.getSelectedComponent();
            if (panel != null && (selectedStep = (AbstractChartPanel)panel.getUserObject()) != null) {
                if (!selectedStep.syncGraphics2Model(-1)) {
                    return false;
                }
                selectedStep.compose();
            }
        } else {
            throw new IllegalStateException("\u9519\u8bef\u7684\u56fe\u8868\u8bbe\u8ba1\u5668\u7c7b\u578b\uff01");
        }
        return true;
    }

    @Override
    public boolean prepare() {
        return this.prepare(new FusionGraphicsModel());
    }

    public boolean prepare(FusionGraphicsModel model) {
        FusionChartWizzard.model = model;
        SpreadView view = this.context.getSpread().getActiveView();
        Rectangle rect = view.getVisibleRect();
        rect = this.calcVisibleCentre(rect);
        model.setX(rect.x);
        model.setY(rect.y);
        FusionChartDataNode dataNode = new FusionChartDataNode(this.context.getBook().getActiveSheet());
        dataNode.setDataFrom(model.getDataFrom());
        dataNode.setChartType(model.getChartType());
        model.setDataNode(dataNode);
        if (this._wizzardState == WIZZARD_STATE_NORMAL) {
            EmbedObject obj;
            this.controlPanel.removeAll();
            this.controlPanel.add((Component)this.last);
            this.controlPanel.add((Component)this.next);
            this.controlPanel.add((Component)this.finish);
            this.controlPanel.add((Component)this.cancle);
            model.addPropertyChangeListener("chartType", this);
            this.reLayoutPanel(this.currentStep);
            this.currentStep.setModel(model);
            this.currentStep.prepare();
            Sheet sheet = this.context.getBook().getActiveSheet();
            EmbedhLayer layer = sheet.getEmbedments(false);
            FusionChartTypeChooserPanel chooser = null;
            chooser = !SHOWCHARTTYPE ? (FusionChartTypeChooserPanel)this.currentStep : (FusionChartTypeChooserPanel)this.currentStep.getNextStep();
            chooser.setModel(model);
            ChartTypeButton.setSelectionButtonChangedListener(chooser);
            if (layer == null) {
                this.configControlPanel();
                return true;
            }
            EmbedObject embedObject = obj = layer.hasSelection() ? layer.getSelectedEmbed(0) : null;
            if (obj instanceof FlashChart) {
                this.cache = obj;
                this.syncFusionBean(((FlashChart)this.cache).getModel(), this.cache);
            } else if (obj instanceof EChart) {
                this.cache = obj;
                this.syncFusionBean(((EChart)this.cache).getModel(), this.cache);
            } else {
                chooser.clearSelection();
            }
            this.configControlPanel();
            return true;
        }
        if (this._wizzardState == WIZZARD_STATE_TAB) {
            try {
                this._tab = new KDTabbedPane(){
                    private static final long serialVersionUID = 1L;

                    public void setSelectedIndex(int index) {
                        if (this.getSelectedIndex() != index) {
                            AbstractChartPanel selectedStep;
                            AbstractChartPanel deSelectedStep;
                            KDPanel panel = (KDPanel)FusionChartWizzard.this._tab.getSelectedComponent();
                            if (panel != null && (deSelectedStep = (AbstractChartPanel)panel.getUserObject()) != null) {
                                deSelectedStep.syncGraphics2Model(-1);
                            }
                            super.setSelectedIndex(index);
                            panel = (KDPanel)FusionChartWizzard.this._tab.getSelectedComponent();
                            if (panel != null && (selectedStep = (AbstractChartPanel)panel.getUserObject()) != null) {
                                selectedStep.syncModel2Graphics(-1);
                            }
                        }
                    }
                };
                this.tabCurrentStep = new FusionChartTypeChooserPanel(null, this.context, (Container)this._tab, model);
                ChartTypeButton.setSelectionButtonChangedListener((FusionChartTypeChooserPanel)this.tabCurrentStep);
                this.tabCurrentStep.setModel(model);
                Sheet sheet = this.context.getBook().getActiveSheet();
                EmbedhLayer layer = sheet.getEmbedments(false);
                this.cache = layer.getSelectedEmbed(0);
                if (this.cache instanceof FlashChart) {
                    this.syncFusionBean(((FlashChart)this.cache).getModel(), this.cache);
                } else if (this.cache instanceof EChart) {
                    this.syncFusionBean(((EChart)this.cache).getModel(), this.cache);
                }
                this.controlPanel.removeAll();
                this.finish.setEnabled(true);
                this.controlPanel.add((Component)this.finish);
                this.cancle.setEnabled(true);
                this.controlPanel.add((Component)this.cancle);
                KDPanel panel = this.tabCurrentStep.getImpl();
                panel.setUserObject((Object)this.tabCurrentStep);
                for (AbstractChartPanel next = (AbstractChartPanel)this.tabCurrentStep.getNextStep(); next != null; next = (AbstractChartPanel)next.getNextStep()) {
                    next.prepare();
                    panel = next.getImpl();
                    panel.setUserObject((Object)next);
                    this._tab.addTab(next.getTitle(), (Component)panel);
                }
                int lastSelectIndex = model.getBean().getLastSelectedIndex();
                this._tab.setSelectedIndex(lastSelectIndex >= this._tab.getTabCount() ? 2 : lastSelectIndex);
                this.setTitle("\u56fe\u8868\u8bbe\u7f6e");
                this.centerPanel.removeAll();
                this.centerPanel.add((Component)this._tab);
                this.centerPanel.revalidate();
                this.centerPanel.repaint();
            }
            catch (RuntimeException ex) {
                this._wizzardState = WIZZARD_STATE_NORMAL;
                if (MiscUtil.shouldLog()) {
                    MiscUtil.log(ex);
                }
                throw ex;
            }
            return true;
        }
        throw new IllegalStateException("\u9519\u8bef\u7684\u9762\u677f\u72b6\u6001\uff01");
    }

    private void syncFusionBean(FlashChartModel flashModel, EmbedObject chart) {
        AbstractFusionBean src = flashModel.getBean();
        this.bean = (AbstractFusionBean)src.clone();
        this.bean.setLastSelectedIndex(src.getLastSelectedIndex());
        this.bean.setChartName(flashModel.getBean().getChartName());
        this.bean.setChartType(flashModel.getChartType());
        this.bean.setTransformable_chart(src.getTransformable_chart());
        this.bean.setChartColorTemplate(src.getChartColorTemplate());
        this.bean.setChart_chartBottomMargin(src.getChart_chartBottomMargin());
        this.bean.setChart_chartTopMargin(src.getChart_chartTopMargin());
        this.bean.setChart_chartRightMargin(src.getChart_chartRightMargin());
        this.bean.setChart_chartLeftMargin(src.getChart_chartLeftMargin());
        model.setDataFrom(flashModel.getDataFrom());
        model.setExtTargets(flashModel.getExtTargets());
        model.setInnerTargets(flashModel.getInnerTargets());
        model.setChartType(flashModel.getChartType());
        model.setBean(this.bean, false);
        model.setX(chart.getX());
        model.setY(chart.getY());
        model.setW(chart.getWidth());
        model.setH(chart.getHeight());
        model.setAnchorMode(chart.getAnchorMode());
        model.setAnchorCellLT(chart.getAnchorCellLT());
        model.setAnchorCellRB(chart.getAnchorCellRB());
        FusionChartDataNode dataNode = flashModel.getDataNode();
        model.setFramworkType(chart instanceof EChart ? ChartFrameWorkType.ECHART : ChartFrameWorkType.FUSIONCART);
        model.setDataNode((FusionChartDataNode)dataNode.clone());
        this.currentStep.model.setChartType(flashModel.getChartType());
        this.currentStep.syncGraphics2Model(1);
    }

    private Rectangle calcVisibleCentre(Rectangle rect) {
        rect.x += (rect.width - 480) / 2;
        rect.y += (rect.height - 297) / 2;
        rect.height = 278;
        rect.width = 420;
        return rect;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.configControlPanel();
    }

    public void show(int step) {
        this.show(step, new FusionGraphicsModel());
    }

    public void show(int step, FusionGraphicsModel model) {
        this._wizzardState = WIZZARD_STATE_TAB;
        this.prepare(model);
        this.setLocationRelativeTo(this.parent);
        this.setVisible(true);
    }

    public void step() {
        this.currentStep = (AbstractChartPanel)this.currentStep.getNextStep();
        this.currentStep.prepare();
    }

    static {
        SHOWCHARTTYPE = Boolean.parseBoolean(System.getProperty("ext.chartwizzard.showChartType", "false"));
    }
}

