/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.defaultImpl;

import chrriis.dj.nativeswing.common.Utils;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.pe.beans.value.BooleanVFPair;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Categories;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Dataset;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.NodeFunc;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Set;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.bos.ctrl.kds.model.struct.node.CellBlockNode;
import java.util.HashMap;
import java.util.List;

public abstract class DefaultStackedSeriesBean
extends AbstractFusionBean {
    private BooleanVFPair chartSum = new BooleanVFPair(false, null);

    public DefaultStackedSeriesBean() {
        this.isHyperLinkEnabled = false;
    }

    @Override
    protected void customAttributes(FusionChartDataNode dataNode) {
    }

    @Override
    protected void fillChartNodes(FusionChartDataNode dataNode) throws SyntaxErrorException {
        super.applyNumberFormats();
        boolean isSeriesByCol = dataNode.isSerialByCol();
        String[] group = dataNode.getGroupKeys();
        String[] series = (String[])dataNode.getSeriesKeys();
        double[][] data = (double[][])dataNode.getData();
        Sheet sheet = dataNode.getSheet();
        String formula = dataNode.getDataFormula();
        int cbLength = 0;
        CellBlockNode[] cb = null;
        if (!StringUtil.isEmptyString((String)formula)) {
            cb = SheetBaseMath.getArrayBlockNodes(sheet, formula, sheet.getBook().getDeps().isA1Style());
            cbLength = cb.length;
        }
        if (data == null || group == null || series == null) {
            return;
        }
        this.categories = new Categories();
        this.categories.categories = new Categories.Category[group.length];
        int len = group.length;
        for (int i = 0; i < len; ++i) {
            this.categories.categories[i] = new Categories.Category(group[i]);
        }
        if (this.chartType == FlashChartType.FLASH_CT_ST_COL2D || this.chartType == FlashChartType.FLASH_CT_ST_COL3D || this.chartType == FlashChartType.FLASH_CT_ST_AREA2D || this.chartType == FlashChartType.FLASH_CT_ST_BAR2D || this.chartType == FlashChartType.FLASH_CT_ST_BAR3D) {
            this.datasets = new Dataset[series.length];
            int len1 = series.length;
            for (int i = 0; i < len1; ++i) {
                this.datasets[i] = new Dataset();
                this.datasets[i].nodes = new NodeFunc[data[i].length];
                this.datasets[i].seriesName = series[i];
                for (int j = 0; j < data[i].length; ++j) {
                    Set s = new Set();
                    this.datasets[i].nodes[j] = s;
                    if (this.isHyperLinkEnabled && this.hyperLinks != null && this.hyperLinks.length > 0 && null != cb) {
                        String cellRef = cbLength > 1 ? (isSeriesByCol ? cb[i].getSheet().getCell(cb[i].getRow() + j, cb[i].getCol() + i, true).getName(false, false) : cb[j].getSheet().getCell(cb[j].getRow() + i, cb[j].getCol() + j, true).getName(false, false)) : (isSeriesByCol ? cb[0].getSheet().getCell(cb[0].getRow() + j, cb[0].getCol() + i, true).getName(false, false) : cb[0].getSheet().getCell(cb[0].getRow() + i, cb[0].getCol() + j, true).getName(false, false));
                        s.setCellRef(cellRef);
                    }
                    s.value = this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1 ? this.magnify100(String.valueOf(data[i][j])) : String.valueOf(data[i][j]);
                    s.link = this.buildLinkProp(group[j], series[i], String.valueOf(data[i][j]));
                }
            }
        }
        super.fillChartNodes(dataNode);
    }

    @Override
    public BooleanVFPair getChartSum() {
        return this.chartSum;
    }

    @Override
    public void setChartSum(BooleanVFPair chartSum) {
        this.chartSum = chartSum;
    }

    @Override
    protected void attachHyperLinkImpl(String[] hyperLinks) {
        int datasetSize = this.datasets.length;
        int index = hyperLinks[0].indexOf("[cell]");
        int index2 = index + 6;
        for (int i = 0; i < datasetSize; ++i) {
            int nodesSize = this.datasets[i].nodes.length;
            for (int j = 0; j < nodesSize; ++j) {
                if (this.datasets[i].nodes[j].getCellRef() == null) continue;
                ((Set)this.datasets[i].nodes[j]).link = Utils.encodeURL((String)(hyperLinks[0].substring(0, index) + "[" + this.datasets[i].nodes[j].getCellRef() + "]" + hyperLinks[0].substring(index2)));
            }
        }
    }

    @Override
    public String calcPlayerID(String cell, int bindingPolicy) {
        String ret = null;
        int series = this.datasets.length;
        switch (bindingPolicy) {
            case 2: {
                ret = cell;
                break;
            }
            case 0: {
                for (int i = 0; i < series; ++i) {
                    int n = this.datasets[i].nodes.length;
                    for (int j = 0; j < n; ++j) {
                        if (!cell.equals(this.datasets[i].nodes[j].getCellRef())) continue;
                        return "G" + j;
                    }
                }
                break;
            }
            case 1: {
                for (int i = 0; i < series; ++i) {
                    int n = this.datasets[i].nodes.length;
                    for (int j = 0; j < n; ++j) {
                        if (!cell.equals(this.datasets[i].nodes[j].getCellRef())) continue;
                        return "S" + i;
                    }
                }
                break;
            }
        }
        return ret;
    }

    public static String getDemoXML(int categories, String chartTypeName, List colors, HashMap numberFormats) {
        StringBuilder sb = new StringBuilder(DefaultStackedSeriesBean.generateCommonDemoChartTtile(chartTypeName, numberFormats));
        sb.append("<categories>");
        StringBuilder sb2 = new StringBuilder();
        String[] demoLabels = DefaultStackedSeriesBean.getDemoLabels();
        int lenSeries = demoLabels.length;
        int size = colors.size();
        for (int i = 0; i < size; ++i) {
            String nextColor = (String)colors.get(i);
            String color = nextColor.substring(0, 6);
            String alpha = String.valueOf((int)((double)Integer.parseInt(nextColor.substring(6, nextColor.length())) * 0.4));
            if (i < categories) {
                sb.append("<category label='\u5206\u7ec4");
                sb.append(i + 1);
                sb.append("' />");
            }
            sb2.append("<dataset seriesName='");
            if (i < lenSeries) {
                sb2.append(demoLabels[i]);
            } else {
                sb2.append(demoLabels[lenSeries - 1]);
            }
            sb2.append("' color='");
            sb2.append(color);
            sb2.append("' alpha='");
            sb2.append(alpha);
            sb2.append("' >");
            int len = colors.size();
            for (int j = 0; j < len; ++j) {
                sb2.append("<set value='25601.34' />");
            }
            sb2.append("</dataset>");
        }
        sb.append("</categories>");
        sb.append(sb2.toString());
        sb.append("</chart>");
        return sb.toString();
    }
}

