/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.configpen;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.bizmodel.ParamsModelSet;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.configpen.ParamUI;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.configpen.TreeIO;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdom2.Content;
import org.jdom2.Element;

class ParamsUI
extends KDPanel {
    private KDList _lstParams;
    private KDWorkButton _btnAddParam;
    private KDWorkButton _btnDelParam;
    private KDWorkButton _btnUpParam;
    private KDWorkButton _btnDownParam;
    private KDWorkButton _btnDeep;
    private ParamUI _paramUi;
    private KDContainer _ctnParamUi;
    private KDCheckBox _chkVisible;
    private KDTextField _txtDemoParamsCount;
    private int _currentParamListIdx = -1;
    private boolean _isSysListChange;

    public ParamsUI() {
        this.init();
        this.installListener();
    }

    private void init() {
        TableLayout2 ly = new TableLayout2(2, 1);
        ly.setRatableHeight(0, 100);
        ly.setFixedHeight(1, 20);
        ly.setRowSpacing(0, 6);
        this.setLayout((LayoutManager)ly);
        this.add((Component)this.createParamDefinePane(), TableLayout2.param((int)0, (int)0));
        this.add((Component)this.createParamsAttrsPane(), TableLayout2.param((int)1, (int)0));
    }

    private void installListener() {
        this._lstParams.addListSelectionListener((ListSelectionListener)new ListSelectionHandler());
        ParamUpDownHandler pudh = new ParamUpDownHandler();
        this._btnUpParam.addActionListener((ActionListener)pudh);
        this._btnDownParam.addActionListener((ActionListener)pudh);
        ParamAddDelHandler padh = new ParamAddDelHandler();
        this._btnAddParam.addActionListener((ActionListener)padh);
        this._btnDelParam.addActionListener((ActionListener)padh);
        this._btnDeep.addActionListener((ActionListener)new ParamDeepDefineHandler());
    }

    private KDPanel createParamDefinePane() {
        ParamUI.INameChangedListener l = new ParamUI.INameChangedListener(){

            @Override
            public void nameChanged(String name) {
                ParamItem item = (ParamItem)ParamsUI.this._lstParams.getElement(ParamsUI.this._currentParamListIdx);
                Element e = item.getValue();
                e.setAttribute("name", name);
                ParamsUI.this._lstParams.repaint();
            }
        };
        KDLabel labParams = new KDLabel("\u53c2\u6570\uff1a");
        this._lstParams = new KDList();
        this._lstParams.setSelectionMode(0);
        this._btnAddParam = new KDWorkButton("\u6dfb");
        this._btnDelParam = new KDWorkButton("\u5220");
        this._btnUpParam = new KDWorkButton("\u2191");
        this._btnDownParam = new KDWorkButton("\u2193");
        this._btnDeep = new KDWorkButton("\u6df1");
        this._paramUi = new ParamUI(l);
        this._ctnParamUi = new KDContainer();
        this._ctnParamUi.setTitle("\u53c2\u6570\u5b9a\u4e49");
        this._ctnParamUi.setContainerType(1);
        this._ctnParamUi.getContentPane().setLayout(new BorderLayout());
        TableLayout2 ly = new TableLayout2(2, 7);
        ly.setColsSpacing(TableLayout2.ALL, 3);
        ly.setColSpacing(5, 8);
        ly.setFixedWidth(TableLayout2.ALL, 22);
        ly.setFixedWidth(0, 42);
        ly.setRatableWidth(6, 100);
        ly.setFixedHeight(0, 20);
        ly.setRatableHeight(1, 100);
        KDPanel pan = new KDPanel((LayoutManager)ly);
        pan.add((Component)labParams, (Object)TableLayout2.param((int)0, (int)0));
        pan.add((Component)this._btnAddParam, (Object)TableLayout2.param((int)0, (int)1));
        pan.add((Component)this._btnDelParam, (Object)TableLayout2.param((int)0, (int)2));
        pan.add((Component)this._btnUpParam, (Object)TableLayout2.param((int)0, (int)3));
        pan.add((Component)this._btnDownParam, (Object)TableLayout2.param((int)0, (int)4));
        pan.add((Component)this._btnDeep, (Object)TableLayout2.param((int)0, (int)5));
        pan.add((Component)new KDScrollPane((Component)this._lstParams), (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)5));
        pan.add((Component)this._ctnParamUi, (Object)TableLayout2.param((int)0, (int)6, (int)1, (int)6));
        return pan;
    }

    private KDPanel createParamsAttrsPane() {
        this._chkVisible = new KDCheckBox("\u53c2\u6570\u5bfc\u822a\u53ef\u89c1");
        this._chkVisible.setEnabled(false);
        this._txtDemoParamsCount = new KDTextField();
        KDLabelContainer lbcDPC = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtDemoParamsCount, (String)"\u53c2\u6570\u5bfc\u822a\u793a\u4f8b\u6570\uff08\u53ef\u4ee5\u591a\u4e2a\u503c\uff0c\u7528|\u5206\u9694\uff0c\u59823|5\uff09", (int)260);
        TableLayout2 ly = new TableLayout2(1, 2);
        ly.setRatableWidth(0, 30);
        ly.setRatableWidth(1, 70);
        ly.setColSpacing(0, 10);
        KDPanel pan = new KDPanel((LayoutManager)ly);
        pan.add((Component)this._chkVisible, (Object)TableLayout2.param((int)0, (int)0));
        pan.add((Component)lbcDPC, (Object)TableLayout2.param((int)0, (int)1));
        return pan;
    }

    public void prepareCtrlValue(Element xmlParams) {
        this._lstParams.removeAllElements();
        if (xmlParams == null) {
            this._chkVisible.setSelected(true);
            this._txtDemoParamsCount.setText(null);
        } else {
            this._chkVisible.setSelected(!"false".equals(xmlParams.getAttributeValue("visible")));
            this._txtDemoParamsCount.setText(xmlParams.getAttributeValue("demoCount"));
            this._isSysListChange = true;
            List listParam = xmlParams.getChildren("param");
            for (int i = listParam.size() - 1; i >= 0; --i) {
                Element xmlParam = (Element)listParam.get(i);
                this._lstParams.insertElement((Object)new ParamItem(xmlParam), 0);
            }
            this._isSysListChange = false;
        }
    }

    public void acceptParamEditing() {
        if (this._currentParamListIdx >= 0 && this._currentParamListIdx < this._lstParams.getElementCount()) {
            ParamItem item = (ParamItem)this._lstParams.getElement(this._currentParamListIdx);
            Element oriXml = item.getValue();
            Element newXml = this._paramUi.getModel();
            if (newXml != null) {
                Element oriSub = oriXml.getChild("array");
                if (oriSub != null) {
                    TreeIO.xmlReAdd(newXml, oriSub);
                }
                item.setValue(newXml);
            }
        }
    }

    public boolean acceptEditing(Element xmlParams) {
        if (this._lstParams.getElementCount() > 0) {
            if (!this._chkVisible.isSelected()) {
                xmlParams.setAttribute("visible", "false");
            }
            String strDemoCount = this._txtDemoParamsCount.getText();
            if (!StringUtil.isEmptyString((String)(strDemoCount = this.checkDemoParamsCount(strDemoCount)))) {
                xmlParams.setAttribute("demoCount", strDemoCount);
            }
            int c = this._lstParams.getElementCount();
            for (int i = 0; i < c; ++i) {
                ParamItem item = (ParamItem)this._lstParams.getElement(i);
                TreeIO.xmlReAdd(xmlParams, item.getValue());
            }
            return true;
        }
        return false;
    }

    private String checkDemoParamsCount(String value) {
        if (!StringUtil.isEmptyString((String)value)) {
            try {
                if (value.indexOf(124) == -1) {
                    Integer.parseInt(value);
                } else {
                    String[] vs = value.split("\\|");
                    int c = vs.length;
                    for (int i = 0; i < c; ++i) {
                        Integer.parseInt(vs[i]);
                    }
                }
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return value;
    }

    public String getTextForExample() {
        Element xmlTemp = new Element("params");
        this.acceptEditing(xmlTemp);
        return ParamsModelSet.pickParamsText(xmlTemp);
    }

    private class ParamDeepDefineHandler
    implements ActionListener {
        private ParamDeepDefineHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int idx = ParamsUI.this._lstParams.getSelectedIndex();
            if (idx == -1) {
                return;
            }
            ParamItem item = (ParamItem)ParamsUI.this._lstParams.getElement(idx);
            Element xmlParam = item.getValue();
            ParamsUI subUi = new ParamsUI();
            subUi._chkVisible.setEnabled(true);
            subUi.prepareCtrlValue(xmlParam.getChild("array"));
            SimpleDialog dlg = SimpleDialog.create((Component)((Object)ParamsUI.this));
            dlg.setComponent((Component)((Object)subUi));
            dlg.setTitle("\u5b9a\u4e49\u53c2\u6570[" + item + "]\u7684\u4e0b\u4e00\u5c42\u53c2\u6570");
            dlg.setSize(800, 400);
            if (dlg.showDialog()) {
                xmlParam.removeChild("array");
                Element xmlArray = new Element("array");
                if (subUi.acceptEditing(xmlArray)) {
                    xmlParam.addContent((Content)xmlArray);
                }
                ParamsUI.this._lstParams.repaint();
            }
        }
    }

    private class ParamAddDelHandler
    implements ActionListener {
        private ParamAddDelHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ParamsUI.this._btnDelParam) {
                int idx = ParamsUI.this._lstParams.getSelectedIndex();
                if (idx == -1) {
                    return;
                }
                ParamsUI.this._lstParams.removeElementAt(idx);
                if (idx > ParamsUI.this._lstParams.getElementCount() - 1) {
                    --idx;
                }
                if (idx >= 0) {
                    ParamsUI.this._lstParams.setSelectedIndex(idx);
                }
            } else if (e.getSource() == ParamsUI.this._btnAddParam) {
                ParamItem item = new ParamItem(new Element("param"));
                ParamsUI.this._lstParams.addElement((Object)item);
                ParamsUI.this._lstParams.setSelectedValue((Object)item, true);
            }
        }
    }

    private class ParamUpDownHandler
    implements ActionListener {
        private ParamUpDownHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int currentIdx;
            ParamsUI.this._isSysListChange = true;
            int idx = currentIdx = ParamsUI.this._lstParams.getSelectedIndex();
            if (idx == -1) {
                return;
            }
            if (e.getSource() == ParamsUI.this._btnUpParam && idx > 0) {
                --idx;
            } else if (e.getSource() == ParamsUI.this._btnDownParam && idx < ParamsUI.this._lstParams.getElementCount() - 1) {
                ++idx;
            }
            if (idx != currentIdx) {
                Object item = ParamsUI.this._lstParams.getElement(currentIdx);
                ParamsUI.this._lstParams.removeElementAt(currentIdx);
                ParamsUI.this._lstParams.insertElement(item, idx);
                ParamsUI.this._lstParams.setSelectedIndex(idx);
            }
            ParamsUI.this._isSysListChange = false;
        }
    }

    private class ListSelectionHandler
    implements ListSelectionListener {
        private ListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ParamItem item;
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (!ParamsUI.this._isSysListChange) {
                ParamsUI.this.acceptParamEditing();
            }
            if ((item = (ParamItem)ParamsUI.this._lstParams.getSelectedValue()) == null) {
                ParamsUI.this._ctnParamUi.getContentPane().removeAll();
                ParamsUI.this._currentParamListIdx = -1;
            } else {
                ParamsUI.this._ctnParamUi.getContentPane().add((Component)((Object)ParamsUI.this._paramUi), "Center");
                ParamsUI.this._paramUi.setModel(item.getValue());
                ParamsUI.this._currentParamListIdx = ParamsUI.this._lstParams.getSelectedIndex();
            }
            ParamsUI.this._ctnParamUi.getContentPane().validate();
            ParamsUI.this._ctnParamUi.getContentPane().repaint();
        }
    }

    private static class ParamItem {
        private Element xml;

        public ParamItem(Element xml) {
            this.setValue(xml);
        }

        public Element getValue() {
            return this.xml;
        }

        public void setValue(Element xml) {
            if (xml == null) {
                throw new RuntimeException("Value must be not null.");
            }
            this.xml = xml;
        }

        public String toString() {
            String result;
            String text = this.xml.getAttributeValue("name");
            String string = result = StringUtil.isEmptyString((String)text) ? "* \u53c2\u6570\u65e0\u540d *" : text;
            if (this.xml.getChild("array") != null) {
                result = result + " [\u6df1]";
            }
            return result;
        }
    }
}

