/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.impl;

import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.AbstractGroupTableBuilder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.DesignBuilder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.MobileReportWizardModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.ReportType;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.TableType;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.style.TableStyleDesign;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.expans.model.ExtProps;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;

public class GroupTableBuilder
extends AbstractGroupTableBuilder {
    public GroupTableBuilder(KDExt ext, MobileReportWizardModel model, int startRow) {
        super(ext, model);
        this.startRow = startRow;
    }

    @Override
    public void build() {
        super.build();
        this.buildGroup(this.startRow);
        this.buildGroupSa(this.startRow);
    }

    private void buildGroup(int startRow) {
        for (int i = 0; i < this.fieldSize; ++i) {
            if (this.tableModel.getFieldList().get(i) == null) continue;
            String field = this.tableModel.getFieldList().get(i).toString();
            Cell cell = this.sheet.getCell(startRow, i, true);
            cell.setValue(new Variant(field));
            this.buildGroup(startRow + 1, i);
            if (this.isShowSubTotal) {
                this.buildSubTotal(startRow + 2, i, startRow + 1);
            }
            if (!this.isShowTotal) continue;
            if (this.isShowSubTotal) {
                this.buildTotal(startRow + 3, i, startRow + 1);
                continue;
            }
            this.buildTotal(startRow + 2, i, startRow + 1);
        }
    }

    private void buildGroupSa(int startRow) {
        DesignBuilder builder = null;
        switch (this.model.getTableModel().getTableStyle().getDesign()) {
            case CLASSIC3: {
                builder = new Classic3Builder();
                break;
            }
            case CLASSIC4: {
                builder = new Classic4Builder();
                break;
            }
            case ECLIPSE: {
                builder = new EclipseDesign();
                break;
            }
            default: {
                builder = new Classic1Builder();
            }
        }
        builder.build();
    }

    private void buildGroup(int row, int col) {
        this.sheet.getCell(row, col, true).setFormula(this.buildSegmentFormula(this.tableModel.getCurrentDs().getAlias(), this.tableModel.getFieldList().get(col).toString(), col));
    }

    @Override
    public ReportType getReportType() {
        return ReportType.TABLE;
    }

    @Override
    public TableStyleDesign[] getDesigns() {
        return new TableStyleDesign[]{TableStyleDesign.CLASSIC1, TableStyleDesign.CLASSIC2, TableStyleDesign.CLASSIC3, TableStyleDesign.CLASSIC4, TableStyleDesign.ECLIPSE};
    }

    @Override
    public TableType getTableType() {
        return TableType.GROUP;
    }

    private class EclipseDesign
    implements DesignBuilder {
        private EclipseDesign() {
        }

        @Override
        public void build() {
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 1, 0, GroupTableBuilder.this.startRow + 1, 65535).insert(true);
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 1, 0, GroupTableBuilder.this.startRow + 1, 65535).setRowHeight(0);
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 2, 0).setStyle(GroupTableBuilder.this.leftSa, Styles.getEmptySA());
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 2, 0).setStyle(GroupTableBuilder.this.boldSa, Styles.getEmptySA());
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 2, 0).setStyle(GroupTableBuilder.this.wrapTextSa, Styles.getEmptySA());
            String ref = GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 2, 0, true).getName(false, false);
            GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 1, 0, true).getExtProps(true).setHead(ref, true);
            GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 1, 0, true).setFormula("=EXINDEX(" + ref + ")");
            for (int i = 0; i < GroupTableBuilder.this.fieldSize; ++i) {
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow, i).setStyle(GroupTableBuilder.this.titleSa, Styles.getEmptySA());
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 2, i).setStyle(GroupTableBuilder.this.detailSa, Styles.getEmptySA());
                if (GroupTableBuilder.this.isShowSubTotal) {
                    GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 3, i).setStyle(GroupTableBuilder.this.subTotalSa, Styles.getEmptySA());
                }
                if (!GroupTableBuilder.this.isShowTotal) continue;
                if (GroupTableBuilder.this.isShowSubTotal) {
                    GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 4, i).setStyle(GroupTableBuilder.this.totalSa, Styles.getEmptySA());
                    continue;
                }
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 3, i).setStyle(GroupTableBuilder.this.totalSa, Styles.getEmptySA());
            }
            int endRow = GroupTableBuilder.this.startRow + 2;
            if (GroupTableBuilder.this.isShowSubTotal) {
                GroupTableBuilder.this.setFormulaTotal(GroupTableBuilder.this.startRow + 3, 0, "\u5c0f\u8ba1");
                String ref2 = GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 2, 0, false).getName(false, false);
                GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 3, 0, false).getExtProps(true).setHead(ref2, true);
                endRow = GroupTableBuilder.this.startRow + 3;
            }
            if (GroupTableBuilder.this.isShowTotal) {
                if (GroupTableBuilder.this.isShowSubTotal) {
                    GroupTableBuilder.this.setFormulaTotal(GroupTableBuilder.this.startRow + 4, 0, "\u603b\u8ba1");
                    endRow = GroupTableBuilder.this.startRow + 4;
                } else {
                    GroupTableBuilder.this.setFormulaTotal(GroupTableBuilder.this.startRow + 3, 0, "\u603b\u8ba1");
                    endRow = GroupTableBuilder.this.startRow + 3;
                }
            }
            GroupTableBuilder.this.buildSpecialSA(GroupTableBuilder.this.startRow, endRow, true);
            if (GroupTableBuilder.this.isShowSubTotal) {
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 3, 0).setStyle(GroupTableBuilder.this.leftSa, Styles.getEmptySA());
            }
            if (GroupTableBuilder.this.isShowTotal) {
                if (GroupTableBuilder.this.isShowSubTotal) {
                    GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 4, 0).setStyle(GroupTableBuilder.this.leftSa, Styles.getEmptySA());
                } else {
                    GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 3, 0).setStyle(GroupTableBuilder.this.leftSa, Styles.getEmptySA());
                }
            }
        }
    }

    private class Classic4Builder
    implements DesignBuilder {
        private Classic4Builder() {
        }

        @Override
        public void build() {
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 1, 0, GroupTableBuilder.this.startRow + 1, 65535).insert(true);
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 1, 0, GroupTableBuilder.this.startRow + 1, 65535).setRowHeight(1);
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 3, 0, GroupTableBuilder.this.startRow + 3, 65535).insert(true);
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 3, 0, GroupTableBuilder.this.startRow + 3, 65535).setRowHeight(0);
            GroupTableBuilder.this.sheet.getRange(0, 0, 1048575, 0).insert(false);
            GroupTableBuilder.this.sheet.getRange(0, 0, 1048575, 0).setColumnWidth(10);
            GroupTableBuilder.this.sheet.getRange(0, GroupTableBuilder.this.fieldSize + 1, 1048575, GroupTableBuilder.this.fieldSize + 1).insert(false);
            GroupTableBuilder.this.sheet.getRange(0, GroupTableBuilder.this.fieldSize + 1, 1048575, GroupTableBuilder.this.fieldSize + 1).setColumnWidth(10);
            if (GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 2, 1, false) == null) {
                return;
            }
            String ref = GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 2, 1, false).getName(false, false);
            GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 1, 0, true).getExtProps(true).setHead(ref, true);
            GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 2, 0, true).getExtProps(true).setHead(ref, true);
            GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 3, 0, true).getExtProps(true).setHead(ref, true);
            GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 1, 0, true).setFormula("=EXINDEX(" + ref + ")");
            String refIndex = GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 1, 0, false).getName(false, false);
            if (GroupTableBuilder.this.isShowSubTotal) {
                GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 4, 0, true).getExtProps(true).setHead(ref, true);
            }
            for (int i = 0; i < GroupTableBuilder.this.fieldSize + 2; ++i) {
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow, i).setStyle(GroupTableBuilder.this.titleSa, Styles.getEmptySA());
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 2, i).setStyle(GroupTableBuilder.this.whiteSa, Styles.getEmptySA());
                GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 1, i, true).getExtProps(true).getFormulas(true).insert(ExtProps.FORMULA_BACKGROUND, "IF(MOD(" + refIndex + ", 2) = 0, RGB(245, 244, 249), RGB(255, 255, 255))");
                GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 2, i, true).getExtProps(true).getFormulas(true).insert(ExtProps.FORMULA_BACKGROUND, "IF(MOD(" + refIndex + ", 2) = 0, RGB(245, 244, 249), RGB(255, 255, 255))");
                if (GroupTableBuilder.this.isShowSubTotal) {
                    GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 4, i, true).getExtProps(true).getFormulas(true).insert(ExtProps.FORMULA_BACKGROUND, "IF(MOD(" + refIndex + ", 2) = 0, RGB(245, 244, 249), RGB(255, 255, 255))");
                    GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 4, i).setStyle(GroupTableBuilder.this.whiteSa, Styles.getEmptySA());
                }
                if (!GroupTableBuilder.this.isShowTotal) continue;
                if (GroupTableBuilder.this.isShowSubTotal) {
                    GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 5, i).setStyle(GroupTableBuilder.this.totalSa, Styles.getEmptySA());
                    continue;
                }
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 4, i).setStyle(GroupTableBuilder.this.totalSa, Styles.getEmptySA());
            }
            int endRow = GroupTableBuilder.this.startRow + 3;
            if (GroupTableBuilder.this.isShowSubTotal) {
                GroupTableBuilder.this.setFormulaTotal(GroupTableBuilder.this.startRow + 4, 1, "\u5c0f\u8ba1");
            }
            if (GroupTableBuilder.this.isShowTotal) {
                if (GroupTableBuilder.this.isShowSubTotal) {
                    GroupTableBuilder.this.setFormulaTotal(GroupTableBuilder.this.startRow + 5, 1, "\u603b\u8ba1");
                    endRow = GroupTableBuilder.this.startRow + 5;
                } else {
                    GroupTableBuilder.this.setFormulaTotal(GroupTableBuilder.this.startRow + 4, 1, "\u603b\u8ba1");
                    endRow = GroupTableBuilder.this.startRow + 4;
                }
            }
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 2, 1).setStyle(GroupTableBuilder.this.leftSa, Styles.getEmptySA());
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 2, 1).setStyle(GroupTableBuilder.this.boldSa, Styles.getEmptySA());
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 2, 1).setStyle(GroupTableBuilder.this.wrapTextSa, Styles.getEmptySA());
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow, 0, GroupTableBuilder.this.startRow, GroupTableBuilder.this.fieldSize + 1).setStyle(GroupTableBuilder.this.borderSaBottom, Styles.getEmptySA());
            if (GroupTableBuilder.this.isShowSubTotal) {
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 4, 1, GroupTableBuilder.this.startRow + 4, GroupTableBuilder.this.fieldSize).setStyle(GroupTableBuilder.this.borderSaTop, Styles.getEmptySA());
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 4, 0, GroupTableBuilder.this.startRow + 4, GroupTableBuilder.this.fieldSize + 1).setStyle(GroupTableBuilder.this.borderSaBottom, Styles.getEmptySA());
            }
            GroupTableBuilder.this.buildSpecialSA(GroupTableBuilder.this.startRow, endRow, false);
            if (GroupTableBuilder.this.isShowSubTotal) {
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 4, 1).setStyle(GroupTableBuilder.this.leftSa, Styles.getEmptySA());
            }
            if (GroupTableBuilder.this.isShowTotal) {
                if (GroupTableBuilder.this.isShowSubTotal) {
                    GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 5, 1).setStyle(GroupTableBuilder.this.leftSa, Styles.getEmptySA());
                } else {
                    GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 4, 1).setStyle(GroupTableBuilder.this.leftSa, Styles.getEmptySA());
                }
            }
        }
    }

    private class Classic3Builder
    implements DesignBuilder {
        private Classic3Builder() {
        }

        @Override
        public void build() {
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 1, 0, GroupTableBuilder.this.startRow + 1, 65535).insert(true);
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 1, 0, GroupTableBuilder.this.startRow + 1, 65535).setRowHeight(1);
            if (!GroupTableBuilder.this.isShowSubTotal) {
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 3, 0, GroupTableBuilder.this.startRow + 3, 65535).insert(true);
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 3, 0, GroupTableBuilder.this.startRow + 3, 65535).setRowHeight(0);
            }
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 4, 0, GroupTableBuilder.this.startRow + 4, 65535).insert(true);
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 4, 0, GroupTableBuilder.this.startRow + 4, 65535).setRowHeight(8);
            GroupTableBuilder.this.sheet.getRange(0, 0, 1048575, 0).insert(false);
            GroupTableBuilder.this.sheet.getRange(0, 0, 1048575, 0).setColumnWidth(10);
            GroupTableBuilder.this.sheet.getRange(0, GroupTableBuilder.this.fieldSize + 1, 1048575, GroupTableBuilder.this.fieldSize + 1).insert(false);
            GroupTableBuilder.this.sheet.getRange(0, GroupTableBuilder.this.fieldSize + 1, 1048575, GroupTableBuilder.this.fieldSize + 1).setColumnWidth(10);
            if (GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 2, 1, false) == null) {
                return;
            }
            String ref = GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 2, 1, false).getName(false, false);
            GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 1, 0, true).getExtProps(true).setHead(ref, true);
            GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 2, 0, true).getExtProps(true).setHead(ref, true);
            GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 3, 0, true).getExtProps(true).setHead(ref, true);
            GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 4, 0, true).getExtProps(true).setHead(ref, true);
            for (int i = 0; i < GroupTableBuilder.this.fieldSize + 2; ++i) {
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow, i).setStyle(GroupTableBuilder.this.titleSa, Styles.getEmptySA());
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 1, i).setStyle(GroupTableBuilder.this.whiteSa, Styles.getEmptySA());
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 2, i).setStyle(GroupTableBuilder.this.whiteSa, Styles.getEmptySA());
                if (GroupTableBuilder.this.isShowSubTotal) {
                    GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 3, i).setStyle(GroupTableBuilder.this.subTotalSa, Styles.getEmptySA());
                }
                if (!GroupTableBuilder.this.isShowTotal) continue;
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 5, i).setStyle(GroupTableBuilder.this.totalSa, Styles.getEmptySA());
            }
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 1, 0, GroupTableBuilder.this.startRow + 1, GroupTableBuilder.this.fieldSize - 1).setStyle(GroupTableBuilder.this.whiteSa, Styles.getEmptySA());
            if (GroupTableBuilder.this.isShowSubTotal) {
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 4, 0, GroupTableBuilder.this.startRow + 4, GroupTableBuilder.this.fieldSize + 1).setStyle(GroupTableBuilder.this.whiteSa, Styles.getEmptySA());
            } else {
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 3, 0, GroupTableBuilder.this.startRow + 3, GroupTableBuilder.this.fieldSize + 1).setStyle(GroupTableBuilder.this.whiteSa, Styles.getEmptySA());
            }
            int endRow = GroupTableBuilder.this.startRow + 2;
            if (GroupTableBuilder.this.isShowSubTotal) {
                GroupTableBuilder.this.setFormulaTotal(GroupTableBuilder.this.startRow + 3, 1, "\u5c0f\u8ba1");
                endRow = GroupTableBuilder.this.startRow + 3;
            }
            if (GroupTableBuilder.this.isShowTotal) {
                GroupTableBuilder.this.setFormulaTotal(GroupTableBuilder.this.startRow + 5, 1, "\u603b\u8ba1");
                endRow = GroupTableBuilder.this.startRow + 5;
            }
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 2, 1).setStyle(GroupTableBuilder.this.boldSa, Styles.getEmptySA());
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 2, 1).setStyle(GroupTableBuilder.this.leftSa, Styles.getEmptySA());
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 2, 1).setStyle(GroupTableBuilder.this.wrapTextSa, Styles.getEmptySA());
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 1, 0, GroupTableBuilder.this.startRow + 3, GroupTableBuilder.this.fieldSize + 1).setStyle(GroupTableBuilder.this.borderSa, Styles.getEmptySA());
            GroupTableBuilder.this.buildSpecialSA(GroupTableBuilder.this.startRow, endRow, false);
            if (GroupTableBuilder.this.isShowSubTotal) {
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 3, 1).setStyle(GroupTableBuilder.this.leftSa, Styles.getEmptySA());
            }
            if (GroupTableBuilder.this.isShowTotal) {
                if (GroupTableBuilder.this.isShowSubTotal) {
                    GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 5, 1).setStyle(GroupTableBuilder.this.leftSa, Styles.getEmptySA());
                } else {
                    GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 4, 1).setStyle(GroupTableBuilder.this.leftSa, Styles.getEmptySA());
                }
            }
        }
    }

    private class Classic1Builder
    implements DesignBuilder {
        private Classic1Builder() {
        }

        @Override
        public void build() {
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 1, 0, GroupTableBuilder.this.startRow + 1, 65535).insert(true);
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 1, 0, GroupTableBuilder.this.startRow + 1, 65535).setRowHeight(0);
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 2, 0).setStyle(GroupTableBuilder.this.leftSa, Styles.getEmptySA());
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 2, 0).setStyle(GroupTableBuilder.this.boldSa, Styles.getEmptySA());
            GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 2, 0).setStyle(GroupTableBuilder.this.wrapTextSa, Styles.getEmptySA());
            String ref = GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 2, 0, true).getName(false, false);
            String refIndex = GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 1, 0, true).getName(false, false);
            GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 1, 0, true).getExtProps(true).setHead(ref, true);
            GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 1, 0, true).setFormula("=EXINDEX(" + ref + ")");
            for (int i = 0; i < GroupTableBuilder.this.fieldSize; ++i) {
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow, i).setStyle(GroupTableBuilder.this.titleSa, Styles.getEmptySA());
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 2, i).setStyle(GroupTableBuilder.this.whiteSa, Styles.getEmptySA());
                if (TableStyleDesign.CLASSIC2 == GroupTableBuilder.this.tableStyle.getDesign()) {
                    GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 2, i, true).getExtProps(true).getFormulas(true).insert(ExtProps.FORMULA_BACKGROUND, "IF(MOD(" + refIndex + ", 2) = 0, RGB(245, 244, 249), RGB(255, 255, 255))");
                }
                if (GroupTableBuilder.this.isShowSubTotal) {
                    GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 3, i).setStyle(GroupTableBuilder.this.subTotalSa, Styles.getEmptySA());
                }
                if (!GroupTableBuilder.this.isShowTotal) continue;
                if (GroupTableBuilder.this.isShowSubTotal) {
                    GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 4, i).setStyle(GroupTableBuilder.this.totalSa, Styles.getEmptySA());
                    continue;
                }
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 3, i).setStyle(GroupTableBuilder.this.totalSa, Styles.getEmptySA());
            }
            if (TableStyleDesign.CLASSIC2 == GroupTableBuilder.this.tableStyle.getDesign()) {
                GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 2, 0, true).getExtProps(true).getFormulas(true).insert(ExtProps.FORMULA_BACKGROUND, "IF(MOD(" + refIndex + ", 2) = 0, RGB(245, 244, 249), RGB(255, 255, 255))");
            }
            int endRow = GroupTableBuilder.this.startRow + 2;
            if (GroupTableBuilder.this.isShowSubTotal) {
                GroupTableBuilder.this.setFormulaTotal(GroupTableBuilder.this.startRow + 3, 0, "\u5c0f\u8ba1");
                String ref2 = GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 2, 0, false).getName(false, false);
                GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 3, 0, false).getExtProps(true).setHead(ref2, true);
                endRow = GroupTableBuilder.this.startRow + 3;
            }
            if (GroupTableBuilder.this.isShowTotal) {
                if (GroupTableBuilder.this.isShowSubTotal) {
                    GroupTableBuilder.this.setFormulaTotal(GroupTableBuilder.this.startRow + 4, 0, "\u603b\u8ba1");
                    endRow = GroupTableBuilder.this.startRow + 4;
                } else {
                    GroupTableBuilder.this.setFormulaTotal(GroupTableBuilder.this.startRow + 3, 0, "\u603b\u8ba1");
                    endRow = GroupTableBuilder.this.startRow + 3;
                }
            }
            GroupTableBuilder.this.buildSpecialSA(GroupTableBuilder.this.startRow, endRow, true);
            if (GroupTableBuilder.this.isShowSubTotal) {
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 3, 0).setStyle(GroupTableBuilder.this.leftSa, Styles.getEmptySA());
            }
            if (GroupTableBuilder.this.isShowTotal) {
                if (GroupTableBuilder.this.isShowSubTotal) {
                    GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 4, 0).setStyle(GroupTableBuilder.this.leftSa, Styles.getEmptySA());
                } else {
                    GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 3, 0).setStyle(GroupTableBuilder.this.leftSa, Styles.getEmptySA());
                }
            }
            if (TableStyleDesign.CLASSIC1 == GroupTableBuilder.this.tableStyle.getDesign()) {
                if (!GroupTableBuilder.this.isShowSubTotal) {
                    GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 3, 0, GroupTableBuilder.this.startRow + 3, 65535).insert(true);
                    GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 3, 0, GroupTableBuilder.this.startRow + 3, 65535).setRowHeight(1);
                    GroupTableBuilder.this.sheet.getCell(GroupTableBuilder.this.startRow + 3, 0, true).getExtProps(true).setHead(ref, true);
                    GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 3, 0, GroupTableBuilder.this.startRow, GroupTableBuilder.this.fieldSize - 1).setStyle(GroupTableBuilder.this.borderSaBottom, Styles.getEmptySA());
                }
                GroupTableBuilder.this.sheet.getRange(GroupTableBuilder.this.startRow + 1, 0, GroupTableBuilder.this.startRow + 1, 65535).delete(true);
            }
        }
    }
}

