/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.showcase;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.pe.beans.editor.formula.FormulaComposer;
import com.kingdee.bos.ctrl.ext.ui.wizards.showcase.MobileDisplayInfo;
import com.kingdee.bos.ctrl.ext.ui.wizards.showcase.TreeDisplayMode;
import com.kingdee.bos.ctrl.ext.ui.wizards.showcase.WaterMarkInfo;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDComboBoxItem;
import com.kingdee.bos.ctrl.swing.KDComboColor;
import com.kingdee.bos.ctrl.swing.KDFontChooser;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class MobileReportViewConstraintsPanel
extends KDPanel {
    private KDRadioButton radioTree;
    private KDRadioButton radioDrill;
    private KDCheckBox zoomBox = new KDCheckBox("\u53cc\u51fb\u7f29\u653e");
    KDComboBox WaterMarkbox;
    private FormulaComposer macroText;
    private KDTextField otherText;
    private KDFontChooser font;
    private KDComboColor fontColor;
    private KDTextField transparency;
    private KDSpinner angleSpin;
    private KDSpinner fontSizeSpin;

    MobileReportViewConstraintsPanel() {
        KDPanel treeModePanel = this.createTreeModePanel();
        KDPanel descPanel = this.createDescriptionPanel();
        KDPanel waterMarkPanel = this.createWaterMarkPanel();
        TableLayout2 layout = new TableLayout2(3, 2);
        layout.setFixedHeight(0, 20);
        layout.setFixedHeight(1, 85);
        layout.setRatableHeight(2, 1);
        layout.setRowSpacing(0, 10);
        layout.setColSpacing(0, 10);
        this.setLayout((LayoutManager)layout);
        this.add((Component)this.zoomBox, TableLayout2.param((int)0, (int)0));
        this.add((Component)treeModePanel, TableLayout2.param((int)1, (int)0));
        this.add((Component)waterMarkPanel, TableLayout2.param((int)2, (int)0));
        this.add((Component)descPanel, TableLayout2.param((int)0, (int)1, (int)2, (int)1));
        this.setCustomInsets(new Insets(10, 10, 10, 10));
    }

    private KDPanel createTreeModePanel() {
        KDPanel panel = new KDPanel();
        panel.setBorder((Border)BorderFactory.createTitledBorder("\u6811\u578b\u62a5\u8868\u5c55\u793a\u6a21\u5f0f"));
        this.radioTree = new KDRadioButton(TreeDisplayMode.EXPAND.getAlias());
        this.radioDrill = new KDRadioButton(TreeDisplayMode.DRILL.getAlias());
        KDButtonGroup btnGroup = new KDButtonGroup();
        this.radioTree.setSelected(true);
        btnGroup.add((AbstractButton)this.radioTree);
        btnGroup.add((AbstractButton)this.radioDrill);
        panel.setLayout(null);
        this.radioTree.setBounds(10, 25, 80, 20);
        panel.add((Component)this.radioTree);
        panel.add((Component)this.radioDrill);
        this.radioDrill.setBounds(10, 50, 80, 20);
        return panel;
    }

    private KDPanel createWaterMarkPanel() {
        KDPanel panel = new KDPanel();
        panel.setLayout(null);
        panel.setBorder((Border)BorderFactory.createTitledBorder("\u6c34\u5370\u8bbe\u7f6e"));
        int y = 25;
        this.macroText = new FormulaComposer();
        this.otherText = new KDTextField();
        this.font = new KDFontChooser();
        this.fontColor = new KDComboColor();
        this.transparency = new KDTextField();
        this.angleSpin = new KDSpinner();
        this.fontSizeSpin = new KDSpinner();
        this.WaterMarkbox = new KDComboBox();
        KDComboBoxItem yesItem = new KDComboBoxItem("\u662f");
        KDComboBoxItem noItem = new KDComboBoxItem("\u5426");
        this.WaterMarkbox.addItem((Object)yesItem);
        this.WaterMarkbox.addItem((Object)noItem);
        this.WaterMarkbox.setSelectedIndex(1);
        KDLabelContainer lc = new KDLabelContainer();
        lc.setBoundLabelText("\u662f\u5426\u6c34\u5370");
        lc.setBoundEditor((JComponent)this.WaterMarkbox);
        lc.setBoundLabelLength(100);
        lc.setBounds(10, y, 220, 20);
        panel.add((Component)lc);
        lc = new KDLabelContainer();
        lc.setBoundLabelText("\u5b8f\u5b9a\u4e49");
        lc.setBoundEditor((JComponent)((Object)this.macroText));
        lc.setBoundLabelLength(100);
        lc.setBounds(10, y += 30, 220, 20);
        panel.add((Component)lc);
        y += 30;
        this.otherText.setText("\u79fb\u52a8\u62a5\u8868");
        lc = new KDLabelContainer();
        lc.setBoundLabelText("\u81ea\u5b9a\u4e49\u6587\u5b57");
        lc.setBoundEditor((JComponent)this.otherText);
        lc.setBoundLabelLength(100);
        lc.setBounds(10, y, 220, 20);
        panel.add((Component)lc);
        lc = new KDLabelContainer();
        lc.setBoundLabelText("\u5b57\u4f53");
        lc.setBoundEditor((JComponent)this.font);
        lc.setBoundLabelLength(100);
        lc.setBounds(10, y += 30, 220, 20);
        panel.add((Component)lc);
        y += 30;
        this.fontSizeSpin.setValue((Object)12);
        KDLabelContainer lbcfontSize = new KDLabelContainer((JComponent)this.fontSizeSpin);
        lbcfontSize.setBoundLabelText("px");
        lbcfontSize.setBoundLabelAlignment(3);
        lbcfontSize.getBoundLabel().setHorizontalAlignment(2);
        lc = new KDLabelContainer();
        lc.setBoundLabelText("\u5b57\u4f53\u5927\u5c0f");
        lc.setBoundEditor((JComponent)lbcfontSize);
        lc.setBoundLabelLength(100);
        lc.setBounds(10, y, 150, 20);
        panel.add((Component)lc);
        lc = new KDLabelContainer();
        lc.setBoundLabelText("\u5b57\u4f53\u989c\u8272");
        lc.setBoundEditor((JComponent)this.fontColor);
        lc.setBoundLabelLength(100);
        lc.setBounds(10, y += 30, 220, 20);
        panel.add((Component)lc);
        y += 30;
        this.angleSpin.setValue((Object)15);
        KDLabelContainer lbcRotate = new KDLabelContainer((JComponent)this.angleSpin);
        lbcRotate.setBoundLabelText("\u5ea6");
        lbcRotate.setBoundLabelAlignment(3);
        lbcRotate.getBoundLabel().setHorizontalAlignment(2);
        lc = new KDLabelContainer();
        lc.setBoundLabelText("\u503e\u659c\u5ea6");
        lc.setBoundEditor((JComponent)lbcRotate);
        lc.setBoundLabelLength(100);
        lc.setBounds(10, y, 150, 20);
        panel.add((Component)lc);
        y += 30;
        lc = new KDLabelContainer();
        lc.setBoundLabelText("\u900f\u660e\u5ea6");
        this.transparency.setText("0.25");
        lc.setBoundEditor((JComponent)this.transparency);
        lc.setBoundLabelLength(100);
        lc.setBounds(10, y, 220, 20);
        panel.add((Component)lc);
        return panel;
    }

    private KDPanel createDescriptionPanel() {
        KDLabel label = new KDLabel("\u4f7f\u7528\u8bf4\u660e");
        KDTextArea area = new KDTextArea();
        area.setEnabled(false);
        area.setText("\u6811\u578b\u62a5\u8868\u5c55\u793a\u6a21\u5f0f\uff1a\u5355\u5143\u683c\u8868\u8fbe\u5f0f\u4f7f\u7528\u4e86TREE\u51fd\u6570\u7684\u62a5\u8868\uff0c\u5728\u624b\u673a\u7aef\u8bbf\u95ee\u65f6\u652f\u6301\u4e24\u79cd\u5c55\u793a\u6a21\u5f0f\uff1a\n\u6811\u5f62\u6a21\u5f0f\uff1a\u901a\u8fc7\u5c55\u5f00\u548c\u6536\u8d77\u7684\u65b9\u5f0f\u8fdb\u884c\u64cd\u4f5c\n\u94bb\u53d6\u6a21\u5f0f\uff1a\u901a\u8fc7\u4e0b\u94bb\u64cd\u4f5c\u6765\u67e5\u770b\u4e0b\u7ea7\u8282\u70b9\u7684\u6570\u636e\uff0c\u901a\u8fc7\u4e0a\u94bb\u64cd\u4f5c\u8fd4\u56de\u5230\u4e0a\u4e00\u7ea7\uff0c\u6b64\u6a21\u5f0f\u9ed8\u8ba4\u53ea\u80fd\u5c55\u5f00\u5230\u7b2c1\u6216\u7b2c2\u7ea7\n\n\u6c34\u5370\u8bbe\u7f6e\u8bf4\u660e\uff1a\n1.\u6c34\u5370\u6587\u5b57 =\u5b8f\u6587\u5b57+\u81ea\u5b9a\u4e49\u6587\u5b57 \n2.\u900f\u660e\u5ea6\u6570\u503c\u8d8a\u4f4e\uff0c\u6c34\u5370\u8d8a\u900f\u660e\uff0c\u6b64\u900f\u660e\u503c\u5bf9\u5e94css\u7684\u900f\u660e\u503c \n3.\u9ed8\u8ba4\u4e0d\u5f00\u542f\u6c34\u5370\uff0c\u9700\u8981\u6c34\u5370\u7684\u9009\u7b2c\u4e00\u9879\u7684\u201c\u662f\u201d\u9009\u9879");
        KDPanel panel = new KDPanel();
        TableLayout2 layout = new TableLayout2(2, 1);
        layout.setFixedHeight(0, 20);
        layout.setRatableHeight(1, 1);
        panel.setLayout((LayoutManager)layout);
        panel.add((Component)label, (Object)TableLayout2.param((int)0, (int)0));
        panel.add((Component)area, (Object)TableLayout2.param((int)1, (int)0));
        return panel;
    }

    MobileDisplayInfo syncUItoModel() {
        MobileDisplayInfo info = new MobileDisplayInfo();
        info.treeMode = this.getTreeDisplayMode();
        info.isClickZoom = this.zoomBox.isSelected();
        return info;
    }

    WaterMarkInfo syncUItoWaterModel() {
        WaterMarkInfo info = new WaterMarkInfo();
        info.setOpen(this.WaterMarkbox.getSelectedIndex() == 0);
        info.setMacroText(this.macroText.getFormula());
        info.setOtherText(this.otherText.getText());
        info.setFont(this.font.getSelectionFont().getFamily());
        info.setFontSizeSpin(this.fontSizeSpin.getIntegerVlaue());
        Color cl = this.fontColor.getColor();
        int redTmp = cl.getRed();
        int greenTmp = cl.getGreen();
        int blueTmp = cl.getBlue();
        int alphaTmp = cl.getAlpha();
        String rgbaTmp = "RGBA(" + redTmp + "," + greenTmp + "," + blueTmp + "," + alphaTmp + ")";
        info.setFontColor(rgbaTmp);
        info.setAngleSpin(this.angleSpin.getIntegerVlaue());
        info.setTransparency(Float.valueOf(this.transparency.getText()).floatValue());
        return info;
    }

    void syncModeToUI(MobileDisplayInfo displayInfo) {
        this.zoomBox.setSelected(displayInfo.isClickZoom);
        this.setTreeDisplayMode(displayInfo.treeMode);
    }

    void syncWaterModeToUI(WaterMarkInfo info) {
        if (info != null) {
            this.WaterMarkbox.setSelectedIndex(info.isOpen() ? 0 : 1);
            this.macroText.setFormula(info.getMacroText());
            this.otherText.setText(info.getOtherText());
            this.font.setFontFamily(info.getFont());
            this.fontSizeSpin.setValue((Object)info.getFontSizeSpin());
            String c = info.getFontColor();
            if (null != c) {
                String t = c.substring(c.indexOf(40) + 1, c.indexOf(41));
                String[] s = t.split(",");
                this.fontColor.setColor(new Color(Integer.valueOf(s[0]), Integer.valueOf(s[1]), Integer.valueOf(s[2]), Integer.valueOf(s[3])));
            }
            this.angleSpin.setValue((Object)info.getAngleSpin());
            this.transparency.setText(String.valueOf(info.getTransparency()));
        }
    }

    private String getTreeDisplayMode() {
        if (this.radioTree.isSelected()) {
            return TreeDisplayMode.EXPAND.name();
        }
        if (this.radioDrill.isSelected()) {
            return TreeDisplayMode.DRILL.name();
        }
        throw new IllegalStateException("error radio selected!");
    }

    private void setTreeDisplayMode(String treeDisplayMode) {
        if (StringUtil.isEmptyString((String)treeDisplayMode) || TreeDisplayMode.EXPAND.name().equalsIgnoreCase(treeDisplayMode)) {
            this.radioTree.setSelected(true);
        } else if (TreeDisplayMode.DRILL.name().equalsIgnoreCase(treeDisplayMode)) {
            this.radioDrill.setSelected(true);
        } else {
            throw new IllegalStateException("error treeDisplayMode: " + treeDisplayMode);
        }
    }
}

