/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.extcommon.digitalstyle;

import com.kingdee.bos.ctrl.extcommon.digitalstyle.DigitDecorateCondition;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.FormatResult;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.LanguageCondition;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.SimpleFormat;
import com.kingdee.bos.ctrl.extcommon.variant.IVarReferences;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kds.model.struct.node.CellBlockNode;
import java.math.BigDecimal;
import java.util.Calendar;

class DigitDecorateFormat
extends SimpleFormat {
    DigitDecorateCondition _nc;
    LanguageCondition _lc;
    private SimpleFormat _format;

    DigitDecorateFormat(SimpleFormat format) {
        this._format = format;
    }

    void setNumberCondition(DigitDecorateCondition nc) {
        this._nc = nc;
    }

    void setLanguageCondition(LanguageCondition lc) {
        this._lc = lc;
    }

    SimpleFormat getActualFormat() {
        return this._format;
    }

    private boolean inCondition(Variant obj, boolean parse) {
        if (null == obj) {
            return false;
        }
        try {
            BigDecimal bd = null;
            if (parse || obj.isNumber() || obj.isDate()) {
                bd = obj.toBigDecimal();
            } else {
                Variant var = obj.getVariant();
                Object value = var.getValue();
                if (var.isNumber()) {
                    bd = var.toBigDecimal();
                } else if (var.isReferences() && value != null && value instanceof CellBlockNode) {
                    bd = ((IVarReferences)value).getActualValue().toBigDecimal();
                }
            }
            if (bd == null) {
                return false;
            }
            if (this._nc == null) {
                return true;
            }
            return this._nc.inCondition(bd);
        }
        catch (SyntaxErrorException e) {
            try {
                Calendar cal = null;
                if (parse) {
                    cal = obj.toCalendar();
                }
                if (cal == null) {
                    return false;
                }
                if (this._nc == null) {
                    return true;
                }
                return this._nc.inCondition(new Variant(cal).toBigDecimal());
            }
            catch (SyntaxErrorException e2) {
                return false;
            }
        }
    }

    @Override
    public FormatResult format(Variant obj, boolean parse) {
        FormatResult result = FormatResult.NullResult;
        if (this._format != null && (!this._format.isDigitCondition() || this.inCondition(obj, parse))) {
            result = this._format.format(obj, parse);
            if (this._lc != null) {
                result.setText(this._lc.translate2(result.getText()));
            }
        }
        return result;
    }

    @Override
    public boolean formatStyle(Variant var, StyleAttributes retSa, boolean parse) {
        if (this._format != null && (!this._format.isDigitCondition() || this.inCondition(var, parse))) {
            this._format.formatStyle(var, retSa, parse);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.toStringFormat();
    }

    @Override
    public String toStringFormat() {
        StringBuffer sb = new StringBuffer();
        if (this._lc != null) {
            sb.append(this._lc.toString());
        }
        if (this._nc != null) {
            sb.append(this._nc.toString());
        }
        sb.append(this.getActualFormat().toString());
        return sb.toString();
    }
}

