/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.extcommon.digitalstyle;

import com.kingdee.bos.ctrl.extcommon.digitalstyle.Format;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.FormatResult;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.Formats;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import java.util.HashMap;
import java.util.Map;

class NumMultiLanFormat {
    private static Map LAN_STRATEGY;

    NumMultiLanFormat() {
    }

    private static Map getStrategy() {
        if (LAN_STRATEGY == null) {
            LAN_STRATEGY = new HashMap();
            LAN_STRATEGY.put("ENG", new EnglishSay());
        }
        return LAN_STRATEGY;
    }

    public String formatNumber(Variant value, String lan) {
        IMultiLanguageSay strategy = (IMultiLanguageSay)NumMultiLanFormat.getStrategy().get(lan.toUpperCase());
        if (strategy != null) {
            return strategy.sayNumber(value);
        }
        return value.toString();
    }

    public String formatCurrency(Variant value, String lan, String currencyIsoCode) {
        IMultiLanguageSay strategy = (IMultiLanguageSay)NumMultiLanFormat.getStrategy().get(lan.toUpperCase());
        if (strategy != null) {
            return strategy.sayCurrency(value, currencyIsoCode);
        }
        return value.toString();
    }

    private static String formatToString(Variant value, String formatString) {
        Format format = Formats.getFormat(formatString);
        FormatResult result = format.format(value);
        return result.toString();
    }

    private static String[] pickIntAndDec(String strValue) {
        int idxDot = strValue.indexOf(46);
        String strInteger = null;
        String strDecimal = null;
        if (idxDot < 0) {
            strInteger = strValue;
        } else if (idxDot == 0) {
            if (strValue.length() > 1) {
                strDecimal = strValue.substring(1);
            }
        } else if (idxDot == strValue.length() - 1) {
            if (strValue.length() > 1) {
                strInteger = strValue.substring(0, idxDot);
            }
        } else {
            strInteger = strValue.substring(0, idxDot);
            strDecimal = strValue.substring(idxDot + 1);
        }
        return new String[]{strInteger, strDecimal};
    }

    private static String[] splitInt(String strInteger) {
        if (strInteger == null) {
            return new String[0];
        }
        if (strInteger.length() < 4) {
            return new String[]{strInteger};
        }
        return strInteger.split(",");
    }

    private static int rightString(String str, int idx) {
        idx = str.length() - idx;
        if (idx < 0) {
            return 0;
        }
        return Integer.parseInt(str.substring(idx, idx + 1));
    }

    private static class EnglishSay
    implements IMultiLanguageSay {
        private static final String[] BASES = new String[]{"ZERO", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE", "TEN", "ELEVEN", "TWELVE", "THIRTEEN", "FOURTEEN", "FIFTEEN", "SIXTEEN", "SEVENTEEN", "EIGHTEEN", "NINETEEN"};
        private static final String[] TENS = new String[]{null, null, "TWENTY", "THIRTY", "FORTY", "FIFTY", "SIXTY", "SEVENTY", "EIGHTY", "NINETY"};
        private static final String[] UNITS = new String[]{null, "THOUSAND", "MILLION", "BILLION", "TRILLION", "ZILLION"};
        private static final String HUNDRED = "HUNDRED";
        private static final String SPACE = " ";
        private static final String AND = "AND";

        private EnglishSay() {
        }

        @Override
        public String sayNumber(Variant value) {
            StringBuffer sbSaying = new StringBuffer();
            String[] intAndDec = NumMultiLanFormat.pickIntAndDec(value.toString());
            if (intAndDec[0] != null) {
                String strInteger = NumMultiLanFormat.formatToString(new Variant(intAndDec[0]), "#,##0");
                try {
                    sbSaying.append(this.sayInteger(strInteger));
                }
                catch (NumberFormatException ex) {
                    return value.toString();
                }
            } else {
                sbSaying.append(BASES[0]);
            }
            if (intAndDec[1] != null) {
                sbSaying.append(SPACE);
                sbSaying.append("POINT");
                for (int i = 0; i < intAndDec[1].length(); ++i) {
                    sbSaying.append(SPACE);
                    try {
                        sbSaying.append(BASES[Integer.parseInt(String.valueOf(intAndDec[1].charAt(i)))]);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        return value.toString();
                    }
                }
            }
            return sbSaying.toString();
        }

        @Override
        public String sayCurrency(Variant value, String currencyIsoCode) {
            StringBuffer sbSaying = new StringBuffer("SAY");
            sbSaying.append(SPACE);
            sbSaying.append(currencyIsoCode.toUpperCase());
            sbSaying.append(SPACE);
            String strValue = NumMultiLanFormat.formatToString(value, "#,##0.00");
            String[] intAndDec = NumMultiLanFormat.pickIntAndDec(strValue);
            if (intAndDec[0] != null) {
                try {
                    sbSaying.append(this.sayInteger(intAndDec[0]));
                }
                catch (NumberFormatException ex) {
                    return value.toString();
                }
            }
            if (intAndDec[1] != null && !"00".equals(intAndDec[1])) {
                sbSaying.append(SPACE);
                sbSaying.append(AND);
                sbSaying.append(SPACE);
                sbSaying.append(intAndDec[1]);
                sbSaying.append("/100");
            }
            sbSaying.append(SPACE);
            sbSaying.append("ONLY");
            return sbSaying.toString();
        }

        private String sayInteger(String strInteger) {
            if ("0".equals(strInteger)) {
                return BASES[0];
            }
            StringBuffer sbSaying = new StringBuffer();
            String[] ints = NumMultiLanFormat.splitInt(strInteger);
            int segLen = ints.length;
            for (int i = 0; i < segLen; ++i) {
                int lessHundred;
                int oneBit;
                int tenBit;
                int hundredBit = NumMultiLanFormat.rightString(ints[i], 3);
                if (hundredBit + (tenBit = NumMultiLanFormat.rightString(ints[i], 2)) + (oneBit = NumMultiLanFormat.rightString(ints[i], 1)) == 0) continue;
                if (i > 0) {
                    sbSaying.append(SPACE);
                }
                if (hundredBit > 0) {
                    sbSaying.append(BASES[hundredBit]);
                    sbSaying.append(SPACE);
                    sbSaying.append(HUNDRED);
                }
                if ((lessHundred = tenBit * 10 + oneBit) > 0) {
                    if (hundredBit > 0) {
                        sbSaying.append(SPACE);
                        sbSaying.append(AND);
                        sbSaying.append(SPACE);
                    } else if (i == segLen - 1 && segLen > 1) {
                        sbSaying.append(AND);
                        sbSaying.append(SPACE);
                    }
                    if (tenBit < 2) {
                        sbSaying.append(BASES[lessHundred]);
                    } else {
                        sbSaying.append(TENS[tenBit]);
                        if (oneBit > 0) {
                            sbSaying.append(SPACE);
                            sbSaying.append(BASES[oneBit]);
                        }
                    }
                }
                String unit = null;
                int idxUnit = segLen - 1 - i;
                unit = idxUnit >= UNITS.length ? "Impossiblellion" : UNITS[idxUnit];
                if (unit == null) continue;
                sbSaying.append(SPACE);
                sbSaying.append(unit);
            }
            return sbSaying.toString();
        }
    }

    private static interface IMultiLanguageSay {
        public String sayNumber(Variant var1);

        public String sayCurrency(Variant var1, String var2);
    }
}

