/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.extcommon.util;

import com.kingdee.bos.ctrl.common.KDToolkit;
import java.io.Serializable;
import java.util.Arrays;

public class ObjectArray
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8070335813395513558L;
    protected Object[] _array;
    protected int _count;

    public ObjectArray() {
        this(10);
    }

    public ObjectArray(int initCap) {
        this._array = new Object[initCap];
        this._count = 0;
    }

    public ObjectArray(Object[] array, int count) {
        this.setArray(array, count);
    }

    protected Object clone() {
        ObjectArray array = null;
        try {
            array = (ObjectArray)super.clone();
            array._array = new Object[Math.max(this._count, 2)];
            KDToolkit.arraycopy((Object[])this._array, (int)0, (Object[])array._array, (int)0, (int)this._count);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return array;
    }

    protected int getIncreasedCellsSize() {
        return (this._array.length * 3 >> 1) + 1;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this._array.length) {
            Object[] oldData = this._array;
            int newCapacity = this.getIncreasedCellsSize();
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this._array = new Object[newCapacity];
            KDToolkit.arraycopy((Object[])oldData, (int)0, (Object[])this._array, (int)0, (int)this._count);
        }
    }

    public void setArray(Object[] array, int count) {
        this._array = array;
        this._count = count;
    }

    public Object[] toArray() {
        return this.toArray(null, 0, 0, this._count - 1);
    }

    public Object[] toArray(Object[] array, int destPos) {
        return this.toArray(array, destPos, 0, this._count - 1);
    }

    public Object[] toArray(Object[] dstArray, int dst, int srcFrom, int srcTo) {
        if (this._count == 0 || srcFrom >= this._count || srcFrom > srcTo) {
            return dstArray == null ? new Object[]{} : dstArray;
        }
        int copyCount = srcTo - srcFrom + 1;
        if (dstArray == null || dstArray.length < dst + copyCount) {
            Object[] newArray = new Object[dst + copyCount];
            if (dst > 0) {
                KDToolkit.arraycopy((Object[])dstArray, (int)0, (Object[])newArray, (int)0, (int)dst);
            }
            dstArray = newArray;
        }
        KDToolkit.arraycopy((Object[])this._array, (int)srcFrom, (Object[])dstArray, (int)dst, (int)copyCount);
        return dstArray;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        if (!this.isEmpty()) {
            for (int i = 0; i < this._count; ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                sb.append(this._array[i].toString());
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public int size() {
        return this._count;
    }

    public void clear() {
        if (this._count > 0) {
            Arrays.fill(this._array, 0, this._count, null);
            this._count = 0;
        }
    }

    public boolean isEmpty() {
        return this._count == 0;
    }

    public Object[] getArray() {
        return this._array;
    }

    public Object get(int index) {
        return this._array[index];
    }

    public Object getAt(int index) {
        return this._array[index];
    }

    public Object set(int index, Object element) {
        if (index >= this._count) {
            this._count = index + 1;
        }
        Object oldValue = this._array[index];
        this._array[index] = element;
        return oldValue;
    }

    public Object getLast() {
        return this._count == 0 ? null : this._array[this._count - 1];
    }

    public Object append(Object obj) {
        if (this._count + 1 > this._array.length) {
            Object[] newArray = new Object[this.getIncreasedCellsSize()];
            KDToolkit.arraycopy((Object[])this._array, (int)0, (Object[])newArray, (int)0, (int)this._count);
            this._array = newArray;
        }
        this._array[this._count++] = obj;
        return obj;
    }

    public void appendAll(ObjectArray src) {
        this.insertAll(this._count, src);
    }

    public void appendAll(Object[] objs) {
        if (objs == null || objs.length == 0) {
            return;
        }
        this.insert(objs, 0, this._count, objs.length);
    }

    public void appendAll(Object[] objs, int from, int to) {
        int count;
        if (objs == null || (count = to - from) < 1) {
            return;
        }
        this.insert(objs, from, this._count, count);
    }

    public void insert(int pos, Object obj) {
        if (this._count == 0) {
            this._array[0] = obj;
            this._count = 1;
        } else {
            if (pos < 0) {
                pos = -(pos + 1);
            }
            if (this._count + 1 > this._array.length) {
                Object[] newArray = new Object[this.getIncreasedCellsSize()];
                KDToolkit.arraycopy((Object[])this._array, (int)0, (Object[])newArray, (int)0, (int)pos);
                KDToolkit.arraycopy((Object[])this._array, (int)pos, (Object[])newArray, (int)(pos + 1), (int)(this._count - pos));
                this._array = newArray;
            } else {
                KDToolkit.arraycopy((Object[])this._array, (int)pos, (Object[])this._array, (int)(pos + 1), (int)(this._count - pos));
            }
            this._array[pos] = obj;
            ++this._count;
        }
    }

    public void insert(Object[] objs, int srcPos, int dstPos, int length) {
        if (dstPos > this._array.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this._count + length > this._array.length) {
            Object[] newArray = new Object[this._count + length];
            KDToolkit.arraycopy((Object[])this._array, (int)0, (Object[])newArray, (int)0, (int)dstPos);
            KDToolkit.arraycopy((Object[])this._array, (int)dstPos, (Object[])newArray, (int)(dstPos + length), (int)(this._count - dstPos));
            this._array = newArray;
        }
        KDToolkit.arraycopy((Object[])objs, (int)srcPos, (Object[])this._array, (int)dstPos, (int)length);
        this._count += length;
    }

    public void insertAll(int pos, ObjectArray src) {
        int ins;
        if (pos < 0) {
            pos = -(pos + 1);
        }
        if (this._count + (ins = src.size()) > this._array.length) {
            Object[] newArray = new Object[((this._count + ins) * 3 >> 1) + 1];
            KDToolkit.arraycopy((Object[])this._array, (int)0, (Object[])newArray, (int)0, (int)pos);
            KDToolkit.arraycopy((Object[])this._array, (int)pos, (Object[])newArray, (int)(pos + ins), (int)(this._count - pos));
            this._array = newArray;
        } else {
            KDToolkit.arraycopy((Object[])this._array, (int)pos, (Object[])this._array, (int)(pos + ins), (int)(this._count - pos));
        }
        KDToolkit.arraycopy((Object[])src._array, (int)0, (Object[])this._array, (int)pos, (int)ins);
        this._count += ins;
    }

    public Object remove(Object obj) {
        for (int i = 0; i < this._array.length; ++i) {
            if (this._array[i] != obj) continue;
            return this.removeByPos(i);
        }
        return null;
    }

    public Object removeByPos(int pos) {
        if (pos < 0 || pos >= this._count) {
            return null;
        }
        Object obj = this._array[pos];
        int remain = this._count - (pos + 1);
        if (remain > 0) {
            KDToolkit.arraycopy((Object[])this._array, (int)(pos + 1), (Object[])this._array, (int)pos, (int)remain);
        }
        this._array[--this._count] = null;
        return obj;
    }

    public Object[] removeByPos(int pos, int pos2, boolean bRet) {
        int remain;
        if (pos > pos2 || pos < 0 || pos >= this._count || pos2 >= this._count) {
            return null;
        }
        int len = pos2 - pos + 1;
        Object[] dst = null;
        if (bRet) {
            dst = new Object[len];
            KDToolkit.arraycopy((Object[])this._array, (int)pos, (Object[])dst, (int)0, (int)len);
        }
        if ((remain = this._count - (pos2 + 1)) > 0) {
            KDToolkit.arraycopy((Object[])this._array, (int)(pos2 + 1), (Object[])this._array, (int)pos, (int)remain);
        }
        Arrays.fill(this._array, this._count - len, this._count, null);
        this._count -= len;
        return dst;
    }

    public void trimToSize() {
        int count = Math.max(this._count, 10);
        if (count < this._array.length) {
            Object[] newArray = new Object[count];
            KDToolkit.arraycopy((Object[])this._array, (int)0, (Object[])newArray, (int)0, (int)this._count);
            this._array = newArray;
        }
    }

    public boolean reduce() {
        int oldCount = this._count;
        for (int i = 0; i < this._count; ++i) {
            int to;
            int from = to = i;
            while (to < this._count && this._array[to] == null) {
                ++to;
            }
            if (from == to) continue;
            int remain = this._count - to;
            KDToolkit.arraycopy((Object[])this._array, (int)to, (Object[])this._array, (int)from, (int)remain);
            int offset = to - from;
            Arrays.fill(this._array, this._count - offset, this._count, null);
            this._count -= offset;
        }
        return oldCount != this._count;
    }

    public boolean contains(Object elem) {
        return this.indexOf(elem) >= 0;
    }

    public int indexOf(Object elem) {
        if (elem == null) {
            for (int i = 0; i < this._count; ++i) {
                if (this._array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this._count; ++i) {
                if (!elem.equals(this._array[i])) continue;
                return i;
            }
        }
        return -1;
    }
}

