/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.exec;

import com.kingdee.bos.ctrl.ext.immit.IRptRuntimeCallback;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetFactory;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.bos.ctrl.kds.expans.model.data.IExtDataSetFactory;
import com.kingdee.bos.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ExecutionContext {
    private Book _book;
    private Map _params;
    private Map _cacheObj;
    private IRptRuntimeCallback runtimeCallback;
    private boolean _isUseDemoData;

    public ExecutionContext(Book book) {
        this._book = book;
    }

    public void registerDataSetFactories(Map factories) {
        ExtDataSetManager datasetManager = this._book.getDataSetManager();
        ExtDataSetFactory sheetDataFactory = datasetManager.getExtDataSetFactory();
        for (ExtDataSetType type : factories.keySet()) {
            sheetDataFactory.registerFactory(type, (IExtDataSetFactory)factories.get(type));
        }
    }

    public Map getDataSetFactories() {
        ExtDataSetManager datasetManager = this._book.getDataSetManager();
        ExtDataSetFactory sheetDataFactory = datasetManager.getExtDataSetFactory();
        return sheetDataFactory.getFactorys();
    }

    public void attachDataSetParameters(Map parameters) {
        if (this._params == null) {
            this._params = new HashMap();
        }
        if (parameters != null) {
            this._params.putAll(parameters);
        }
        Iterator it = this._params.entrySet().iterator();
        while (it.hasNext()) {
            IParameter value = (IParameter)it.next().getValue();
            this._book.insertValuedNameObject(value.getParameterPrefix() + value.getName(), value.getValue());
        }
    }

    public void attachDataSetOutputParameters(Map parameters) {
        Iterator it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            IParameter value = (IParameter)it.next().getValue();
            this._book.insertValuedNameObject("@" + value.getName(), value.getValue());
        }
    }

    public Map getDataSetParameters() {
        return this._params;
    }

    public void setDataSetParameters(Map params) {
        this._params = params;
    }

    public IParameter getDataSetParameter(String pName) {
        if (this._params == null) {
            return null;
        }
        return (IParameter)this._params.get(pName);
    }

    public void copyCacheObjectFrom(ExecutionContext ctx) {
        this._cacheObj = ctx._cacheObj;
    }

    public Object getDataSetCacheObject(Object key) {
        if (this._cacheObj == null) {
            return null;
        }
        return this._cacheObj.get(key);
    }

    public void registerDataSetCacheObject(Object key, Object cacheObj) {
        if (this._cacheObj == null) {
            this._cacheObj = new HashMap();
        }
        this._cacheObj.put(key, cacheObj);
    }

    public void registerDataSetCacheObject(Map cacheMap) {
        if (cacheMap == null || cacheMap.isEmpty()) {
            return;
        }
        if (this._cacheObj == null) {
            this._cacheObj = new HashMap();
        }
        this._cacheObj.putAll(cacheMap);
    }

    public void setRptRuntimeCallback(IRptRuntimeCallback rptRun) {
        this.runtimeCallback = rptRun;
    }

    public IRptRuntimeCallback getRptRuntimeCallback() {
        return this.runtimeCallback;
    }

    public Book getBook() {
        return this._book;
    }

    public String getReportId() {
        if (this.runtimeCallback != null) {
            return this.runtimeCallback.getReportId();
        }
        return null;
    }

    public boolean isUseDemoData() {
        return this._isUseDemoData;
    }

    public void setUseDemoData(boolean isUseDemoData) {
        this._isUseDemoData = isUseDemoData;
    }
}

