/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl;

import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.core.ICellEditorProvider;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.impl.facade.PromptPanel;
import com.kingdee.bos.ctrl.kds.impl.facade.editor.CellDiagonalHeaderEditor;
import com.kingdee.bos.ctrl.kds.impl.facade.editor.CellTextEditor;
import com.kingdee.bos.ctrl.kds.impl.facade.editor.ICellEditor;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.DiagonalHeader;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import java.awt.Font;
import java.awt.Image;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.UIDefaults;

public class CellEditManager {
    private SpreadContext _context;
    private Hashtable _defEditors;
    private ICellEditor _curEditor;
    ICellEditorProvider editorProvider;

    public CellEditManager(SpreadContext context) {
        this._context = context;
        this.init();
    }

    private void init() {
        this._defEditors = new UIDefaults();
        this.setLazyValue(this._defEditors, Object.class, "com.kingdee.bos.ctrl.kds.impl.facade.editor.CellTextEditor");
        this.setLazyValue(this._defEditors, DiagonalHeader.class, "com.kingdee.bos.ctrl.kds.impl.facade.editor.CellDiagonalHeaderEditor");
        this.setLazyValue(this._defEditors, Boolean.class, "com.kingdee.bos.ctrl.kds.cell.EditorFactory$BooleanEditor");
        this.setLazyValue(this._defEditors, Date.class, "com.kingdee.bos.ctrl.kds.cell.EditorFactory$DatePickerEditor");
        this.setLazyValue(this._defEditors, Image.class, "com.kingdee.bos.ctrl.kds.cell.EditorFactory$ImageEditor");
    }

    public boolean startEditing() {
        return this.startEditing(null);
    }

    public boolean startEditing(Object condition) {
        if (!this._context.getSpread().isEditable()) {
            return false;
        }
        boolean b = false;
        if (this._curEditor == null) {
            Book book = this._context.getBook();
            Sheet sheet = book.getActiveSheet();
            int row = sheet.getActiveRow();
            int col = sheet.getActiveCol();
            this.checkFont(sheet.getCell(row, col, false));
            this._curEditor = this.getCellEditor(sheet, row, col);
            if (this._curEditor != null && !(this._curEditor instanceof CellDiagonalHeaderEditor)) {
                boolean bl = b = ICellEditor.SUCCESS == this._curEditor.startEditing(this._context, row, col, condition);
            }
            if (!b) {
                this._curEditor = null;
            }
        }
        this._context.getFacadeManager().getPromptPanel().setEditing(b);
        if (b && this._curEditor instanceof CellTextEditor) {
            PromptPanel.LeftPromptPanel lpp = this._context.getFacadeManager().getPromptPanel().getLeftPane();
            lpp.setSyncEnabled(false);
            this._context.getFacadeManager().getPromptPanel().setFormula(((CellTextEditor)this._curEditor).getText());
            lpp.setSyncEnabled(true);
        }
        return b;
    }

    private void checkFont(Cell cll) {
        if (cll == null) {
            return;
        }
        String value = cll.getText();
        if (value == null || value.length() == 0) {
            return;
        }
        ShareStyleAttributes[] ssas = new ShareStyleAttributes[]{cll.getDisplayStyle(), cll.getSheet().getRowSSA(cll.getRow()), cll.getSheet().getColSSA(cll.getCol()), cll.getSheet().getSSA()};
        ShareStyleAttributes ssa = Styles.mergeSSA((ShareStyleAttributes[])ssas);
        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)ssa);
        String fontName = sa.getFontName();
        if (fontName == null || fontName.length() == 0) {
            sa.setFontName("\u5b8b\u4f53");
            cll.setSSA(Styles.getSSA((StyleAttributes)sa));
            return;
        }
        Font font = new Font(fontName, 1, 9);
        if (font.canDisplayUpTo(value) != -1) {
            sa.setFontName("\u5b8b\u4f53");
            cll.setSSA(Styles.getSSA((StyleAttributes)sa));
        }
    }

    public boolean cancelEditing() {
        boolean b = false;
        if (this._curEditor != null) {
            boolean bl = b = ICellEditor.CANCEL == this._curEditor.cancelEditing();
        }
        if (b) {
            this._curEditor = null;
        }
        this._context.getFacadeManager().getPromptPanel().setEditing(!b);
        return b;
    }

    public boolean stopEditing() {
        ICellEditor.ResultType rt = ICellEditor.FAILED;
        if (this._curEditor != null) {
            rt = this._curEditor.stopEditing();
        }
        if (rt != ICellEditor.FAILED) {
            this._curEditor = null;
        }
        if (rt == ICellEditor.CANCEL) {
            this._context.getStateManager().popEditState();
        }
        this._context.getFacadeManager().getPromptPanel().setEditing(rt != ICellEditor.SUCCESS);
        return rt == ICellEditor.SUCCESS;
    }

    public ICellEditor getCurrentEditor() {
        return this._curEditor;
    }

    ICellEditor getCellEditor(Sheet sheet, int row, int col) {
        ICellEditor editor = this.getCustomEditor(sheet, row, col);
        if (editor == null) {
            Class cls = Object.class;
            Cell cell = sheet.getCell(row, col, false);
            if (cell != null && cell.getDiagonalHeader() != null) {
                cls = DiagonalHeader.class;
            }
            editor = this.getDefaultEditor(cls);
        }
        return editor;
    }

    ICellEditor getDefaultEditor(Class c) {
        if (c == null) {
            return null;
        }
        Object editor = this._defEditors.get(c);
        if (editor != null) {
            return (ICellEditor)editor;
        }
        return this.getDefaultEditor(c.getSuperclass());
    }

    private ICellEditor getCustomEditor(Sheet sheet, int row, int col) {
        if (this.editorProvider != null) {
            return this.editorProvider.getEditor(sheet, row, col);
        }
        return null;
    }

    private void setLazyValue(Hashtable h, Class c, String s) {
        h.put(c, new UIDefaults.ProxyLazyValue(s));
    }

    public ICellEditorProvider getEditorProvider() {
        return this.editorProvider;
    }

    public void setEditorProvider(ICellEditorProvider editorProvider) {
        this.editorProvider = editorProvider;
    }
}

