/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.io.kml;

import com.kingdee.bos.ctrl.common.util.SizeOf;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kdf.util.Tools;
import com.kingdee.bos.ctrl.kds.io.IBookFieldFlags;
import com.kingdee.bos.ctrl.kds.io.kml.IKmlConstants;
import com.kingdee.bos.ctrl.kds.io.kml.KmlToBook;
import com.kingdee.bos.ctrl.kds.io.kml.KmlUtil;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class KmlAreaReader
implements IKmlConstants {
    private StringBuffer bufString = new StringBuffer();
    private XmlToBookHandler _handler;
    private DataCache _dataCache;
    private ElementStack _elementStack;

    public static void main(String[] args) throws Exception {
        String key = "sheet1!a1";
        HashMap<String, Object> cells = new HashMap<String, Object>();
        cells.put(key, null);
        SizeOf.startAction();
        try {
            new KmlAreaReader().load("D:\\userfiles\\aa.xml", cells);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SizeOf.endAction();
    }

    private SAXParserFactory createSAXParser() throws Exception {
        SAXParserFactory factory = null;
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(KmlToBook.class.getClassLoader());
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            factory = SAXParserFactory.newInstance();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
            catch (SecurityException securityException) {}
        }
        return factory;
    }

    public void load(InputSource is, HashMap cells) throws Exception {
        SAXParserFactory factory = this.createSAXParser();
        if (null != factory) {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(is, (DefaultHandler)this.createHandler(cells));
        }
    }

    public void load(String file, HashMap cells) throws Exception {
        this.load(new FileInputStream(file), cells);
    }

    public void load(InputStream is, HashMap cells) throws Exception {
        SAXParserFactory factory = this.createSAXParser();
        try {
            if (null != factory) {
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(is, (DefaultHandler)this.createHandler(cells));
            }
        }
        catch (SAXException e) {
            if (e.getException() instanceof CellsLoadCompletedException) {
                return;
            }
            throw e;
        }
    }

    private XmlToBookHandler createHandler(HashMap cells) {
        this._handler = new XmlToBookHandler();
        this._dataCache = new DataCache(cells);
        this._elementStack = new ElementStack();
        this._elementStack.push(new BookElement());
        return this._handler;
    }

    class CellDataElement
    extends AbsElement {
        CellDataElement() {
        }

        @Override
        boolean isCurrentElement(String uri, String localName, String qName) {
            return "Data".equals(KmlUtil.getLocalName(qName));
        }

        @Override
        void startElement(String uri, String localName, String qName, Attributes attributes, ElementStack parserCache, DataCache dataCache) throws SAXException {
            super.startElement(uri, localName, qName, attributes, parserCache, dataCache);
        }

        @Override
        void startElementImpl(String uri, String localName, String qName, Attributes attributes, ElementStack parserCache, DataCache dataCache) throws SAXException {
            if (this.isCurrentElement(uri, localName, qName)) {
                KmlAreaReader.this.bufString.delete(0, KmlAreaReader.this.bufString.length());
                String type = attributes.getValue(KmlUtil.getNSName("Type", NS_SHEET));
                if (!StringUtil.isEmptyString((String)type)) {
                    dataCache.setCurDatatype(type);
                }
            }
        }

        @Override
        void characters(char[] ch, int start, int length, ElementStack parserCache, DataCache dataCache) throws SAXException {
            KmlAreaReader.this.bufString.append(ch, start, length);
        }

        @Override
        void endElement(String uri, String localName, String qName, ElementStack parserCache, DataCache dataCache) throws SAXException {
            super.endElement(uri, localName, qName, parserCache, dataCache);
            if (this.isCurrentElement(uri, localName, qName)) {
                Variant var;
                HashMap condition = dataCache._cells;
                String sheetName = dataCache.getCurSheetName();
                int colIndex = dataCache.getCurCellIndex();
                int rowIndex = dataCache.getCurRowIndex();
                String position = sheetName.toUpperCase() + "!" + Tools.getCharacterFromIndex((int)colIndex) + (rowIndex + 1);
                if (!condition.containsKey(position) && !condition.containsKey(position = sheetName.toLowerCase() + "!" + Tools.getCharacterFromIndex((int)colIndex, (char)'a') + (rowIndex + 1))) {
                    return;
                }
                String type = dataCache.getCurDataType();
                String str = KmlUtil.toBookString(KmlAreaReader.this.bufString.toString());
                if ("String".equals(type)) {
                    var = new Variant(str, 11);
                } else if ("Number".equals(type)) {
                    var = new Variant(new BigDecimal(str), 10);
                } else if ("DateTime".equals(type)) {
                    Calendar cal = Calendar.getInstance();
                    String[] strs = str.split("[-T:.]");
                    cal.set(Integer.parseInt(strs[0]), Integer.parseInt(strs[1]) - 1, Integer.parseInt(strs[2]), Integer.parseInt(strs[3]), Integer.parseInt(strs[4]), Integer.parseInt(strs[5]));
                    if (strs.length > 6) {
                        cal.set(14, Integer.parseInt(strs[6]));
                    }
                    var = new Variant(cal, 13);
                } else {
                    var = "Boolean".equals(type) ? new Variant(str.equals("1") ? Boolean.TRUE : Boolean.FALSE, 8) : Variant.nullVariant;
                }
                condition.put(position, var.getValue());
                if (dataCache.addCellCount()) {
                    throw new SAXException(new CellsLoadCompletedException());
                }
            }
        }
    }

    class CellElement
    extends AbsElement {
        private AbsElement _cde;

        CellElement() {
        }

        @Override
        boolean isCurrentElement(String uri, String localName, String qName) {
            return "Cell".equals(KmlUtil.getLocalName(qName));
        }

        private AbsElement getFitParser(String uri, String localName, String qName) {
            String qqname = KmlUtil.getLocalName(qName);
            if ("Data".equals(qqname)) {
                if (this._cde == null) {
                    this._cde = new CellDataElement();
                }
                return this._cde;
            }
            return null;
        }

        @Override
        void startElementImpl(String uri, String localName, String qName, Attributes attributes, ElementStack parserCache, DataCache dataCache) throws SAXException {
            if (this.isCurrentElement(uri, localName, qName)) {
                int cellColIndex;
                String strCellColIndex = attributes.getValue(KmlUtil.getNSName("Index", NS_SHEET));
                if (strCellColIndex == null) {
                    cellColIndex = 0;
                    if (dataCache.getCurCellIndex() != -1) {
                        cellColIndex = dataCache.getCurCellIndex() + 1;
                    }
                } else {
                    cellColIndex = Integer.parseInt(strCellColIndex) - 1;
                }
                dataCache.setCurCellIndex(cellColIndex);
            } else {
                AbsElement parser = this.getFitParser(uri, localName, qName);
                if (parser != null) {
                    parserCache.push(parser);
                    parser.startElement(uri, localName, qName, attributes, parserCache, dataCache);
                }
            }
        }
    }

    class RowElement
    extends AbsElement {
        private AbsElement _ce;

        RowElement() {
        }

        private AbsElement getFitParser(String uri, String localName, String qName) {
            if ("Cell".equals(KmlUtil.getLocalName(qName))) {
                if (this._ce == null) {
                    this._ce = new CellElement();
                }
                return this._ce;
            }
            return null;
        }

        @Override
        boolean isCurrentElement(String uri, String localName, String qName) {
            return "Row".equals(KmlUtil.getLocalName(qName));
        }

        @Override
        void startElementImpl(String uri, String localName, String qName, Attributes attributes, ElementStack parserCache, DataCache dataCache) throws SAXException {
            if (this.isCurrentElement(uri, localName, qName)) {
                int rowIndex;
                String strRowIndex = attributes.getValue(KmlUtil.getNSName("Index", NS_SHEET));
                if (strRowIndex == null) {
                    rowIndex = 0;
                    int defaultRowIndex = dataCache.getCurRowIndex();
                    if (defaultRowIndex != -1) {
                        rowIndex = defaultRowIndex + 1;
                    }
                } else {
                    rowIndex = Integer.parseInt(strRowIndex) - 1;
                }
                int span = 0;
                String strSpan = attributes.getValue(KmlUtil.getNSName("Span", NS_SHEET));
                if (strSpan != null) {
                    span = Integer.parseInt(strSpan);
                }
                dataCache.setCurRowIndex(rowIndex + span);
            } else {
                AbsElement parser = this.getFitParser(uri, localName, qName);
                if (parser != null) {
                    parserCache.push(parser);
                    parser.startElement(uri, localName, qName, attributes, parserCache, dataCache);
                }
            }
        }
    }

    class SheetElement
    extends AbsElement {
        private AbsElement _re;

        SheetElement() {
        }

        @Override
        boolean isCurrentElement(String uri, String localName, String qName) {
            return "Worksheet".equals(KmlUtil.getLocalName(qName));
        }

        private AbsElement getFitParser(String uri, String localName, String qName) {
            if ("Row".equals(KmlUtil.getLocalName(qName))) {
                if (this._re == null) {
                    this._re = new RowElement();
                }
                return this._re;
            }
            return null;
        }

        @Override
        void startElementImpl(String uri, String localName, String qName, Attributes attributes, ElementStack parserCache, DataCache dataCache) throws SAXException {
            if (this.isCurrentElement(uri, localName, qName)) {
                String sheetName = attributes.getValue(KmlUtil.getNSName("Name", NS_SHEET));
                dataCache.setCurSheetName(sheetName);
            } else {
                AbsElement parser = this.getFitParser(uri, localName, qName);
                if (parser != null) {
                    parserCache.push(parser);
                    parser.startElement(uri, localName, qName, attributes, parserCache, dataCache);
                }
            }
        }
    }

    class BookElement
    extends AbsElement {
        private AbsElement _sheetE;

        BookElement() {
        }

        private AbsElement getFitParser(String uri, String localName, String qName) {
            if ("Worksheet".equals(KmlUtil.getLocalName(qName))) {
                if (this._sheetE == null) {
                    this._sheetE = new SheetElement();
                }
                return this._sheetE;
            }
            return null;
        }

        @Override
        void startElementImpl(String uri, String localName, String qName, Attributes attributes, ElementStack parserCache, DataCache dataCache) throws SAXException {
            AbsElement parser;
            if (!this.isCurrentElement(uri, localName, qName) && (parser = this.getFitParser(uri, localName, qName)) != null) {
                parserCache.push(parser);
                parser.startElement(uri, localName, qName, attributes, parserCache, dataCache);
            }
        }

        @Override
        boolean isCurrentElement(String uri, String localName, String qName) {
            return "Workbook".equals(KmlUtil.getLocalName(qName));
        }
    }

    abstract class AbsElement
    extends IBookFieldFlags
    implements IKmlConstants {
        AbsElement() {
        }

        void startElement(String uri, String localName, String qName, Attributes attributes, ElementStack parserCache, DataCache dataCache) throws SAXException {
            this.startElementImpl(uri, localName, qName, attributes, parserCache, dataCache);
        }

        abstract void startElementImpl(String var1, String var2, String var3, Attributes var4, ElementStack var5, DataCache var6) throws SAXException;

        void endElement(String uri, String localName, String qName, ElementStack parserCache, DataCache dataCache) throws SAXException {
            if (this.isCurrentElement(uri, localName, qName)) {
                parserCache.pop();
            }
        }

        void characters(char[] ch, int start, int length, ElementStack parserCache, DataCache dataCache) throws SAXException {
        }

        abstract boolean isCurrentElement(String var1, String var2, String var3);
    }

    class XmlToBookHandler
    extends DefaultHandler {
        XmlToBookHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            AbsElement parser = KmlAreaReader.this._elementStack.getCurrentParser();
            parser.startElement(uri, localName, qName, attributes, KmlAreaReader.this._elementStack, KmlAreaReader.this._dataCache);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            KmlAreaReader.this._elementStack.getCurrentParser().endElement(uri, localName, qName, KmlAreaReader.this._elementStack, KmlAreaReader.this._dataCache);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            KmlAreaReader.this._elementStack.getCurrentParser().characters(ch, start, length, KmlAreaReader.this._elementStack, KmlAreaReader.this._dataCache);
        }
    }

    static class ElementStack {
        private Stack _parsers = new Stack();

        public void push(AbsElement parser) {
            this._parsers.push(parser);
        }

        public AbsElement pop() {
            return (AbsElement)this._parsers.pop();
        }

        public AbsElement getCurrentParser() {
            return (AbsElement)this._parsers.get(this._parsers.size() - 1);
        }
    }

    static class DataCache {
        private String _sheetName;
        private int _rowIndex = -1;
        private int _cellIndex = -1;
        private String _dataType = "";
        private HashMap _cells;
        private int _requestCount;
        private int _cellCount;

        DataCache(HashMap cells) {
            this._cells = cells;
            this._requestCount = this._cells.size();
        }

        boolean addCellCount() {
            ++this._cellCount;
            return this._requestCount == this._cellCount;
        }

        void setCurRowIndex(int rowIndex) {
            this._rowIndex = rowIndex;
            this._cellIndex = -1;
        }

        int getCurRowIndex() {
            return this._rowIndex;
        }

        void setCurCellIndex(int cellIndex) {
            this._cellIndex = cellIndex;
        }

        int getCurCellIndex() {
            return this._cellIndex;
        }

        String getCurSheetName() {
            return this._sheetName;
        }

        void setCurSheetName(String sheetName) {
            this._sheetName = sheetName;
            this._rowIndex = -1;
        }

        String getCurDataType() {
            return this._dataType;
        }

        void setCurDatatype(String dataType) {
            this._dataType = dataType;
        }
    }

    static class CellsLoadCompletedException
    extends Exception {
        CellsLoadCompletedException() {
        }
    }
}

