/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct;

import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.CellFinder;
import com.kingdee.bos.ctrl.kds.model.struct.Protection;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetAction;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.Size;
import com.kingdee.bos.ctrl.kds.model.struct.SizeWithExclusiveCount;
import com.kingdee.bos.ctrl.kds.model.struct.URState;
import com.kingdee.bos.ctrl.kds.model.struct.UserObject;
import com.kingdee.bos.ctrl.kds.model.struct.borders.Borders;
import com.kingdee.bos.ctrl.kds.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.kds.model.util.SortedCellBlockArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class SheetAction_Replace
extends SheetAction {
    private HashMap _blocks;
    private CellFinder.ICellReplacer _rpl;
    private SizeWithExclusiveCount _sz = new SizeWithExclusiveCount();

    public SheetAction_Replace(Range rg, SortedObjectArray sa, CellFinder.ICellReplacer rpl) {
        super(rg, SheetChangeEvent.Changed_Content | SheetChangeEvent.Changed_Style);
        this._rpl = rpl;
        this._blocks = new HashMap();
        rg._sheets.clear();
        for (int i = sa.size() - 1; i >= 0; --i) {
            Cell cll = (Cell)sa.get(i);
            Sheet sheet = cll.getSheet();
            ArrayList<Cell> tal = (ArrayList<Cell>)this._blocks.get(sheet);
            if (tal == null) {
                tal = new ArrayList<Cell>();
                this._blocks.put(sheet, tal);
                rg._sheets.insert(sheet);
            }
            tal.add(cll);
        }
    }

    Size getReplaced() {
        return this._sz;
    }

    @Override
    protected void actionBlock(URState state, Sheet sheet, CellBlock cb) {
        ArrayList clls = (ArrayList)this._blocks.get(sheet);
        if (clls == null) {
            return;
        }
        Cell cll = (Cell)clls.get(0);
        Cell cll2 = (Cell)clls.get(clls.size() - 1);
        cb = CellBlock.getCellBlock(cll.getRow(), cll.getCol(), cll2.getRow(), cll2.getCol());
        boolean bFormula = this._rpl.canReplaceFormula();
        boolean bStyle = this._rpl.canReplaceStyle();
        boolean bUserObject = this._rpl.canReplaceUseObject();
        int count = 0;
        this._sz.setExclusiveCount(clls.size());
        int size = clls.size();
        for (int i = 0; i < size; ++i) {
            Protection pro;
            cll = (Cell)clls.get(i);
            if (cll.getStyle().isLocked() && (pro = cll.getSheet().getSheetOption().getProtection(false)) != null && pro.isProtected()) continue;
            CellBlock mergeBlock = cll.getMerge(false);
            if (mergeBlock != null) {
                Sheet.ICellsIterator ci = sheet.getCellsIterator(mergeBlock, true, false);
                if (!ci.hasNext()) continue;
                while (ci.hasNext()) {
                    cll = ci.next();
                    count = this.setCellStyle(cll, bFormula, bStyle, bUserObject, state, sheet, mergeBlock, count);
                }
                continue;
            }
            count = this.setCellStyle(cll, bFormula, bStyle, bUserObject, state, sheet, CellBlock.getCellBlock(cll.getRow(), cll.getCol()), count);
        }
        if (count > 0) {
            this._sz.setXY(this._sz.getX() + count, this._sz.getY() + 1);
            this._sz.setExclusiveCount(clls.size() - count);
        }
        this.checkedAutoFilter(sheet, state);
    }

    private int setCellStyle(Cell cll, boolean bFormula, boolean bStyle, boolean bUserObject, URState state, Sheet sheet, CellBlock cb, int count) {
        UserObject obj;
        UserObject newObj;
        StyleAttributes newSA;
        Object[] ao = null;
        if (bFormula) {
            String oldFormula = cll.getFormula();
            String newFormula = this._rpl.getFormula(cll);
            if (newFormula != oldFormula) {
                if (ao == null) {
                    ao = new Object[3];
                }
                ao[0] = oldFormula;
                cll.setFormula(newFormula);
            }
        }
        if (bStyle && (newSA = this._rpl.getSA(cll)) != null) {
            if (ao == null) {
                ao = new Object[3];
            }
            ao[1] = cll.getSSA();
            this.setCellStyle(state, sheet, cll.getRow(), cll.getCol(), cll, (ShareStyleAttributes)newSA, null, null);
            boolean borderChanged = false;
            StyleAttributes replaceSA = this._rpl.getReplaceSA();
            if (replaceSA.isDirtyBorder()) {
                Borders bdrs = sheet.getBorders();
                List borderList = state.get("BDR") == null ? new ArrayList() : (List)state.get("BDR");
                borderList.add(bdrs.setBySA(cb, replaceSA, Styles.getEmptySA(), state != null));
                borderChanged = this.URStore(state, "BDR", borderList);
                SortedCellBlockArray mergeBlocks = sheet.getTouchedMergeBlocks(cb);
                if (borderChanged && mergeBlocks != null) {
                    for (int j = mergeBlocks.size() - 1; j >= 0; --j) {
                        bdrs.clearInner(mergeBlocks.getBlock(j), null);
                    }
                }
            }
        }
        if (bUserObject && (newObj = this._rpl.getUseObject(cll)) != null && !newObj.equals(obj = cll.getUserObject(newObj.getKey()))) {
            if (ao == null) {
                ao = new Object[3];
            }
            cll.setUserObject(newObj);
            ao[2] = obj == null ? newObj.getKey() : obj;
        }
        if (ao != null) {
            this.setCellState(state, cll, ao, null);
            ++count;
        }
        return count;
    }

    private void checkedAutoFilter(Sheet sheet, URState state) {
        CellBlock autoFilterArea = sheet.getAutoFilterArea();
        if (autoFilterArea == null) {
            return;
        }
        CellBlock newArea = new CellBlock(autoFilterArea);
        SheetBaseMath.unCancerizeCellBlock(sheet, newArea);
        if (newArea.getCol() == -1 || newArea.getCol2() == -1 || newArea.getRow() == -1 || newArea.getRow2() == -1) {
            this.colseAutoFilter(sheet, state, autoFilterArea);
            return;
        }
        SheetBaseMath.cancerizeCellBlock(sheet, newArea, false, true, false);
        state.setData("AutoFilterArea", sheet.getAutoFilterArea());
        sheet.setAutoFilterArea(newArea);
        sheet.getBook().fireSheetChange(sheet, null, SheetChangeEvent.Changed_AutoFilter);
    }

    @Override
    protected void resumeBlock(URState state, Sheet sheet, CellBlock cb) {
        ObjectArray clls = (ObjectArray)state.get("CELL_OBJ");
        if (clls != null) {
            ObjectArray SSAs = (ObjectArray)state.get("CELL_VALUE");
            int iEnd = clls.size();
            for (int i = 0; i < iEnd; ++i) {
                Cell cll = (Cell)clls.get(i);
                Object[] ao = (Object[])SSAs.get(i);
                if (ao[0] != null) {
                    cll.setFormula((String)ao[0]);
                }
                if (ao[1] != null) {
                    cll.setSSA((ShareStyleAttributes)ao[1]);
                }
                if (ao[2] == null) continue;
                if (ao[2] instanceof String) {
                    cll.removeUserObject((String)ao[2]);
                    continue;
                }
                UserObject uo = (UserObject)ao[2];
                cll.setUserObject(uo);
            }
        }
        this.resumeAutoFilter(sheet, state);
        List borderList = (List)state.get("BDR");
        if (borderList != null) {
            Iterator it = borderList.iterator();
            while (it.hasNext()) {
                sheet.getBorders().set((Borders)it.next());
            }
        }
    }

    @Override
    public String getPresentationName() {
        return "\u66ff\u6362" + super.getPresentationName();
    }
}

