/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.radar;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.Radar;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.code.X;
import com.github.abel533.echarts.code.Y;
import com.github.abel533.echarts.data.RadarData;
import com.github.abel533.echarts.series.RadarSeries;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.radar.RadarBean;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractSmoothTransfer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.ArrayList;
import java.util.Arrays;

public class RadarBeanTransferImpl
extends AbstractSmoothTransfer<RadarBean> {
    public RadarBeanTransferImpl() {
        super(EChartsType.RADAR, "\u96f7\u8fbe\u56fe");
        this.setSetPosition(true);
    }

    @Override
    public Option transfer2Opiton(RadarBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        if (null != p.getTooltip()) {
            p.tooltip().setTrigger(Trigger.item);
        }
        if (null != p.getLegend()) {
            Object[] series = (String[])dataNode.getSeriesKeys();
            p.legend().data(series);
        }
        String[] labels = dataNode.getGroupKeys();
        double[][] data = (double[][])dataNode.getData();
        if (null == labels || null == data) {
            return null;
        }
        String[] series = (String[])dataNode.getSeriesKeys();
        CategoryAxis caxis = new CategoryAxis();
        caxis.setBoundaryGap((Object)false);
        ArrayList<Radar.Indicator> list = new ArrayList<Radar.Indicator>();
        Chart chart = bean.getChart();
        String[] chartCaptions = super.getChartCaptions(dataNode);
        double max = TransferUtils.getMax(data);
        double min = TransferUtils.getMin(data);
        max = Math.max(Math.abs(max), Math.abs(min));
        for (int i = 0; i < labels.length; ++i) {
            Radar.Indicator sIndicator = new Radar.Indicator();
            sIndicator.setName(labels[i]);
            max = TransferUtils.ceil(max);
            sIndicator.setMax((Object)max);
            if (min < 0.0) {
                sIndicator.setMin((Object)(0.0 - max));
            } else {
                sIndicator.setMin((Object)0.0);
            }
            if (i == 0 && "1".equals(chartCaptions[38])) {
                sIndicator.axisLabel().show(Boolean.valueOf(true));
                sIndicator.axisLabel().formatter((Object)JSUtils.getNumberFormatFunctionVar(true));
            }
            list.add(sIndicator);
        }
        Radar radar = new Radar();
        radar.radius((Object)"75%");
        if (null != p.getLegend()) {
            if (null != p.legend().bottom()) {
                radar.radius((Object)"60%");
            } else if (null != p.legend().right()) {
                radar.center((Object[])new String[]{"45%", "55%"});
            }
        }
        radar.indicator(list);
        for (int i = 0; i < data.length; ++i) {
            RadarSeries radarSeries = new RadarSeries();
            if ("0".equals(chart.drawAnchors)) {
                radarSeries.symbolSize((Object)0);
            }
            if ("1".equals(chartCaptions[20])) {
                radarSeries.areaStyle();
            }
            if ("0".equals(chartCaptions[19])) {
                radarSeries.lineStyle().width(Integer.valueOf(0));
            }
            radarSeries.setName(series[i]);
            ArrayList<Double> listD = new ArrayList<Double>();
            for (int j = 0; j < data[i].length; ++j) {
                listD.add(data[i][j]);
                RadarData radarData = new RadarData(series[i], listD);
                radarSeries.setData(Arrays.asList(radarData));
            }
            if ("1".equals(chartCaptions[16])) {
                radarSeries.label().normal().show(Boolean.valueOf(true));
            }
            p.series().add(radarSeries);
        }
        p.radar(radar);
        return p;
    }

    @Override
    public Option mockOption(RadarBean bean) {
        Option p = super.mockOption(bean);
        p.tooltip().trigger(Trigger.item);
        p.legend().bottom((Object)Y.bottom);
        p.legend().x(X.center);
        p.legend().setData(Arrays.asList("\u9884\u7b97\u5206\u914d"));
        Radar radar = new Radar();
        radar.radius((Object)"65%");
        radar.center((Object[])new String[]{"50%", "45%"});
        Radar.Indicator sIndicator = new Radar.Indicator();
        sIndicator.setMax((Object)6500);
        sIndicator.setName("\u9500\u552e");
        Radar.Indicator mIndicator = new Radar.Indicator();
        mIndicator.setMax((Object)16000);
        mIndicator.setName("\u7ba1\u7406");
        Radar.Indicator iIndicator = new Radar.Indicator();
        iIndicator.setMax((Object)30000);
        iIndicator.setName("\u4fe1\u606f\u6280\u672f");
        Radar.Indicator cIndicator = new Radar.Indicator();
        cIndicator.setMax((Object)38000);
        cIndicator.setName("\u5ba2\u670d");
        Radar.Indicator dIndicator = new Radar.Indicator();
        dIndicator.setMax((Object)52000);
        dIndicator.setName("\u7814\u53d1");
        Radar.Indicator maIndicator = new Radar.Indicator();
        maIndicator.setMax((Object)25000);
        maIndicator.setName("\u5e02\u573a");
        radar.indicator(new Radar.Indicator[]{sIndicator, mIndicator, iIndicator, cIndicator, dIndicator, maIndicator});
        p.radar(radar);
        RadarSeries radarSeries = new RadarSeries();
        radarSeries.label().show(Boolean.valueOf(true));
        radarSeries.setName("\u9884\u7b97  Budget)");
        RadarData radarData = new RadarData("\u9884\u7b97\u5206\u914d", Arrays.asList(4200, 3000, 20000, 35000, 50000, 18000));
        radarSeries.setData(Arrays.asList(radarData));
        p.series().add(radarSeries);
        return p;
    }
}

