/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.filter;

import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.filter.AbstractAutoFilter;
import com.kingdee.bos.ctrl.kds.model.struct.filter.AlgorithmUtil;
import com.kingdee.bos.ctrl.kds.model.struct.filter.ISheetAutoFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class SheetFirstNAutoFilter
extends AbstractAutoFilter {
    private int amount;
    private boolean isAsc;
    private boolean isPercent;
    private static Comparator comparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            Cell left = (Cell)arg0;
            Cell right = (Cell)arg1;
            Variant leftValue = left.getValue();
            Variant rightValue = right.getValue();
            try {
                String rightText;
                int rev = leftValue.compareTo(rightValue);
                if (rev != 0) {
                    return rev;
                }
                String leftText = left.getText();
                rev = leftText.compareTo(rightText = right.getText());
                if (rev != 0) {
                    return rev;
                }
            }
            catch (SyntaxErrorException syntaxErrorException) {
                // empty catch block
            }
            return 0;
        }
    };
    private ArrayList orderedCells;
    private int count;
    private int showCount;

    public SheetFirstNAutoFilter(Sheet sheet, int colIndex, int amount, boolean isAsc, boolean isPercent) {
        super(sheet, colIndex);
        this.amount = amount;
        this.isAsc = isAsc;
        this.isPercent = isPercent;
    }

    @Override
    public ISheetAutoFilter changedColIndex(int colIndex) {
        return new SheetFirstNAutoFilter(this.sheet, colIndex, colIndex, this.isAsc, this.isPercent);
    }

    @Override
    protected void beforeDoFilter() {
        CellBlock cb = CellBlock.getCellBlock(this.sheet.getAutoFilterArea());
        int row = cb.getRow();
        int row2 = cb.getRow2();
        if (this.isPercent) {
            this.amount = (row2 - row) * this.amount / 100;
        }
        this.orderedCells = new ArrayList();
        Sheet.ICellsIterator ri = this.sheet.getCellsIterator(row + 1, this.colIndex, row2, this.colIndex, false, true);
        int[] securityRows = this.sheet.getSecHidedRows();
        while (ri.hasNext()) {
            Cell icell = ri.next();
            if (AlgorithmUtil.contain(securityRows, icell.getRow())) continue;
            this.orderedCells.add(icell);
        }
        Collections.sort(this.orderedCells, comparator);
        this.count = Math.min(this.amount, this.orderedCells.size());
        this.showCount = 0;
    }

    @Override
    protected boolean matchFilter(Cell cell) {
        int index = this.orderedCells.indexOf(cell);
        if (index < 0) {
            return false;
        }
        if (this.showCount >= this.count) {
            return false;
        }
        if (!(!this.isAsc ? index >= this.orderedCells.size() - this.count : index < this.count)) {
            return false;
        }
        ++this.showCount;
        return true;
    }

    @Override
    public int getAutoFilterType() {
        return 0;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean isAsc() {
        return this.isAsc;
    }

    public boolean isPercent() {
        return this.isPercent;
    }
}

